/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.creator;

import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.hikari.HikariCpConfig;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;

public class HikariDataSourceCreator {
    private HikariCpConfig hikariCpConfig;

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        HikariConfig config = dataSourceProperty.getHikari().toHikariConfig(this.hikariCpConfig);
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setDriverClassName(dataSourceProperty.getDriverClassName());
        config.setPoolName(dataSourceProperty.getPollName());
        return new HikariDataSource(config);
    }

    public HikariCpConfig getHikariCpConfig() {
        return this.hikariCpConfig;
    }

    public void setHikariCpConfig(HikariCpConfig hikariCpConfig) {
        this.hikariCpConfig = hikariCpConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HikariDataSourceCreator)) {
            return false;
        }
        HikariDataSourceCreator other = (HikariDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HikariCpConfig this$hikariCpConfig = this.getHikariCpConfig();
        HikariCpConfig other$hikariCpConfig = other.getHikariCpConfig();
        return !(this$hikariCpConfig == null ? other$hikariCpConfig != null : !((Object)this$hikariCpConfig).equals(other$hikariCpConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HikariDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HikariCpConfig $hikariCpConfig = this.getHikariCpConfig();
        result = result * 59 + ($hikariCpConfig == null ? 43 : ((Object)$hikariCpConfig).hashCode());
        return result;
    }

    public String toString() {
        return "HikariDataSourceCreator(hikariCpConfig=" + this.getHikariCpConfig() + ")";
    }

    public HikariDataSourceCreator(HikariCpConfig hikariCpConfig) {
        this.hikariCpConfig = hikariCpConfig;
    }
}

