/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.creator;

import cn.humingfeng.dynamic.datasource.exception.ErrorCreateDataSourceException;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.dbcp.Dbcp2Config;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbaseDataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(GbaseDataSourceCreator.class);
    private static final Log LOG = LogFactory.getLog(GbaseDataSourceCreator.class);
    private Dbcp2Config dbcp2Config;

    public GbaseDataSourceCreator(Dbcp2Config dbcp2Config) {
        this.dbcp2Config = dbcp2Config;
    }

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        try {
            Properties properties = new Properties();
            properties.setProperty("url", dataSourceProperty.getUrl());
            properties.setProperty("username", dataSourceProperty.getUsername());
            properties.setProperty("password", dataSourceProperty.getPassword());
            properties.setProperty("driverClassName", dataSourceProperty.getDriverClassName());
            properties.setProperty("initialSize", "5");
            properties.setProperty("minIdle", "5");
            properties.setProperty("maxIdle", "20");
            properties.setProperty("maxTotal", "100");
            properties.setProperty("maxWaitMillis", "100000");
            properties.setProperty("defaultAutoCommit", "true");
            properties.setProperty("removeAbandonedTimeout", "600");
            properties.setProperty("removeAbandonedOnBorrow", "true");
            properties.setProperty("removeAbandonedOnMaintenance", "true");
            properties.setProperty("testWhileIdle", "true");
            properties.setProperty("timeBetweenEvictionRunsMillis", "60000");
            properties.setProperty("numTestsPerEvictionRun", "5");
            properties.setProperty("minEvictableIdleTimeMillis", "300000");
            if (this.dbcp2Config.getInitialSize() != null) {
                properties.setProperty("initialSize", String.valueOf(this.dbcp2Config.getInitialSize()));
            }
            if (this.dbcp2Config.getMinIdle() != null) {
                properties.setProperty("minIdle", String.valueOf(this.dbcp2Config.getMinIdle()));
            }
            if (this.dbcp2Config.getMaxIdle() != null) {
                properties.setProperty("maxIdle", String.valueOf(this.dbcp2Config.getMaxIdle()));
            }
            if (this.dbcp2Config.getMaxTotal() != null) {
                properties.setProperty("maxTotal", String.valueOf(this.dbcp2Config.getMaxTotal()));
            }
            if (this.dbcp2Config.getMaxWaitMillis() != null) {
                properties.setProperty("maxWaitMillis", String.valueOf(this.dbcp2Config.getMaxWaitMillis()));
            }
            if (this.dbcp2Config.getDefaultAutoCommit() != null && !this.dbcp2Config.getDefaultAutoCommit().booleanValue()) {
                properties.setProperty("defaultAutoCommit", "false");
            }
            if (this.dbcp2Config.getRemoveAbandonedTimeout() != null) {
                properties.setProperty("removeAbandonedTimeout", String.valueOf(this.dbcp2Config.getRemoveAbandonedTimeout()));
            }
            if (this.dbcp2Config.getRemoveAbandonedOnBorrow() != null && !this.dbcp2Config.getRemoveAbandonedOnBorrow().booleanValue()) {
                properties.setProperty("removeAbandonedOnBorrow", "false");
            }
            if (this.dbcp2Config.getRemoveAbandonedOnMaintenance() != null && !this.dbcp2Config.getRemoveAbandonedOnMaintenance().booleanValue()) {
                properties.setProperty("removeAbandonedOnMaintenance", "false");
            }
            if (this.dbcp2Config.getTestWhileIdle() != null && !this.dbcp2Config.getTestWhileIdle().booleanValue()) {
                properties.setProperty("testWhileIdle", "false");
            }
            if (this.dbcp2Config.getTimeBetweenEvictionRunsMillis() != null) {
                properties.setProperty("timeBetweenEvictionRunsMillis", String.valueOf(this.dbcp2Config.getTimeBetweenEvictionRunsMillis()));
            }
            if (this.dbcp2Config.getNumTestsPerEvictionRun() != null) {
                properties.setProperty("numTestsPerEvictionRun", String.valueOf(this.dbcp2Config.getNumTestsPerEvictionRun()));
            }
            if (this.dbcp2Config.getMinEvictableIdleTimeMillis() != null) {
                properties.setProperty("minEvictableIdleTimeMillis", String.valueOf(this.dbcp2Config.getMinEvictableIdleTimeMillis()));
            }
            BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)properties);
            LOG.info("dynamic-datasource create gbase database named " + dataSourceProperty.getPollName() + " succeed");
            return dataSource;
        }
        catch (Exception e) {
            LOG.error("dynamic-datasource create basic database named " + dataSourceProperty.getPollName() + " error");
            throw new ErrorCreateDataSourceException("dynamic-datasource create basic database named " + dataSourceProperty.getPollName() + " error");
        }
    }

    private GbaseDataSourceCreator() {
    }

    public Dbcp2Config getDbcp2Config() {
        return this.dbcp2Config;
    }

    public void setDbcp2Config(Dbcp2Config dbcp2Config) {
        this.dbcp2Config = dbcp2Config;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GbaseDataSourceCreator)) {
            return false;
        }
        GbaseDataSourceCreator other = (GbaseDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Dbcp2Config this$dbcp2Config = this.getDbcp2Config();
        Dbcp2Config other$dbcp2Config = other.getDbcp2Config();
        return !(this$dbcp2Config == null ? other$dbcp2Config != null : !((Object)this$dbcp2Config).equals(other$dbcp2Config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GbaseDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Dbcp2Config $dbcp2Config = this.getDbcp2Config();
        result = result * 59 + ($dbcp2Config == null ? 43 : ((Object)$dbcp2Config).hashCode());
        return result;
    }

    public String toString() {
        return "GbaseDataSourceCreator(dbcp2Config=" + this.getDbcp2Config() + ")";
    }
}

