/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource.creator;

import cn.humingfeng.dynamic.datasource.exception.ErrorCreateDataSourceException;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.druid.DruidConfig;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.druid.DruidSlf4jConfig;
import cn.humingfeng.dynamic.datasource.spring.boot.autoconfigure.druid.DruidWallConfigUtil;
import com.alibaba.druid.filter.Filter;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class DruidDataSourceCreator {
    private DruidConfig druidConfig;
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    public DruidDataSourceCreator(DruidConfig druidConfig) {
        this.druidConfig = druidConfig;
    }

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        Boolean logAbandoned;
        Boolean abandoned;
        Integer timeout;
        Boolean breakAfterAcquireFailure;
        Integer connectionErrorRetryAttempts;
        Boolean sharePreparedStatements;
        Integer validationQueryTimeout;
        Boolean testOnReturn;
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUsername(dataSourceProperty.getUsername());
        dataSource.setPassword(dataSourceProperty.getPassword());
        dataSource.setUrl(dataSourceProperty.getUrl());
        dataSource.setDriverClassName(dataSourceProperty.getDriverClassName());
        dataSource.setName(dataSourceProperty.getPollName());
        DruidConfig config = dataSourceProperty.getDruid();
        Properties properties = config.toProperties(this.druidConfig);
        String filters = properties.getProperty("druid.filters");
        ArrayList<Object> proxyFilters = new ArrayList<Object>(2);
        if (!StringUtils.isEmpty((Object)filters) && filters.contains("stat")) {
            StatFilter statFilter = new StatFilter();
            statFilter.configFromProperties(properties);
            proxyFilters.add(statFilter);
        }
        if (!StringUtils.isEmpty((Object)filters) && filters.contains("wall")) {
            WallConfig wallConfig = DruidWallConfigUtil.toWallConfig(dataSourceProperty.getDruid().getWall(), this.druidConfig.getWall());
            WallFilter wallFilter = new WallFilter();
            wallFilter.setConfig(wallConfig);
            proxyFilters.add(wallFilter);
        }
        if (!StringUtils.isEmpty((Object)filters) && filters.contains("slf4j")) {
            Slf4jLogFilter slf4jLogFilter = new Slf4jLogFilter();
            DruidSlf4jConfig slf4jConfig = this.druidConfig.getSlf4j();
            slf4jLogFilter.setStatementLogEnabled(slf4jConfig.getEnable().booleanValue());
            slf4jLogFilter.setStatementExecutableSqlLogEnable(slf4jConfig.getStatementExecutableSqlLogEnable().booleanValue());
            proxyFilters.add(slf4jLogFilter);
        }
        if (this.applicationContext != null) {
            for (String filterId : this.druidConfig.getProxyFilters()) {
                proxyFilters.add(this.applicationContext.getBean(filterId, Filter.class));
            }
        }
        dataSource.setProxyFilters(proxyFilters);
        dataSource.configFromPropety(properties);
        dataSource.setConnectProperties(config.getConnectionProperties());
        Boolean bl = testOnReturn = config.getTestOnReturn() == null ? this.druidConfig.getTestOnReturn() : config.getTestOnReturn();
        if (testOnReturn != null && testOnReturn.equals(true)) {
            dataSource.setTestOnReturn(true);
        }
        Integer n = validationQueryTimeout = config.getValidationQueryTimeout() == null ? this.druidConfig.getValidationQueryTimeout() : config.getValidationQueryTimeout();
        if (validationQueryTimeout != null && !validationQueryTimeout.equals(-1)) {
            dataSource.setValidationQueryTimeout(validationQueryTimeout.intValue());
        }
        Boolean bl2 = sharePreparedStatements = config.getSharePreparedStatements() == null ? this.druidConfig.getSharePreparedStatements() : config.getSharePreparedStatements();
        if (sharePreparedStatements != null && sharePreparedStatements.equals(true)) {
            dataSource.setSharePreparedStatements(true);
        }
        Integer n2 = connectionErrorRetryAttempts = config.getConnectionErrorRetryAttempts() == null ? this.druidConfig.getConnectionErrorRetryAttempts() : config.getConnectionErrorRetryAttempts();
        if (connectionErrorRetryAttempts != null && !connectionErrorRetryAttempts.equals(1)) {
            dataSource.setConnectionErrorRetryAttempts(connectionErrorRetryAttempts.intValue());
        }
        Boolean bl3 = breakAfterAcquireFailure = config.getBreakAfterAcquireFailure() == null ? this.druidConfig.getBreakAfterAcquireFailure() : config.getBreakAfterAcquireFailure();
        if (breakAfterAcquireFailure != null && breakAfterAcquireFailure.equals(true)) {
            dataSource.setBreakAfterAcquireFailure(true);
        }
        Integer n3 = timeout = config.getRemoveAbandonedTimeoutMillis() == null ? this.druidConfig.getRemoveAbandonedTimeoutMillis() : config.getRemoveAbandonedTimeoutMillis();
        if (timeout != null) {
            dataSource.setRemoveAbandonedTimeout(timeout.intValue());
        }
        Boolean bl4 = abandoned = config.getRemoveAbandoned() == null ? this.druidConfig.getRemoveAbandoned() : config.getRemoveAbandoned();
        if (abandoned != null) {
            dataSource.setRemoveAbandoned(abandoned.booleanValue());
        }
        Boolean bl5 = logAbandoned = config.getLogAbandoned() == null ? this.druidConfig.getLogAbandoned() : config.getLogAbandoned();
        if (logAbandoned != null) {
            dataSource.setLogAbandoned(logAbandoned.booleanValue());
        }
        try {
            dataSource.init();
        }
        catch (SQLException e) {
            throw new ErrorCreateDataSourceException("druid create error", e);
        }
        return dataSource;
    }

    private DruidDataSourceCreator() {
    }

    public DruidConfig getDruidConfig() {
        return this.druidConfig;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setDruidConfig(DruidConfig druidConfig) {
        this.druidConfig = druidConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidDataSourceCreator)) {
            return false;
        }
        DruidDataSourceCreator other = (DruidDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DruidConfig this$druidConfig = this.getDruidConfig();
        DruidConfig other$druidConfig = other.getDruidConfig();
        if (this$druidConfig == null ? other$druidConfig != null : !((Object)this$druidConfig).equals(other$druidConfig)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        return !(this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DruidDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DruidConfig $druidConfig = this.getDruidConfig();
        result = result * 59 + ($druidConfig == null ? 43 : ((Object)$druidConfig).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        return result;
    }

    public String toString() {
        return "DruidDataSourceCreator(druidConfig=" + this.getDruidConfig() + ", applicationContext=" + this.getApplicationContext() + ")";
    }
}

