/*
 * Decompiled with CFR 0.152.
 */
package cn.humingfeng.dynamic.datasource;

import cn.humingfeng.dynamic.datasource.strategy.DynamicDataSourceStrategy;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public class DynamicGroupDataSource {
    private String groupName;
    private DynamicDataSourceStrategy dynamicDataSourceStrategy;
    private List<DataSource> dataSources = new LinkedList<DataSource>();

    public DynamicGroupDataSource(String groupName, DynamicDataSourceStrategy dynamicDataSourceStrategy) {
        this.groupName = groupName;
        this.dynamicDataSourceStrategy = dynamicDataSourceStrategy;
    }

    public void addDatasource(DataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    public void removeDatasource(DataSource dataSource) {
        this.dataSources.remove(dataSource);
    }

    public DataSource determineDataSource() {
        return this.dynamicDataSourceStrategy.determineDataSource(this.dataSources);
    }

    public int size() {
        return this.dataSources.size();
    }

    private DynamicGroupDataSource() {
    }

    public String getGroupName() {
        return this.groupName;
    }

    public DynamicDataSourceStrategy getDynamicDataSourceStrategy() {
        return this.dynamicDataSourceStrategy;
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setDynamicDataSourceStrategy(DynamicDataSourceStrategy dynamicDataSourceStrategy) {
        this.dynamicDataSourceStrategy = dynamicDataSourceStrategy;
    }

    public void setDataSources(List<DataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicGroupDataSource)) {
            return false;
        }
        DynamicGroupDataSource other = (DynamicGroupDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        if (this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName)) {
            return false;
        }
        DynamicDataSourceStrategy this$dynamicDataSourceStrategy = this.getDynamicDataSourceStrategy();
        DynamicDataSourceStrategy other$dynamicDataSourceStrategy = other.getDynamicDataSourceStrategy();
        if (this$dynamicDataSourceStrategy == null ? other$dynamicDataSourceStrategy != null : !this$dynamicDataSourceStrategy.equals(other$dynamicDataSourceStrategy)) {
            return false;
        }
        List<DataSource> this$dataSources = this.getDataSources();
        List<DataSource> other$dataSources = other.getDataSources();
        return !(this$dataSources == null ? other$dataSources != null : !((Object)this$dataSources).equals(other$dataSources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicGroupDataSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        DynamicDataSourceStrategy $dynamicDataSourceStrategy = this.getDynamicDataSourceStrategy();
        result = result * 59 + ($dynamicDataSourceStrategy == null ? 43 : $dynamicDataSourceStrategy.hashCode());
        List<DataSource> $dataSources = this.getDataSources();
        result = result * 59 + ($dataSources == null ? 43 : ((Object)$dataSources).hashCode());
        return result;
    }

    public String toString() {
        return "DynamicGroupDataSource(groupName=" + this.getGroupName() + ", dynamicDataSourceStrategy=" + this.getDynamicDataSourceStrategy() + ", dataSources=" + this.getDataSources() + ")";
    }
}

