/*
 * Decompiled with CFR 0.152.
 */
package cn.huazai.tool.whitelist.access.utils;

import java.util.Objects;
import java.util.Optional;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ConfigByEnvironment
implements EnvironmentAware {
    private static Environment environment;

    private ConfigByEnvironment() {
    }

    public void setEnvironment(@NonNull Environment environment) {
        ConfigByEnvironment.environment = environment;
    }

    public static Optional<String> get(String configKey) {
        String config = environment.getProperty(configKey);
        return Objects.isNull(config) ? Optional.empty() : Optional.of(config);
    }

    public static <T> Optional<T> get(String configKey, Class<T> targetType) {
        Object config = environment.getProperty(configKey, targetType);
        return Objects.isNull(config) ? Optional.empty() : Optional.of(config);
    }

    public static String getProperty(String key) {
        return environment.getProperty(key);
    }

    public static <T> T getProperty(String key, Class<T> targetType) {
        return (T)environment.getProperty(key, targetType);
    }
}

