/*
 * Decompiled with CFR 0.152.
 */
package cn.huazai.tool.whitelist.access.aspect;

import cn.huazai.tool.whitelist.access.annotation.WhitelistAccess;
import cn.huazai.tool.whitelist.access.exception.IllegalAccessException;
import cn.huazai.tool.whitelist.access.utils.ConfigByEnvironment;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WhitelistAccessResolveAspect {
    Logger log = LoggerFactory.getLogger(WhitelistAccessResolveAspect.class);
    private static final String WHITELIST_SWITCH = "whitelist.switch";
    private static final String DEFAULT_WHITELIST_SPLIT_KEY = ",";
    private static final String DEFAULT_WHITELIST_TOAST = "\u975e\u767d\u540d\u5355\u7981\u6b62\u8bbf\u95ee";
    private static final String WHITELIST_KEY_PREFIX = "business.whitelist.switch.";
    private static final String WHITELIST_VALUE_PREFIX = "business.whitelist.value.";
    private static final String WHITELIST_CHECK_BEGIN_AT_PREFIX = "business.whitelist.beginAt.";
    private static final String WHITELIST_CHECK_END_AT_PREFIX = "business.whitelist.endAt.";
    private static final String WHITELIST_TOAST_PREFIX = "business.whitelist.toast.";
    ExpressionParser parser = new SpelExpressionParser();
    LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Around(value="@annotation(whitelistAccessPoint)")
    public Object doAround(ProceedingJoinPoint pjp, WhitelistAccess whitelistAccessPoint) throws Throwable {
        if (!Boolean.TRUE.toString().equalsIgnoreCase(ConfigByEnvironment.get(WHITELIST_SWITCH).orElse(null))) {
            return pjp.proceed();
        }
        Object[] args = pjp.getArgs();
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        String[] params = this.discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int len = 0; len < Objects.requireNonNull(params).length; ++len) {
            context.setVariable(params[len], args[len]);
        }
        String businessKey = whitelistAccessPoint.businessKey();
        String businessSwitch = ConfigByEnvironment.get(WHITELIST_KEY_PREFIX + businessKey).orElse(null);
        if (!Boolean.TRUE.toString().equalsIgnoreCase(businessSwitch)) {
            this.log.info("\u767d\u540d\u5355\u6821\u9a8c\u5173\u95ed \u4e1a\u52a1\u952e:[{}]", (Object)businessKey);
            return pjp.proceed();
        }
        if (!this.checkWhitelistTime(businessKey)) {
            this.log.info("\u767d\u540d\u5355\u6821\u9a8c\u4e0d\u5728\u6821\u9a8c\u65f6\u95f4\u5185 \u4e1a\u52a1\u952e:[{}]", (Object)businessKey);
            return pjp.proceed();
        }
        String checkValueSpel = whitelistAccessPoint.checkValue();
        Expression checkValueExpression = this.parser.parseExpression(checkValueSpel);
        String checkValue = (String)checkValueExpression.getValue((EvaluationContext)context, String.class);
        this.log.info("\u767d\u540d\u5355\u6821\u9a8c\u5f00\u542f \u4e1a\u52a1\u952e:[{}], \u6821\u9a8c\u503c:[{}]", (Object)businessKey, (Object)checkValue);
        String businessWhitelist = ConfigByEnvironment.get(WHITELIST_VALUE_PREFIX + businessKey).orElse(null);
        if (StringUtils.isEmpty((CharSequence)businessWhitelist) || StringUtils.isEmpty((CharSequence)checkValue) || !this.checkWhitelist(businessWhitelist, checkValue)) {
            this.log.info("\u767d\u540d\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7 \u4e1a\u52a1\u952e:[{}], \u6821\u9a8c\u503c:[{}]", (Object)businessKey, (Object)checkValue);
            throw new IllegalAccessException(ConfigByEnvironment.get(WHITELIST_TOAST_PREFIX + businessKey).orElse(DEFAULT_WHITELIST_TOAST));
        }
        this.log.info("\u767d\u540d\u5355\u6821\u9a8c\u901a\u8fc7 \u4e1a\u52a1\u952e:[{}], \u6821\u9a8c\u503c:[{}]", (Object)businessKey, (Object)checkValue);
        return pjp.proceed();
    }

    private boolean checkWhitelistTime(String businessKey) {
        String whitelistEndAtStr;
        Long whitelistBeginAt = null;
        Long whitelistEndAt = null;
        String whitelistBeginAtStr = ConfigByEnvironment.get(WHITELIST_CHECK_BEGIN_AT_PREFIX + businessKey).orElse(null);
        if (null != whitelistBeginAtStr) {
            whitelistBeginAt = Long.parseLong(whitelistBeginAtStr);
        }
        if (null != (whitelistEndAtStr = (String)ConfigByEnvironment.get(WHITELIST_CHECK_END_AT_PREFIX + businessKey).orElse(null))) {
            whitelistEndAt = Long.parseLong(whitelistEndAtStr);
        }
        if (null == whitelistBeginAt && null == whitelistEndAt) {
            return true;
        }
        if (null != whitelistBeginAt && null != whitelistEndAt) {
            long current = System.currentTimeMillis();
            return whitelistBeginAt <= current && whitelistEndAt > current;
        }
        if (null != whitelistBeginAt) {
            long current = System.currentTimeMillis();
            return whitelistBeginAt <= current;
        }
        long current = System.currentTimeMillis();
        return whitelistEndAt > current;
    }

    private boolean checkWhitelist(String businessWhitelist, String checkValue) {
        String finalCheckValue = checkValue.trim();
        return Arrays.stream(businessWhitelist.split(DEFAULT_WHITELIST_SPLIT_KEY)).filter(StringUtils::isNotBlank).anyMatch(whitelist -> whitelist.equals(finalCheckValue));
    }
}

