/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.aggregates.sunrise_moonset.SunriseMoonset;
import cn.huangdayu.almanac.dto.TimeZoneDTO;
import cn.huangdayu.almanac.utils.JulianCalendarUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class SunMoonUtils {
    private static double RAD = 206264.80624709636;
    private static double midDayTime;
    private static double dawnTime;
    private static double moonRise;
    private static double moonSet;
    private static String codeStr;
    private static double latitude;
    private static double longitude;

    public static void init(TimeZoneDTO timeZoneDTO, SunriseMoonset sunriseMoonset) {
        SunMoonUtils.sunTime(timeZoneDTO, sunriseMoonset);
        SunMoonUtils.moonTime(timeZoneDTO, sunriseMoonset);
    }

    public static String setItude(double d, boolean b) {
        if (!b) {
            if (d < 0.0) {
                return "\u5357\u7eac ";
            }
            return "\u5317\u7eac ";
        }
        if (d < 0.0) {
            return "\u897f\u7ecf ";
        }
        return "\u4e1c\u7ecf ";
    }

    public static String setStringPointDouble(double itude, boolean boo) {
        BigDecimal big = new BigDecimal(itude);
        String str0 = String.valueOf(SunMoonUtils.roundByScale(itude, 4));
        int leng = str0.length();
        String str1 = str0.substring(0, leng - 5);
        String str2 = str0.substring(leng - 4, leng - 2);
        String str3 = str0.substring(leng - 2, leng);
        String str4 = SunMoonUtils.setItude(itude, boo) + str1 + "\u00b0" + str2 + "'" + str3 + "\"";
        return str4;
    }

    public static String roundByScale(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The   scale   must   be   a   positive   integer   or   zero");
        }
        if (scale == 0) {
            return new DecimalFormat("0").format(v);
        }
        String formatStr = "0.";
        for (int i = 0; i < scale; ++i) {
            formatStr = formatStr + "0";
        }
        return new DecimalFormat(formatStr).format(v);
    }

    public static double getTwoPointDouble(double d) {
        BigDecimal b = new BigDecimal(d);
        double f1 = b.setScale(2, 4).doubleValue();
        return f1;
    }

    public static double getDoubleLongitude() {
        return SunMoonUtils.getTwoPointDouble(longitude);
    }

    public static double getDoubleLatitude() {
        return SunMoonUtils.getTwoPointDouble(latitude);
    }

    private static void sunTime(TimeZoneDTO timeZoneDTO, SunriseMoonset sunriseMoonset) {
        String jwd = SunMoonUtils.decodeJWD(timeZoneDTO.getAddress());
        latitude = Double.parseDouble(jwd.substring(0, 2)) + Double.parseDouble(jwd.substring(2, 4)) / 60.0;
        longitude = Double.parseDouble(jwd.substring(4, 7)) + Double.parseDouble(jwd.substring(7)) / 60.0;
        sunriseMoonset.setLongitude(SunMoonUtils.setStringPointDouble(longitude, true));
        sunriseMoonset.setLatitude(SunMoonUtils.setStringPointDouble(latitude, false));
        Double wd = latitude / 180.0 * Math.PI;
        Double jd = -longitude / 180.0 * Math.PI;
        double richu = SunMoonUtils.getJuLian_old(timeZoneDTO.getYear(), timeZoneDTO.getMonth(), timeZoneDTO.getDay(), timeZoneDTO.getHour(), timeZoneDTO.getMinute(), timeZoneDTO.getSecond()) - JulianCalendarUtils.getJuLianByYear(timeZoneDTO.getYear());
        for (int i = 0; i < 10; ++i) {
            richu = SunMoonUtils.sunRiseTime(richu, jd, wd, timeZoneDTO.getIndex() / 24.0);
        }
        sunriseMoonset.setSunRiseTime(SunMoonUtils.doubleToStr(richu));
        sunriseMoonset.setSunSetTime(SunMoonUtils.doubleToStr(midDayTime + midDayTime - richu));
        sunriseMoonset.setMidDayTime(SunMoonUtils.doubleToStr(midDayTime));
        sunriseMoonset.setDawnTime(SunMoonUtils.doubleToStr(dawnTime));
        sunriseMoonset.setDarkTime(SunMoonUtils.doubleToStr(midDayTime + midDayTime - dawnTime));
        sunriseMoonset.setDiurnalTime(SunMoonUtils.doubleToStr((midDayTime - richu) * 2.0 - 0.5));
        sunriseMoonset.setNightTime(SunMoonUtils.doubleToStr(24.0 - ((midDayTime - richu) * 2.0 - 0.5)));
    }

    public static String decodeJWD(String encode) {
        StringBuilder jwd = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (2 == i) {
                jwd.append(String.format("%03d", codeStr.indexOf(encode.charAt(i)) + 73));
                continue;
            }
            jwd.append(String.format("%02d", codeStr.indexOf(encode.charAt(i))));
        }
        return jwd.toString();
    }

    public static String encodeJWD(Integer decode) {
        StringBuilder jwd = new StringBuilder();
        int i = 230811316;
        int ge = i % 100;
        int shi = i % 100000 - ge;
        int bai = i % 10000000 - shi;
        int qian = i % 1000000000 - bai;
        shi = shi / 100 - 73;
        jwd.append(codeStr.charAt(qian /= 10000000)).append(codeStr.charAt(bai /= 100000)).append(codeStr.charAt(shi)).append(codeStr.charAt(ge));
        return jwd.toString();
    }

    public static Double sunRiseTime(double date, double lo, double la, double tz) {
        double t = (date -= tz) / 36525.0;
        double j = SunMoonUtils.sunHJ(t);
        double sinJ = Math.sin(j);
        double cosJ = Math.cos(j);
        double gst = Math.PI * 2 * (0.779057273264 + 1.00273781191135 * date) + (0.014506 + 4612.15739966 * t + 1.39667721 * t * t) / RAD;
        double E = (84381.406 - 46.836769 * t) / RAD;
        double a = Math.atan2(sinJ * Math.cos(E), cosJ);
        double D = Math.asin(Math.sin(E) * sinJ);
        double cosH0 = (Math.sin(-3000.0 / RAD) - Math.sin(la) * Math.sin(D)) / (Math.cos(la) * Math.cos(D));
        double cosH1 = (Math.sin(-21600.0 / RAD) - Math.sin(la) * Math.sin(D)) / (Math.cos(la) * Math.cos(D));
        if (cosH0 >= 1.0 || cosH0 <= -1.0) {
            return -0.5;
        }
        double H0 = -Math.acos(cosH0);
        double H1 = -Math.acos(cosH1);
        double H = gst - lo - a;
        midDayTime = date - SunMoonUtils.degree(H) / Math.PI / 2.0 + tz;
        dawnTime = date - SunMoonUtils.degree(H - H1) / Math.PI / 2.0 + tz;
        return date - SunMoonUtils.degree(H - H0) / Math.PI / 2.0 + tz;
    }

    public static Double degree(double ag) {
        return (ag = SunMoonUtils.mod(ag, Math.PI * 2).doubleValue()) <= -Math.PI ? ag + Math.PI * 2 : (ag > Math.PI ? ag - Math.PI * 2 : ag);
    }

    public static Double mod(double num1, double num2) {
        num2 = Math.abs(num2);
        return num1 >= 0.0 ? num1 - (double)((int)(num1 / num2)) * num2 : (double)((int)(Math.abs(num1) / num2)) * num2 - Math.abs(num1);
    }

    public static Double sunHJ(double t) {
        t += (32.0 * (t + 1.8) * (t + 1.8) - 20.0) / 86400.0 / 36525.0;
        double j = 4.895062166E7 + 6.283319653318E9 * t + 53.0 * t * t - 994.0 + 334166.0 * Math.cos(4.669257 + 628.307585 * t) + 3489.0 * Math.cos(4.6261 + 1256.61517 * t) + 2060.6 * Math.cos(2.67823 + 628.307585 * t) * t;
        return j / 1.0E7;
    }

    public static int getJuLian_old(int y, int M, int d, int h, int m, int s) {
        double time = 0.0;
        if (M <= 2) {
            M += 12;
            --y;
        }
        if (y * 372 + M * 31 + d >= 588829) {
            time = y / 100;
            time = 2.0 - time + (double)((int)(time / 4.0));
        }
        return (int)Math.round(time += (double)((int)Math.round(365.25 * (double)(y + 4716) + 0.01) + (int)(30.60001 * (double)(M + 1)) + d + (h * 3600 + m * 60 + s) / 86400) - 1524.5);
    }

    private static double getJuLian_new(int year, int month, double day) {
        int n = 0;
        boolean G = false;
        if ((double)(year * 372 + month * 31) + Math.floor(day) >= 588829.0) {
            G = true;
        }
        if (month <= 2) {
            month += 12;
            --year;
        }
        if (G) {
            n = (int)Math.floor(year / 100);
            n = 2 - n + (int)Math.floor(n / 4);
        }
        return Math.floor(365.25 * (double)(year + 4716)) + Math.floor(30.6001 * (double)(month + 1)) + day + (double)n - 1524.5 + 0.5;
    }

    public static String doubleToStr(double time) {
        double t = time + 0.5;
        t = (t - (double)((int)t)) * 24.0;
        int h = (int)t;
        t = (t - (double)h) * 60.0;
        int m = (int)t;
        t = (t - (double)m) * 60.0;
        int s = (int)t;
        return (h < 10 ? "0" + h : Integer.valueOf(h)) + ":" + (m < 10 ? "0" + m : Integer.valueOf(m)) + ":" + (s < 10 ? "0" + s : Integer.valueOf(s));
    }

    public static String timeToStr(double sum) {
        if (sum < 0.0) {
            return "--:--:--";
        }
        int h = (int)sum;
        int m = (int)((sum - (double)h) * 60.0);
        int s = (int)(((sum - (double)h) * 60.0 - (double)m) * 60.0);
        return (h < 10 ? "0" + h : Integer.valueOf(h)) + ":" + (m < 10 ? "0" + m : Integer.valueOf(m)) + ":" + (s < 10 ? "0" + s : Integer.valueOf(s));
    }

    private static void moonTime(TimeZoneDTO timeZoneDTO, SunriseMoonset sunriseMoonset) {
        double dbLon = SunMoonUtils.getDoubleLongitude();
        double dbLat = SunMoonUtils.getDoubleLatitude();
        double mjdd = SunMoonUtils.mjd(timeZoneDTO.getDay(), timeZoneDTO.getMonth(), timeZoneDTO.getYear(), 0);
        SunMoonUtils.find_moonrise_set(mjdd, timeZoneDTO.getIndex(), dbLon, dbLat, 0, 0, sunriseMoonset);
    }

    private static void find_moonrise_set(double mjd, double tz, double glong, double glat, int dls, int ST, SunriseMoonset sunriseMoonset) {
        double utrise = 0.0;
        double utset = 0.0;
        double rads = 0.0174532925;
        double[] quadout = new double[5];
        double sinho = Math.sin(rads * 8.0 / 60.0);
        double sglat = Math.sin(rads * glat);
        double cglat = Math.cos(rads * glat);
        double date = mjd - tz / 24.0;
        Boolean rise = false;
        Boolean sett = false;
        Boolean above = false;
        double hour = 1.0;
        double ym = SunMoonUtils.sin_alt(1, date, hour - 1.0, glong, cglat, sglat) - sinho;
        if (ym > 0.0) {
            above = true;
        }
        while (!(!(hour < 25.0) || sett.booleanValue() && rise.booleanValue())) {
            double yz = SunMoonUtils.sin_alt(1, date, hour, glong, cglat, sglat) - sinho;
            double yp = SunMoonUtils.sin_alt(1, date, hour + 1.0, glong, cglat, sglat) - sinho;
            quadout = SunMoonUtils.quad(ym, yz, yp);
            double nz = quadout[0];
            double z1 = quadout[1];
            double z2 = quadout[2];
            double xe = quadout[3];
            double ye = quadout[4];
            if (nz == 1.0) {
                if (ym < 0.0) {
                    utrise = hour + z1;
                    rise = true;
                } else {
                    utset = hour + z1;
                    sett = true;
                }
            }
            if (nz == 2.0) {
                if (ye < 0.0) {
                    utrise = hour + z2;
                    utset = hour + z1;
                } else {
                    utrise = hour + z1;
                    utset = hour + z2;
                }
            }
            ym = yp;
            hour += 2.0;
        }
        if (rise.booleanValue() || sett.booleanValue()) {
            moonRise = rise.booleanValue() ? (ST == 0 ? utrise + (double)dls : SunMoonUtils.lmst(mjd + (utrise - tz) / 24.0, glong)) : -1.0;
            moonSet = sett.booleanValue() ? (ST == 0 ? utset + (double)dls : SunMoonUtils.lmst(mjd + (utset - tz) / 24.0, glong)) : -1.0;
        } else {
            moonSet = -2.0;
        }
        sunriseMoonset.setMoonRiseTime(SunMoonUtils.timeToStr(moonRise));
        sunriseMoonset.setMoonSetTime(SunMoonUtils.timeToStr(moonSet));
        sunriseMoonset.setMoonMiddleTime(SunMoonUtils.timeToStr((moonSet + moonRise) / 2.0));
    }

    private static double lmst(double mjd, double glong) {
        double d = mjd - 51544.5;
        double t = d / 36525.0;
        double lst = SunMoonUtils.range(280.46061837 + 360.98564736629 * d + 3.87933E-4 * t * t - t * t * t / 3.871E7);
        if ((lst = lst / 15.0 + glong / 15.0) >= 24.0) {
            lst -= 24.0;
        }
        return lst;
    }

    private static double range(double x) {
        double b = x / 360.0;
        double a = 360.0 * (b - SunMoonUtils.ipart(b));
        if (a < 0.0) {
            a += 360.0;
        }
        return a;
    }

    private static double ipart(double x) {
        double a = x > 0.0 ? Math.floor(x) : Math.ceil(x);
        return a;
    }

    private static double[] quad(double ym, double yz, double yp) {
        double z1 = 0.0;
        double z2 = 0.0;
        double[] quadout = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double nz = 0.0;
        double a = 0.5 * (ym + yp) - yz;
        double b = 0.5 * (yp - ym);
        double c = yz;
        double xe = -b / (2.0 * a);
        double ye = (a * xe + b) * xe + c;
        double dis = b * b - 4.0 * a * c;
        if (dis > 0.0) {
            double dx = 0.5 * Math.sqrt(dis) / Math.abs(a);
            z1 = xe - dx;
            z2 = xe + dx;
            if (Math.abs(z1) <= 1.0) {
                nz += 1.0;
            }
            if (Math.abs(z2) <= 1.0) {
                nz += 1.0;
            }
            if (z1 < -1.0) {
                z1 = z2;
            }
        }
        quadout[0] = nz;
        quadout[1] = z1;
        quadout[2] = z2;
        quadout[3] = xe;
        quadout[4] = ye;
        return quadout;
    }

    private static double sin_alt(int iobj, double mjd0, double hour, double glong, double cglat, double sglat) {
        double rads = 0.0174532925;
        double[] objpos = new double[]{0.0, 0.0};
        double mjd = mjd0 + hour / 24.0;
        double t = (mjd - 51544.5) / 36525.0;
        if (iobj == 1) {
            objpos = SunMoonUtils.minimoon(t);
        }
        double ra = objpos[0];
        double dec = objpos[1];
        double tau = 15.0 * (SunMoonUtils.lmst(mjd, glong) - ra);
        double salt = sglat * Math.sin(rads * dec) + cglat * Math.cos(rads * dec) * Math.cos(rads * tau);
        return salt;
    }

    private static double[] minimoon(double t) {
        double p2 = 6.283185307;
        double arc = 206264.8062;
        double coseps = 0.91748;
        double sineps = 0.39778;
        double[] mooneq = new double[]{0.0, 0.0};
        double L0 = SunMoonUtils.frac(0.606433 + 1336.855225 * t);
        double L = p2 * SunMoonUtils.frac(0.374897 + 1325.55241 * t);
        double LS = p2 * SunMoonUtils.frac(0.993133 + 99.997361 * t);
        double D = p2 * SunMoonUtils.frac(0.827361 + 1236.853086 * t);
        double F = p2 * SunMoonUtils.frac(0.259086 + 1342.227825 * t);
        double DL = 22640.0 * Math.sin(L);
        DL += -4586.0 * Math.sin(L - 2.0 * D);
        DL += 2370.0 * Math.sin(2.0 * D);
        DL += 769.0 * Math.sin(2.0 * L);
        DL += -668.0 * Math.sin(LS);
        DL += -412.0 * Math.sin(2.0 * F);
        DL += -212.0 * Math.sin(2.0 * L - 2.0 * D);
        DL += -206.0 * Math.sin(L + LS - 2.0 * D);
        DL += 192.0 * Math.sin(L + 2.0 * D);
        DL += -165.0 * Math.sin(LS - 2.0 * D);
        DL += -125.0 * Math.sin(D);
        DL += -110.0 * Math.sin(L + LS);
        DL += 148.0 * Math.sin(L - LS);
        double S = F + ((DL += -55.0 * Math.sin(2.0 * F - 2.0 * D)) + 412.0 * Math.sin(2.0 * F) + 541.0 * Math.sin(LS)) / arc;
        double H = F - 2.0 * D;
        double N = -526.0 * Math.sin(H);
        N += 44.0 * Math.sin(L + H);
        N += -31.0 * Math.sin(-L + H);
        N += -23.0 * Math.sin(LS + H);
        N += 11.0 * Math.sin(-LS + H);
        N += -25.0 * Math.sin(-2.0 * L + F);
        double L_moon = p2 * SunMoonUtils.frac(L0 + DL / 1296000.0);
        double B_moon = (18520.0 * Math.sin(S) + (N += 21.0 * Math.sin(-L + F))) / arc;
        double CB = Math.cos(B_moon);
        double X = CB * Math.cos(L_moon);
        double V = CB * Math.sin(L_moon);
        double W = Math.sin(B_moon);
        double Y = coseps * V - sineps * W;
        double Z = sineps * V + coseps * W;
        double RHO = Math.sqrt(1.0 - Z * Z);
        double dec = 360.0 / p2 * Math.atan(Z / RHO);
        double ra = 48.0 / p2 * Math.atan(Y / (X + RHO));
        if (ra < 0.0) {
            ra += 24.0;
        }
        mooneq[1] = dec;
        mooneq[0] = ra;
        return mooneq;
    }

    private static double frac(double x) {
        return (x -= (double)((int)x)) < 0.0 ? x + 1.0 : x;
    }

    private static double mjd(int day, int month, int year, int hour) {
        double a;
        if (month <= 2) {
            month += 12;
            --year;
        }
        double b = (a = 10000.0 * (double)year + 100.0 * (double)month + (double)day) <= 1.58210041E7 ? -2.0 * Math.floor((year + 4716) / 4) - 1179.0 : Math.floor(year / 400) - Math.floor(year / 100) + Math.floor(year / 4);
        a = 365.0 * (double)year - 679004.0;
        return a + b + Math.floor(30.6001 * (double)(month + 1)) + (double)day + (double)hour / 24.0;
    }

    static {
        codeStr = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    }
}

