/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.exception.AlmanacException;
import java.io.IOException;
import java.util.Properties;

public class PropertiesUtils {
    private static final Properties LATITUDE = PropertiesUtils.getLatitudeProperties();
    private static final Properties LONGITUDE = PropertiesUtils.getLongitudeProperties();
    private static final Properties ADMINISTRATIVE = PropertiesUtils.getAdministrativeProperties();

    private PropertiesUtils() {
    }

    public static Properties getProperties(String name) {
        Properties properties = new Properties();
        try {
            properties.load(PropertiesUtils.class.getClassLoader().getResourceAsStream(name));
        }
        catch (IOException e) {
            throw new AlmanacException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", e);
        }
        return properties;
    }

    public static Properties getAdministrativeProperties() {
        return PropertiesUtils.getProperties("administrative.properties");
    }

    public static Properties getLatitudeProperties() {
        return PropertiesUtils.getProperties("latport.properties");
    }

    public static Properties getLongitudeProperties() {
        return PropertiesUtils.getProperties("loogport.properties");
    }

    public static Properties getLatitude() {
        return LATITUDE;
    }

    public static Properties getLongitude() {
        return LONGITUDE;
    }

    public static Properties getADMINISTRATIVE() {
        return ADMINISTRATIVE;
    }
}

