/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.dto.TimeZoneDTO;
import cn.huangdayu.almanac.utils.CommonUtils;
import java.util.Calendar;

public class JulianCalendarUtils {
    public static int getJuLian(int year, int month, int day) {
        return day - 32075 + 1461 * (year + 4800 + (month - 14) / 12) / 4 + 367 * (month - 2 - (month - 14) / 12 * 12) / 12 - 3 * ((year + 4900 + (month - 14) / 12) / 100) / 4;
    }

    public static int getJuLian(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2) + 1;
        int d = calendar.get(5);
        return JulianCalendarUtils.getJuLian(y, m, d);
    }

    public static int getJuLianByYear(int year) {
        int quZhen = year / 100;
        int quYu = year % 100;
        String Str = 0 == quYu && quZhen > 0 && year != 0 ? String.valueOf(quZhen - 1) + "00" : String.valueOf(quZhen) + "00";
        if (year <= 0) {
            Str = String.valueOf((-year - 1) / 100 - 1) + "00";
        }
        return JulianCalendarUtils.getJuLian(Integer.valueOf(Str), 1, 1);
    }

    public static int getYear_INT(int year) {
        int quZhen = year / 100;
        int quYu = year % 100;
        String Str = quZhen > 0 && year != 0 ? String.valueOf(quZhen - 1) + "00" : String.valueOf(quZhen) + "00";
        if (year <= 0) {
            Str = String.valueOf((-year - 1) / 100 - 1) + "00";
        }
        return Integer.valueOf(Str);
    }

    public static double getJulianDayNumber(int year, int month) {
        return JulianCalendarUtils.getJulianDayNumber(year, month, 1, 12, 0, 0.1);
    }

    public static double getJulianDayNumber(int year, int month, int day, int hour, int minute, double second) {
        return JulianCalendarUtils.getJulianDayNumber(year, month, (double)day + ((second / 60.0 + (double)minute) / 60.0 + (double)hour) / 24.0);
    }

    public static double getJulianDayNumber(int year, int month, double day) {
        if (month > 12) {
            year += (month %= 12) / 12;
        }
        int n = 0;
        boolean G = false;
        if ((double)(year * 372 + month * 31) + Math.floor(day) >= 588829.0) {
            G = true;
        }
        if (month <= 2) {
            month += 12;
            --year;
        }
        if (G) {
            n = (int)Math.floor(year / 100);
            n = 2 - n + (int)Math.floor(n / 4);
        }
        return Math.floor(365.25 * (double)(year + 4716)) + Math.floor(30.6001 * (double)(month + 1)) + day + (double)n - 1524.5;
    }

    public static TimeZoneDTO julianDaysToTimeZone(double julianDays) {
        int D = (int)Math.floor(julianDays + 0.5);
        double F = julianDays + 0.5 - (double)D;
        if (D >= 2299161) {
            int c = (int)Math.floor(((double)D - 1867216.25) / 36524.25);
            D = (int)((double)D + ((double)(1 + c) - Math.floor(c / 4)));
        }
        int year = (int)Math.floor(((double)(D += 1524) - 122.1) / 365.25);
        D = (int)((double)D - Math.floor(365.25 * (double)year));
        int month = (int)Math.floor((double)D / 30.601);
        int day = D = (int)((double)D - Math.floor(30.601 * (double)month));
        if (month > 13) {
            month -= 13;
            year -= 4715;
        } else {
            --month;
            year -= 4716;
        }
        int hour = (int)Math.floor(F *= 24.0);
        F -= (double)hour;
        int minute = (int)Math.floor(F *= 60.0);
        F -= (double)minute;
        double second = F *= 60.0;
        return new TimeZoneDTO(year, month, day, hour, minute, (int)second);
    }

    @Deprecated
    public static String julianDateByTimeZone(TimeZoneDTO timeZoneDTO) {
        String y = "     " + timeZoneDTO.getYear();
        String m = "0" + timeZoneDTO.getMonth();
        String d = "0" + timeZoneDTO.getDay();
        int h = timeZoneDTO.getHour();
        int mm = timeZoneDTO.getMinute();
        int s = (int)Math.floor((double)timeZoneDTO.getSecond() + 0.5);
        if (s >= 60) {
            s -= 60;
            ++mm;
        }
        if (mm >= 60) {
            mm -= 60;
            ++h;
        }
        String hStr = "0" + h;
        String mStr = "0" + mm;
        String sStr = "0" + s;
        y = CommonUtils.subString(y, y.length() - 5);
        m = CommonUtils.subString(m, m.length() - 2);
        d = CommonUtils.subString(d, d.length() - 2);
        hStr = CommonUtils.subString(hStr, hStr.length() - 2);
        mStr = CommonUtils.subString(mStr, mStr.length() - 2);
        sStr = CommonUtils.subString(sStr, sStr.length() - 2);
        return y + "-" + m + "-" + d + " " + hStr + ":" + mStr + ":" + sStr;
    }

    public static String julianDays2str(double jd) {
        return JulianCalendarUtils.julianDaysToTimeZone(jd).getDateTimeInfo();
    }

    public static String getJulianTime(double jd) {
        jd += 0.5;
        jd -= Math.floor(jd);
        int s = (int)Math.floor(jd * 86400.0 + 0.5);
        int h = (int)Math.floor(s / 3600);
        int m = (int)Math.floor((s -= h * 3600) / 60);
        String hStr = "0" + h;
        String mStr = "0" + m;
        String sStr = "0" + (s -= m * 60);
        return CommonUtils.subString(hStr, hStr.length() - 2, hStr.length()) + ":" + CommonUtils.subString(mStr, mStr.length() - 2, mStr.length()) + ":" + CommonUtils.subString(sStr, sStr.length() - 2, sStr.length());
    }

    protected int getWeek(double jd) {
        return (int)Math.floor(jd + 1.5 + 7000000.0) % 7;
    }

    public static int julianDaysByWeek(int year, int month, int n, int week) {
        double jd = JulianCalendarUtils.getJulianDayNumber(year, month, 1.5);
        double w0 = (jd + 1.0 + 7000000.0) % 7.0;
        int r = (int)(jd - w0 + (double)(7 * n) + (double)week);
        if ((double)week >= w0) {
            r -= 7;
        }
        if (n == 5) {
            if (++month > 12) {
                month = 1;
                ++year;
            }
            if ((double)r >= JulianCalendarUtils.getJulianDayNumber(year, month, 1.5)) {
                r -= 7;
            }
        }
        return r;
    }
}

