/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.dto.TimeZoneDTO;
import cn.huangdayu.almanac.utils.ConstantsUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTimeUtils {
    public static String timeStr = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2 \u65f6\u533a:Z \u661f\u671f\u4e2d\u7684\u5929\u6570:E \u5e74\u4e2d\u7684\u5468\u6570:w \u6708\u4efd\u4e2d\u7684\u5468\u6570:W \u5e74\u4e2d\u7684\u5929\u6570:D \u6708\u4efd\u4e2d\u7684\u5929\u6570:d \u6708\u4efd\u4e2d\u7684\u661f\u671f:F ";
    private static GregorianCalendar utcCal = null;

    public static Calendar dateToCalendar(Date date) {
        return DateTimeUtils.timeInMillisToCalendar(date.getTime());
    }

    public static Calendar dateToCalendar2(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static GregorianCalendar timeInMillisToCalendar(long TimeInMillis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(TimeInMillis);
        return calendar;
    }

    public static Calendar timeInMillisToCalendar2(long TimeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeInMillis);
        return calendar;
    }

    public static Calendar instantToCalendar(Instant instant) {
        return DateTimeUtils.timeInMillisToCalendar(instant.toEpochMilli());
    }

    public static Calendar instantToCalendar(String instant) {
        String[] sqlits = instant.split("T|-|Z|:|\\.");
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.parseInt(sqlits[0]), Integer.parseInt(sqlits[1]) - 1, Integer.parseInt(sqlits[2]), Integer.parseInt(sqlits[3]) + 8, Integer.parseInt(sqlits[4]), Integer.parseInt(sqlits[5]));
        return calendar;
    }

    public static Calendar strToCalendar(String str) {
        return DateTimeUtils.dateToCalendar(DateTimeUtils.toDate(str));
    }

    public static Calendar intToCalendar(int year, int month, int day, int hourOfDay, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, hourOfDay, minute);
        return calendar;
    }

    public static Calendar intToCalendar(int year, int month, int day, int hourOfDay, int minute, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, hourOfDay, minute, second);
        return calendar;
    }

    public static Calendar intToCalendar(int year, int month, int day, int hourOfDay, int minute, double second) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, day, hourOfDay, minute, (int)second);
        return calendar;
    }

    public static Calendar intToCalendar(int year, int month, int day, int hourOfDay, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    public static Calendar toCalendar(TimeZoneDTO timeZoneDTO) {
        return DateTimeUtils.intToCalendar(timeZoneDTO.getYear(), timeZoneDTO.getMonth(), timeZoneDTO.getDay(), timeZoneDTO.getHour(), timeZoneDTO.getMinute(), timeZoneDTO.getSecond());
    }

    public static void toTimeZone(TimeZoneDTO timeZoneDTO, Calendar calendar) {
        timeZoneDTO.setYear(calendar.get(1));
        timeZoneDTO.setMonth(calendar.get(2) + 1);
        timeZoneDTO.setDay(calendar.get(5));
        timeZoneDTO.setWeek(calendar.get(7));
        timeZoneDTO.setHour(calendar.get(11));
        timeZoneDTO.setMinute(calendar.get(12));
        timeZoneDTO.setSecond(calendar.get(13));
        timeZoneDTO.setIndex(DateTimeUtils.getTimZoneInt(calendar));
        String format = DateTimeUtils.formatDateByFormat(calendar, "Z");
        String value = format.substring(1, 3);
        int i = 1;
        int j = Integer.parseInt(value);
        i = j > 0 ? Integer.parseInt(value) : Integer.parseInt(value.substring(1));
        if (format.contains("-")) {
            timeZoneDTO.setTimeZone(format + " \u897f" + ConstantsUtils.TIMEZONE[i - 1] + "\u533a");
        } else {
            timeZoneDTO.setTimeZone(format + " \u4e1c" + ConstantsUtils.TIMEZONE[i - 1] + "\u533a");
        }
    }

    public static void calculateTimeZone(TimeZoneDTO now, TimeZoneDTO old) {
        DateTimeUtils.toTimeZone(now, DateTimeUtils.toCalendar(old));
    }

    public static String toUTC(Date date) {
        return date.toInstant().toString();
    }

    public static String dateFormat(Calendar calendar, String format) {
        return DateTimeUtils.dateFormat(DateTimeUtils.calendarToDate(calendar), format);
    }

    public static String dateFormat(Date date, String format) {
        String result = null;
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                result = sdf.format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static Date toDate(String str) {
        String format = null;
        if (str.contains(".") || str.contains("T") || str.contains("Z")) {
            str = str.replace("T", " ").replaceAll("Z", "");
            format = "yyyy-MM-dd HH:mm:ss.SS";
        } else {
            format = str.contains("\u5e74") && 2 == str.split(":").length ? "yyyy\u5e74MM\u6708dd\u65e5 HH:mm" : (str.contains("\u5e74") ? "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss" : (2 == str.split(":").length ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd HH:mm:ss"));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = dateFormat.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date toDate(int y, int M, int d, int h, int m) {
        String str = y + "-" + M + "-" + d + " " + h + ":" + m;
        return DateTimeUtils.toDate(str);
    }

    public static Date toDate(int y, int M, int d, int h, int m, int s) {
        String str = y + "-" + M + "-" + d + " " + h + ":" + m + ":" + s;
        return DateTimeUtils.toDate(str);
    }

    public static Date toDate(int y, int M, int d, int h, int m, int s, int ss) {
        String str = y + "-" + M + "-" + d + " " + h + ":" + m + ":" + s + "." + ss;
        return DateTimeUtils.toDate(str);
    }

    public static String getFormattingTime(String str) {
        String newStr = "";
        if (str.contains(":") && !str.contains("\u5e74") && !str.contains("-") && !str.contains("\u6708")) {
            String[] strsArea = str.split(":");
            for (int i = 0; i < strsArea.length; ++i) {
                if (Integer.valueOf(strsArea[i]) >= 10) continue;
                strsArea[i] = "0" + strsArea[i];
            }
            newStr = strsArea[0] + ":" + strsArea[1] + ":" + strsArea[2];
        } else {
            newStr = str;
        }
        return newStr;
    }

    public static int getTimZoneInt(Calendar calendar) {
        return DateTimeUtils.getTimZoneInt(calendar.getTime());
    }

    public static int getTimZoneInt(Date date) {
        String strDateFormat = DateTimeUtils.formatDateByFormat(date, "Z");
        String str2 = strDateFormat.substring(1, 3);
        int j = Integer.valueOf(str2.substring(0));
        int timeZoneInt = 0;
        timeZoneInt = j > 0 ? Integer.valueOf(str2).intValue() : Integer.valueOf(str2.substring(1)).intValue();
        return timeZoneInt;
    }

    public static String formatDateByFormat(Calendar calendar, String format) {
        return DateTimeUtils.formatDateByFormat(DateTimeUtils.calendarToDate(calendar), format);
    }

    public static String formatDateByFormat(Date date, String format) {
        String result = "";
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                result = sdf.format(date);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static String getFormatDate(String str) {
        return new SimpleDateFormat(str).format(new Date()).toString();
    }

    public static Date calendarToDate(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int week = calendar.get(7);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millisecond = calendar.get(14);
        return DateTimeUtils.toDate(year, month, day, hour, minute, second, millisecond);
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        System.out.println(DateTimeUtils.calendarToDate(calendar));
    }

    public static String getWeek(Calendar calendar) {
        int y = calendar.get(1);
        int m = calendar.get(2) + 1;
        int d = calendar.get(5);
        if (m < 3) {
            m += 12;
            --y;
        }
        int w = (d + 1 + 2 * m + 3 * (m + 1) / 5 + y + (y >> 2) - y / 100 + y / 400) % 7;
        return ConstantsUtils.WEEK_NAME[w];
    }

    public static String getTime(double d) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date currentTime = new Date((long)d);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    private static synchronized void makeUTCCalendar() {
        if (utcCal == null) {
            utcCal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long UTC(int y, int m, int d, int hh, int mm, int ss) {
        DateTimeUtils.makeUTCCalendar();
        GregorianCalendar gregorianCalendar = utcCal;
        synchronized (gregorianCalendar) {
            utcCal.clear();
            utcCal.set(y, m, d, hh, mm, ss);
            return utcCal.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getUTCDay(Date date) {
        DateTimeUtils.makeUTCCalendar();
        GregorianCalendar gregorianCalendar = utcCal;
        synchronized (gregorianCalendar) {
            utcCal.clear();
            utcCal.setTimeInMillis(date.getTime());
            return utcCal.get(5);
        }
    }
}

