/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.exception.AlmanacException;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class CommonUtils {
    public static final double RAD = 206264.80624709636;
    public static final int JULIAN_FOR_2000 = 2451545;
    public static final double PI_2 = Math.PI * 2;
    private static final double[] DT_AT = new double[]{-4000.0, 108371.7, -13036.8, 392.0, 0.0, -500.0, 17201.0, -627.82, 16.17, -0.3413, -150.0, 12200.6, -346.41, 5.403, -0.1593, 150.0, 9113.8, -328.13, -1.647, 0.0377, 500.0, 5707.5, -391.41, 0.915, 0.3145, 900.0, 2203.4, -283.45, 13.034, -0.1778, 1300.0, 490.1, -57.35, 2.085, -0.0072, 1600.0, 120.0, -9.81, -1.532, 0.1403, 1700.0, 10.2, -0.91, 0.51, -0.037, 1800.0, 13.4, -0.72, 0.202, -0.0193, 1830.0, 7.8, -1.81, 0.416, -0.0247, 1860.0, 8.3, -0.13, -0.406, 0.0292, 1880.0, -5.4, 0.32, -0.183, 0.0173, 1900.0, -2.3, 2.06, 0.169, -0.0135, 1920.0, 21.2, 1.69, -0.304, 0.0167, 1940.0, 24.2, 1.22, -0.064, 0.0031, 1960.0, 33.2, 0.51, 0.231, -0.0109, 1980.0, 51.0, 1.29, -0.026, 0.0032, 2000.0, 63.87, 0.1, 0.0, 0.0, 2005.0, 64.7, 0.4, 0.0, 0.0, 2015.0, 69.0};
    private static final double[] NUT_B = new double[]{2.1824, -33.75705, 3.6E-5, -1720.0, 920.0, 3.5069, 1256.66393, 1.1E-5, -132.0, 57.0, 1.3375, 16799.4182, -5.1E-5, -23.0, 10.0, 4.3649, -67.5141, 7.2E-5, 21.0, -9.0, 0.04, -628.302, 0.0, -14.0, 0.0, 2.36, 8328.691, 0.0, 7.0, 0.0, 3.46, 1884.966, 0.0, -5.0, 2.0, 5.44, 16833.175, 0.0, -4.0, 2.0, 3.69, 25128.11, 0.0, -3.0, 0.0, 3.55, 628.362, 0.0, 2.0, 0.0};
    private static double[][] XL0 = new double[8][];
    private static final double[] XL0_xzb;
    private static final double[][][] XL1;

    public static String subString(String str, int beginIndex) {
        return CommonUtils.subString(str, beginIndex, 0);
    }

    public static String subString(String str, int beginIndex, int endIndex) {
        String subStr = "";
        if (subStr != null) {
            int length = str.length();
            if (beginIndex >= 0 && beginIndex < length) {
                if (endIndex == 0) {
                    subStr = str.substring(beginIndex);
                } else if (beginIndex < endIndex && endIndex <= length) {
                    subStr = str.substring(beginIndex, endIndex);
                }
            }
        }
        return subStr;
    }

    private static double dtExt(double y, int jsd) {
        double dy = (y - 1820.0) / 100.0;
        return -20.0 + (double)jsd * dy * dy;
    }

    private static double dtCalc(double y) {
        int i;
        double y0 = DT_AT[DT_AT.length - 2];
        double t0 = DT_AT[DT_AT.length - 1];
        if (y >= y0) {
            int jsd = 31;
            if (y > y0 + 100.0) {
                return CommonUtils.dtExt(y, jsd);
            }
            double v = CommonUtils.dtExt(y, jsd);
            double dv = CommonUtils.dtExt(y0, jsd) - t0;
            return v - dv * (y0 + 100.0 - y) / 100.0;
        }
        double[] d = DT_AT;
        for (i = 0; i < d.length && !(y < d[i + 5]); i += 5) {
        }
        double t1 = (y - d[i]) / (d[i + 5] - d[i]) * 10.0;
        double t2 = t1 * t1;
        double t3 = t2 * t1;
        return d[i + 1] + d[i + 2] * t1 + d[i + 3] * t2 + d[i + 4] * t3;
    }

    public static double dtT(double t) {
        return CommonUtils.dtCalc(t / 365.2425 + 2000.0) / 86400.0;
    }

    public static double nutationLon2(double t) {
        double t2 = t * t;
        double dL = 0.0;
        double[] B = NUT_B;
        for (int i = 0; i < B.length; i += 5) {
            double a = i == 0 ? -1.742 * t : 0.0;
            dL += (B[i + 3] + a) * Math.sin(B[i] + B[i + 1] * t + B[i + 2] * t2);
        }
        return dL / 100.0 / 206264.80624709636;
    }

    private static double[] getXL0_1() {
        double[] XL0 = new double[]{1.0E10, 20.0, 578.0, 920.0, 1100.0, 1124.0, 1136.0, 1148.0, 1217.0, 1226.0, 1229.0, 1229.0, 1229.0, 1229.0, 1937.0, 2363.0, 2618.0, 2633.0, 2660.0, 2666.0, 1.7534704567E10, 0.0, 0.0, 3.34165646E8, 4.669256804, 6283.075849991, 3489428.0, 4.6261024, 12566.1517, 349706.0, 2.744118, 5753.384885, 341757.0, 2.828866, 3.523118, 313590.0, 3.62767, 77713.771468, 267622.0, 4.418084, 7860.419392, 234269.0, 6.135162, 3930.209696, 132429.0, 0.742464, 11506.76977, 127317.0, 2.037097, 529.690965, 119917.0, 1.109629, 1577.343542, 99025.0, 5.23268, 5884.92685, 90186.0, 2.04505, 26.29832, 85722.0, 3.50849, 398.149, 77979.0, 1.17883, 5223.69392, 75314.0, 2.53339, 5507.55324, 50526.0, 4.58293, 18849.22755, 49238.0, 4.20507, 775.52261, 35666.0, 2.91954, 0.06731, 31709.0, 5.84902, 11790.62909, 28413.0, 1.89869, 796.29801, 27104.0, 0.31489, 10977.0788, 24281.0, 0.34481, 5486.77784, 20616.0, 4.80647, 2544.31442, 20539.0, 1.86948, 5573.1428, 20226.0, 2.45768, 6069.77675, 15552.0, 0.83306, 213.2991, 13221.0, 3.41118, 2942.46342, 12618.0, 1.08303, 20.7754, 11513.0, 0.64545, 0.98032, 10285.0, 0.636, 4694.00295, 10190.0, 0.97569, 15720.83878, 10172.0, 4.2668, 7.11355, 9921.0, 6.2099, 2146.1654, 9761.0, 0.681, 155.4204, 8580.0, 5.9832, 161000.6857, 8513.0, 1.2987, 6275.9623, 8471.0, 3.6708, 71430.6956, 7964.0, 1.8079, 17260.1547, 7876.0, 3.037, 12036.4607, 7465.0, 1.7551, 5088.6288, 7387.0, 3.5032, 3154.6871, 7355.0, 4.6793, 801.8209, 6963.0, 0.833, 9437.7629, 6245.0, 3.9776, 8827.3903, 6115.0, 1.8184, 7084.8968, 5696.0, 2.7843, 6286.599, 5612.0, 4.3869, 14143.4952, 5558.0, 3.4701, 6279.5527, 5199.0, 0.1891, 12139.5535, 5161.0, 1.3328, 1748.0164, 5115.0, 0.2831, 5856.4777, 4900.0, 0.4874, 1194.447, 4104.0, 5.3682, 8429.2413, 4094.0, 2.3985, 19651.0485, 3920.0, 6.1683, 10447.3878, 3677.0, 6.0413, 10213.2855, 3660.0, 2.5696, 1059.3819, 3595.0, 1.7088, 2352.8662, 3557.0, 1.776, 6812.7668, 3329.0, 0.5931, 17789.8456, 3041.0, 0.4429, 83996.8473, 3005.0, 2.7398, 1349.8674, 2535.0, 3.1647, 4690.4798, 2474.0, 0.2148, 3.5904, 2366.0, 0.4847, 8031.0923, 2357.0, 2.0653, 3340.6124, 2282.0, 5.222, 4705.7323, 2189.0, 5.5559, 553.5694, 2142.0, 1.4256, 16730.4637, 2109.0, 4.1483, 951.7184, 2030.0, 0.3713, 283.8593, 1992.0, 5.2221, 12168.0027, 1986.0, 5.7747, 6309.3742, 1912.0, 3.8222, 23581.2582, 1889.0, 5.3863, 149854.4001, 1790.0, 2.2149, 13367.9726, 1748.0, 4.5605, 135.0651, 1622.0, 5.9884, 11769.8537, 1508.0, 4.1957, 6256.7775, 1442.0, 4.1932, 242.7286, 1435.0, 3.7236, 38.0277, 1397.0, 4.4014, 6681.2249, 1362.0, 1.8893, 7632.9433, 1250.0, 1.1305, 5.5229, 1205.0, 2.6223, 955.5997, 1200.0, 1.0035, 632.7837, 1129.0, 0.1774, 4164.312, 1083.0, 0.3273, 103.0928, 1052.0, 0.9387, 11926.2544, 1050.0, 5.3591, 1592.596, 1033.0, 6.1998, 6438.4962, 1001.0, 6.0291, 5746.2713, 980.0, 0.999, 11371.705, 980.0, 5.244, 27511.468, 938.0, 2.624, 5760.498, 923.0, 0.483, 522.577, 922.0, 4.571, 4292.331, 905.0, 5.337, 6386.169, 862.0, 4.165, 7058.598, 841.0, 3.299, 7234.794, 836.0, 4.539, 25132.303, 813.0, 6.112, 4732.031, 812.0, 6.271, 426.598, 801.0, 5.821, 28.449, 787.0, 0.996, 5643.179, 776.0, 2.957, 23013.54, 769.0, 3.121, 7238.676, 758.0, 3.974, 11499.656, 735.0, 4.386, 316.392, 731.0, 0.607, 11513.883, 719.0, 3.998, 74.782, 706.0, 0.323, 263.084, 676.0, 5.911, 90955.552, 663.0, 3.665, 17298.182, 653.0, 5.791, 18073.705, 630.0, 4.717, 6836.645, 615.0, 1.458, 233141.314, 612.0, 1.075, 19804.827, 596.0, 3.321, 6283.009, 596.0, 2.876, 6283.143, 555.0, 2.452, 12352.853, 541.0, 5.392, 419.485, 531.0, 0.382, 31441.678, 519.0, 4.065, 6208.294, 513.0, 2.361, 10973.556, 494.0, 5.737, 9917.697, 450.0, 3.272, 11015.106, 449.0, 3.653, 206.186, 447.0, 2.064, 7079.374, 435.0, 4.423, 5216.58, 421.0, 1.906, 245.832, 413.0, 0.921, 3738.761, 402.0, 0.84, 20.355, 387.0, 1.826, 11856.219, 379.0, 2.344, 3.881, 374.0, 2.954, 3128.389, 370.0, 5.031, 536.805, 365.0, 1.018, 16200.773, 365.0, 1.083, 88860.057, 352.0, 5.978, 3894.182, 352.0, 2.056, 244287.6, 351.0, 3.713, 6290.189, 340.0, 1.106, 14712.317, 339.0, 0.978, 8635.942, 339.0, 3.202, 5120.601, 333.0, 0.837, 6496.375, 325.0, 3.479, 6133.513, 316.0, 5.089, 21228.392, 316.0, 1.328, 10873.986, 309.0, 3.646, 10.637, 303.0, 1.802, 35371.887, 296.0, 3.397, 9225.539, 288.0, 6.026, 154717.61, 281.0, 2.585, 14314.168, 262.0, 3.856, 266.607, 262.0, 2.579, 22483.849, 257.0, 1.561, 23543.231, 255.0, 3.949, 1990.745, 251.0, 3.744, 10575.407, 240.0, 1.161, 10984.192, 238.0, 0.106, 7.046, 236.0, 4.272, 6040.347, 234.0, 3.577, 10969.965, 211.0, 3.714, 65147.62, 210.0, 0.754, 13521.751, 207.0, 4.228, 5650.292, 202.0, 0.814, 170.673, 201.0, 4.629, 6037.244, 200.0, 0.381, 6172.87, 199.0, 3.933, 6206.81, 199.0, 5.197, 6262.3, 197.0, 1.046, 18209.33, 195.0, 1.07, 5230.807, 195.0, 4.869, 36.028, 194.0, 4.313, 6244.943, 192.0, 1.229, 709.933, 192.0, 5.595, 6282.096, 192.0, 0.602, 6284.056, 189.0, 3.744, 23.878, 188.0, 1.904, 15.252, 188.0, 0.867, 22003.915, 182.0, 3.681, 15110.466, 181.0, 0.491, 1.484, 179.0, 3.222, 39302.097, 179.0, 1.259, 12559.038, 6.2833196674749E13, 0.0, 0.0, 2.0605886E7, 2.67823456, 6283.07584999, 430343.0, 2.635127, 12566.1517, 42526.0, 1.59047, 3.52312, 11926.0, 5.79557, 26.29832, 10898.0, 2.96618, 1577.34354, 9348.0, 2.5921, 18849.2275, 7212.0, 1.1385, 529.691, 6777.0, 1.8747, 398.149, 6733.0, 4.4092, 5507.5532, 5903.0, 2.888, 5223.6939, 5598.0, 2.1747, 155.4204, 4541.0, 0.398, 796.298, 3637.0, 0.4662, 775.5226, 2896.0, 2.6471, 7.1135, 2084.0, 5.3414, 0.9803, 1910.0, 1.8463, 5486.7778, 1851.0, 4.9686, 213.2991, 1729.0, 2.9912, 6275.9623, 1623.0, 0.0322, 2544.3144, 1583.0, 1.4305, 2146.1654, 1462.0, 1.2053, 10977.0788, 1246.0, 2.8343, 1748.0164, 1188.0, 3.258, 5088.6288, 1181.0, 5.2738, 1194.447, 1151.0, 2.075, 4694.003, 1064.0, 0.7661, 553.5694, 997.0, 1.303, 6286.599, 972.0, 4.239, 1349.867, 945.0, 2.7, 242.729, 858.0, 5.645, 951.718, 758.0, 5.301, 2352.866, 639.0, 2.65, 9437.763, 610.0, 4.666, 4690.48, 583.0, 1.766, 1059.382, 531.0, 0.909, 3154.687, 522.0, 5.661, 71430.696, 520.0, 1.854, 801.821, 504.0, 1.425, 6438.496, 433.0, 0.241, 6812.767, 426.0, 0.774, 10447.388, 413.0, 5.24, 7084.897, 374.0, 2.001, 8031.092, 356.0, 2.429, 14143.495, 350.0, 4.8, 6279.553, 337.0, 0.888, 12036.461, 337.0, 3.862, 1592.596, 325.0, 3.4, 7632.943, 322.0, 0.616, 8429.241, 318.0, 3.188, 4705.732, 297.0, 6.07, 4292.331, 295.0, 1.431, 5746.271, 290.0, 2.325, 20.355, 275.0, 0.935, 5760.498, 270.0, 4.804, 7234.794, 253.0, 6.223, 6836.645, 228.0, 5.003, 17789.846, 225.0, 5.672, 11499.656, 215.0, 5.202, 11513.883, 208.0, 3.955, 10213.286, 208.0, 2.268, 522.577, 206.0, 2.224, 5856.478, 206.0, 2.55, 25132.303, 203.0, 0.91, 6256.778, 189.0, 0.532, 3340.612, 188.0, 4.735, 83996.847, 179.0, 1.474, 4164.312, 178.0, 3.025, 5.523, 177.0, 3.026, 5753.385, 159.0, 4.637, 3.286, 157.0, 6.124, 5216.58, 155.0, 3.077, 6681.225, 154.0, 4.2, 13367.973, 143.0, 1.191, 3894.182, 138.0, 3.093, 135.065, 136.0, 4.245, 426.598, 134.0, 5.765, 6040.347, 128.0, 3.085, 5643.179, 127.0, 2.092, 6290.189, 125.0, 3.077, 11926.254, 125.0, 3.445, 536.805, 114.0, 3.244, 12168.003, 112.0, 2.318, 16730.464, 111.0, 3.901, 11506.77, 111.0, 5.32, 23.878, 105.0, 3.75, 7860.419, 103.0, 2.447, 1990.745, 96.0, 0.82, 3.88, 96.0, 4.08, 6127.66, 91.0, 5.42, 206.19, 91.0, 0.42, 7079.37, 88.0, 5.17, 11790.63, 81.0, 0.34, 9917.7, 80.0, 3.89, 10973.56, 78.0, 2.4, 1589.07, 78.0, 2.58, 11371.7, 77.0, 3.98, 955.6, 77.0, 3.36, 36.03, 76.0, 1.3, 103.09, 75.0, 5.18, 10969.97, 75.0, 4.96, 6496.37, 73.0, 5.21, 38.03, 72.0, 2.65, 6309.37, 70.0, 5.61, 3738.76, 69.0, 2.6, 3496.03, 69.0, 0.39, 15.25, 69.0, 2.78, 20.78, 65.0, 1.13, 7058.6, 64.0, 4.28, 28.45, 61.0, 5.63, 10984.19, 60.0, 0.73, 419.48, 60.0, 5.28, 10575.41, 58.0, 5.55, 17298.18, 58.0, 3.19, 4732.03, 5291887.0, 0.0, 0.0, 871984.0, 1.072097, 6283.07585, 30913.0, 0.86729, 12566.1517, 2734.0, 0.053, 3.5231, 1633.0, 5.1883, 26.2983, 1575.0, 3.6846, 155.4204, 954.0, 0.757, 18849.228, 894.0, 2.057, 77713.771, 695.0, 0.827, 775.523, 506.0, 4.663, 1577.344, 406.0, 1.031, 7.114, 381.0, 3.441, 5573.143, 346.0, 5.141, 796.298, 317.0, 6.053, 5507.553, 302.0, 1.192, 242.729, 289.0, 6.117, 529.691, 271.0, 0.306, 398.149, 254.0, 2.28, 553.569, 237.0, 4.381, 5223.694, 208.0, 3.754, 0.98, 168.0, 0.902, 951.718, 153.0, 5.759, 1349.867, 145.0, 4.364, 1748.016, 134.0, 3.721, 1194.447, 125.0, 2.948, 6438.496, 122.0, 2.973, 2146.165, 110.0, 1.271, 161000.686, 104.0, 0.604, 3154.687, 100.0, 5.986, 6286.599, 92.0, 4.8, 5088.63, 89.0, 5.23, 7084.9, 83.0, 3.31, 213.3, 76.0, 3.42, 5486.78, 71.0, 6.19, 4690.48, 68.0, 3.43, 4694.0, 65.0, 1.6, 2544.31, 64.0, 1.98, 801.82, 61.0, 2.48, 10977.08, 50.0, 1.44, 6836.65, 49.0, 2.34, 1592.6, 46.0, 1.31, 4292.33, 46.0, 3.81, 149854.4, 43.0, 0.04, 7234.79, 40.0, 4.94, 7632.94, 39.0, 1.57, 71430.7, 38.0, 3.17, 6309.37, 35.0, 0.99, 6040.35, 35.0, 0.67, 1059.38, 31.0, 3.18, 2352.87, 31.0, 3.55, 8031.09, 30.0, 1.92, 10447.39, 30.0, 2.52, 6127.66, 28.0, 4.42, 9437.76, 28.0, 2.71, 3894.18, 27.0, 0.67, 25132.3, 26.0, 5.27, 6812.77, 25.0, 0.55, 6279.55, 23.0, 1.38, 4705.73, 22.0, 0.64, 6256.78, 20.0, 6.07, 640.88, 28923.0, 5.84384, 6283.07585, 3496.0, 0.0, 0.0, 1682.0, 5.4877, 12566.1517, 296.0, 5.196, 155.42, 129.0, 4.722, 3.523, 71.0, 5.3, 18849.23, 64.0, 5.97, 242.73, 40.0, 3.79, 553.57, 11408.0, 3.14159, 0.0, 772.0, 4.134, 6283.076, 77.0, 3.84, 12566.15, 42.0, 0.42, 155.42, 88.0, 3.14, 0.0, 17.0, 2.77, 6283.08, 5.0, 2.01, 155.42, 3.0, 2.21, 12566.15, 27962.0, 3.1987, 84334.66158, 10164.0, 5.42249, 5507.55324, 8045.0, 3.8801, 5223.6939, 4381.0, 3.7044, 2352.8662, 3193.0, 4.0003, 1577.3435, 2272.0, 3.9847, 1047.7473, 1814.0, 4.9837, 6283.0758, 1639.0, 3.5646, 5856.4777, 1444.0, 3.7028, 9437.7629, 1430.0, 3.4112, 10213.2855, 1125.0, 4.8282, 14143.4952, 1090.0, 2.0857, 6812.7668, 1037.0, 4.0566, 71092.8814, 971.0, 3.473, 4694.003, 915.0, 1.142, 6620.89, 878.0, 4.44, 5753.385, 837.0, 4.993, 7084.897, 770.0, 5.554, 167621.576, 719.0, 3.602, 529.691, 692.0, 4.326, 6275.962, 558.0, 4.41, 7860.419, 529.0, 2.484, 4705.732, 521.0, 6.25, 18073.705, 903.0, 3.897, 5507.553, 618.0, 1.73, 5223.694, 380.0, 5.244, 2352.866, 166.0, 1.627, 84334.662, 1.000139888E10, 0.0, 0.0, 1.67069963E8, 3.098463508, 6283.075849991, 1395602.0, 3.0552461, 12566.1517, 308372.0, 5.198467, 77713.771468, 162846.0, 1.173877, 5753.384885, 157557.0, 2.846852, 7860.419392, 92480.0, 5.45292, 11506.76977, 54244.0, 4.56409, 3930.2097, 47211.0, 3.661, 5884.92685, 34598.0, 0.96369, 5507.55324, 32878.0, 5.89984, 5223.69392, 30678.0, 0.29867, 5573.1428, 24319.0, 4.2735, 11790.62909, 21183.0, 5.84715, 1577.34354, 18575.0, 5.02194, 10977.0788, 17484.0, 3.01194, 18849.22755, 10984.0, 5.05511, 5486.77784, 9832.0, 0.8868, 6069.7768, 8650.0, 5.6896, 15720.8388, 8583.0, 1.2708, 161000.6857, 6490.0, 0.2725, 17260.1547, 6292.0, 0.9218, 529.691, 5706.0, 2.0137, 83996.8473, 5574.0, 5.2416, 71430.6956, 4938.0, 3.245, 2544.3144, 4696.0, 2.5781, 775.5226, 4466.0, 5.5372, 9437.7629, 4252.0, 6.0111, 6275.9623, 3897.0, 5.3607, 4694.003, 3825.0, 2.3926, 8827.3903, 3749.0, 0.8295, 19651.0485, 3696.0, 4.9011, 12139.5535, 3566.0, 1.6747, 12036.4607, 3454.0, 1.8427, 2942.4634, 3319.0, 0.2437, 7084.8968, 3192.0, 0.1837, 5088.6288, 3185.0, 1.7778, 398.149, 2846.0, 1.2134, 6286.599, 2779.0, 1.8993, 6279.5527, 2628.0, 4.589, 10447.3878, 2460.0, 3.7866, 8429.2413, 2393.0, 4.996, 5856.4777, 2359.0, 0.2687, 796.298, 2329.0, 2.8078, 14143.4952, 2210.0, 1.95, 3154.6871, 2035.0, 4.6527, 2146.1654, 1951.0, 5.3823, 2352.8662, 1883.0, 0.6731, 149854.4001, 1833.0, 2.2535, 23581.2582, 1796.0, 0.1987, 6812.7668, 1731.0, 6.152, 16730.4637, 1717.0, 4.4332, 10213.2855, 1619.0, 5.2316, 17789.8456, 1381.0, 5.1896, 8031.0923, 1364.0, 3.6852, 4705.7323, 1314.0, 0.6529, 13367.9726, 1041.0, 4.3329, 11769.8537, 1017.0, 1.5939, 4690.4798, 998.0, 4.201, 6309.374, 966.0, 3.676, 27511.468, 874.0, 6.064, 1748.016, 779.0, 3.674, 12168.003, 771.0, 0.312, 7632.943, 756.0, 2.626, 6256.778, 746.0, 5.648, 11926.254, 693.0, 2.924, 6681.225, 680.0, 1.423, 23013.54, 674.0, 0.563, 3340.612, 663.0, 5.661, 11371.705, 659.0, 3.136, 801.821, 648.0, 2.65, 19804.827, 615.0, 3.029, 233141.314, 612.0, 5.134, 1194.447, 563.0, 4.341, 90955.552, 552.0, 2.091, 17298.182, 534.0, 5.1, 31441.678, 531.0, 2.407, 11499.656, 523.0, 4.624, 6438.496, 513.0, 5.324, 11513.883, 477.0, 0.256, 11856.219, 461.0, 1.722, 7234.794, 458.0, 3.766, 6386.169, 458.0, 4.466, 5746.271, 423.0, 1.055, 5760.498, 422.0, 1.557, 7238.676, 415.0, 2.599, 7058.598, 401.0, 3.03, 1059.382, 397.0, 1.201, 1349.867, 379.0, 4.907, 4164.312, 360.0, 5.707, 5643.179, 352.0, 3.626, 244287.6, 348.0, 0.761, 10973.556, 342.0, 3.001, 4292.331, 336.0, 4.546, 4732.031, 334.0, 3.138, 6836.645, 324.0, 4.164, 9917.697, 316.0, 1.691, 11015.106, 307.0, 0.238, 35371.887, 298.0, 1.306, 6283.143, 298.0, 1.75, 6283.009, 293.0, 5.738, 16200.773, 286.0, 5.928, 14712.317, 281.0, 3.515, 21228.392, 280.0, 5.663, 8635.942, 277.0, 0.513, 26.298, 268.0, 4.207, 18073.705, 266.0, 0.9, 12352.853, 260.0, 2.962, 25132.303, 255.0, 2.477, 6208.294, 242.0, 2.8, 709.933, 231.0, 1.054, 22483.849, 229.0, 1.07, 14314.168, 216.0, 1.314, 154717.61, 215.0, 6.038, 10873.986, 200.0, 0.561, 7079.374, 198.0, 2.614, 951.718, 197.0, 4.369, 167283.762, 186.0, 2.861, 5216.58, 183.0, 1.66, 39302.097, 183.0, 5.912, 3738.761, 175.0, 2.145, 6290.189, 173.0, 2.168, 10575.407, 171.0, 3.702, 1592.596, 171.0, 1.343, 3128.389, 164.0, 5.55, 6496.375, 164.0, 5.856, 10984.192, 161.0, 1.998, 10969.965, 161.0, 1.909, 6133.513, 157.0, 4.955, 25158.602, 154.0, 6.216, 23543.231, 153.0, 5.357, 13521.751, 150.0, 5.77, 18209.33, 150.0, 5.439, 155.42, 139.0, 1.778, 9225.539, 139.0, 1.626, 5120.601, 128.0, 2.46, 13916.019, 123.0, 0.717, 143571.324, 122.0, 2.654, 88860.057, 121.0, 4.414, 3894.182, 121.0, 1.192, 3.523, 120.0, 4.03, 553.569, 119.0, 1.513, 17654.781, 117.0, 3.117, 14945.316, 113.0, 2.698, 6040.347, 110.0, 3.085, 43232.307, 109.0, 0.998, 955.6, 108.0, 2.939, 17256.632, 107.0, 5.285, 65147.62, 103.0, 0.139, 11712.955, 103.0, 5.85, 213.299, 102.0, 3.046, 6037.244, 101.0, 2.842, 8662.24, 100.0, 3.626, 6262.3, 98.0, 2.36, 6206.81, 98.0, 5.11, 6172.87, 98.0, 2.0, 15110.47, 97.0, 2.67, 5650.29, 97.0, 2.75, 6244.94, 96.0, 4.02, 6282.1, 96.0, 5.31, 6284.06, 92.0, 0.1, 29088.81, 85.0, 3.26, 20426.57, 84.0, 2.6, 28766.92, 81.0, 3.58, 10177.26, 80.0, 5.81, 5230.81, 78.0, 2.53, 16496.36, 77.0, 4.06, 6127.66, 73.0, 0.04, 5481.25, 72.0, 5.96, 12559.04, 72.0, 5.92, 4136.91, 71.0, 5.49, 22003.91, 70.0, 3.41, 7.11, 69.0, 0.62, 11403.68, 69.0, 3.9, 1589.07, 69.0, 1.96, 12416.59, 69.0, 4.51, 426.6, 67.0, 1.61, 11087.29, 66.0, 4.5, 47162.52, 66.0, 5.08, 283.86, 66.0, 4.32, 16858.48, 65.0, 1.04, 6062.66, 64.0, 1.59, 18319.54, 63.0, 5.7, 45892.73, 63.0, 4.6, 66567.49, 63.0, 3.82, 13517.87, 62.0, 2.62, 11190.38, 61.0, 1.54, 33019.02, 60.0, 5.58, 10344.3, 60.0, 5.38, 316428.23, 60.0, 5.78, 632.78, 59.0, 6.12, 9623.69, 57.0, 0.16, 17267.27, 57.0, 3.86, 6076.89, 57.0, 1.98, 7668.64, 56.0, 4.78, 20199.09, 55.0, 4.56, 18875.53, 55.0, 3.51, 17253.04, 54.0, 3.07, 226858.24, 54.0, 4.83, 18422.63, 53.0, 5.02, 12132.44, 52.0, 3.63, 5333.9, 52.0, 0.97, 155427.54, 51.0, 3.36, 20597.24, 50.0, 0.99, 11609.86, 50.0, 2.21, 1990.75, 48.0, 1.62, 12146.67, 48.0, 1.17, 12569.67, 47.0, 4.62, 5436.99, 47.0, 1.81, 12562.63, 47.0, 0.59, 21954.16, 47.0, 0.76, 7342.46, 46.0, 0.27, 4590.91, 46.0, 3.77, 156137.48, 45.0, 5.66, 10454.5, 44.0, 5.84, 3496.03, 43.0, 0.24, 17996.03, 41.0, 5.93, 51092.73, 41.0, 4.21, 12592.45, 40.0, 5.14, 1551.05, 40.0, 5.28, 15671.08, 39.0, 3.69, 18052.93, 39.0, 4.94, 24356.78, 38.0, 2.72, 11933.37, 38.0, 5.23, 7477.52, 38.0, 4.99, 9779.11, 37.0, 3.7, 9388.01, 37.0, 4.44, 4535.06, 36.0, 2.16, 28237.23, 36.0, 2.54, 242.73, 36.0, 0.22, 5429.88, 35.0, 6.15, 19800.95, 35.0, 2.92, 36949.23, 34.0, 5.63, 2379.16, 34.0, 5.73, 16460.33, 34.0, 5.11, 5849.36, 33.0, 6.19, 6268.85, 1.0301861E7, 1.1074897, 6283.07584999, 172124.0, 1.064423, 12566.1517, 70222.0, 3.14159, 0.0, 3235.0, 1.0217, 18849.2275, 3080.0, 2.8435, 5507.5532, 2497.0, 1.3191, 5223.6939, 1849.0, 1.4243, 1577.3435, 1008.0, 5.9138, 10977.0788, 865.0, 1.42, 6275.962, 863.0, 0.271, 5486.778, 507.0, 1.686, 5088.629, 499.0, 6.014, 6286.599, 467.0, 5.987, 529.691, 440.0, 0.518, 4694.003, 410.0, 1.084, 9437.763, 387.0, 4.75, 2544.314, 375.0, 5.071, 796.298, 352.0, 0.023, 83996.847, 344.0, 0.949, 71430.696, 341.0, 5.412, 775.523, 322.0, 6.156, 2146.165, 286.0, 5.484, 10447.388, 284.0, 3.42, 2352.866, 255.0, 6.132, 6438.496, 252.0, 0.243, 398.149, 243.0, 3.092, 4690.48, 225.0, 3.689, 7084.897, 220.0, 4.952, 6812.767, 219.0, 0.42, 8031.092, 209.0, 1.282, 1748.016, 193.0, 5.314, 8429.241, 185.0, 1.82, 7632.943, 175.0, 3.229, 6279.553, 173.0, 1.537, 4705.732, 158.0, 4.097, 11499.656, 158.0, 5.539, 3154.687, 150.0, 3.633, 11513.883, 148.0, 3.222, 7234.794, 147.0, 3.653, 1194.447, 144.0, 0.817, 14143.495, 135.0, 6.151, 5746.271, 134.0, 4.644, 6836.645, 128.0, 2.693, 1349.867, 123.0, 5.65, 5760.498, 118.0, 2.577, 13367.973, 113.0, 3.357, 17789.846, 110.0, 4.497, 4292.331, 108.0, 5.828, 12036.461, 102.0, 5.621, 6256.778, 99.0, 1.14, 1059.38, 98.0, 0.66, 5856.48, 93.0, 2.32, 10213.29, 92.0, 0.77, 16730.46, 88.0, 1.5, 11926.25, 86.0, 1.42, 5753.38, 85.0, 0.66, 155.42, 81.0, 1.64, 6681.22, 80.0, 4.11, 951.72, 66.0, 4.55, 5216.58, 65.0, 0.98, 25132.3, 64.0, 4.19, 6040.35, 64.0, 0.52, 6290.19, 63.0, 1.51, 5643.18, 59.0, 6.18, 4164.31, 57.0, 2.3, 10973.56, 55.0, 2.32, 11506.77, 55.0, 2.2, 1592.6, 55.0, 5.27, 3340.61, 54.0, 5.54, 553.57, 53.0, 5.04, 9917.7, 53.0, 0.92, 11371.7, 52.0, 3.98, 17298.18, 52.0, 3.6, 10969.97, 49.0, 5.91, 3894.18, 49.0, 2.51, 6127.66, 48.0, 1.67, 12168.0, 46.0, 0.31, 801.82, 42.0, 3.7, 10575.41, 42.0, 4.05, 10984.19, 40.0, 2.17, 7860.42, 40.0, 4.17, 26.3, 38.0, 5.82, 7058.6, 37.0, 3.39, 6496.37, 36.0, 1.08, 6309.37, 36.0, 5.34, 7079.37, 34.0, 3.62, 11790.63, 32.0, 0.32, 16200.77, 31.0, 4.24, 3738.76, 29.0, 4.55, 11856.22, 29.0, 1.26, 8635.94, 27.0, 3.45, 5884.93, 26.0, 5.08, 10177.26, 26.0, 5.38, 21228.39, 24.0, 2.26, 11712.96, 24.0, 1.05, 242.73, 24.0, 5.59, 6069.78, 23.0, 3.63, 6284.06, 23.0, 1.64, 4732.03, 22.0, 3.46, 213.3, 21.0, 1.05, 3496.03, 21.0, 3.92, 13916.02, 21.0, 4.01, 5230.81, 20.0, 5.16, 12352.85, 20.0, 0.69, 1990.75, 19.0, 2.73, 6062.66, 19.0, 5.01, 11015.11, 18.0, 6.04, 6283.01, 18.0, 2.85, 7238.68, 18.0, 5.6, 6283.14, 18.0, 5.16, 17253.04, 18.0, 2.54, 14314.17, 17.0, 1.58, 7.11, 17.0, 0.98, 3930.21, 17.0, 4.75, 17267.27, 16.0, 2.19, 6076.89, 16.0, 2.19, 18073.7, 16.0, 6.12, 3.52, 16.0, 4.61, 9623.69, 16.0, 3.4, 16496.36, 15.0, 0.19, 9779.11, 15.0, 5.3, 13517.87, 15.0, 4.26, 3128.39, 15.0, 0.81, 709.93, 14.0, 0.5, 25158.6, 14.0, 4.38, 4136.91, 13.0, 0.98, 65147.62, 13.0, 3.31, 154717.61, 13.0, 2.11, 1589.07, 13.0, 1.92, 22483.85, 12.0, 6.03, 9225.54, 12.0, 1.53, 12559.04, 12.0, 5.82, 6282.1, 12.0, 5.61, 5642.2, 12.0, 2.38, 167283.76, 12.0, 0.39, 12132.44, 12.0, 3.98, 4686.89, 12.0, 5.81, 12569.67, 12.0, 0.56, 5849.36, 11.0, 0.45, 6172.87, 11.0, 5.8, 16858.48, 11.0, 6.22, 12146.67, 11.0, 2.27, 5429.88, 435939.0, 5.784551, 6283.07585, 12363.0, 5.57935, 12566.1517, 1234.0, 3.1416, 0.0, 879.0, 3.628, 77713.771, 569.0, 1.87, 5573.143, 330.0, 5.47, 18849.228, 147.0, 4.48, 5507.553, 110.0, 2.842, 161000.686, 101.0, 2.815, 5223.694, 85.0, 3.11, 1577.34, 65.0, 5.47, 775.52, 61.0, 1.38, 6438.5, 50.0, 4.42, 6286.6, 47.0, 3.66, 7084.9, 46.0, 5.39, 149854.4, 42.0, 0.9, 10977.08, 40.0, 3.2, 5088.63, 35.0, 1.81, 5486.78, 32.0, 5.35, 3154.69, 30.0, 3.52, 796.3, 29.0, 4.62, 4690.48, 28.0, 1.84, 4694.0, 27.0, 3.14, 71430.7, 27.0, 6.17, 6836.65, 26.0, 1.42, 2146.17, 25.0, 2.81, 1748.02, 24.0, 2.18, 155.42, 23.0, 4.76, 7234.79, 21.0, 3.38, 7632.94, 21.0, 0.22, 4705.73, 20.0, 4.22, 1349.87, 20.0, 2.01, 1194.45, 20.0, 4.58, 529.69, 19.0, 1.59, 6309.37, 18.0, 5.7, 6040.35, 18.0, 6.03, 4292.33, 17.0, 2.9, 9437.76, 17.0, 2.0, 8031.09, 17.0, 5.78, 83996.85, 16.0, 0.05, 2544.31, 15.0, 0.95, 6127.66, 14.0, 0.36, 10447.39, 14.0, 1.48, 2352.87, 13.0, 0.77, 553.57, 13.0, 5.48, 951.72, 13.0, 5.27, 6279.55, 13.0, 3.76, 6812.77, 11.0, 5.41, 6256.78, 10.0, 0.68, 1592.6, 10.0, 4.95, 398.15, 10.0, 1.15, 3894.18, 10.0, 5.2, 244287.6, 10.0, 1.94, 11856.22, 9.0, 5.39, 25132.3, 8.0, 6.18, 1059.38, 8.0, 0.69, 8429.24, 8.0, 5.85, 242.73, 7.0, 5.26, 14143.5, 7.0, 0.52, 801.82, 6.0, 2.24, 8635.94, 6.0, 4.0, 13367.97, 6.0, 2.77, 90955.55, 6.0, 5.17, 7058.6, 5.0, 1.46, 233141.31, 5.0, 4.13, 7860.42, 5.0, 3.91, 26.3, 5.0, 3.89, 12036.46, 5.0, 5.58, 6290.19, 5.0, 5.54, 1990.75, 5.0, 0.83, 11506.77, 5.0, 6.22, 6681.22, 4.0, 5.26, 10575.41, 4.0, 1.91, 7477.52, 4.0, 0.43, 10213.29, 4.0, 1.09, 709.93, 4.0, 5.09, 11015.11, 4.0, 4.22, 88860.06, 4.0, 3.57, 7079.37, 4.0, 1.98, 6284.06, 4.0, 3.93, 10973.56, 4.0, 6.18, 9917.7, 4.0, 0.36, 10177.26, 4.0, 2.75, 3738.76, 4.0, 3.33, 5643.18, 4.0, 5.36, 25158.6, 14459.0, 4.27319, 6283.07585, 673.0, 3.917, 12566.152, 77.0, 0.0, 0.0, 25.0, 3.73, 18849.23, 4.0, 2.8, 6286.6, 386.0, 2.564, 6283.076, 31.0, 2.27, 12566.15, 5.0, 3.44, 5573.14, 2.0, 2.05, 18849.23, 1.0, 2.06, 77713.77, 1.0, 4.41, 161000.69, 1.0, 3.82, 149854.4, 1.0, 4.08, 6127.66, 1.0, 5.26, 6438.5, 9.0, 1.22, 6283.08, 1.0, 0.66, 12566.15};
        return XL0;
    }

    private static double[] getXL0_2() {
        double[] XL0 = new double[]{1.0E9, 20.0, 443.0, 710.0, 761.0, 791.0, 818.0, 824.0, 1043.0, 1106.0, 1142.0, 1169.0, 1190.0, 1196.0, 1550.0, 1742.0, 1781.0, 1808.0, 1823.0, 1823.0, 4.402507101E9, 0.0, 0.0, 4.0989415E8, 1.483020342, 26087.903141574, 5.0462942E7, 4.4778549, 52175.80628315, 8553468.0, 1.1652032, 78263.7094247, 1655904.0, 4.1196916, 104351.6125663, 345619.0, 0.779308, 130439.515708, 75835.0, 3.71348, 156527.41885, 35597.0, 1.51203, 1109.37855, 18035.0, 4.10333, 5661.33205, 17260.0, 0.35832, 182615.32199, 15899.0, 2.9951, 25028.52121, 13647.0, 4.59918, 27197.28169, 10173.0, 0.88031, 31749.23519, 7142.0, 1.5414, 24978.5246, 6438.0, 5.3027, 21535.9496, 4511.0, 6.0499, 51116.4244, 4042.0, 3.2823, 208703.2251, 3524.0, 5.2416, 20426.5711, 3452.0, 2.7921, 15874.6176, 3433.0, 5.7653, 955.5997, 3392.0, 5.8633, 25558.2122, 3253.0, 1.3367, 53285.1848, 2729.0, 2.4945, 529.691, 2643.0, 3.9171, 57837.1383, 2596.0, 0.9873, 4551.9535, 2388.0, 0.1134, 1059.3819, 2348.0, 0.2667, 11322.6641, 2166.0, 0.6599, 13521.7514, 2090.0, 2.0918, 47623.8528, 1834.0, 2.6288, 27043.5029, 1816.0, 2.4341, 25661.305, 1760.0, 4.5364, 51066.4277, 1726.0, 2.452, 24498.8302, 1423.0, 3.36, 37410.5672, 1379.0, 0.291, 10213.2855, 1252.0, 3.7208, 39609.6546, 1182.0, 2.7815, 77204.3275, 1064.0, 4.2057, 19804.8273, 969.0, 6.204, 234791.128, 900.0, 5.852, 41962.521, 883.0, 5.413, 26617.594, 868.0, 2.642, 51646.115, 867.0, 1.96, 46514.474, 850.0, 4.331, 79373.088, 697.0, 3.572, 25132.303, 692.0, 4.194, 19.67, 685.0, 0.634, 83925.041, 648.0, 0.048, 33326.579, 635.0, 3.147, 7238.676, 595.0, 2.747, 16983.996, 565.0, 5.119, 73711.756, 554.0, 4.053, 30639.857, 544.0, 3.143, 27147.285, 515.0, 5.478, 50586.733, 496.0, 3.99, 6770.711, 480.0, 5.493, 51749.208, 476.0, 5.497, 3.881, 447.0, 1.224, 77154.331, 419.0, 5.193, 6283.076, 418.0, 5.642, 53131.406, 380.0, 2.431, 12566.152, 360.0, 1.424, 2218.757, 356.0, 0.814, 32858.614, 354.0, 3.37, 36301.189, 340.0, 0.475, 65697.558, 340.0, 2.786, 14765.239, 308.0, 5.77, 103292.231, 306.0, 5.84, 43071.899, 295.0, 0.698, 213.299, 285.0, 0.65, 426.598, 275.0, 0.98, 45892.73, 271.0, 0.085, 63498.47, 268.0, 1.061, 3442.575, 263.0, 0.648, 1589.073, 262.0, 5.242, 22645.328, 243.0, 4.4, 7.114, 237.0, 2.842, 260879.031, 229.0, 2.585, 68050.424, 224.0, 1.025, 105460.991, 223.0, 5.653, 77734.018, 223.0, 2.179, 52705.497, 222.0, 3.224, 25448.006, 220.0, 4.934, 72602.377, 186.0, 4.527, 28306.66, 178.0, 3.612, 110012.945, 176.0, 4.717, 25874.604, 172.0, 0.284, 51220.207, 172.0, 3.261, 153.779, 149.0, 1.835, 99799.659, 144.0, 0.966, 26107.573, 144.0, 1.91, 23969.139, 142.0, 5.142, 26068.233, 142.0, 6.124, 53235.188, 140.0, 2.302, 76674.637, 134.0, 4.518, 26080.79, 134.0, 0.766, 56727.76, 124.0, 2.223, 77837.111, 120.0, 6.205, 18849.228, 116.0, 2.385, 79219.309, 115.0, 4.178, 103242.234, 112.0, 2.048, 32370.979, 111.0, 3.783, 26301.202, 100.0, 2.046, 48733.231, 98.0, 2.27, 26091.78, 97.0, 3.84, 26084.02, 97.0, 2.99, 59414.48, 97.0, 5.78, 25938.34, 94.0, 5.44, 38654.05, 93.0, 4.03, 467.96, 90.0, 6.23, 25021.41, 90.0, 3.48, 91785.46, 90.0, 0.11, 62389.09, 89.0, 2.85, 25035.63, 83.0, 5.34, 19317.19, 82.0, 5.78, 40853.14, 81.0, 1.12, 26095.02, 80.0, 2.46, 129380.13, 76.0, 0.18, 12432.04, 74.0, 4.71, 6.63, 70.0, 3.99, 71980.63, 70.0, 1.63, 23869.15, 66.0, 3.66, 26514.5, 61.0, 3.67, 27676.98, 60.0, 0.0, 51535.91, 59.0, 3.99, 131548.89, 59.0, 4.12, 29530.48, 59.0, 5.57, 94138.33, 59.0, 5.76, 286966.93, 59.0, 6.13, 26011.64, 59.0, 2.14, 20760.43, 58.0, 2.35, 103821.92, 58.0, 4.45, 19406.68, 57.0, 3.02, 89586.37, 57.0, 5.18, 78793.4, 57.0, 1.61, 98690.28, 52.0, 3.29, 38519.95, 51.0, 3.78, 58946.52, 46.0, 0.29, 136100.85, 45.0, 1.5, 51962.51, 45.0, 4.89, 50057.04, 44.0, 3.25, 77308.11, 2.6088147062227E13, 0.0, 0.0, 1.1260078E7, 6.21703971, 26087.90314157, 3034714.0, 3.0556547, 52175.8062831, 805385.0, 6.104547, 78263.709425, 212450.0, 2.835319, 104351.612566, 55921.0, 5.82676, 130439.51571, 14722.0, 2.51845, 156527.41885, 3883.0, 5.4804, 182615.322, 3522.0, 3.0524, 1109.3786, 1027.0, 2.1488, 208703.2251, 935.0, 6.118, 27197.282, 906.0, 0.0, 24978.525, 519.0, 5.621, 5661.332, 444.0, 4.573, 25028.521, 281.0, 3.042, 51066.428, 273.0, 5.092, 234791.128, 220.0, 0.865, 955.6, 204.0, 3.715, 20426.571, 202.0, 0.519, 21535.95, 175.0, 5.727, 4551.953, 167.0, 1.351, 529.691, 154.0, 5.743, 19.67, 153.0, 1.792, 11322.664, 140.0, 3.594, 24498.83, 128.0, 2.696, 53285.185, 126.0, 3.895, 3.881, 126.0, 4.705, 1059.382, 86.0, 6.06, 77154.33, 80.0, 3.93, 27043.5, 80.0, 4.18, 26617.59, 79.0, 0.5, 46514.47, 77.0, 2.48, 57837.14, 73.0, 1.75, 260879.03, 72.0, 2.98, 2218.76, 68.0, 2.77, 7.11, 66.0, 5.53, 6770.71, 64.0, 2.14, 25132.3, 59.0, 2.2, 13521.75, 58.0, 4.28, 16984.0, 50.0, 3.94, 25661.3, 50.0, 2.48, 30639.86, 49.0, 4.85, 37410.57, 46.0, 0.82, 25558.21, 46.0, 1.56, 27147.29, 45.0, 5.79, 3442.57, 44.0, 4.94, 213.3, 43.0, 5.09, 10213.29, 42.0, 5.54, 83925.04, 37.0, 1.4, 77204.33, 36.0, 2.34, 32858.61, 35.0, 3.59, 26068.23, 34.0, 0.5, 22645.33, 33.0, 5.23, 25448.01, 32.0, 1.26, 14765.24, 31.0, 6.21, 26080.79, 31.0, 6.07, 28306.66, 30.0, 4.45, 7238.68, 30.0, 0.14, 50586.73, 29.0, 1.64, 25021.41, 29.0, 0.67, 26091.78, 28.0, 2.51, 26107.57, 28.0, 3.54, 72602.38, 27.0, 5.64, 1589.07, 27.0, 0.88, 52705.5, 26.0, 2.78, 103242.23, 25.0, 5.8, 26095.02, 25.0, 4.35, 41962.52, 24.0, 1.16, 25035.63, 23.0, 5.44, 26084.02, 23.0, 1.85, 36301.19, 21.0, 5.16, 51220.21, 21.0, 1.07, 43071.9, 20.0, 2.96, 23969.14, 20.0, 4.44, 103292.23, 20.0, 0.84, 12566.15, 20.0, 4.68, 286966.93, 18.0, 1.81, 26301.2, 18.0, 5.18, 426.6, 17.0, 2.29, 110012.94, 17.0, 4.63, 53235.19, 17.0, 1.26, 33326.58, 16.0, 5.53, 56727.76, 16.0, 0.08, 23869.15, 16.0, 4.66, 79373.09, 16.0, 3.76, 73711.76, 14.0, 1.14, 68050.42, 14.0, 1.45, 51646.12, 13.0, 3.8, 19317.19, 13.0, 1.73, 12432.04, 530498.0, 0.0, 0.0, 169037.0, 4.690723, 26087.903142, 73967.0, 1.34736, 52175.80628, 30183.0, 4.45644, 78263.70942, 11074.0, 1.26227, 104351.61257, 3782.0, 4.32, 130439.5157, 1230.0, 1.0687, 156527.4188, 387.0, 4.08, 182615.322, 149.0, 4.633, 1109.379, 119.0, 0.792, 208703.225, 52.0, 4.72, 24978.52, 36.0, 3.77, 234791.13, 26.0, 1.44, 27197.28, 20.0, 1.5, 51066.43, 11.0, 0.46, 260879.03, 10.0, 1.8, 955.6, 8.0, 4.54, 77154.33, 1881.0, 0.0347, 52175.8063, 1422.0, 3.1251, 26087.9031, 969.0, 3.004, 78263.709, 437.0, 6.019, 104351.613, 354.0, 0.0, 0.0, 180.0, 2.775, 130439.516, 70.0, 5.82, 156527.42, 26.0, 2.57, 182615.32, 9.0, 5.59, 208703.23, 3.0, 2.32, 234791.13, 1141.0, 3.1416, 0.0, 32.0, 2.03, 26087.9, 19.0, 1.42, 78263.71, 17.0, 4.5, 52175.81, 12.0, 4.5, 104351.61, 6.0, 1.27, 130439.52, 3.0, 4.31, 156527.42, 1.0, 1.06, 182615.32, 1.0, 4.09, 208703.23, 9.0, 3.14, 0.0, 1.0, 3.38, 52175.81, 1.1737529E8, 1.983574988, 26087.903141574, 2.388077E7, 5.0373896, 52175.80628315, 1.2228395E7, 3.14159265, 0.0, 5432518.0, 1.7964436, 78263.7094247, 1297788.0, 4.832325, 104351.6125663, 318669.0, 1.580885, 130439.515708, 79633.0, 4.60972, 156527.41885, 20142.0, 1.35324, 182615.32199, 5140.0, 4.3784, 208703.2251, 2086.0, 2.0202, 24978.5246, 2077.0, 4.9177, 27197.2817, 1320.0, 1.1191, 234791.1283, 1214.0, 1.8127, 53285.1848, 1005.0, 5.6568, 20426.5711, 992.0, 0.094, 51116.424, 946.0, 1.242, 31749.235, 916.0, 2.282, 25028.521, 843.0, 5.085, 51066.428, 788.0, 4.407, 57837.138, 777.0, 0.526, 1059.382, 499.0, 3.498, 5661.332, 465.0, 3.237, 77204.327, 448.0, 4.878, 79373.088, 408.0, 2.466, 46514.474, 374.0, 4.458, 4551.953, 359.0, 1.091, 1109.379, 341.0, 4.142, 260879.031, 320.0, 1.185, 83925.041, 318.0, 2.415, 47623.853, 310.0, 3.503, 21535.95, 287.0, 1.848, 77154.331, 258.0, 2.776, 27043.503, 252.0, 3.591, 27147.285, 202.0, 3.068, 51646.115, 201.0, 4.066, 25132.303, 186.0, 5.584, 73711.756, 170.0, 6.137, 41962.521, 170.0, 0.028, 103292.231, 158.0, 3.796, 529.691, 156.0, 6.077, 53131.406, 150.0, 1.647, 105460.991, 142.0, 0.331, 10213.286, 140.0, 5.528, 72602.377, 130.0, 3.48, 37410.567, 129.0, 4.817, 30639.857, 124.0, 4.051, 39609.655, 123.0, 3.166, 14765.239, 113.0, 0.113, 13521.751, 112.0, 0.557, 63498.47, 110.0, 5.797, 51749.208, 110.0, 4.232, 110012.945, 107.0, 1.537, 25661.305, 105.0, 5.83, 50586.733, 102.0, 2.879, 12566.152, 99.0, 0.95, 65697.56, 98.0, 1.66, 24498.83, 94.0, 1.82, 15874.62, 92.0, 6.16, 77734.02, 91.0, 4.89, 103242.23, 90.0, 1.04, 426.6, 89.0, 0.4, 53235.19, 88.0, 0.88, 286966.93, 88.0, 5.81, 11322.66, 87.0, 3.04, 68050.42, 85.0, 1.05, 1589.07, 83.0, 5.27, 25558.21, 82.0, 0.84, 51220.21, 76.0, 3.44, 36301.19, 73.0, 2.37, 99799.66, 71.0, 5.74, 26617.59, 66.0, 2.67, 52705.5, 58.0, 6.25, 33326.58, 57.0, 2.87, 79219.31, 4291514.0, 3.5016978, 26087.9031416, 1462337.0, 3.1415927, 0.0, 226753.0, 0.015154, 52175.806283, 108950.0, 0.485402, 78263.709425, 63535.0, 3.42944, 104351.61257, 24957.0, 0.16051, 130439.51571, 8596.0, 3.1845, 156527.4188, 2775.0, 6.2102, 182615.322, 862.0, 2.952, 208703.225, 277.0, 0.291, 27197.282, 261.0, 5.977, 234791.128, 128.0, 3.377, 53285.185, 127.0, 0.538, 24978.525, 78.0, 2.72, 260879.03, 75.0, 3.58, 51066.43, 62.0, 2.92, 31749.24, 55.0, 1.97, 51116.42, 35.0, 0.11, 79373.09, 34.0, 0.35, 77154.33, 29.0, 5.95, 57837.14, 27.0, 0.99, 25028.52, 118309.0, 4.790656, 26087.903142, 19135.0, 0.0, 0.0, 10448.0, 1.21217, 52175.80628, 2662.0, 4.4342, 78263.7094, 1703.0, 1.6226, 104351.6126, 963.0, 4.8, 130439.516, 447.0, 1.608, 156527.419, 183.0, 4.669, 182615.322, 69.0, 1.43, 208703.23, 25.0, 4.47, 234791.13, 17.0, 1.83, 27197.28, 9.0, 1.23, 260879.03, 2354.0, 0.3539, 26087.9031, 1605.0, 0.0, 0.0, 189.0, 4.363, 52175.806, 64.0, 2.51, 78263.71, 46.0, 6.14, 104351.61, 31.0, 3.12, 130439.52, 17.0, 6.27, 156527.42, 9.0, 3.08, 182615.32, 4.0, 6.15, 208703.23, 43.0, 1.75, 26087.9, 10.0, 3.14, 0.0, 4.0, 4.03, 52175.81, 3.0, 0.21, 78263.71, 1.0, 3.75, 104351.61, 1.0, 1.18, 130439.52, 1.0, 4.55, 156527.42, 1.0, 3.95, 26087.9, 1.0, 3.14, 0.0, 3.95282717E8, 0.0, 0.0, 7.8341318E7, 6.19233723, 26087.90314157, 7955256.0, 2.9598969, 52175.8062831, 1212818.0, 6.0106415, 78263.7094247, 219220.0, 2.778201, 104351.612566, 43541.0, 5.82895, 130439.51571, 9182.0, 2.5965, 156527.4188, 2900.0, 1.4244, 25028.5212, 2600.0, 3.0282, 27197.2817, 2019.0, 5.6473, 182615.322, 2015.0, 5.5923, 31749.2352, 1420.0, 6.2526, 24978.5246, 1001.0, 3.7344, 21535.9496, 776.0, 3.67, 20426.571, 755.0, 4.474, 51116.424, 668.0, 2.525, 5661.332, 633.0, 4.299, 25558.212, 630.0, 4.766, 1059.382, 483.0, 6.068, 53285.185, 457.0, 2.415, 208703.225, 442.0, 1.22, 15874.618, 408.0, 2.359, 57837.138, 372.0, 0.517, 47623.853, 352.0, 1.059, 27043.503, 339.0, 0.864, 25661.305, 309.0, 0.884, 24498.83, 301.0, 1.795, 37410.567, 284.0, 3.021, 51066.428, 261.0, 2.15, 39609.655, 213.0, 5.369, 13521.751, 194.0, 4.984, 10213.286, 187.0, 4.965, 11322.664, 171.0, 1.241, 77204.327, 169.0, 3.888, 26617.594, 163.0, 2.633, 19804.827, 151.0, 0.445, 46514.474, 150.0, 4.282, 41962.521, 140.0, 4.771, 33326.579, 139.0, 1.626, 27147.285, 139.0, 2.0, 25132.303, 134.0, 1.077, 51646.115, 128.0, 6.064, 1109.379, 128.0, 2.076, 529.691, 121.0, 2.85, 79373.088, 119.0, 2.365, 4551.953, 106.0, 5.466, 234791.128, 95.0, 0.84, 12566.15, 94.0, 5.41, 83925.04, 91.0, 1.21, 14765.24, 89.0, 3.88, 50586.73, 85.0, 3.57, 73711.76, 77.0, 3.92, 51749.21, 75.0, 2.45, 30639.86, 75.0, 5.53, 32858.61, 72.0, 1.17, 16984.0, 71.0, 5.33, 426.6, 69.0, 5.31, 1589.07, 69.0, 1.82, 36301.19, 66.0, 4.28, 43071.9, 65.0, 6.07, 77154.33, 59.0, 4.07, 53131.41, 54.0, 5.2, 65697.56, 52.0, 3.57, 6283.08, 44.0, 5.69, 45892.73, 41.0, 1.65, 25448.01, 41.0, 3.68, 22645.33, 41.0, 4.29, 103292.23, 36.0, 2.96, 28306.66, 34.0, 0.65, 52705.5, 34.0, 3.49, 72602.38, 33.0, 3.14, 25874.6, 33.0, 1.03, 68050.42, 31.0, 4.13, 77734.02, 30.0, 5.91, 105460.99, 28.0, 4.63, 18849.23, 28.0, 5.05, 51220.21, 28.0, 5.68, 26107.57, 27.0, 4.68, 53235.19, 27.0, 4.75, 63498.47, 27.0, 3.57, 26068.23, 26.0, 2.95, 26080.79, 25.0, 0.35, 23969.14, 25.0, 2.23, 260879.03, 23.0, 0.5, 32370.98, 23.0, 2.18, 110012.94, 21.0, 0.85, 76674.64, 21.0, 2.19, 26301.2, 20.0, 0.34, 99799.66, 20.0, 0.47, 48733.23, 20.0, 3.77, 19317.19, 20.0, 1.37, 7238.68, 19.0, 2.37, 6770.71, 19.0, 0.69, 26091.78, 19.0, 3.93, 38654.05, 19.0, 2.27, 26084.02, 18.0, 4.21, 25938.34, 18.0, 0.92, 79219.31, 18.0, 5.51, 56727.76, 17.0, 0.68, 77837.11, 17.0, 4.29, 40853.14, 17.0, 2.15, 26514.5, 17.0, 4.98, 9103.91, 16.0, 4.66, 25021.41, 16.0, 1.28, 25035.63, 16.0, 5.85, 26095.02, 16.0, 2.84, 103242.23, 15.0, 1.55, 955.6, 15.0, 2.16, 27676.98, 14.0, 0.06, 23869.15, 14.0, 4.85, 62389.09, 12.0, 1.97, 91785.46, 12.0, 1.73, 38519.95, 11.0, 4.56, 26011.64, 10.0, 2.78, 213.3, 10.0, 1.06, 129380.13, 10.0, 2.44, 71980.63, 10.0, 4.71, 51535.91, 10.0, 2.54, 29530.48, 2173477.0, 4.6561716, 26087.9031416, 441418.0, 1.423855, 52175.806283, 100945.0, 4.474663, 78263.709425, 24328.0, 1.24226, 104351.61257, 16244.0, 0.0, 0.0, 6040.0, 4.293, 130439.5157, 1529.0, 1.0606, 156527.4188, 392.0, 4.111, 182615.322, 180.0, 4.712, 24978.525, 178.0, 4.544, 27197.282, 102.0, 0.879, 208703.225, 81.0, 3.01, 25028.52, 44.0, 2.14, 20426.57, 44.0, 1.48, 51066.43, 35.0, 3.21, 1059.38, 31.0, 5.24, 21535.95, 27.0, 3.93, 234791.13, 25.0, 2.03, 24498.83, 20.0, 1.24, 53285.18, 20.0, 4.05, 5661.33, 15.0, 2.62, 26617.59, 15.0, 2.36, 27043.5, 14.0, 1.38, 1109.38, 13.0, 5.19, 46514.47, 13.0, 0.56, 25132.3, 12.0, 0.21, 11322.66, 12.0, 4.53, 77154.33, 11.0, 0.86, 57837.14, 11.0, 6.24, 27147.29, 10.0, 3.28, 37410.57, 9.0, 2.37, 25661.3, 9.0, 5.55, 25558.21, 8.0, 5.96, 14765.24, 7.0, 0.78, 32858.61, 7.0, 4.07, 1589.07, 7.0, 2.71, 16984.0, 7.0, 0.93, 30639.86, 7.0, 0.7, 260879.03, 7.0, 2.02, 26068.23, 6.0, 0.86, 4551.95, 6.0, 3.66, 25448.01, 6.0, 4.5, 28306.66, 6.0, 4.65, 26080.79, 6.0, 3.5, 10213.29, 6.0, 0.63, 13521.75, 5.0, 5.38, 26091.78, 5.0, 0.94, 26107.57, 5.0, 5.22, 22645.33, 5.0, 0.06, 25021.41, 5.0, 3.89, 83925.04, 5.0, 4.84, 50586.73, 5.0, 5.55, 12566.15, 5.0, 4.24, 26095.02, 5.0, 6.01, 77204.33, 5.0, 0.73, 529.69, 4.0, 3.87, 26084.02, 4.0, 5.87, 25035.63, 4.0, 5.79, 43071.9, 4.0, 0.26, 36301.19, 4.0, 2.78, 41962.52, 4.0, 5.6, 52705.5, 4.0, 3.82, 426.6, 4.0, 1.96, 72602.38, 4.0, 6.0, 33326.58, 31179.0, 3.08232, 26087.90314, 12454.0, 6.15183, 52175.80628, 4248.0, 2.9258, 78263.7094, 1361.0, 5.9798, 104351.6126, 422.0, 2.749, 130439.516, 218.0, 3.142, 0.0, 128.0, 5.801, 156527.419, 38.0, 2.57, 182615.32, 11.0, 5.62, 208703.23, 10.0, 3.15, 24978.52, 5.0, 6.14, 27197.28, 3.0, 2.39, 234791.13, 3.0, 6.21, 51066.43, 327.0, 1.68, 26087.903, 242.0, 4.634, 52175.806, 121.0, 1.39, 78263.709, 51.0, 4.44, 104351.61, 20.0, 1.21, 130439.52, 15.0, 3.14, 0.0, 7.0, 4.26, 156527.42, 3.0, 1.03, 182615.32, 1.0, 4.08, 208703.23, 4.0, 0.37, 26087.9, 4.0, 3.19, 52175.81, 3.0, 6.17, 78263.71, 1.0, 2.92, 104351.61, 1.0, 5.96, 130439.52};
        return XL0;
    }

    private static double[] getXL0_3() {
        double[] XL0 = new double[]{1.0E9, 20.0, 257.0, 374.0, 425.0, 437.0, 449.0, 458.0, 566.0, 629.0, 641.0, 653.0, 665.0, 668.0, 929.0, 1040.0, 1082.0, 1091.0, 1094.0, 1094.0, 3.176146668E9, 0.0, 0.0, 1.3539684E7, 5.5931332, 10213.28554621, 898916.0, 5.3065, 20426.571092, 54772.0, 4.41631, 7860.41939, 34557.0, 2.69964, 11790.62909, 23721.0, 2.99378, 3930.2097, 16641.0, 4.25019, 1577.34354, 14383.0, 4.15745, 9683.59458, 13171.0, 5.18668, 26.29832, 12005.0, 6.15357, 30639.85664, 7693.0, 0.8163, 9437.7629, 7614.0, 1.9501, 529.691, 7077.0, 1.0647, 775.5226, 5848.0, 3.9984, 191.4483, 4999.0, 4.1234, 15720.8388, 4295.0, 3.5864, 19367.1892, 3270.0, 5.6774, 5507.5532, 3262.0, 4.5906, 10404.7338, 2319.0, 3.1625, 9153.9036, 1797.0, 4.6534, 1109.3786, 1555.0, 5.5704, 19651.0485, 1283.0, 4.226, 20.7754, 1279.0, 0.9621, 5661.332, 1055.0, 1.5372, 801.8209, 991.0, 0.833, 213.299, 988.0, 5.394, 13367.973, 880.0, 3.889, 9999.986, 857.0, 0.356, 3154.687, 821.0, 3.216, 18837.498, 716.0, 0.111, 11015.106, 702.0, 0.675, 23581.258, 561.0, 4.24, 7.114, 508.0, 0.245, 11322.664, 461.0, 5.316, 18073.705, 446.0, 6.063, 40853.142, 426.0, 1.8, 7084.897, 426.0, 5.329, 2352.866, 412.0, 0.362, 382.897, 357.0, 2.704, 10206.172, 339.0, 2.023, 6283.076, 333.0, 2.1, 27511.468, 302.0, 4.942, 13745.346, 299.0, 4.022, 10239.584, 293.0, 3.514, 283.859, 291.0, 3.592, 22003.915, 285.0, 2.224, 1059.382, 263.0, 0.541, 17298.182, 244.0, 2.702, 8624.213, 243.0, 4.278, 5.523, 237.0, 4.829, 6872.673, 205.0, 0.585, 38.028, 203.0, 3.795, 14143.495, 191.0, 6.12, 29050.784, 190.0, 4.138, 4551.953, 183.0, 3.047, 19999.973, 171.0, 3.522, 31441.678, 159.0, 1.501, 8635.942, 137.0, 4.413, 3532.061, 118.0, 1.913, 21228.392, 116.0, 5.81, 19896.88, 110.0, 2.584, 9786.687, 110.0, 2.846, 18307.807, 106.0, 0.854, 10596.182, 101.0, 2.343, 10742.977, 99.0, 1.09, 7064.12, 94.0, 4.95, 35371.89, 92.0, 5.52, 12566.15, 89.0, 1.97, 10186.99, 82.0, 1.92, 15.25, 70.0, 1.0, 632.78, 68.0, 4.4, 8662.24, 67.0, 1.55, 14945.32, 64.0, 2.18, 10988.81, 63.0, 0.36, 103.09, 60.0, 5.05, 245.83, 60.0, 2.97, 4732.03, 58.0, 1.93, 3340.61, 56.0, 0.49, 522.58, 55.0, 3.37, 25158.6, 1.0213529430529E13, 0.0, 0.0, 957077.0, 2.464244, 10213.285546, 144450.0, 0.516246, 20426.571092, 2134.0, 1.7955, 30639.8566, 1739.0, 2.6554, 26.2983, 1517.0, 6.1064, 1577.3435, 822.0, 5.702, 191.448, 697.0, 2.681, 9437.763, 524.0, 3.6, 775.523, 383.0, 1.034, 529.691, 296.0, 1.251, 5507.553, 251.0, 6.107, 10404.734, 178.0, 6.194, 1109.379, 165.0, 2.643, 7.114, 142.0, 5.451, 9153.904, 126.0, 1.245, 40853.142, 126.0, 1.881, 382.897, 116.0, 4.976, 213.299, 89.0, 0.95, 13367.97, 74.0, 4.39, 10206.17, 67.0, 5.06, 801.82, 66.0, 2.28, 2352.87, 63.0, 4.08, 3154.69, 49.0, 3.45, 11015.11, 43.0, 0.08, 6283.08, 41.0, 4.12, 18837.5, 37.0, 2.48, 5661.33, 36.0, 1.48, 1059.38, 35.0, 6.2, 5.52, 34.0, 1.77, 11322.66, 30.0, 2.24, 18073.7, 30.0, 0.39, 15.25, 30.0, 5.35, 7084.9, 28.0, 1.46, 10239.58, 26.0, 0.35, 22003.91, 24.0, 2.36, 10596.18, 23.0, 2.37, 17298.18, 22.0, 2.08, 8635.94, 21.0, 4.47, 8624.21, 541271.0, 0.0, 0.0, 38915.0, 0.34514, 10213.28555, 13379.0, 2.02011, 20426.57109, 238.0, 2.046, 26.298, 193.0, 3.535, 30639.857, 100.0, 3.971, 775.523, 70.0, 1.52, 1577.34, 60.0, 1.0, 191.45, 32.0, 4.36, 9437.76, 21.0, 2.66, 40853.14, 19.0, 3.39, 382.9, 15.0, 6.05, 529.69, 13.0, 2.95, 5507.55, 12.0, 3.73, 3154.69, 10.0, 3.53, 11015.11, 10.0, 1.41, 10404.73, 10.0, 5.11, 801.82, 1357.0, 4.8039, 10213.2855, 778.0, 3.669, 20426.571, 260.0, 0.0, 0.0, 12.0, 5.32, 30639.86, 1140.0, 3.1416, 0.0, 32.0, 5.21, 20426.57, 17.0, 2.51, 10213.29, 1.0, 0.71, 30639.86, 9.0, 3.14, 0.0, 1.0, 1.91, 10213.29, 1.0, 0.55, 20426.57, 5.9236385E7, 0.26702776, 10213.28554621, 401080.0, 1.147372, 20426.571092, 328149.0, 3.141593, 0.0, 10114.0, 1.08946, 30639.85664, 1495.0, 6.2539, 18073.7049, 1378.0, 0.8602, 1577.3435, 1300.0, 3.6715, 9437.7629, 1195.0, 3.7047, 2352.8662, 1080.0, 4.539, 22003.9146, 920.0, 1.54, 9153.904, 530.0, 2.281, 5507.553, 456.0, 0.723, 10239.584, 435.0, 6.14, 11790.629, 417.0, 5.991, 19896.88, 396.0, 3.868, 8635.942, 392.0, 3.95, 529.691, 389.0, 2.934, 10186.987, 333.0, 4.832, 14143.495, 237.0, 2.906, 10988.808, 235.0, 2.008, 13367.973, 218.0, 2.697, 19651.048, 207.0, 0.987, 775.523, 186.0, 1.805, 40853.142, 178.0, 5.963, 25934.124, 170.0, 4.137, 10021.837, 154.0, 3.296, 11015.106, 149.0, 5.611, 10404.734, 131.0, 5.707, 9683.595, 129.0, 5.427, 29580.475, 120.0, 3.576, 10742.977, 118.0, 1.191, 8624.213, 115.0, 5.128, 6283.076, 98.0, 0.15, 20618.02, 95.0, 2.75, 191.45, 86.0, 0.43, 9786.69, 81.0, 1.31, 15720.84, 5133476.0, 1.8036431, 10213.2855462, 43801.0, 3.38616, 20426.57109, 1992.0, 0.0, 0.0, 1966.0, 2.53, 30639.8566, 140.0, 2.271, 9437.763, 130.0, 1.507, 18073.705, 119.0, 5.605, 1577.344, 103.0, 5.242, 2352.866, 93.0, 6.08, 22003.91, 80.0, 0.29, 9153.9, 75.0, 5.08, 10186.99, 74.0, 1.5, 11790.63, 47.0, 3.88, 10239.58, 47.0, 0.75, 5507.55, 44.0, 3.59, 40853.14, 40.0, 1.28, 10404.73, 38.0, 4.33, 19651.05, 36.0, 1.26, 19896.88, 35.0, 5.51, 529.69, 34.0, 4.89, 10988.81, 29.0, 0.09, 14143.5, 223777.0, 3.385091, 10213.285546, 2817.0, 0.0, 0.0, 1732.0, 5.2556, 20426.5711, 269.0, 3.87, 30639.857, 6467.0, 4.9917, 10213.2855, 200.0, 3.142, 0.0, 55.0, 0.77, 20426.57, 25.0, 5.44, 30639.86, 141.0, 0.315, 10213.286, 2.0, 3.14, 0.0, 2.0, 2.35, 20426.57, 2.0, 0.74, 30639.86, 2.0, 2.05, 10213.29, 7.23348209E8, 0.0, 0.0, 4898242.0, 4.0215183, 10213.2855462, 16581.0, 4.90207, 20426.57109, 16321.0, 2.84549, 7860.41939, 13780.0, 1.12847, 11790.62909, 4984.0, 2.5868, 9683.5946, 3740.0, 1.4231, 3930.2097, 2636.0, 5.5294, 9437.7629, 2375.0, 2.5514, 15720.8388, 2220.0, 2.0135, 19367.1892, 1259.0, 2.7277, 1577.3435, 1195.0, 3.0198, 10404.7338, 853.0, 3.986, 19651.048, 762.0, 1.596, 9153.904, 743.0, 4.12, 5507.553, 425.0, 3.819, 13367.973, 419.0, 1.643, 18837.498, 394.0, 5.39, 23581.258, 313.0, 2.318, 9999.986, 290.0, 5.677, 5661.332, 276.0, 5.724, 775.523, 273.0, 4.822, 11015.106, 198.0, 0.532, 27511.468, 197.0, 4.962, 11322.664, 162.0, 0.565, 529.691, 136.0, 3.755, 18073.705, 132.0, 3.372, 13745.346, 131.0, 5.244, 17298.182, 129.0, 1.134, 10206.172, 118.0, 5.09, 3154.687, 117.0, 0.234, 7084.897, 114.0, 4.568, 29050.784, 108.0, 2.45, 10239.584, 107.0, 1.955, 31441.678, 104.0, 1.202, 15874.618, 96.0, 1.47, 19999.97, 93.0, 1.62, 2352.87, 91.0, 3.07, 1109.38, 84.0, 5.78, 30639.86, 82.0, 1.95, 22003.91, 76.0, 1.14, 8624.21, 65.0, 2.17, 14143.5, 64.0, 0.84, 6283.08, 62.0, 3.26, 6872.67, 61.0, 0.35, 21228.39, 60.0, 3.38, 35371.89, 59.0, 0.01, 8635.94, 56.0, 3.95, 12566.15, 55.0, 1.27, 18307.81, 45.0, 4.73, 19896.88, 45.0, 2.48, 191.45, 43.0, 2.6, 4551.95, 40.0, 0.0, 801.82, 39.0, 5.57, 10596.18, 39.0, 1.01, 9786.69, 35.0, 4.8, 39302.1, 33.0, 0.71, 10742.98, 32.0, 0.4, 10186.99, 32.0, 1.81, 25158.6, 31.0, 6.26, 14945.32, 30.0, 4.21, 28521.09, 27.0, 5.8, 7064.12, 25.0, 0.69, 10988.81, 24.0, 3.78, 21535.95, 22.0, 2.83, 8662.24, 21.0, 6.22, 43232.31, 20.0, 5.42, 16496.36, 20.0, 2.21, 19786.67, 19.0, 2.86, 3532.06, 19.0, 2.63, 29580.47, 19.0, 1.5, 10021.84, 18.0, 3.23, 29088.81, 18.0, 0.42, 4705.73, 17.0, 3.68, 26.3, 15.0, 0.0, 17277.41, 15.0, 2.48, 31749.24, 14.0, 5.86, 9676.48, 14.0, 5.18, 10316.38, 13.0, 2.49, 9690.71, 13.0, 1.36, 47162.52, 13.0, 5.25, 19360.08, 12.0, 1.88, 19374.3, 12.0, 5.56, 6770.71, 12.0, 1.42, 4732.03, 12.0, 1.43, 18875.53, 11.0, 5.92, 13936.79, 11.0, 4.64, 33019.02, 345510.0, 0.891987, 10213.285546, 2342.0, 1.7722, 20426.5711, 2340.0, 3.1416, 0.0, 239.0, 1.113, 9437.763, 106.0, 4.592, 1577.344, 91.0, 4.54, 10404.73, 66.0, 5.98, 5507.55, 47.0, 3.88, 9153.9, 38.0, 5.66, 13367.97, 27.0, 2.82, 10206.17, 22.0, 2.05, 775.52, 21.0, 2.55, 18837.5, 18.0, 1.88, 11015.11, 18.0, 2.65, 30639.86, 13.0, 0.21, 11322.66, 12.0, 0.79, 17298.18, 11.0, 4.95, 6283.08, 10.0, 6.17, 10239.58, 9.0, 4.6, 1109.38, 9.0, 0.81, 10596.18, 9.0, 2.48, 3154.69, 9.0, 0.67, 18073.7, 8.0, 5.59, 12566.15, 8.0, 0.44, 8635.94, 8.0, 5.49, 529.69, 8.0, 3.75, 7084.9, 8.0, 0.9, 5661.33, 7.0, 2.87, 8624.21, 7.0, 5.07, 22003.91, 6.0, 4.1, 191.45, 6.0, 3.14, 10186.99, 6.0, 2.25, 21228.39, 6.0, 2.17, 18307.81, 5.0, 5.87, 2352.87, 5.0, 5.33, 14143.5, 5.0, 4.34, 9786.69, 5.0, 5.56, 10742.98, 14066.0, 5.06366, 10213.28555, 155.0, 5.473, 20426.571, 131.0, 0.0, 0.0, 11.0, 2.79, 9437.76, 5.0, 6.28, 1577.34, 4.0, 1.95, 11015.11, 4.0, 2.33, 775.52, 4.0, 6.12, 10404.73, 3.0, 1.39, 5507.55, 2.0, 5.63, 10239.58, 2.0, 6.17, 30639.86, 2.0, 1.11, 13367.97, 2.0, 3.64, 7084.9, 2.0, 2.22, 3154.69, 496.0, 3.223, 10213.286, 8.0, 3.21, 20426.57, 1.0, 3.14, 0.0, 6.0, 0.92, 10213.29};
        return XL0;
    }

    /*
     * Opcode count of 13154 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static double[] getXL0_4() {
        double[] XL0 = new double[]{1.0E9, 20.0, 596.0, 1028.0, 1289.0, 1385.0, 1427.0, 1454.0, 1586.0, 1670.0, 1694.0, 1709.0, 1718.0, 1724.0, 2360.0, 2873.0, 3155.0, 3239.0, 3275.0, 3287.0, 6.203477116E9, 0.0, 0.0, 1.86563681E8, 5.050371003, 3340.6124267, 1.1082168E7, 5.40099837, 6681.2248534, 917984.0, 5.754787, 10021.83728, 277450.0, 5.970495, 3.523118, 123159.0, 0.849561, 2810.921462, 106102.0, 2.939585, 2281.230497, 89268.0, 4.15698, 0.01725, 87157.0, 6.11005, 13362.44971, 77749.0, 3.33969, 5621.84292, 67976.0, 0.36462, 398.149, 41611.0, 0.22815, 2942.46342, 35751.0, 1.66187, 2544.31442, 30753.0, 0.85697, 191.44827, 29375.0, 6.07894, 0.06731, 26281.0, 0.64806, 3337.08931, 25798.0, 0.02997, 3344.13555, 23894.0, 5.03896, 796.29801, 17988.0, 0.65634, 529.69097, 15464.0, 2.9158, 1751.53953, 15281.0, 1.14979, 6151.53389, 12862.0, 3.06796, 2146.16542, 12644.0, 3.62275, 5092.15196, 10249.0, 3.69334, 8962.45535, 8916.0, 0.1829, 16703.0621, 8588.0, 2.4009, 2914.0142, 8327.0, 4.495, 3340.6297, 8327.0, 2.4642, 3340.5952, 7487.0, 3.8225, 155.4204, 7239.0, 0.675, 3738.7614, 7129.0, 3.6634, 1059.3819, 6552.0, 0.4886, 3127.3133, 6356.0, 2.9218, 8432.7644, 5527.0, 4.4748, 1748.0164, 5505.0, 3.81, 0.9803, 4722.0, 3.6255, 1194.447, 4260.0, 0.5537, 6283.0758, 4151.0, 0.4966, 213.2991, 3121.0, 0.9985, 6677.7017, 3066.0, 0.3805, 6684.748, 3024.0, 4.4862, 3532.0607, 2994.0, 2.7832, 6254.6267, 2932.0, 4.2213, 20.7754, 2836.0, 5.7689, 3149.1642, 2811.0, 5.8816, 1349.8674, 2740.0, 0.1337, 3340.6797, 2740.0, 0.5422, 3340.5451, 2389.0, 5.3716, 4136.9104, 2361.0, 5.755, 3333.4989, 2312.0, 1.2824, 3870.3034, 2212.0, 3.5047, 382.8965, 2042.0, 2.8213, 1221.8486, 1931.0, 3.3572, 3.5904, 1886.0, 1.491, 9492.1463, 1792.0, 1.0056, 951.7184, 1741.0, 2.4136, 553.5694, 1721.0, 0.4394, 5486.7778, 1600.0, 3.9485, 4562.461, 1443.0, 1.4187, 135.0651, 1399.0, 3.3259, 2700.7151, 1382.0, 4.3015, 7.1135, 1310.0, 4.0449, 12303.0678, 1281.0, 2.2081, 1592.596, 1281.0, 1.8067, 5088.6288, 1169.0, 3.1281, 7903.0734, 1135.0, 3.7007, 1589.0729, 1104.0, 1.052, 242.7286, 1045.0, 0.7854, 8827.3903, 1001.0, 3.2434, 11773.3768, 989.0, 4.846, 6681.242, 989.0, 2.815, 6681.208, 956.0, 0.54, 20043.675, 869.0, 2.202, 11243.686, 868.0, 1.021, 7079.374, 842.0, 3.99, 4399.994, 837.0, 3.203, 4690.48, 750.0, 0.766, 6467.926, 735.0, 2.184, 8429.241, 721.0, 5.847, 5884.927, 714.0, 2.803, 3185.192, 690.0, 3.764, 6041.328, 684.0, 2.738, 2288.344, 667.0, 0.736, 3723.509, 653.0, 2.681, 28.449, 634.0, 0.913, 3553.912, 633.0, 4.528, 426.598, 617.0, 6.168, 2274.117, 566.0, 5.063, 15.252, 564.0, 1.687, 6872.673, 559.0, 3.463, 263.084, 555.0, 4.606, 4292.331, 523.0, 0.899, 9623.688, 517.0, 2.813, 3339.632, 513.0, 4.148, 3341.593, 485.0, 3.957, 4535.059, 459.0, 0.287, 5614.729, 458.0, 0.788, 1990.745, 442.0, 3.195, 5628.956, 419.0, 3.583, 8031.092, 412.0, 6.02, 3894.182, 407.0, 3.138, 9595.239, 395.0, 5.632, 3097.884, 388.0, 1.352, 10018.314, 384.0, 5.829, 3191.049, 382.0, 2.348, 162.467, 381.0, 0.734, 10025.36, 378.0, 4.155, 2803.808, 371.0, 0.685, 2818.035, 367.0, 2.637, 692.158, 340.0, 2.595, 11769.854, 336.0, 6.12, 6489.777, 331.0, 1.14, 5.523, 326.0, 0.484, 6681.292, 326.0, 0.893, 6681.158, 312.0, 3.982, 20.355, 290.0, 2.427, 3319.837, 287.0, 5.721, 7477.523, 276.0, 1.597, 7210.916, 275.0, 6.084, 6674.111, 273.0, 4.556, 3361.388, 264.0, 1.345, 3496.033, 256.0, 0.25, 522.577, 255.0, 3.432, 3443.705, 254.0, 0.521, 10.637, 246.0, 4.003, 11371.705, 244.0, 0.97, 632.784, 238.0, 1.841, 12832.759, 231.0, 4.75, 3347.726, 228.0, 3.526, 1648.447, 227.0, 4.985, 7632.943, 227.0, 3.954, 4989.059, 226.0, 5.241, 3205.547, 225.0, 5.649, 2388.894, 223.0, 0.721, 266.607, 215.0, 6.154, 3264.346, 213.0, 4.282, 4032.77, 212.0, 3.118, 2957.716, 210.0, 4.279, 5099.266, 202.0, 3.671, 1758.653, 201.0, 1.082, 7064.121, 198.0, 2.377, 10713.995, 193.0, 3.239, 7.046, 184.0, 4.225, 2787.043, 181.0, 3.258, 3337.022, 180.0, 4.254, 2487.416, 177.0, 3.697, 3344.203, 176.0, 4.092, 74.782, 168.0, 5.486, 3.881, 168.0, 4.397, 15643.68, 166.0, 2.528, 14584.298, 161.0, 2.369, 3265.831, 161.0, 3.794, 2118.764, 160.0, 1.768, 3475.678, 160.0, 1.547, 14054.607, 158.0, 0.569, 103.093, 158.0, 3.132, 59.374, 146.0, 3.452, 7373.382, 145.0, 4.38, 316.392, 142.0, 0.598, 23.878, 140.0, 1.442, 10404.734, 139.0, 5.408, 10973.556, 137.0, 3.591, 15113.989, 137.0, 2.541, 4933.208, 135.0, 4.042, 4929.685, 134.0, 5.169, 10213.286, 133.0, 6.178, 1744.426, 128.0, 0.105, 7234.794, 127.0, 1.799, 13745.346, 123.0, 2.521, 2906.901, 123.0, 3.169, 10021.82, 123.0, 5.199, 10021.855, 122.0, 1.731, 36.028, 122.0, 4.423, 14712.317, 119.0, 5.48, 2921.128, 119.0, 4.766, 5828.028, 118.0, 5.727, 0.42, 109.0, 0.604, 5085.038, 108.0, 1.372, 10419.986, 107.0, 4.339, 7740.607, 106.0, 5.477, 419.485, 106.0, 3.45, 639.897, 106.0, 0.896, 23384.287, 106.0, 1.091, 12168.003, 100.0, 1.383, 3583.341, 99.0, 2.69, 36.61, 98.0, 5.84, 14314.17, 98.0, 3.6, 206.19, 97.0, 6.28, 9225.54, 96.0, 4.89, 3230.41, 96.0, 4.33, 131.54, 91.0, 1.1, 9808.54, 88.0, 3.97, 170.67, 3.340856274743E12, 0.0, 0.0, 1.4582271E7, 3.60426054, 3340.6124267, 1649013.0, 3.9263125, 6681.2248534, 199633.0, 4.265941, 10021.83728, 34524.0, 4.7321, 3.52312, 24855.0, 4.61278, 13362.44971, 8416.0, 4.4586, 2281.2305, 5376.0, 5.0159, 398.149, 5210.0, 4.9942, 3344.1355, 4326.0, 2.5607, 191.4483, 4297.0, 5.3165, 155.4204, 3817.0, 3.5388, 796.298, 3141.0, 4.9634, 16703.0621, 2828.0, 3.1597, 2544.3144, 2057.0, 4.5689, 2146.1654, 1688.0, 1.3289, 3337.0893, 1576.0, 4.185, 1751.5395, 1337.0, 2.2333, 0.9803, 1336.0, 5.9742, 1748.0164, 1176.0, 6.0241, 6151.5339, 1166.0, 2.2135, 1059.3819, 1139.0, 2.1287, 1194.447, 1136.0, 5.428, 3738.7614, 911.0, 1.096, 1349.867, 853.0, 3.909, 553.569, 833.0, 5.296, 6684.748, 808.0, 4.428, 529.691, 795.0, 2.249, 8962.455, 729.0, 2.502, 951.718, 725.0, 5.842, 242.729, 715.0, 3.856, 2914.014, 676.0, 5.023, 382.897, 651.0, 1.018, 3340.595, 651.0, 3.049, 3340.63, 615.0, 4.152, 3149.164, 565.0, 3.888, 4136.91, 485.0, 4.874, 213.299, 476.0, 1.182, 3333.499, 466.0, 1.315, 3185.192, 413.0, 0.714, 1592.596, 403.0, 2.725, 7.114, 401.0, 5.316, 20043.675, 329.0, 5.411, 6283.076, 282.0, 0.045, 9492.146, 266.0, 3.89, 1221.849, 266.0, 5.113, 2700.715, 233.0, 6.168, 3532.061, 228.0, 1.545, 2274.117, 226.0, 0.838, 3097.884, 224.0, 5.466, 20.355, 223.0, 5.885, 3870.303, 214.0, 4.971, 3340.68, 214.0, 5.379, 3340.545, 211.0, 3.525, 15.252, 204.0, 2.364, 1589.073, 202.0, 3.364, 5088.629, 200.0, 4.731, 4690.48, 200.0, 5.787, 7079.374, 197.0, 2.578, 12303.068, 195.0, 0.492, 6677.702, 195.0, 2.531, 4399.994, 185.0, 5.579, 1990.745, 178.0, 6.125, 4292.331, 166.0, 1.255, 3894.182, 165.0, 2.603, 3341.593, 154.0, 2.47, 4535.059, 153.0, 2.265, 3723.509, 150.0, 1.035, 2288.344, 147.0, 3.37, 6681.242, 147.0, 1.339, 6681.208, 136.0, 1.977, 5614.729, 135.0, 2.123, 5486.778, 133.0, 3.422, 5621.843, 130.0, 1.514, 5628.956, 130.0, 5.619, 10025.36, 127.0, 2.95, 3496.033, 119.0, 5.476, 3553.912, 119.0, 3.127, 426.598, 118.0, 2.586, 8432.764, 114.0, 6.234, 135.065, 111.0, 5.842, 2803.808, 110.0, 4.158, 2388.894, 109.0, 5.282, 2818.035, 105.0, 2.736, 2787.043, 97.0, 4.53, 6489.78, 88.0, 4.23, 7477.52, 87.0, 4.44, 5092.15, 87.0, 4.33, 3339.63, 86.0, 3.16, 162.47, 85.0, 1.91, 11773.38, 84.0, 3.16, 3347.73, 83.0, 2.18, 23.88, 81.0, 1.61, 2957.72, 80.0, 5.7, 6041.33, 77.0, 5.72, 9623.69, 74.0, 6.18, 3583.34, 67.0, 5.08, 8031.09, 64.0, 2.12, 5884.93, 62.0, 3.54, 692.16, 61.0, 1.66, 6525.8, 57.0, 3.68, 8429.24, 55.0, 2.01, 522.58, 55.0, 6.13, 2487.42, 55.0, 0.19, 7632.94, 54.0, 1.05, 4933.21, 54.0, 0.18, 2942.46, 53.0, 2.23, 3127.31, 52.0, 0.37, 12832.76, 52.0, 1.15, 28.45, 51.0, 5.67, 23384.29, 50.0, 1.51, 1744.43, 50.0, 2.45, 5099.27, 49.0, 3.1, 5.52, 49.0, 5.61, 6467.93, 49.0, 5.29, 6681.29, 48.0, 5.7, 6681.16, 47.0, 0.23, 36.03, 47.0, 0.03, 7210.92, 45.0, 4.17, 2906.9, 44.0, 0.31, 10018.31, 43.0, 4.43, 640.88, 43.0, 2.88, 2810.92, 41.0, 1.6, 7234.79, 41.0, 3.96, 3.88, 38.0, 2.26, 2699.73, 37.0, 2.92, 15643.68, 35.0, 1.76, 1758.65, 34.0, 1.53, 6674.11, 34.0, 2.66, 4929.69, 33.0, 2.59, 2118.76, 32.0, 6.14, 10419.99, 32.0, 2.33, 5085.04, 32.0, 2.87, 7740.61, 31.0, 1.76, 9595.24, 31.0, 2.56, 7064.12, 30.0, 1.87, 7.05, 29.0, 1.28, 574.34, 28.0, 0.99, 3191.05, 28.0, 0.43, 5828.03, 28.0, 1.76, 639.9, 27.0, 3.71, 10021.85, 27.0, 1.68, 10021.82, 26.0, 3.12, 6836.65, 26.0, 3.77, 2921.13, 580158.0, 2.049795, 3340.612427, 541876.0, 0.0, 0.0, 139084.0, 2.457424, 6681.224853, 24651.0, 2.8, 10021.83728, 3984.0, 3.1412, 13362.4497, 2220.0, 3.1944, 3.5231, 1210.0, 0.5433, 155.4204, 615.0, 3.485, 16703.062, 536.0, 3.542, 3344.136, 343.0, 6.002, 2281.23, 317.0, 4.14, 191.448, 298.0, 1.999, 796.298, 232.0, 4.334, 242.729, 217.0, 3.445, 398.149, 204.0, 5.422, 553.569, 162.0, 0.657, 0.98, 160.0, 6.11, 2146.165, 156.0, 1.221, 1748.016, 149.0, 6.095, 3185.192, 144.0, 4.019, 951.718, 143.0, 2.619, 1349.867, 134.0, 0.602, 1194.447, 119.0, 3.861, 6684.748, 113.0, 4.718, 2544.314, 104.0, 0.25, 382.897, 95.0, 0.68, 1059.38, 92.0, 3.83, 20043.67, 90.0, 3.88, 3738.76, 75.0, 5.46, 1751.54, 69.0, 2.58, 3149.16, 67.0, 2.38, 4136.91, 65.0, 5.48, 1592.6, 63.0, 2.34, 3097.88, 59.0, 1.15, 7.11, 48.0, 2.9, 3333.5, 46.0, 4.43, 6151.53, 42.0, 3.69, 5614.73, 40.0, 6.12, 5628.96, 37.0, 4.07, 1990.75, 36.0, 2.47, 529.69, 33.0, 0.68, 8962.46, 33.0, 2.8, 3894.18, 31.0, 4.57, 3496.03, 29.0, 5.41, 2914.01, 29.0, 1.23, 2787.04, 29.0, 3.41, 3337.09, 28.0, 1.39, 4292.33, 26.0, 4.68, 3583.34, 26.0, 1.04, 3341.59, 26.0, 2.65, 2388.89, 26.0, 1.5, 3340.63, 26.0, 5.75, 3340.6, 24.0, 0.96, 4535.06, 24.0, 1.05, 4399.99, 24.0, 4.27, 7079.37, 24.0, 4.85, 9492.15, 23.0, 4.18, 10025.36, 23.0, 0.01, 4690.48, 22.0, 3.26, 213.3, 22.0, 0.16, 6525.8, 21.0, 0.48, 2700.72, 18.0, 0.97, 1589.07, 18.0, 2.52, 2810.92, 18.0, 3.81, 3723.51, 16.0, 1.11, 12303.07, 16.0, 4.94, 1221.85, 16.0, 4.96, 5088.63, 15.0, 2.93, 640.88, 15.0, 0.11, 2957.72, 14.0, 2.98, 6489.78, 14.0, 1.54, 3347.73, 14.0, 3.86, 6283.08, 14.0, 2.73, 7477.52, 14.0, 4.18, 23384.29, 13.0, 5.3, 6677.7, 12.0, 3.77, 2699.73, 12.0, 6.14, 6681.21, 12.0, 1.89, 6681.24, 12.0, 1.51, 426.6, 11.0, 3.78, 3870.3, 11.0, 5.05, 5621.84, 11.0, 3.81, 3553.91, 10.0, 5.83, 4933.21, 9.0, 1.91, 3532.06, 9.0, 3.82, 5092.15, 9.0, 4.13, 162.47, 9.0, 3.83, 3340.55, 14824.0, 0.44435, 3340.61243, 6621.0, 0.8847, 6681.2249, 1883.0, 1.288, 10021.8373, 415.0, 1.649, 13362.45, 260.0, 0.0, 0.0, 227.0, 2.053, 155.42, 105.0, 1.58, 3.523, 80.0, 2.0, 16703.06, 49.0, 2.82, 242.73, 38.0, 2.02, 3344.14, 32.0, 4.59, 3185.19, 31.0, 0.65, 553.57, 17.0, 5.54, 951.72, 15.0, 5.72, 191.45, 14.0, 0.46, 796.3, 14.0, 2.34, 20043.67, 13.0, 5.36, 0.98, 12.0, 4.15, 1349.87, 11.0, 2.38, 6684.75, 10.0, 1.77, 382.9, 9.0, 5.34, 1194.45, 8.0, 2.75, 1748.02, 6.0, 3.18, 3583.34, 6.0, 6.11, 3496.03, 6.0, 5.86, 7.11, 6.0, 1.85, 398.15, 5.0, 4.93, 6525.8, 5.0, 1.01, 3149.16, 5.0, 0.84, 4136.91, 5.0, 5.98, 2787.04, 4.0, 1.27, 2281.23, 4.0, 2.33, 3738.76, 1140.0, 3.1416, 0.0, 287.0, 5.637, 6681.225, 244.0, 5.139, 3340.612, 112.0, 6.032, 10021.837, 33.0, 0.13, 13362.45, 32.0, 3.56, 155.42, 8.0, 0.49, 16703.06, 8.0, 1.32, 242.73, 5.0, 3.06, 3185.19, 4.0, 2.16, 553.57, 3.0, 6.23, 3.52, 2.0, 0.44, 3344.14, 2.0, 0.82, 20043.67, 2.0, 3.74, 3496.03, 9.0, 3.14, 0.0, 7.0, 4.04, 6681.22, 5.0, 4.49, 10021.84, 4.0, 5.07, 155.42, 2.0, 3.51, 3340.61, 2.0, 4.85, 13362.45, 1.0, 6.09, 242.73, 1.0, 5.19, 16703.06, 1.0, 1.56, 3185.19, 3.197135E7, 3.76832042, 3340.6124267, 2980332.0, 4.10617, 6681.2248534, 2891047.0, 0.0, 0.0, 313655.0, 4.446511, 10021.83728, 34841.0, 4.78813, 13362.44971, 4434.0, 5.0264, 3344.1355, 4430.0, 5.6523, 3337.0893, 3991.0, 5.1306, 16703.0621, 2925.0, 3.7929, 2281.2305, 1820.0, 6.1365, 6151.5339, 1632.0, 4.264, 529.691, 1597.0, 2.2319, 1059.3819, 1493.0, 2.165, 5621.8429, 1427.0, 1.1822, 3340.5952, 1427.0, 3.2129, 3340.6297, 1393.0, 2.418, 8962.4553, 864.0, 5.744, 3738.761, 833.0, 5.989, 6677.702, 825.0, 5.367, 6684.748, 736.0, 5.092, 398.149, 727.0, 5.538, 6283.076, 631.0, 0.73, 5884.927, 623.0, 4.851, 2942.463, 601.0, 3.68, 796.298, 472.0, 4.522, 3149.164, 470.0, 5.135, 3340.68, 470.0, 5.543, 3340.545, 466.0, 5.474, 20043.675, 456.0, 2.133, 2810.921, 413.0, 0.2, 9492.146, 385.0, 4.08, 4136.91, 331.0, 4.066, 1751.54, 327.0, 2.621, 2914.014, 297.0, 5.922, 3532.061, 295.0, 2.753, 12303.068, 286.0, 4.947, 3870.303, 282.0, 2.063, 5486.778, 266.0, 3.551, 6681.242, 266.0, 1.52, 6681.208, 261.0, 2.601, 4399.994, 233.0, 2.276, 1589.073, 226.0, 2.275, 1194.447, 199.0, 2.674, 8432.764, 189.0, 6.044, 7079.374, 3500688.0, 5.3684784, 3340.6124267, 141160.0, 3.141593, 0.0, 96708.0, 5.47878, 6681.22485, 14719.0, 3.20206, 10021.83728, 4259.0, 3.4084, 13362.4497, 1020.0, 0.7762, 3337.0893, 788.0, 3.718, 16703.062, 327.0, 3.458, 5621.843, 262.0, 2.483, 2281.23, 207.0, 1.441, 6151.534, 183.0, 6.031, 529.691, 170.0, 4.811, 3344.136, 157.0, 3.931, 8962.455, 156.0, 2.782, 3340.595, 156.0, 4.813, 3340.63, 143.0, 0.246, 2942.463, 138.0, 1.68, 3532.061, 131.0, 0.973, 6677.702, 127.0, 4.045, 20043.675, 125.0, 2.256, 5884.927, 93.0, 4.35, 3496.03, 89.0, 5.95, 2810.92, 88.0, 0.34, 398.15, 86.0, 1.75, 2544.31, 81.0, 0.84, 6283.08, 81.0, 4.3, 6684.75, 59.0, 3.7, 5486.78, 58.0, 3.55, 5092.15, 167267.0, 0.602214, 3340.612427, 49868.0, 3.14159, 0.0, 3021.0, 5.5587, 6681.2249, 258.0, 1.897, 13362.45, 215.0, 0.917, 10021.837, 118.0, 2.242, 3337.089, 80.0, 2.25, 16703.06, 30.0, 5.89, 3496.03, 6065.0, 1.9805, 3340.6124, 426.0, 0.0, 0.0, 137.0, 1.796, 6681.225, 27.0, 3.45, 10021.84, 9.0, 3.75, 3337.09, 134.0, 0.0, 0.0, 113.0, 3.457, 3340.612, 7.0, 0.5, 6681.22, 5.0, 4.87, 3340.61, 1.0, 5.31, 6681.22, 1.530334883E9, 0.0, 0.0, 1.41849532E8, 3.479712835, 3340.6124267, 6607764.0, 3.8178344, 6681.2248534, 461791.0, 4.155953, 10021.83728, 81097.0, 5.55958, 2810.92146, 74853.0, 1.77239, 5621.84292, 55232.0, 1.36436, 2281.2305, 38252.0, 4.49407, 13362.44971, 24844.0, 4.92546, 2942.46342, 23065.0, 0.09082, 2544.31442, 19994.0, 5.3606, 3337.08931, 19602.0, 4.74249, 3344.13555, 11671.0, 2.11262, 5092.15196, 11028.0, 5.00908, 398.149, 9923.0, 5.8386, 6151.5339, 8991.0, 4.4079, 529.691, 8073.0, 2.1022, 1059.3819, 7979.0, 3.4484, 796.298, 7410.0, 1.4991, 2146.1654, 7256.0, 1.2452, 8432.7644, 6923.0, 2.1338, 8962.4553, 6331.0, 0.8935, 3340.5952, 6331.0, 2.9243, 3340.6297, 6300.0, 1.2874, 1751.5395, 5744.0, 0.829, 2914.0142, 5262.0, 5.3829, 3738.7614, 4728.0, 5.1985, 3127.3133, 3481.0, 4.8322, 16703.0621, 2837.0, 2.9069, 3532.0607, 2796.0, 5.2575, 6283.0758, 2755.0, 1.2177, 6254.6267, 2752.0, 2.9082, 1748.0164, 2699.0, 3.7639, 5884.9268, 2391.0, 2.0367, 1194.447, 2338.0, 5.1055, 5486.7778, 2281.0, 3.2553, 6872.6731, 2232.0, 4.1986, 3149.1642, 2194.0, 5.5834, 191.4483, 2083.0, 4.8463, 3340.6797, 2083.0, 5.2548, 3340.5451, 1862.0, 5.6987, 6677.7017, 1827.0, 5.0806, 6684.748, 1786.0, 4.1842, 3333.4989, 1760.0, 5.9534, 3870.3034, 1635.0, 3.7989, 4136.9104, 1443.0, 0.213, 5088.6288, 1418.0, 2.4779, 4562.461, 1331.0, 1.5391, 7903.0734, 1286.0, 5.4988, 8827.3903, 1188.0, 2.1218, 1589.0729, 1149.0, 4.3175, 1349.8674, 1115.0, 0.5534, 11243.6858, 1021.0, 6.1814, 9492.1463, 867.0, 1.75, 2700.715, 853.0, 1.616, 4690.48, 845.0, 0.623, 1592.596, 832.0, 0.616, 8429.241, 825.0, 1.622, 11773.377, 718.0, 2.475, 12303.068, 686.0, 2.402, 4399.994, 665.0, 2.213, 6041.328, 636.0, 2.673, 426.598, 620.0, 1.101, 1221.849, 590.0, 3.262, 6681.242, 590.0, 1.232, 6681.208, 586.0, 4.721, 213.299, 558.0, 1.233, 3185.192, 557.0, 5.447, 3723.509, 550.0, 5.727, 951.718, 524.0, 3.024, 4292.331, 516.0, 5.723, 7079.374, 489.0, 5.616, 3553.912, 454.0, 5.433, 6467.926, 446.0, 2.015, 8031.092, 443.0, 5.003, 5614.729, 433.0, 1.037, 11769.854, 424.0, 2.266, 155.42, 422.0, 1.633, 5628.956, 392.0, 1.242, 3339.632, 390.0, 2.578, 3341.593, 364.0, 4.439, 3894.182, 360.0, 1.16, 2288.344, 353.0, 5.49, 1990.745, 336.0, 5.17, 20043.675, 331.0, 0.855, 553.569, 323.0, 2.382, 4535.059, 320.0, 1.94, 382.897, 319.0, 4.593, 2274.117, 319.0, 4.375, 3.523, 303.0, 2.442, 11371.705, 294.0, 4.06, 3097.884, 279.0, 4.258, 3191.049, 275.0, 1.577, 9595.239, 262.0, 5.585, 9623.688, 252.0, 0.814, 10713.995, 248.0, 5.39, 2818.035, 247.0, 2.58, 2803.808, 234.0, 6.015, 3496.033, 228.0, 3.417, 7632.943, 221.0, 0.857, 3319.837, 213.0, 6.192, 14054.607, 210.0, 2.385, 4989.059, 206.0, 2.987, 3361.388, 204.0, 4.536, 6489.777, 199.0, 2.735, 5099.266, 197.0, 1.863, 3443.705, 195.0, 6.038, 10018.314, 194.0, 5.185, 6681.292, 194.0, 5.594, 6681.158, 191.0, 5.42, 10025.36, 191.0, 0.226, 13745.346, 186.0, 4.073, 2388.894, 183.0, 5.796, 7064.121, 182.0, 5.613, 7.114, 180.0, 2.814, 4032.77, 172.0, 3.671, 3205.547, 172.0, 3.188, 3347.726, 171.0, 1.55, 2957.716, 170.0, 6.155, 10404.734, 167.0, 4.521, 6674.111, 165.0, 4.141, 7477.523, 165.0, 3.845, 10973.556, 165.0, 2.866, 14712.317, 163.0, 6.282, 7210.916, 163.0, 1.923, 7373.382, 161.0, 0.928, 14584.298, 160.0, 4.584, 3264.346, 154.0, 2.208, 2118.764, 151.0, 2.654, 2787.043, 137.0, 1.686, 3337.022, 134.0, 2.128, 3344.203, 131.0, 4.275, 14314.168, 119.0, 0.799, 3265.831, 119.0, 4.821, 7234.794, 118.0, 0.197, 3475.678, 118.0, 3.229, 5828.028, 112.0, 0.239, 12832.759, 110.0, 0.445, 10213.286, 106.0, 1.74, 639.897, 102.0, 5.748, 242.729, 102.0, 2.665, 2487.416, 101.0, 5.375, 5085.038, 101.0, 0.789, 9381.94, 101.0, 2.451, 4929.685, 90.0, 0.96, 4933.21, 90.0, 1.99, 15113.99, 90.0, 4.18, 9225.54, 83.0, 1.94, 1648.45, 83.0, 0.95, 2906.9, 82.0, 5.25, 10575.41, 80.0, 3.92, 2921.13, 79.0, 2.81, 15643.68, 78.0, 2.05, 1758.65, 75.0, 5.68, 13916.02, 74.0, 6.1, 3583.34, 74.0, 0.84, 692.16, 70.0, 3.32, 3230.41, 68.0, 4.69, 17654.78, 65.0, 6.12, 135.07, 65.0, 2.74, 7740.61, 64.0, 4.2, 5202.36, 63.0, 3.32, 3767.21, 63.0, 4.5, 8425.65, 62.0, 6.11, 17256.63, 62.0, 4.48, 22747.29, 62.0, 4.59, 6531.66, 62.0, 1.57, 10021.82, 62.0, 3.6, 10021.85, 61.0, 0.0, 6836.65, 57.0, 0.14, 13524.92, 55.0, 5.75, 12168.0, 55.0, 6.06, 10419.99, 54.0, 5.22, 5305.45, 54.0, 5.08, 2707.83, 53.0, 4.55, 1744.43, 52.0, 2.7, 4459.37, 51.0, 1.57, 6525.8, 51.0, 1.29, 8439.88, 50.0, 2.34, 1052.27, 50.0, 4.68, 522.58, 47.0, 0.01, 3325.36, 47.0, 5.78, 9808.54, 47.0, 3.06, 5518.75, 47.0, 5.15, 1066.5, 45.0, 1.44, 3369.06, 45.0, 5.95, 6894.52, 44.0, 5.57, 16865.53, 44.0, 0.82, 3302.48, 43.0, 3.11, 4569.57, 43.0, 2.79, 3503.08, 42.0, 1.91, 263.08, 41.0, 4.4, 3074.01, 41.0, 5.49, 2699.73, 41.0, 5.47, 3120.2, 40.0, 1.34, 6247.51, 40.0, 1.84, 3134.43, 40.0, 3.83, 3355.86, 39.0, 1.98, 8969.57, 39.0, 1.49, 9168.64, 39.0, 0.38, 10177.26, 39.0, 1.23, 16858.48, 39.0, 3.48, 20618.02, 38.0, 0.8, 13517.87, 38.0, 0.27, 17395.22, 37.0, 4.25, 6261.74, 37.0, 1.58, 6680.24, 36.0, 2.95, 6144.42, 36.0, 5.55, 632.78, 36.0, 2.92, 6682.21, 36.0, 3.68, 5724.94, 36.0, 0.15, 2178.14, 35.0, 1.18, 10184.3, 1.1074333E7, 2.03250525, 3340.6124267, 1031759.0, 2.3707185, 6681.2248534, 128772.0, 0.0, 0.0, 108159.0, 2.708881, 10021.83728, 11946.0, 3.04702, 13362.44971, 4386.0, 2.8884, 2281.2305, 3957.0, 3.4232, 3344.1355, 1826.0, 1.5843, 2544.3144, 1359.0, 3.3851, 16703.0621, 1284.0, 6.0434, 3337.0893, 1282.0, 0.6299, 1059.3819, 1271.0, 1.9539, 796.298, 1184.0, 2.9976, 2146.1654, 875.0, 3.421, 398.149, 830.0, 3.856, 3738.761, 756.0, 4.451, 6151.534, 720.0, 2.764, 529.691, 665.0, 2.549, 1751.54, 664.0, 4.406, 1748.016, 575.0, 0.544, 1194.447, 543.0, 0.678, 8962.455, 510.0, 3.726, 6684.748, 494.0, 5.73, 3340.595, 494.0, 1.477, 3340.63, 483.0, 2.581, 3149.164, 479.0, 2.285, 2914.014, 390.0, 2.319, 4136.91, 372.0, 5.814, 1349.867, 364.0, 6.027, 3185.192, 360.0, 5.895, 3333.499, 311.0, 0.978, 191.448, 272.0, 5.414, 1592.596, 243.0, 3.758, 155.42, 228.0, 1.748, 5088.629, 223.0, 0.939, 951.718, 217.0, 3.836, 6283.076, 216.0, 4.569, 3532.061, 213.0, 0.78, 1589.073, 204.0, 3.135, 4690.48, 182.0, 0.413, 5486.778, 180.0, 4.219, 3870.303, 169.0, 4.537, 4292.331, 168.0, 5.549, 3097.884, 165.0, 0.968, 4399.994, 165.0, 3.539, 2700.715, 163.0, 3.808, 3340.545, 163.0, 3.399, 3340.68, 162.0, 2.349, 553.569, 158.0, 4.757, 9492.146, 157.0, 3.724, 20043.675, 147.0, 5.953, 3894.182, 143.0, 3.999, 1990.745, 132.0, 0.415, 5614.729, 130.0, 5.142, 6677.702, 127.0, 0.69, 3723.509, 125.0, 1.032, 3341.593, 124.0, 6.231, 5628.956, 122.0, 4.223, 7079.374, 118.0, 6.253, 2274.117, 113.0, 1.024, 12303.068, 112.0, 1.318, 3496.033, 104.0, 1.233, 426.598, 103.0, 0.901, 4535.059, 98.0, 3.45, 382.9, 92.0, 1.82, 6681.24, 92.0, 6.07, 6681.21, 92.0, 3.9, 3553.91, 90.0, 2.58, 2388.89, 88.0, 2.2, 1221.85, 86.0, 1.16, 2787.04, 79.0, 5.74, 2288.34, 78.0, 4.15, 6041.33, 77.0, 1.01, 8432.76, 73.0, 4.27, 2803.81, 72.0, 3.7, 2818.04, 71.0, 3.51, 8031.09, 68.0, 4.05, 10025.36, 68.0, 0.24, 11773.38, 67.0, 4.26, 242.73, 65.0, 0.04, 2957.72, 65.0, 2.12, 8429.24, 65.0, 2.76, 3339.63, 63.0, 1.9, 5621.84, 63.0, 1.6, 3347.73, 60.0, 2.96, 6489.78, 57.0, 3.14, 213.3, 55.0, 4.91, 7632.94, 55.0, 4.61, 3583.34, 53.0, 3.78, 5092.15, 52.0, 2.67, 7477.52, 51.0, 3.98, 7.11, 47.0, 0.91, 5099.27, 46.0, 1.82, 2810.92, 40.0, 4.14, 9623.69, 40.0, 4.91, 2942.46, 39.0, 0.54, 5884.93, 39.0, 3.08, 3.52, 39.0, 0.67, 3127.31, 38.0, 0.03, 7234.79, 37.0, 0.09, 6525.8, 36.0, 5.77, 4933.21, 32.0, 4.55, 2487.42, 31.0, 1.0, 2118.76, 30.0, 2.59, 2906.9, 30.0, 4.15, 6681.16, 30.0, 3.74, 6681.29, 30.0, 0.83, 5085.04, 29.0, 4.66, 7210.92, 28.0, 1.01, 7064.12, 28.0, 0.05, 639.9, 28.0, 3.98, 6467.93, 28.0, 5.17, 5828.03, 27.0, 0.69, 2699.73, 26.0, 5.34, 10973.56, 26.0, 5.01, 10018.31, 26.0, 1.09, 4929.69, 26.0, 5.09, 12832.76, 25.0, 1.53, 6836.65, 24.0, 3.94, 11371.7, 22.0, 0.19, 9595.24, 21.0, 5.69, 3191.05, 21.0, 1.3, 7740.61, 21.0, 3.54, 1066.5, 21.0, 6.24, 6674.11, 20.0, 6.16, 1744.43, 20.0, 0.46, 10575.41, 19.0, 5.02, 3475.68, 19.0, 1.37, 15643.68, 18.0, 4.06, 23384.29, 18.0, 6.16, 8425.65, 18.0, 5.68, 3319.84, 18.0, 2.31, 3355.86, 18.0, 5.87, 3320.26, 17.0, 4.58, 10419.99, 17.0, 2.22, 2921.13, 17.0, 1.93, 3767.21, 16.0, 4.34, 5331.36, 16.0, 5.93, 8439.88, 15.0, 1.54, 3361.39, 15.0, 0.35, 8969.57, 14.0, 2.15, 10021.85, 14.0, 0.12, 10021.82, 14.0, 0.56, 15113.99, 14.0, 1.39, 6682.21, 14.0, 4.65, 4562.46, 14.0, 1.5, 3325.36, 14.0, 0.15, 1758.65, 13.0, 1.25, 7875.67, 13.0, 1.87, 692.16, 13.0, 1.45, 6254.63, 13.0, 5.79, 14584.3, 13.0, 1.35, 10404.73, 12.0, 6.03, 3264.35, 12.0, 1.88, 10177.26, 12.0, 0.85, 3120.2, 12.0, 4.3, 6894.52, 12.0, 0.9, 13916.02, 12.0, 4.18, 3360.97, 12.0, 3.0, 6247.51, 11.0, 0.15, 3134.43, 11.0, 2.84, 640.88, 11.0, 2.58, 6261.74, 11.0, 0.49, 11243.69, 11.0, 0.25, 3337.02, 11.0, 0.13, 522.58, 11.0, 0.68, 3344.2, 10.0, 4.06, 6158.65, 10.0, 5.7, 536.8, 10.0, 5.77, 14314.17, 10.0, 1.28, 4569.57, 10.0, 2.92, 5729.51, 442422.0, 0.479306, 3340.612427, 81380.0, 0.86998, 6681.22485, 12749.0, 1.22594, 10021.83728, 1874.0, 1.573, 13362.4497, 524.0, 3.142, 0.0, 407.0, 1.971, 3344.136, 266.0, 1.917, 16703.062, 178.0, 4.435, 2281.23, 117.0, 4.525, 3185.192, 102.0, 5.391, 1059.382, 100.0, 0.419, 796.298, 92.0, 4.54, 2146.17, 78.0, 5.93, 1748.02, 73.0, 3.14, 2544.31, 72.0, 2.29, 6684.75, 68.0, 5.27, 155.42, 67.0, 5.3, 1194.45, 65.0, 2.31, 3738.76, 58.0, 1.05, 1349.87, 54.0, 1.0, 3149.16, 47.0, 0.77, 3097.88, 46.0, 0.81, 4136.91, 44.0, 2.46, 951.72, 43.0, 3.9, 1592.6, 39.0, 3.86, 553.57, 37.0, 2.26, 20043.67, 36.0, 1.32, 3333.5, 35.0, 1.85, 398.15, 34.0, 3.82, 1751.54, 32.0, 2.12, 5614.73, 31.0, 4.55, 5628.96, 30.0, 2.86, 6151.53, 29.0, 1.19, 529.69, 29.0, 1.2, 3894.18, 28.0, 2.49, 1990.75, 27.0, 2.92, 3496.03, 27.0, 6.07, 4292.33, 24.0, 4.68, 4690.48, 24.0, 5.94, 2787.04, 23.0, 2.56, 191.45, 22.0, 1.85, 3337.09, 22.0, 5.37, 8962.46, 22.0, 1.07, 2388.89, 21.0, 2.75, 242.73, 20.0, 3.82, 2914.01, 20.0, 5.76, 3341.59, 20.0, 5.76, 4399.99, 20.0, 4.17, 3340.6, 20.0, 6.21, 3340.63, 20.0, 3.11, 3583.34, 18.0, 5.69, 1589.07, 18.0, 3.32, 5088.63, 16.0, 5.68, 4535.06, 15.0, 4.96, 382.9, 15.0, 2.23, 3723.51, 14.0, 2.7, 7079.37, 14.0, 5.19, 2700.72, 13.0, 4.88, 6525.8, 13.0, 4.82, 2957.72, 12.0, 2.62, 10025.36, 12.0, 0.93, 2810.92, 12.0, 3.27, 9492.15, 10.0, 6.27, 3347.73, 10.0, 3.4, 5621.84, 10.0, 2.11, 3870.3, 9.0, 1.4, 6489.78, 9.0, 5.81, 12303.07, 9.0, 2.2, 2699.73, 9.0, 5.96, 426.6, 8.0, 2.26, 6283.08, 8.0, 2.24, 3553.91, 8.0, 1.17, 7477.52, 8.0, 2.01, 5092.15, 8.0, 0.23, 3532.06, 8.0, 2.06, 5486.78, 7.0, 4.26, 4933.21, 7.0, 0.3, 6681.24, 7.0, 4.55, 6681.21, 7.0, 2.34, 7.11, 7.0, 3.99, 6677.7, 7.0, 0.16, 7632.94, 6.0, 2.25, 3340.55, 6.0, 1.84, 3340.68, 6.0, 1.55, 7234.79, 6.0, 3.3, 1221.85, 6.0, 5.06, 8031.09, 5.0, 4.26, 3339.63, 5.0, 2.6, 23384.29, 5.0, 3.08, 6836.65, 4.0, 1.34, 640.88, 4.0, 4.96, 8969.57, 4.0, 2.85, 5331.36, 4.0, 6.27, 2487.42, 4.0, 6.1, 7740.61, 11131.0, 5.14987, 3340.61243, 4244.0, 5.6134, 6681.2249, 1000.0, 5.9973, 10021.8373, 196.0, 0.076, 13362.45, 47.0, 3.14, 0.0, 35.0, 0.43, 16703.06, 29.0, 0.45, 3344.14, 24.0, 3.02, 3185.19, 7.0, 0.81, 6684.75, 6.0, 0.78, 20043.67, 5.0, 3.87, 1059.38, 5.0, 1.61, 3583.34, 5.0, 4.52, 3496.03, 4.0, 5.72, 3149.16, 4.0, 4.42, 2787.04, 4.0, 5.56, 4136.91, 3.0, 3.38, 6525.8, 3.0, 0.76, 3738.76, 2.0, 2.14, 3097.88, 2.0, 5.83, 2388.89, 2.0, 0.57, 155.42, 2.0, 4.2, 3341.59, 2.0, 0.97, 1990.75, 2.0, 2.35, 1592.6, 2.0, 4.15, 4535.06, 2.0, 3.76, 1194.45, 2.0, 1.14, 10025.36, 2.0, 5.13, 796.3, 196.0, 3.582, 3340.612, 163.0, 4.051, 6681.225, 58.0, 4.46, 10021.84, 15.0, 4.84, 13362.45, 4.0, 1.51, 3185.19, 3.0, 5.21, 16703.06, 2.0, 5.16, 3344.14, 1.0, 0.0, 0.0, 1.0, 2.19, 3496.03, 1.0, 0.1, 3583.34, 1.0, 5.55, 20043.67, 1.0, 1.87, 6525.8, 5.0, 2.48, 6681.22, 3.0, 2.92, 10021.84, 1.0, 1.77, 3340.61, 1.0, 3.31, 13362.45};
        return XL0;
    }

    /*
     * Opcode count of 15698 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static double[] getXL0_5() {
        double[] XL0 = new double[]{1.0E8, 20.0, 503.0, 863.0, 1256.0, 1451.0, 1529.0, 1550.0, 1676.0, 1802.0, 1910.0, 1964.0, 1988.0, 1991.0, 2513.0, 2945.0, 3482.0, 3761.0, 3896.0, 3923.0, 5.9954691E7, 0.0, 0.0, 9695899.0, 5.0619179, 529.6909651, 573610.0, 1.444062, 7.113547, 306389.0, 5.417347, 1059.38193, 97178.0, 4.14265, 632.78374, 72903.0, 3.64043, 522.57742, 64264.0, 3.41145, 103.09277, 39806.0, 2.29377, 419.48464, 38858.0, 1.27232, 316.39187, 27965.0, 1.78455, 536.80451, 13590.0, 5.77481, 1589.0729, 8769.0, 3.63, 949.1756, 8246.0, 3.5823, 206.1855, 7368.0, 5.081, 735.8765, 6263.0, 0.025, 213.2991, 6114.0, 4.5132, 1162.4747, 5305.0, 4.1863, 1052.2684, 5305.0, 1.3067, 14.2271, 4905.0, 1.3208, 110.2063, 4647.0, 4.6996, 3.9322, 3045.0, 4.3168, 426.5982, 2610.0, 1.5667, 846.0828, 2028.0, 1.0638, 3.1814, 1921.0, 0.9717, 639.8973, 1765.0, 2.1415, 1066.4955, 1723.0, 3.8804, 1265.5675, 1633.0, 3.582, 515.4639, 1432.0, 4.2968, 625.6702, 973.0, 4.098, 95.979, 884.0, 2.437, 412.371, 733.0, 6.085, 838.969, 731.0, 3.806, 1581.959, 709.0, 1.293, 742.99, 692.0, 6.134, 2118.764, 614.0, 4.109, 1478.867, 582.0, 4.54, 309.278, 495.0, 3.756, 323.505, 441.0, 2.958, 454.909, 417.0, 1.036, 2.448, 390.0, 4.897, 1692.166, 376.0, 4.703, 1368.66, 341.0, 5.715, 533.623, 330.0, 4.74, 0.048, 262.0, 1.877, 0.963, 261.0, 0.82, 380.128, 257.0, 3.724, 199.072, 244.0, 5.22, 728.763, 235.0, 1.227, 909.819, 220.0, 1.651, 543.918, 207.0, 1.855, 525.759, 202.0, 1.807, 1375.774, 197.0, 5.293, 1155.361, 175.0, 3.73, 942.062, 175.0, 3.226, 1898.351, 175.0, 5.91, 956.289, 158.0, 4.365, 1795.258, 151.0, 3.906, 74.782, 149.0, 4.377, 1685.052, 141.0, 3.136, 491.558, 138.0, 1.318, 1169.588, 131.0, 4.169, 1045.155, 117.0, 2.5, 1596.186, 117.0, 3.389, 0.521, 106.0, 4.554, 526.51, 100.0, 1.421, 532.872, 96.0, 1.18, 117.32, 92.0, 0.86, 1272.68, 88.0, 1.22, 453.42, 77.0, 4.43, 39.36, 72.0, 4.24, 2111.65, 70.0, 5.14, 835.04, 69.0, 2.35, 2.92, 67.0, 2.99, 2214.74, 66.0, 5.34, 1471.75, 63.0, 4.98, 0.75, 62.0, 0.51, 220.41, 60.0, 4.13, 4.19, 59.0, 4.11, 2001.44, 58.0, 5.87, 5753.38, 56.0, 1.15, 21.34, 54.0, 1.57, 983.12, 53.0, 0.91, 10.29, 52.0, 4.1, 1258.45, 47.0, 3.55, 5.42, 47.0, 4.79, 305.35, 46.0, 4.67, 5.63, 46.0, 5.11, 4.67, 43.0, 0.15, 528.21, 42.0, 4.68, 302.16, 40.0, 4.69, 0.16, 39.0, 4.25, 853.2, 39.0, 1.72, 11.05, 39.0, 6.08, 518.65, 38.0, 2.44, 433.71, 38.0, 0.21, 2648.45, 38.0, 6.19, 831.86, 36.0, 2.45, 430.53, 36.0, 4.61, 2008.56, 34.0, 1.01, 9683.59, 33.0, 5.29, 88.87, 32.0, 5.14, 1788.14, 31.0, 0.42, 1.48, 30.0, 3.67, 508.35, 30.0, 5.34, 2221.86, 28.0, 1.85, 0.21, 27.0, 2.81, 18.16, 27.0, 1.78, 532.14, 26.0, 2.74, 2531.13, 26.0, 3.86, 2317.84, 25.0, 2.63, 114.14, 24.0, 3.82, 1574.85, 24.0, 2.53, 494.27, 23.0, 3.24, 984.6, 23.0, 3.85, 2428.04, 22.0, 6.02, 1063.31, 21.0, 1.29, 35.42, 21.0, 4.03, 355.75, 20.0, 1.02, 628.85, 20.0, 5.6, 527.24, 19.0, 0.52, 14.98, 19.0, 4.86, 1361.55, 18.0, 4.3, 6.15, 17.0, 1.59, 1439.51, 16.0, 2.77, 760.26, 16.0, 5.27, 142.45, 16.0, 1.89, 529.64, 16.0, 5.09, 529.74, 16.0, 4.12, 636.72, 15.0, 6.08, 149.56, 15.0, 2.82, 621.74, 15.0, 4.86, 2104.54, 15.0, 0.88, 99.16, 15.0, 6.26, 569.05, 14.0, 2.41, 530.65, 14.0, 2.72, 0.26, 14.0, 3.56, 217.23, 13.0, 2.19, 1055.45, 13.0, 2.72, 1364.73, 13.0, 4.76, 528.73, 13.0, 1.39, 7.07, 12.0, 2.61, 405.26, 12.0, 4.3, 604.47, 12.0, 0.25, 1485.98, 12.0, 3.6, 2634.23, 12.0, 4.6, 7.16, 12.0, 2.35, 643.83, 11.0, 2.01, 1073.61, 11.0, 2.48, 423.42, 11.0, 4.05, 519.4, 11.0, 5.04, 458.84, 11.0, 5.09, 2324.95, 11.0, 2.51, 2847.53, 11.0, 2.08, 92.05, 11.0, 3.12, 1.27, 10.0, 3.63, 2744.43, 10.0, 2.09, 511.53, 10.0, 1.31, 1905.46, 10.0, 3.66, 107.02, 10.0, 4.06, 38.13, 10.0, 1.7, 1699.28, 10.0, 1.22, 32.24, 5.2993480757E10, 0.0, 0.0, 489741.0, 4.220667, 529.690965, 228919.0, 6.026475, 7.113547, 27655.0, 4.57266, 1059.38193, 20721.0, 5.45939, 522.57742, 12106.0, 0.16986, 536.80451, 6068.0, 4.4242, 103.0928, 5434.0, 3.9848, 419.4846, 4238.0, 5.8901, 14.2271, 2212.0, 5.2677, 206.1855, 1746.0, 4.9267, 1589.0729, 1296.0, 5.5513, 3.1814, 1173.0, 5.8565, 1052.2684, 1163.0, 0.5145, 3.9322, 1099.0, 5.307, 515.4639, 1007.0, 0.4648, 735.8765, 1004.0, 3.1504, 426.5982, 848.0, 5.758, 110.206, 827.0, 4.803, 213.299, 816.0, 0.586, 1066.495, 725.0, 5.518, 639.897, 568.0, 5.989, 625.67, 474.0, 4.132, 412.371, 413.0, 5.737, 95.979, 345.0, 4.242, 632.784, 336.0, 3.732, 1162.475, 234.0, 4.035, 949.176, 234.0, 6.243, 309.278, 199.0, 1.505, 838.969, 195.0, 2.219, 323.505, 187.0, 6.086, 742.99, 184.0, 6.28, 543.918, 171.0, 5.417, 199.072, 131.0, 0.626, 728.763, 115.0, 0.68, 846.083, 115.0, 5.286, 2118.764, 108.0, 4.493, 956.289, 80.0, 5.82, 1045.15, 72.0, 5.34, 942.06, 70.0, 5.97, 532.87, 67.0, 5.73, 21.34, 66.0, 0.13, 526.51, 65.0, 6.09, 1581.96, 59.0, 0.59, 1155.36, 58.0, 0.99, 1596.19, 57.0, 5.97, 1169.59, 57.0, 1.41, 533.62, 55.0, 5.43, 10.29, 52.0, 5.73, 117.32, 52.0, 0.23, 1368.66, 50.0, 6.08, 525.76, 47.0, 3.63, 1478.87, 47.0, 0.51, 1265.57, 40.0, 4.16, 1692.17, 34.0, 0.1, 302.16, 33.0, 5.04, 220.41, 32.0, 5.37, 508.35, 29.0, 5.42, 1272.68, 29.0, 3.36, 4.67, 29.0, 0.76, 88.87, 25.0, 1.61, 831.86, 22.0, 6.15, 1685.05, 21.0, 5.86, 1258.45, 20.0, 2.17, 316.39, 18.0, 0.83, 433.71, 18.0, 5.96, 5.42, 18.0, 0.5, 1375.77, 17.0, 0.71, 1471.75, 17.0, 2.76, 853.2, 14.0, 0.91, 18.16, 14.0, 0.63, 2.92, 12.0, 1.76, 380.13, 12.0, 4.3, 405.26, 11.0, 5.57, 1574.85, 10.0, 0.31, 1361.55, 10.0, 0.39, 1073.61, 10.0, 5.9, 519.4, 9.0, 3.22, 1795.26, 9.0, 0.54, 1788.14, 8.0, 5.88, 2001.44, 8.0, 5.1, 1485.98, 8.0, 5.65, 2648.45, 7.0, 6.19, 11.05, 7.0, 2.41, 4.19, 6.0, 1.36, 1148.25, 6.0, 4.22, 2008.56, 6.0, 5.57, 191.96, 5.0, 4.4, 2221.86, 5.0, 1.46, 330.62, 5.0, 5.23, 628.85, 5.0, 2.93, 518.65, 5.0, 0.17, 629.6, 5.0, 0.79, 721.65, 5.0, 6.25, 1677.94, 5.0, 4.95, 635.97, 5.0, 2.07, 453.42, 4.0, 0.09, 1062.56, 4.0, 4.36, 423.42, 4.0, 0.15, 1699.28, 4.0, 4.14, 511.53, 4.0, 0.24, 2104.54, 4.0, 1.44, 2125.88, 4.0, 0.5, 1056.2, 4.0, 6.19, 636.72, 4.0, 2.55, 74.78, 4.0, 2.93, 32.24, 4.0, 5.67, 2317.84, 4.0, 0.25, 1055.45, 3.0, 5.89, 1802.37, 3.0, 4.61, 416.3, 3.0, 5.5, 107.02, 3.0, 1.09, 1464.64, 3.0, 5.73, 99.91, 3.0, 3.31, 0.75, 3.0, 1.61, 1063.31, 3.0, 1.25, 540.74, 3.0, 3.04, 422.67, 3.0, 4.29, 106.27, 3.0, 0.35, 1898.35, 3.0, 3.6, 750.1, 47234.0, 4.32148, 7.11355, 38966.0, 0.0, 0.0, 30629.0, 2.93021, 529.69097, 3189.0, 1.055, 522.5774, 2729.0, 4.8455, 536.8045, 2723.0, 3.4141, 1059.3819, 1721.0, 4.1873, 14.2271, 383.0, 5.768, 419.485, 378.0, 0.76, 515.464, 367.0, 6.055, 103.093, 337.0, 3.786, 3.181, 308.0, 0.694, 206.186, 218.0, 3.814, 1589.073, 199.0, 5.34, 1066.495, 197.0, 2.484, 3.932, 156.0, 1.406, 1052.268, 146.0, 3.814, 639.897, 142.0, 1.634, 426.598, 130.0, 5.837, 412.371, 117.0, 1.414, 625.67, 97.0, 4.03, 110.21, 91.0, 1.11, 95.98, 87.0, 2.52, 632.78, 79.0, 4.64, 543.92, 72.0, 2.22, 735.88, 58.0, 0.83, 199.07, 57.0, 3.12, 213.3, 49.0, 1.67, 309.28, 40.0, 4.02, 21.34, 40.0, 0.62, 323.51, 36.0, 2.33, 728.76, 29.0, 3.61, 10.29, 28.0, 3.24, 838.97, 26.0, 4.5, 742.99, 26.0, 2.51, 1162.47, 25.0, 1.22, 1045.15, 24.0, 3.01, 956.29, 19.0, 4.29, 532.87, 18.0, 0.81, 508.35, 17.0, 4.2, 2118.76, 17.0, 1.83, 526.51, 15.0, 5.81, 1596.19, 15.0, 0.68, 942.06, 15.0, 4.0, 117.32, 14.0, 5.95, 316.39, 14.0, 1.8, 302.16, 13.0, 2.52, 88.87, 13.0, 4.37, 1169.59, 11.0, 4.44, 525.76, 10.0, 1.72, 1581.96, 9.0, 2.18, 1155.36, 9.0, 3.29, 220.41, 9.0, 3.32, 831.86, 8.0, 5.76, 846.08, 8.0, 2.71, 533.62, 7.0, 2.18, 1265.57, 6.0, 0.5, 949.18, 5.0, 6.01, 405.26, 5.0, 3.65, 1272.68, 5.0, 1.41, 1258.45, 4.0, 3.02, 1692.17, 4.0, 5.48, 433.71, 4.0, 2.27, 1368.66, 4.0, 5.07, 1073.61, 4.0, 5.29, 18.16, 4.0, 1.27, 853.2, 3.0, 1.54, 519.4, 3.0, 0.99, 191.96, 3.0, 2.05, 1361.55, 3.0, 2.1, 1478.87, 3.0, 1.06, 1574.85, 2.0, 2.37, 1471.75, 2.0, 3.03, 1148.25, 2.0, 2.48, 721.65, 2.0, 3.71, 1485.98, 2.0, 6.17, 330.62, 2.0, 1.88, 1685.05, 1.0, 5.15, 1375.77, 1.0, 4.72, 32.24, 1.0, 3.19, 635.97, 1.0, 1.99, 629.6, 1.0, 4.27, 551.03, 1.0, 1.28, 1038.04, 1.0, 4.02, 539.99, 1.0, 4.76, 1062.56, 1.0, 4.63, 2648.45, 1.0, 2.26, 1788.14, 1.0, 0.03, 2125.88, 1.0, 1.7, 1677.94, 1.0, 2.18, 1795.26, 1.0, 2.98, 81.75, 1.0, 5.06, 1699.28, 1.0, 0.14, 416.3, 1.0, 1.99, 295.05, 1.0, 3.75, 28.45, 1.0, 1.91, 750.1, 1.0, 2.81, 1464.64, 1.0, 3.01, 124.43, 1.0, 1.18, 99.91, 1.0, 3.53, 227.53, 1.0, 1.75, 1898.35, 1.0, 2.07, 1056.2, 1.0, 2.74, 618.56, 1.0, 6.25, 423.42, 1.0, 2.0, 2111.65, 1.0, 1.65, 2001.44, 1.0, 4.92, 1055.45, 1.0, 2.89, 2008.56, 1.0, 4.32, 1802.37, 1.0, 1.26, 1382.89, 1.0, 3.03, 2221.86, 1.0, 2.65, 106.27, 1.0, 3.3, 628.85, 1.0, 3.44, 824.74, 1.0, 0.08, 963.4, 1.0, 3.12, 5746.27, 1.0, 5.47, 5760.5, 1.0, 1.88, 2104.54, 1.0, 1.2, 422.67, 1.0, 4.68, 611.44, 1.0, 1.86, 636.72, 1.0, 4.54, 9676.48, 1.0, 0.61, 9690.71, 1.0, 2.84, 1905.46, 1.0, 3.08, 380.13, 1.0, 0.84, 1891.24, 1.0, 3.96, 440.83, 1.0, 1.56, 1994.33, 1.0, 2.55, 1781.03, 1.0, 1.11, 107.02, 1.0, 4.44, 647.01, 6502.0, 2.5986, 7.1135, 1357.0, 1.3464, 529.691, 471.0, 2.475, 14.227, 417.0, 3.245, 536.805, 353.0, 2.974, 522.577, 155.0, 2.076, 1059.382, 87.0, 2.51, 515.46, 44.0, 0.0, 0.0, 34.0, 3.83, 1066.5, 28.0, 2.45, 206.19, 24.0, 1.28, 412.37, 23.0, 2.98, 543.92, 20.0, 2.1, 639.9, 20.0, 1.4, 419.48, 19.0, 1.59, 103.09, 17.0, 2.3, 21.34, 17.0, 2.6, 1589.07, 16.0, 3.15, 625.67, 16.0, 3.36, 1052.27, 13.0, 2.76, 95.98, 13.0, 2.54, 199.07, 13.0, 6.27, 426.6, 9.0, 1.76, 10.29, 9.0, 2.27, 110.21, 7.0, 3.43, 309.28, 7.0, 4.04, 728.76, 6.0, 2.52, 508.35, 5.0, 2.91, 1045.15, 5.0, 5.25, 323.51, 4.0, 4.3, 88.87, 4.0, 3.52, 302.16, 4.0, 4.09, 735.88, 3.0, 1.43, 956.29, 3.0, 4.36, 1596.19, 3.0, 1.25, 213.3, 3.0, 5.02, 838.97, 3.0, 2.24, 117.32, 2.0, 2.9, 742.99, 2.0, 2.36, 942.06, 2.0, 2.77, 1169.59, 2.0, 5.01, 831.86, 2.0, 1.4, 405.26, 1.0, 1.61, 220.41, 1.0, 3.09, 2118.76, 1.0, 3.98, 1155.36, 1.0, 3.46, 1073.61, 1.0, 3.39, 532.87, 1.0, 2.7, 191.96, 1.0, 1.48, 632.78, 1.0, 3.3, 1258.45, 1.0, 1.11, 1162.47, 1.0, 3.66, 1581.96, 1.0, 3.75, 433.71, 1.0, 5.9, 853.2, 1.0, 1.96, 1272.68, 1.0, 2.93, 1574.85, 1.0, 3.53, 525.76, 1.0, 2.02, 526.51, 1.0, 4.15, 721.65, 1.0, 4.69, 81.75, 1.0, 2.28, 551.03, 1.0, 4.36, 1368.66, 1.0, 1.57, 949.18, 1.0, 4.96, 1148.25, 1.0, 4.31, 330.62, 669.0, 0.853, 7.114, 114.0, 3.142, 0.0, 100.0, 0.743, 14.227, 50.0, 1.65, 536.8, 44.0, 5.82, 529.69, 32.0, 4.86, 522.58, 15.0, 4.29, 515.46, 9.0, 0.71, 1059.38, 5.0, 1.3, 543.92, 4.0, 2.32, 1066.5, 4.0, 0.48, 21.34, 3.0, 3.0, 412.37, 2.0, 0.4, 639.9, 2.0, 4.26, 199.07, 2.0, 4.91, 625.67, 2.0, 4.26, 206.19, 1.0, 5.26, 1052.27, 1.0, 4.72, 95.98, 1.0, 1.29, 1589.07, 1.0, 4.78, 1045.15, 1.0, 6.06, 88.87, 1.0, 5.78, 728.76, 1.0, 4.55, 426.6, 1.0, 3.4, 419.48, 1.0, 3.55, 103.09, 1.0, 0.52, 110.21, 50.0, 5.26, 7.11, 16.0, 5.25, 14.23, 4.0, 0.01, 536.8, 2.0, 1.1, 522.58, 1.0, 3.14, 0.0, 1.0, 5.86, 543.92, 1.0, 0.87, 515.46, 2268616.0, 3.5585261, 529.6909651, 110090.0, 0.0, 0.0, 109972.0, 3.908093, 1059.38193, 8101.0, 3.6051, 522.5774, 6438.0, 0.3063, 536.8045, 6044.0, 4.2588, 1589.0729, 1107.0, 2.9853, 1162.4747, 944.0, 1.675, 426.598, 942.0, 2.936, 1052.268, 894.0, 1.754, 7.114, 836.0, 5.179, 103.093, 767.0, 2.155, 632.784, 684.0, 3.678, 213.299, 629.0, 0.643, 1066.495, 559.0, 0.014, 846.083, 532.0, 2.703, 110.206, 464.0, 1.173, 949.176, 431.0, 2.608, 419.485, 351.0, 4.611, 2118.764, 132.0, 4.778, 742.99, 123.0, 3.35, 1692.166, 116.0, 1.387, 323.505, 115.0, 5.049, 316.392, 104.0, 3.701, 515.464, 103.0, 2.319, 1478.867, 102.0, 3.153, 1581.959, 79.0, 3.98, 1265.57, 70.0, 2.56, 956.29, 63.0, 4.5, 735.88, 56.0, 0.38, 1375.77, 55.0, 0.4, 525.76, 52.0, 0.99, 1596.19, 50.0, 0.19, 543.92, 49.0, 3.57, 533.62, 29.0, 5.43, 206.19, 28.0, 1.54, 625.67, 24.0, 6.11, 1169.59, 23.0, 5.95, 838.97, 23.0, 4.06, 526.51, 23.0, 6.19, 532.87, 21.0, 2.69, 1045.15, 21.0, 4.96, 2648.45, 177352.0, 5.701665, 529.690965, 3230.0, 5.7794, 1059.3819, 3081.0, 5.4746, 522.5774, 2212.0, 4.7348, 536.8045, 1694.0, 3.1416, 0.0, 346.0, 4.746, 1052.268, 234.0, 5.189, 1066.495, 196.0, 6.186, 7.114, 150.0, 3.927, 1589.073, 114.0, 3.439, 632.784, 97.0, 2.91, 949.18, 82.0, 5.08, 1162.47, 77.0, 2.51, 103.09, 77.0, 0.61, 419.48, 74.0, 5.5, 515.46, 61.0, 5.45, 213.3, 50.0, 3.95, 735.88, 46.0, 0.54, 110.21, 45.0, 1.9, 846.08, 37.0, 4.7, 543.92, 36.0, 6.11, 316.39, 32.0, 4.92, 1581.96, 25.0, 3.94, 2118.76, 23.0, 5.85, 323.51, 21.0, 5.63, 1596.19, 17.0, 5.65, 533.62, 17.0, 5.67, 1265.57, 17.0, 5.9, 526.51, 16.0, 4.43, 1045.15, 13.0, 4.3, 532.87, 12.0, 4.3, 525.76, 12.0, 1.81, 956.29, 11.0, 6.16, 14.23, 10.0, 2.03, 206.19, 9.0, 4.87, 1155.36, 9.0, 1.56, 426.6, 8.0, 3.93, 1478.87, 8.0, 4.2, 1169.59, 8.0, 3.85, 625.67, 8.0, 2.99, 942.06, 6.0, 3.41, 639.9, 5.0, 0.83, 117.32, 8094.0, 1.4632, 529.691, 813.0, 3.142, 0.0, 742.0, 0.957, 522.577, 399.0, 2.899, 536.805, 342.0, 1.447, 1059.382, 74.0, 0.41, 1052.27, 46.0, 3.48, 1066.5, 30.0, 1.93, 1589.07, 29.0, 0.99, 515.46, 23.0, 4.27, 7.11, 14.0, 2.92, 543.92, 12.0, 5.22, 632.78, 11.0, 4.88, 949.18, 6.0, 6.21, 1045.15, 6.0, 0.53, 1581.96, 5.0, 6.03, 735.88, 5.0, 1.43, 526.51, 5.0, 0.92, 1162.47, 5.0, 4.02, 1596.19, 4.0, 4.54, 110.21, 3.0, 1.39, 533.62, 3.0, 0.42, 419.48, 3.0, 4.4, 14.23, 3.0, 2.48, 2118.76, 3.0, 2.4, 532.87, 3.0, 2.06, 316.39, 3.0, 3.98, 323.51, 2.0, 0.88, 213.3, 2.0, 0.37, 1155.36, 2.0, 4.78, 942.06, 2.0, 3.89, 426.6, 2.0, 3.9, 846.08, 2.0, 1.2, 103.09, 2.0, 5.8, 625.67, 2.0, 2.24, 525.76, 2.0, 1.42, 1265.57, 252.0, 3.381, 529.691, 122.0, 2.733, 522.577, 49.0, 1.04, 536.8, 11.0, 2.31, 1052.27, 8.0, 2.77, 515.46, 7.0, 4.25, 1059.38, 6.0, 1.78, 1066.5, 4.0, 1.13, 543.92, 3.0, 3.14, 0.0, 2.0, 2.29, 7.11, 2.0, 1.78, 1045.15, 1.0, 0.45, 632.78, 1.0, 0.33, 1589.07, 1.0, 0.31, 949.18, 1.0, 1.53, 735.88, 1.0, 2.64, 14.23, 1.0, 2.37, 1581.96, 1.0, 2.48, 1596.19, 15.0, 4.53, 522.58, 5.0, 4.47, 529.69, 4.0, 5.44, 536.8, 3.0, 0.0, 0.0, 2.0, 4.52, 515.46, 1.0, 4.2, 1052.27, 1.0, 5.59, 543.92, 1.0, 0.06, 1066.5, 1.0, 0.09, 522.58, 5.20887429E8, 0.0, 0.0, 2.5209327E7, 3.4910864, 529.69096509, 610600.0, 3.841154, 1059.38193, 282029.0, 2.574199, 632.783739, 187647.0, 2.075904, 522.577418, 86793.0, 0.71001, 419.48464, 72063.0, 0.21466, 536.80451, 65517.0, 5.97996, 316.39187, 30135.0, 2.16132, 949.17561, 29135.0, 1.67759, 103.09277, 23947.0, 0.27458, 7.11355, 23453.0, 3.54023, 735.87651, 22284.0, 4.19363, 1589.0729, 13033.0, 2.96043, 1162.4747, 12749.0, 2.7155, 1052.26838, 9703.0, 1.9067, 206.1855, 9161.0, 4.4135, 213.2991, 7895.0, 2.4791, 426.5982, 7058.0, 2.1818, 1265.5675, 6138.0, 6.2642, 846.0828, 5477.0, 5.6573, 639.8973, 4170.0, 2.0161, 515.4639, 4137.0, 2.7222, 625.6702, 3503.0, 0.5653, 1066.4955, 2617.0, 2.0099, 1581.9593, 2500.0, 4.5518, 838.9693, 2128.0, 6.1275, 742.9901, 1912.0, 0.8562, 412.3711, 1611.0, 3.0887, 1368.6603, 1479.0, 2.6803, 1478.8666, 1231.0, 1.8904, 323.5054, 1217.0, 1.8017, 110.2063, 1015.0, 1.3867, 454.9094, 999.0, 2.872, 309.278, 961.0, 4.549, 2118.764, 886.0, 4.148, 533.623, 821.0, 1.593, 1898.351, 812.0, 5.941, 909.819, 777.0, 3.677, 728.763, 727.0, 3.988, 1155.361, 655.0, 2.791, 1685.052, 654.0, 3.382, 1692.166, 621.0, 4.823, 956.289, 615.0, 2.276, 942.062, 562.0, 0.081, 543.918, 542.0, 0.284, 525.759, 496.0, 5.53, 380.128, 470.0, 2.819, 1795.258, 458.0, 0.127, 1375.774, 445.0, 0.146, 14.227, 436.0, 2.603, 95.979, 346.0, 1.564, 491.558, 338.0, 2.799, 1045.155, 319.0, 1.348, 2214.743, 309.0, 5.369, 1272.681, 303.0, 1.154, 5753.385, 294.0, 2.049, 199.072, 291.0, 6.031, 1169.588, 291.0, 3.893, 1471.753, 277.0, 2.522, 2001.444, 275.0, 2.989, 526.51, 257.0, 6.134, 532.872, 239.0, 3.574, 835.037, 215.0, 2.636, 2111.65, 201.0, 2.373, 1258.454, 197.0, 5.929, 453.425, 192.0, 0.92, 1596.186, 191.0, 6.283, 983.116, 177.0, 2.577, 9683.595, 139.0, 3.64, 1788.145, 129.0, 1.106, 2531.135, 128.0, 4.666, 831.856, 124.0, 2.262, 2317.836, 120.0, 2.952, 3.932, 113.0, 4.862, 528.206, 112.0, 0.856, 433.712, 106.0, 5.815, 220.413, 104.0, 2.222, 74.782, 99.0, 4.5, 518.65, 94.0, 2.73, 853.2, 86.0, 2.11, 1574.85, 86.0, 2.34, 2428.04, 82.0, 3.23, 1361.55, 80.0, 0.89, 430.53, 77.0, 2.1, 508.35, 70.0, 3.22, 305.35, 70.0, 3.04, 302.16, 70.0, 0.2, 532.14, 68.0, 3.36, 2104.54, 64.0, 1.1, 1364.73, 60.0, 0.96, 494.27, 58.0, 5.72, 628.85, 58.0, 3.46, 2008.56, 57.0, 2.0, 2634.23, 57.0, 3.92, 2221.86, 54.0, 0.87, 2847.53, 53.0, 1.2, 760.26, 52.0, 4.02, 527.24, 49.0, 5.6, 2810.92, 46.0, 2.54, 636.72, 45.0, 4.9, 2648.45, 45.0, 1.62, 984.6, 44.0, 4.43, 1063.31, 44.0, 1.25, 621.74, 43.0, 0.03, 1439.51, 42.0, 0.32, 529.64, 42.0, 3.52, 529.74, 40.0, 2.1, 2744.43, 40.0, 4.39, 1148.25, 40.0, 2.46, 355.75, 39.0, 4.71, 569.05, 39.0, 4.32, 149.56, 38.0, 2.93, 1677.94, 37.0, 5.08, 1905.46, 37.0, 0.84, 530.65, 34.0, 3.09, 2420.93, 34.0, 0.76, 643.83, 33.0, 3.19, 528.73, 32.0, 2.73, 604.47, 32.0, 6.19, 3.18, 31.0, 5.36, 1485.98, 29.0, 1.84, 1891.24, 28.0, 2.48, 519.4, 27.0, 3.92, 2324.95, 27.0, 1.75, 2950.62, 27.0, 1.04, 405.26, 26.0, 0.6, 1055.45, 26.0, 1.34, 330.62, 26.0, 0.52, 511.53, 26.0, 3.46, 458.84, 24.0, 0.88, 423.42, 24.0, 5.0, 1289.95, 23.0, 5.27, 672.14, 23.0, 0.65, 3163.92, 22.0, 0.43, 1073.61, 22.0, 5.92, 1802.37, 22.0, 1.42, 540.74, 21.0, 3.08, 629.6, 20.0, 2.73, 39.36, 20.0, 4.14, 1464.64, 19.0, 1.86, 3060.83, 19.0, 5.17, 635.97, 19.0, 3.66, 415.55, 19.0, 3.69, 88.87, 19.0, 1.97, 38.13, 18.0, 1.9, 1021.25, 18.0, 3.6, 746.92, 18.0, 2.67, 1994.33, 17.0, 2.82, 2737.32, 17.0, 1.91, 217.23, 17.0, 5.67, 408.44, 16.0, 0.18, 1699.28, 16.0, 3.35, 1056.2, 16.0, 3.82, 721.65, 15.0, 1.06, 114.14, 15.0, 1.32, 117.32, 15.0, 3.74, 2641.34, 15.0, 1.33, 490.33, 15.0, 4.65, 6283.08, 15.0, 1.67, 529.17, 15.0, 0.8, 5223.69, 15.0, 2.17, 530.21, 14.0, 3.54, 142.45, 13.0, 1.49, 3267.01, 13.0, 3.97, 2538.25, 13.0, 0.74, 908.33, 12.0, 0.21, 1062.56, 12.0, 3.67, 750.1, 12.0, 1.72, 911.3, 12.0, 2.97, 505.31, 12.0, 1.67, 2207.63, 12.0, 5.12, 685.47, 12.0, 5.23, 524.06, 12.0, 1.6, 1474.67, 1271802.0, 2.6493751, 529.6909651, 61662.0, 3.00076, 1059.38193, 53444.0, 3.89718, 522.57742, 41390.0, 0.0, 0.0, 31185.0, 4.88277, 536.80451, 11847.0, 2.4133, 419.48464, 9166.0, 4.7598, 7.1135, 3404.0, 3.3469, 1589.0729, 3203.0, 5.2108, 735.8765, 3176.0, 2.793, 103.0928, 2806.0, 3.7422, 515.4639, 2677.0, 4.3305, 1052.2684, 2600.0, 3.6344, 206.1855, 2412.0, 1.4695, 426.5982, 2101.0, 3.9276, 639.8973, 1646.0, 5.3095, 1066.4955, 1641.0, 4.4163, 625.6702, 1050.0, 3.1611, 213.2991, 1025.0, 2.5543, 412.3711, 806.0, 2.678, 632.784, 741.0, 2.171, 1162.475, 677.0, 6.25, 838.969, 567.0, 4.577, 742.99, 485.0, 2.469, 949.176, 469.0, 4.71, 543.918, 445.0, 0.403, 323.505, 416.0, 5.368, 728.763, 402.0, 4.605, 309.278, 347.0, 4.681, 14.227, 338.0, 3.168, 956.289, 261.0, 5.343, 846.083, 247.0, 3.923, 942.062, 220.0, 4.842, 1368.66, 203.0, 5.6, 1155.361, 200.0, 4.439, 1045.155, 197.0, 3.706, 2118.764, 196.0, 3.759, 199.072, 184.0, 4.265, 95.979, 180.0, 4.402, 532.872, 170.0, 4.846, 526.51, 146.0, 6.13, 533.623, 133.0, 1.322, 110.206, 132.0, 4.512, 525.759, 124.0, 2.043, 1478.867, 122.0, 4.406, 1169.588, 115.0, 4.467, 1581.959, 111.0, 3.625, 1272.681, 100.0, 5.247, 1265.567, 99.0, 5.73, 1596.19, 92.0, 4.53, 1685.05, 86.0, 0.08, 831.86, 82.0, 3.81, 508.35, 81.0, 4.11, 1258.45, 80.0, 2.72, 1692.17, 78.0, 5.57, 1471.75, 56.0, 4.75, 302.16, 55.0, 0.35, 316.39, 52.0, 5.53, 433.71, 51.0, 4.86, 1375.77, 49.0, 4.01, 220.41, 44.0, 4.94, 1361.55, 42.0, 1.22, 853.2, 38.0, 5.33, 1788.14, 38.0, 4.27, 2001.44, 36.0, 3.85, 1574.85, 36.0, 1.76, 1795.26, 29.0, 5.17, 3.93, 27.0, 6.1, 1148.25, 25.0, 4.34, 519.4, 25.0, 2.73, 405.26, 23.0, 0.19, 380.13, 20.0, 4.33, 3.18, 20.0, 4.63, 1677.94, 20.0, 5.11, 1073.61, 19.0, 5.05, 2104.54, 18.0, 6.03, 330.62, 18.0, 3.77, 1485.98, 17.0, 4.02, 2317.84, 17.0, 5.43, 88.87, 16.0, 2.93, 1905.46, 15.0, 2.93, 2008.56, 15.0, 5.51, 721.65, 14.0, 3.63, 628.85, 14.0, 2.74, 2221.86, 14.0, 4.88, 629.6, 13.0, 1.39, 518.65, 13.0, 5.84, 1464.64, 12.0, 1.59, 2111.65, 12.0, 3.38, 635.97, 12.0, 4.08, 2648.45, 11.0, 2.58, 511.53, 11.0, 3.55, 1891.24, 11.0, 4.63, 636.72, 10.0, 0.5, 453.42, 10.0, 2.76, 423.42, 10.0, 4.39, 1994.33, 9.0, 4.33, 1802.37, 9.0, 4.79, 2420.93, 9.0, 4.81, 1062.56, 9.0, 1.86, 750.1, 9.0, 5.16, 1056.2, 9.0, 4.54, 21.34, 8.0, 3.73, 2634.23, 8.0, 1.29, 2428.04, 7.0, 3.02, 416.3, 7.0, 4.98, 1699.28, 7.0, 4.98, 1898.35, 7.0, 4.99, 1055.45, 7.0, 5.97, 540.74, 7.0, 2.91, 2324.95, 7.0, 5.55, 1781.03, 7.0, 4.57, 1038.04, 6.0, 1.39, 422.67, 6.0, 6.14, 2125.88, 6.0, 4.46, 551.03, 6.0, 3.87, 191.96, 6.0, 3.66, 621.74, 6.0, 2.58, 569.05, 6.0, 4.23, 539.99, 5.0, 5.63, 618.56, 5.0, 4.91, 835.04, 5.0, 0.18, 117.32, 5.0, 6.22, 963.4, 5.0, 0.07, 1063.31, 5.0, 1.35, 1382.89, 5.0, 4.56, 2737.32, 5.0, 4.61, 643.83, 5.0, 3.35, 2207.63, 5.0, 4.24, 227.53, 5.0, 4.08, 2310.72, 4.0, 1.48, 408.44, 4.0, 0.19, 824.74, 4.0, 4.61, 647.01, 4.0, 2.38, 2538.25, 4.0, 1.13, 415.55, 4.0, 4.1, 430.53, 4.0, 1.15, 74.78, 4.0, 3.43, 2950.62, 4.0, 1.03, 2744.43, 4.0, 2.19, 534.36, 4.0, 4.12, 440.83, 4.0, 4.64, 2214.74, 4.0, 5.29, 2097.42, 4.0, 1.63, 525.03, 79645.0, 1.35866, 529.69097, 8252.0, 5.7777, 522.5774, 7030.0, 3.2748, 536.8045, 5314.0, 1.8384, 1059.3819, 1861.0, 2.9768, 7.1135, 964.0, 5.48, 515.464, 836.0, 4.199, 419.485, 498.0, 3.142, 0.0, 427.0, 2.228, 639.897, 406.0, 3.783, 1066.495, 377.0, 2.242, 1589.073, 363.0, 5.368, 206.186, 342.0, 6.099, 1052.268, 339.0, 6.127, 625.67, 333.0, 0.003, 426.598, 280.0, 4.262, 412.371, 257.0, 0.963, 632.784, 230.0, 0.705, 735.877, 201.0, 3.069, 543.918, 200.0, 4.429, 103.093, 139.0, 2.932, 14.227, 114.0, 0.787, 728.763, 95.0, 1.7, 838.97, 86.0, 5.14, 323.51, 83.0, 0.06, 309.28, 80.0, 2.98, 742.99, 75.0, 1.6, 956.29, 70.0, 1.51, 213.3, 67.0, 5.47, 199.07, 62.0, 6.1, 1045.15, 56.0, 0.96, 1162.47, 52.0, 5.58, 942.06, 50.0, 2.72, 532.87, 45.0, 5.52, 508.35, 44.0, 0.27, 526.51, 40.0, 5.95, 95.98, 30.0, 0.94, 1155.36, 29.0, 1.79, 831.86, 28.0, 2.88, 525.76, 27.0, 2.65, 2118.76, 27.0, 2.81, 1169.59, 26.0, 4.27, 1596.19, 23.0, 0.18, 302.16, 22.0, 1.89, 1272.68, 21.0, 4.35, 316.39, 21.0, 0.54, 1265.57, 20.0, 0.04, 949.18, 20.0, 1.16, 533.62, 20.0, 0.06, 1581.96, 18.0, 4.15, 846.08, 17.0, 5.89, 1258.45, 17.0, 0.53, 1368.66, 13.0, 0.79, 110.21, 13.0, 3.9, 433.71, 12.0, 2.23, 220.41, 12.0, 0.41, 1361.55, 12.0, 4.44, 405.26, 10.0, 1.0, 1471.75, 10.0, 6.01, 853.2, 9.0, 1.51, 1148.25, 9.0, 1.6, 1692.17, 9.0, 6.27, 519.4, 9.0, 3.52, 1073.61, 8.0, 5.6, 1574.85, 8.0, 0.18, 1685.05, 8.0, 0.65, 1478.87, 7.0, 0.88, 88.87, 7.0, 0.89, 721.65, 7.0, 4.44, 330.62, 6.0, 2.5, 3.18, 5.0, 0.85, 1788.14, 5.0, 2.79, 21.34, 5.0, 2.98, 1375.77, 5.0, 0.05, 1677.94, 5.0, 0.86, 3.93, 5.0, 2.28, 1485.98, 4.0, 1.28, 1464.64, 4.0, 0.41, 629.6, 4.0, 1.61, 635.97, 4.0, 2.71, 551.03, 3.0, 2.45, 539.99, 3.0, 0.55, 1795.26, 3.0, 1.19, 1905.46, 3.0, 6.19, 1038.04, 3.0, 5.55, 191.96, 3.0, 6.23, 2001.44, 3.0, 4.82, 416.3, 3.0, 0.55, 2104.54, 3.0, 3.24, 1062.56, 3.0, 0.03, 1898.35, 3.0, 1.24, 2221.86, 3.0, 2.4, 227.53, 2.0, 0.07, 750.1, 2.0, 4.28, 963.4, 2.0, 1.95, 824.74, 2.0, 6.19, 1994.33, 2.0, 1.72, 628.85, 2.0, 5.33, 1891.24, 2.0, 1.05, 1781.03, 2.0, 3.33, 1699.28, 2.0, 4.62, 423.42, 2.0, 0.29, 636.72, 2.0, 0.29, 2111.65, 2.0, 0.32, 295.05, 2.0, 3.44, 647.01, 2.0, 2.79, 1802.37, 2.0, 3.14, 611.44, 2.0, 1.12, 618.56, 2.0, 4.72, 2125.88, 2.0, 1.6, 2008.56, 2.0, 3.01, 2648.45, 2.0, 2.32, 440.83, 2.0, 5.89, 2317.84, 2.0, 2.42, 10.29, 2.0, 0.37, 1056.2, 2.0, 3.52, 1055.45, 2.0, 5.83, 422.67, 2.0, 5.76, 117.32, 1.0, 0.08, 1382.89, 1.0, 0.18, 2420.93, 1.0, 1.2, 1063.31, 1.0, 0.76, 2097.42, 1.0, 5.99, 2310.72, 1.0, 1.59, 380.13, 1.0, 4.2, 547.85, 1.0, 4.23, 934.95, 1.0, 3.86, 1603.3, 1.0, 1.35, 732.7, 1.0, 1.55, 2324.95, 1.0, 5.6, 99.91, 1.0, 6.18, 945.99, 1.0, 1.03, 81.75, 1.0, 0.09, 2737.32, 1.0, 2.54, 6283.08, 1.0, 1.15, 952.36, 1.0, 5.22, 2207.63, 1.0, 6.01, 511.53, 1.0, 3.03, 3046.6, 1.0, 2.71, 3370.1, 1.0, 6.01, 2214.74, 1.0, 5.0, 319.57, 1.0, 3.91, 10213.29, 1.0, 2.52, 3679.38, 1.0, 4.69, 5746.27, 1.0, 2.39, 3267.01, 1.0, 0.77, 5760.5, 1.0, 6.12, 9676.48, 1.0, 3.99, 337.73, 1.0, 2.19, 9690.71, 1.0, 1.12, 739.81, 1.0, 5.93, 2634.23, 1.0, 1.15, 2641.34, 1.0, 0.73, 1354.43, 1.0, 0.65, 2538.25, 1.0, 4.84, 860.31, 1.0, 4.23, 9683.59, 1.0, 1.2, 124.43, 1.0, 5.44, 107.02, 1.0, 0.9, 106.27, 1.0, 2.22, 2015.67, 1.0, 6.0, 501.24, 1.0, 5.12, 3156.81, 1.0, 1.24, 3803.82, 1.0, 2.43, 739.06, 1.0, 2.98, 1262.39, 1.0, 6.0, 1049.09, 1.0, 1.85, 453.42, 1.0, 6.19, 1987.22, 1.0, 5.33, 2751.55, 1.0, 4.92, 447.8, 1.0, 1.0, 462.02, 1.0, 4.77, 3473.2, 1.0, 5.61, 2524.02, 1.0, 5.82, 2627.11, 1.0, 2.43, 3686.5, 1.0, 3.89, 2516.91, 1.0, 3.55, 3178.15, 1.0, 3.29, 4.67, 1.0, 5.36, 9.56, 3519.0, 6.058, 529.691, 1073.0, 1.6732, 536.8045, 916.0, 1.413, 522.577, 342.0, 0.523, 1059.382, 255.0, 1.196, 7.114, 222.0, 0.952, 515.464, 90.0, 3.14, 0.0, 69.0, 2.27, 1066.5, 58.0, 1.41, 543.92, 58.0, 0.53, 639.9, 51.0, 5.98, 412.37, 47.0, 1.58, 625.67, 43.0, 6.12, 419.48, 37.0, 1.18, 14.23, 34.0, 1.67, 1052.27, 34.0, 0.85, 206.19, 31.0, 1.04, 1589.07, 30.0, 4.63, 426.6, 21.0, 2.5, 728.76, 15.0, 0.89, 199.07, 14.0, 0.96, 508.35, 13.0, 1.5, 1045.15, 12.0, 2.61, 735.88, 12.0, 3.56, 323.51, 11.0, 1.79, 309.28, 11.0, 6.28, 956.29, 10.0, 6.26, 103.09, 9.0, 3.45, 838.97, 7.0, 1.28, 742.99, 7.0, 0.92, 942.06, 7.0, 3.45, 831.86, 7.0, 1.87, 302.16, 6.0, 1.38, 95.98, 5.0, 2.83, 1596.19, 4.0, 1.21, 1169.59, 4.0, 5.99, 213.3, 4.0, 6.11, 405.26, 3.0, 2.33, 1155.36, 2.0, 0.35, 1272.68, 2.0, 1.87, 532.87, 2.0, 0.43, 220.41, 2.0, 5.97, 1162.47, 2.0, 1.95, 1073.61, 2.0, 0.09, 632.78, 2.0, 1.59, 2118.76, 2.0, 1.51, 1258.45, 2.0, 1.07, 21.34, 2.0, 2.16, 433.71, 2.0, 5.94, 110.21, 2.0, 3.17, 1148.25, 2.0, 2.55, 88.87, 2.0, 2.7, 721.65, 2.0, 2.26, 1361.55, 2.0, 1.98, 525.76, 2.0, 2.71, 330.62, 2.0, 0.44, 533.62, 2.0, 4.46, 853.2, 2.0, 0.47, 526.51, 2.0, 0.12, 949.18, 1.0, 0.67, 551.03, 1.0, 1.17, 1038.04, 1.0, 3.02, 963.4, 1.0, 1.16, 1574.85, 1.0, 2.55, 846.08, 1.0, 1.79, 1581.96, 1.0, 1.07, 227.53, 1.0, 2.7, 519.4, 1.0, 4.17, 2627.11, 1.0, 3.69, 824.74, 1.0, 4.91, 1670.83, 1.0, 2.93, 1368.66, 1.0, 0.6, 539.99, 1.0, 4.52, 750.1, 1.0, 0.94, 191.96, 1.0, 4.87, 611.44, 1.0, 0.21, 1141.13, 1.0, 3.23, 2125.88, 1.0, 2.39, 2317.84, 1.0, 2.25, 2538.25, 1.0, 5.8, 1485.98, 1.0, 2.27, 1699.28, 1.0, 0.67, 440.83, 1.0, 2.48, 1265.57, 1.0, 5.51, 2413.82, 1.0, 4.41, 1382.89, 1.0, 6.14, 1279.79, 1.0, 1.93, 2634.23, 1.0, 2.18, 1062.56, 1.0, 1.96, 1677.94, 1.0, 2.32, 1471.75, 1.0, 2.05, 295.05, 1.0, 2.5, 2207.63, 1.0, 0.19, 10.29, 129.0, 0.084, 536.805, 113.0, 4.249, 529.691, 83.0, 3.3, 522.58, 38.0, 2.73, 515.46, 27.0, 5.69, 7.11, 18.0, 5.4, 1059.38, 13.0, 6.02, 543.92, 9.0, 0.77, 1066.5, 8.0, 5.68, 14.23, 7.0, 1.43, 412.37, 6.0, 5.12, 639.9, 5.0, 3.34, 625.67, 3.0, 3.4, 1052.27, 3.0, 4.16, 728.76, 3.0, 2.9, 426.6, 2.0, 6.22, 1589.07, 2.0, 3.12, 1045.15, 2.0, 1.89, 419.48, 2.0, 2.6, 199.07, 2.0, 0.0, 0.0, 2.0, 2.81, 206.19, 2.0, 1.33, 1596.19, 1.0, 5.16, 831.86, 1.0, 4.42, 956.29, 1.0, 5.47, 220.41, 1.0, 0.67, 1361.55, 1.0, 1.87, 1148.25, 1.0, 3.17, 508.35, 1.0, 5.79, 1169.59, 1.0, 1.48, 1272.68, 1.0, 2.42, 117.32, 1.0, 2.2, 942.06, 1.0, 5.31, 551.03, 1.0, 0.5, 1073.61, 1.0, 2.85, 191.96, 1.0, 3.72, 88.87, 1.0, 3.53, 302.16, 1.0, 1.84, 10.29, 1.0, 1.59, 3.18, 1.0, 3.82, 618.56, 1.0, 0.86, 330.62, 1.0, 5.26, 21.34, 1.0, 1.83, 647.01, 1.0, 0.24, 433.71, 1.0, 4.44, 110.21, 11.0, 4.75, 536.8, 4.0, 5.92, 522.58, 2.0, 5.57, 515.46, 2.0, 4.3, 543.92, 2.0, 3.69, 7.11, 2.0, 4.13, 1059.38, 2.0, 5.49, 1066.5, 1.0, 3.78, 14.23, 1.0, 4.51, 529.69};
        return XL0;
    }

    /*
     * Opcode count of 26150 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static double[] getXL0_6() {
        double[] XL0 = new double[]{1.0E8, 20.0, 806.0, 1406.0, 1946.0, 2177.0, 2282.0, 2333.0, 2537.0, 2726.0, 2867.0, 2963.0, 3008.0, 3026.0, 4091.0, 5063.0, 5789.0, 6260.0, 6452.0, 6536.0, 8.7401354E7, 0.0, 0.0, 1.110766E7, 3.9620509, 213.29909544, 1414151.0, 4.5858152, 7.113547, 398379.0, 0.52112, 206.185548, 350769.0, 3.303299, 426.598191, 206816.0, 0.246584, 103.092774, 79271.0, 3.84007, 220.41264, 23990.0, 4.66977, 110.20632, 16574.0, 0.43719, 419.48464, 15820.0, 0.93809, 632.78374, 15054.0, 2.7167, 639.89729, 14907.0, 5.76903, 316.39187, 14610.0, 1.56519, 3.93215, 13160.0, 4.44891, 14.22709, 13005.0, 5.98119, 11.0457, 10725.0, 3.1294, 202.2534, 6126.0, 1.7633, 277.035, 5863.0, 0.2366, 529.691, 5228.0, 4.2078, 3.1814, 5020.0, 3.1779, 433.7117, 4593.0, 0.6198, 199.072, 4006.0, 2.2448, 63.7359, 3874.0, 3.2228, 138.5175, 3269.0, 0.7749, 949.1756, 2954.0, 0.9828, 95.9792, 2461.0, 2.0316, 735.8765, 1758.0, 3.2658, 522.5774, 1640.0, 5.505, 846.0828, 1581.0, 4.3727, 309.2783, 1391.0, 4.0233, 323.5054, 1124.0, 2.8373, 415.5525, 1087.0, 4.1834, 2.4477, 1017.0, 3.717, 227.5262, 957.0, 0.507, 1265.567, 853.0, 3.421, 175.166, 849.0, 3.191, 209.367, 789.0, 5.007, 0.963, 749.0, 2.144, 853.196, 744.0, 5.253, 224.345, 687.0, 1.747, 1052.268, 654.0, 1.599, 0.048, 634.0, 2.299, 412.371, 625.0, 0.97, 210.118, 580.0, 3.093, 74.782, 546.0, 2.127, 350.332, 543.0, 1.518, 9.561, 530.0, 4.449, 117.32, 478.0, 2.965, 137.033, 474.0, 5.475, 742.99, 452.0, 1.044, 490.334, 449.0, 1.29, 127.472, 372.0, 2.278, 217.231, 355.0, 3.013, 838.969, 347.0, 1.539, 340.771, 343.0, 0.246, 0.521, 330.0, 0.247, 1581.959, 322.0, 0.961, 203.738, 322.0, 2.572, 647.011, 309.0, 3.495, 216.48, 287.0, 2.37, 351.817, 278.0, 0.4, 211.815, 249.0, 1.47, 1368.66, 227.0, 4.91, 12.53, 220.0, 4.204, 200.769, 209.0, 1.345, 625.67, 208.0, 0.483, 1162.475, 208.0, 1.283, 39.357, 205.0, 6.011, 265.989, 185.0, 3.503, 149.563, 184.0, 0.973, 4.193, 182.0, 5.491, 2.921, 174.0, 1.863, 0.751, 165.0, 0.44, 5.417, 149.0, 5.736, 52.69, 148.0, 1.535, 5.629, 146.0, 6.231, 195.14, 140.0, 4.295, 21.341, 131.0, 4.068, 10.295, 125.0, 6.277, 1898.351, 122.0, 1.976, 4.666, 118.0, 5.341, 554.07, 117.0, 2.679, 1155.361, 114.0, 5.594, 1059.382, 112.0, 1.105, 191.208, 110.0, 0.166, 1.484, 109.0, 3.438, 536.805, 107.0, 4.012, 956.289, 104.0, 2.192, 88.866, 103.0, 1.197, 1685.052, 101.0, 4.965, 269.921, 97.0, 4.54, 302.16, 96.0, 2.83, 275.55, 91.0, 1.88, 38.13, 90.0, 5.8, 114.14, 89.0, 3.86, 278.52, 84.0, 5.49, 0.11, 83.0, 2.29, 628.85, 82.0, 3.05, 440.83, 79.0, 4.45, 35.42, 76.0, 1.61, 284.15, 75.0, 2.18, 728.76, 74.0, 5.09, 1375.77, 72.0, 5.11, 65.22, 70.0, 4.87, 0.21, 70.0, 3.71, 14.98, 69.0, 3.44, 515.46, 68.0, 0.73, 1478.87, 67.0, 0.03, 70.85, 66.0, 2.02, 142.45, 64.0, 3.32, 62.25, 63.0, 3.49, 479.29, 63.0, 2.59, 422.67, 61.0, 1.5, 210.85, 61.0, 2.69, 388.47, 55.0, 0.97, 942.06, 54.0, 2.46, 22.09, 54.0, 0.78, 191.96, 53.0, 3.18, 8.08, 53.0, 5.51, 0.26, 51.0, 4.27, 99.16, 50.0, 6.03, 2214.74, 49.0, 2.39, 1471.75, 47.0, 2.03, 312.2, 47.0, 4.6, 437.64, 46.0, 0.54, 212.34, 45.0, 0.93, 2001.44, 45.0, 1.12, 6.15, 44.0, 3.93, 525.5, 43.0, 2.53, 288.08, 43.0, 1.37, 563.63, 43.0, 3.82, 330.62, 42.0, 1.9, 430.53, 40.0, 5.71, 408.44, 40.0, 1.63, 1066.5, 38.0, 0.31, 423.42, 38.0, 1.2, 2.71, 38.0, 3.7, 1272.68, 38.0, 4.52, 24.38, 36.0, 6.01, 18.16, 36.0, 0.85, 213.35, 36.0, 3.93, 213.25, 35.0, 4.19, 215.75, 35.0, 4.46, 214.26, 35.0, 1.02, 203.0, 33.0, 0.54, 107.02, 33.0, 0.66, 692.59, 33.0, 0.81, 1795.26, 32.0, 5.22, 92.05, 32.0, 5.59, 6069.78, 32.0, 1.69, 0.16, 32.0, 5.5, 56.62, 31.0, 0.37, 703.63, 31.0, 6.14, 417.04, 30.0, 0.72, 222.86, 30.0, 5.3, 33.94, 29.0, 0.15, 131.4, 29.0, 1.2, 404.51, 28.0, 5.64, 128.96, 28.0, 1.46, 7.16, 27.0, 6.23, 1.27, 27.0, 1.9, 1045.15, 27.0, 0.07, 205.22, 27.0, 4.57, 7.07, 26.0, 5.41, 140.0, 26.0, 4.36, 32.24, 24.0, 3.09, 145.63, 24.0, 3.94, 414.07, 24.0, 2.54, 76.27, 23.0, 3.97, 483.22, 23.0, 2.1, 1788.14, 23.0, 3.2, 208.63, 23.0, 3.66, 207.67, 23.0, 6.1, 177.87, 23.0, 5.24, 212.78, 22.0, 5.92, 173.94, 21.0, 0.72, 1258.45, 21.0, 5.79, 2531.13, 21.0, 2.02, 860.31, 21.0, 0.67, 2317.84, 21.0, 5.22, 6.59, 20.0, 2.82, 429.78, 20.0, 5.07, 617.81, 19.0, 1.64, 565.12, 19.0, 5.94, 425.11, 19.0, 5.78, 213.82, 18.0, 0.73, 9999.99, 18.0, 5.23, 73.3, 18.0, 6.11, 210.38, 18.0, 3.14, 831.86, 17.0, 0.24, 134.59, 17.0, 0.72, 2111.65, 17.0, 3.28, 98.9, 16.0, 3.97, 355.75, 16.0, 3.1, 106.27, 15.0, 3.29, 1589.07, 15.0, 3.25, 78.71, 15.0, 5.19, 305.35, 15.0, 2.75, 1.22, 14.0, 3.88, 54.17, 14.0, 4.52, 59.8, 14.0, 1.72, 69.15, 14.0, 6.18, 245.54, 14.0, 2.37, 125.99, 14.0, 2.55, 405.26, 14.0, 2.54, 1.7, 14.0, 3.59, 234.64, 13.0, 0.83, 99.91, 13.0, 4.17, 225.83, 13.0, 6.01, 214.78, 13.0, 4.69, 767.37, 13.0, 5.31, 344.7, 12.0, 2.12, 28.31, 12.0, 3.6, 124.43, 12.0, 1.62, 1361.55, 12.0, 4.07, 280.97, 12.0, 4.0, 267.47, 12.0, 0.12, 7.63, 12.0, 2.79, 362.86, 11.0, 5.51, 192.69, 11.0, 1.82, 2104.54, 11.0, 2.62, 7.86, 11.0, 2.61, 339.29, 11.0, 5.51, 199.28, 11.0, 3.58, 1.44, 11.0, 0.19, 217.49, 11.0, 2.37, 831.1, 10.0, 2.84, 85.83, 10.0, 1.69, 31.02, 10.0, 4.72, 216.22, 10.0, 0.22, 198.32, 10.0, 0.22, 144.15, 10.0, 3.61, 14.01, 10.0, 3.94, 207.88, 10.0, 4.02, 207.15, 10.0, 0.42, 2634.23, 10.0, 1.61, 0.89, 10.0, 3.67, 212.55, 10.0, 3.34, 223.59, 10.0, 0.64, 218.93, 9.0, 0.72, 347.88, 9.0, 4.26, 20.61, 9.0, 5.4, 342.26, 9.0, 4.28, 312.46, 9.0, 5.08, 241.61, 9.0, 4.25, 46.47, 9.0, 1.65, 210.33, 9.0, 0.91, 497.45, 9.0, 5.81, 329.73, 9.0, 4.23, 6.36, 9.0, 0.57, 2428.04, 9.0, 5.36, 343.22, 9.0, 5.55, 2847.53, 9.0, 4.48, 1692.17, 9.0, 0.49, 1574.85, 8.0, 4.06, 237.68, 8.0, 0.81, 264.5, 8.0, 4.71, 333.66, 8.0, 2.73, 4.14, 8.0, 3.82, 380.13, 8.0, 5.54, 116.43, 8.0, 5.63, 518.65, 8.0, 5.44, 621.74, 2.1354295596E10, 0.0, 0.0, 1296855.0, 1.8282054, 213.2990954, 564348.0, 2.885001, 7.113547, 107679.0, 2.277699, 206.185548, 98323.0, 1.0807, 426.59819, 40255.0, 2.04128, 220.41264, 19942.0, 1.27955, 103.09277, 10512.0, 2.7488, 14.22709, 6939.0, 0.4049, 639.8973, 4803.0, 2.4419, 419.4846, 4056.0, 2.9217, 110.2063, 3769.0, 3.6497, 3.9322, 3385.0, 2.4169, 3.1814, 3302.0, 1.2626, 433.7117, 3071.0, 2.3274, 199.072, 1953.0, 3.5639, 11.0457, 1249.0, 2.628, 95.9792, 922.0, 1.961, 227.526, 706.0, 4.417, 529.691, 650.0, 6.174, 202.253, 628.0, 6.111, 309.278, 487.0, 6.04, 853.196, 479.0, 4.988, 522.577, 468.0, 4.617, 63.736, 417.0, 2.117, 323.505, 408.0, 1.299, 209.367, 352.0, 2.317, 632.784, 344.0, 3.959, 412.371, 340.0, 3.634, 316.392, 336.0, 3.772, 735.877, 332.0, 2.861, 210.118, 289.0, 2.733, 117.32, 281.0, 5.744, 2.448, 266.0, 0.543, 647.011, 230.0, 1.644, 216.48, 192.0, 2.965, 224.345, 173.0, 4.077, 846.083, 167.0, 2.597, 21.341, 136.0, 2.286, 10.295, 131.0, 3.441, 742.99, 128.0, 4.095, 217.231, 109.0, 6.161, 415.552, 98.0, 4.73, 838.97, 94.0, 3.48, 1052.27, 92.0, 3.95, 88.87, 87.0, 1.22, 440.83, 83.0, 3.11, 625.67, 78.0, 6.24, 302.16, 67.0, 0.29, 4.67, 66.0, 5.65, 9.56, 62.0, 4.29, 127.47, 62.0, 1.83, 195.14, 58.0, 2.48, 191.96, 57.0, 5.02, 137.03, 55.0, 0.28, 74.78, 54.0, 5.13, 490.33, 51.0, 1.46, 536.8, 47.0, 1.18, 149.56, 47.0, 5.15, 515.46, 46.0, 2.23, 956.29, 44.0, 2.71, 5.42, 40.0, 0.41, 269.92, 40.0, 3.89, 728.76, 38.0, 0.65, 422.67, 38.0, 2.53, 12.53, 37.0, 3.78, 2.92, 35.0, 6.08, 5.63, 34.0, 3.21, 1368.66, 33.0, 4.64, 277.03, 33.0, 5.43, 1066.5, 33.0, 0.3, 351.82, 32.0, 4.39, 1155.36, 31.0, 2.43, 52.69, 30.0, 2.84, 203.0, 30.0, 6.19, 284.15, 30.0, 3.39, 1059.38, 29.0, 2.03, 330.62, 28.0, 2.74, 265.99, 26.0, 4.51, 340.77, 23.0, 4.14, 191.21, 23.0, 5.89, 210.85, 22.0, 1.96, 203.74, 22.0, 5.14, 4.19, 22.0, 2.68, 942.06, 21.0, 6.16, 860.31, 20.0, 2.31, 437.64, 19.0, 4.77, 70.85, 19.0, 4.1, 18.16, 18.0, 0.9, 429.78, 18.0, 1.85, 234.64, 18.0, 2.45, 423.42, 17.0, 5.97, 628.85, 16.0, 4.06, 949.18, 16.0, 1.94, 1272.68, 16.0, 1.06, 56.62, 16.0, 5.59, 6.15, 15.0, 4.24, 1162.47, 15.0, 0.74, 200.77, 15.0, 5.77, 22.09, 15.0, 3.6, 1045.15, 14.0, 2.94, 1685.05, 14.0, 1.44, 408.44, 14.0, 4.1, 1471.75, 13.0, 6.25, 38.13, 13.0, 5.76, 138.52, 13.0, 4.25, 405.26, 12.0, 4.85, 831.86, 12.0, 1.86, 131.4, 12.0, 1.81, 124.43, 11.0, 1.55, 223.59, 11.0, 5.37, 215.75, 10.0, 3.47, 1375.77, 10.0, 6.08, 32.24, 10.0, 2.38, 107.02, 10.0, 3.95, 430.53, 10.0, 2.55, 99.91, 10.0, 1.39, 145.63, 9.0, 5.81, 7.16, 9.0, 3.65, 142.45, 9.0, 4.95, 208.63, 9.0, 1.24, 106.27, 9.0, 0.08, 288.08, 8.0, 4.42, 703.63, 8.0, 5.64, 62.25, 8.0, 2.42, 1258.45, 8.0, 6.22, 14.98, 8.0, 0.53, 654.12, 8.0, 3.75, 312.2, 7.0, 4.85, 222.86, 7.0, 0.28, 0.75, 7.0, 0.53, 388.47, 7.0, 2.05, 99.16, 7.0, 0.24, 8.08, 7.0, 5.83, 483.22, 7.0, 3.49, 35.42, 6.0, 2.89, 114.14, 6.0, 3.33, 1361.55, 6.0, 3.81, 1788.14, 6.0, 0.55, 65.22, 6.0, 1.63, 1589.07, 6.0, 2.68, 2001.44, 6.0, 0.89, 92.05, 6.0, 4.39, 81.75, 5.0, 5.48, 563.63, 5.0, 4.58, 134.59, 5.0, 2.12, 214.26, 5.0, 4.68, 212.34, 5.0, 3.34, 1.48, 5.0, 5.77, 565.12, 5.0, 2.2, 207.88, 5.0, 4.2, 404.51, 5.0, 0.42, 76.27, 5.0, 3.78, 1265.57, 5.0, 0.46, 362.86, 5.0, 4.53, 1148.25, 5.0, 4.59, 554.07, 5.0, 5.8, 217.96, 5.0, 3.25, 231.46, 5.0, 5.38, 497.45, 4.0, 0.11, 295.05, 4.0, 1.8, 213.25, 4.0, 5.0, 213.35, 4.0, 4.88, 98.9, 4.0, 0.59, 750.1, 4.0, 0.99, 24.38, 4.0, 0.82, 344.7, 4.0, 0.81, 343.22, 4.0, 5.13, 218.93, 4.0, 1.61, 245.54, 4.0, 0.35, 333.66, 3.0, 5.3, 350.33, 3.0, 1.85, 225.83, 3.0, 2.2, 1574.85, 3.0, 5.31, 347.88, 3.0, 0.21, 635.97, 3.0, 2.88, 216.22, 3.0, 1.72, 1169.59, 3.0, 1.92, 17.41, 3.0, 3.04, 1677.94, 3.0, 4.31, 6062.66, 3.0, 1.34, 543.92, 3.0, 0.25, 120.36, 3.0, 3.36, 7.86, 3.0, 2.53, 1692.17, 3.0, 2.49, 46.47, 3.0, 3.53, 2104.54, 3.0, 4.87, 144.15, 3.0, 5.73, 9992.87, 3.0, 3.73, 6076.89, 3.0, 0.24, 357.45, 3.0, 2.43, 2317.84, 3.0, 5.76, 618.56, 3.0, 5.15, 10007.1, 3.0, 0.72, 85.83, 3.0, 3.43, 31.02, 3.0, 3.8, 17.27, 3.0, 1.63, 182.28, 3.0, 0.92, 479.29, 3.0, 4.52, 198.32, 3.0, 2.11, 168.05, 116441.0, 1.179879, 7.113547, 91921.0, 0.07425, 213.2991, 90592.0, 0.0, 0.0, 15277.0, 4.06492, 206.18555, 10631.0, 0.25778, 220.41264, 10605.0, 5.40964, 426.59819, 4265.0, 1.046, 14.2271, 1216.0, 2.9186, 103.0928, 1165.0, 4.6094, 639.8973, 1082.0, 5.6913, 433.7117, 1045.0, 4.0421, 199.072, 1020.0, 0.6337, 3.1814, 634.0, 4.388, 419.485, 549.0, 5.573, 3.932, 457.0, 1.268, 110.206, 425.0, 0.209, 227.526, 274.0, 4.288, 95.979, 162.0, 1.381, 11.046, 129.0, 1.566, 309.278, 117.0, 3.881, 853.196, 105.0, 4.9, 647.011, 101.0, 0.893, 21.341, 96.0, 2.91, 316.39, 95.0, 5.63, 412.37, 85.0, 5.73, 209.37, 83.0, 6.05, 216.48, 82.0, 1.02, 117.32, 75.0, 4.76, 210.12, 67.0, 0.46, 522.58, 66.0, 0.48, 10.29, 64.0, 0.35, 323.51, 61.0, 4.88, 632.78, 53.0, 2.75, 529.69, 46.0, 5.69, 440.83, 45.0, 1.67, 202.25, 42.0, 5.71, 88.87, 32.0, 0.07, 63.74, 32.0, 1.67, 302.16, 31.0, 4.16, 191.96, 27.0, 0.83, 224.34, 25.0, 5.66, 735.88, 20.0, 5.94, 217.23, 18.0, 4.9, 625.67, 17.0, 1.63, 742.99, 16.0, 0.58, 515.46, 14.0, 0.21, 838.97, 14.0, 3.76, 195.14, 12.0, 4.72, 203.0, 12.0, 0.13, 234.64, 12.0, 3.12, 846.08, 11.0, 5.92, 536.8, 11.0, 5.6, 728.76, 11.0, 3.2, 1066.5, 10.0, 4.99, 422.67, 10.0, 0.26, 330.62, 10.0, 4.15, 860.31, 9.0, 0.46, 956.29, 8.0, 2.14, 269.92, 8.0, 5.25, 429.78, 8.0, 4.03, 9.56, 7.0, 5.4, 1052.27, 6.0, 4.46, 284.15, 6.0, 5.93, 405.26, 6.0, 5.41, 149.56, 6.0, 4.29, 415.55, 6.0, 0.02, 124.43, 6.0, 6.02, 223.59, 6.0, 0.3, 127.47, 5.0, 5.54, 949.18, 5.0, 3.2, 277.03, 5.0, 4.93, 654.12, 5.0, 2.27, 18.16, 5.0, 6.14, 1155.36, 5.0, 4.41, 942.06, 4.0, 2.89, 56.62, 4.0, 4.69, 74.78, 4.0, 5.31, 1045.15, 4.0, 0.29, 831.86, 4.0, 0.37, 12.53, 4.0, 6.1, 81.75, 4.0, 3.3, 490.33, 4.0, 4.93, 52.69, 4.0, 0.41, 137.03, 4.0, 0.15, 437.64, 4.0, 0.2, 1272.68, 3.0, 4.77, 423.42, 3.0, 4.29, 99.91, 3.0, 1.57, 1059.38, 3.0, 3.13, 70.85, 3.0, 0.33, 191.21, 3.0, 3.38, 408.44, 3.0, 1.88, 295.05, 3.0, 5.15, 1368.66, 3.0, 3.59, 131.4, 3.0, 5.12, 265.99, 2.0, 1.59, 32.24, 2.0, 3.9, 210.85, 2.0, 5.83, 106.27, 2.0, 4.77, 351.82, 2.0, 3.14, 22.09, 2.0, 5.98, 6062.66, 2.0, 2.06, 6076.89, 2.0, 5.95, 145.63, 2.0, 5.23, 1265.57, 2.0, 1.12, 9992.87, 2.0, 3.48, 10007.1, 2.0, 5.87, 1471.75, 2.0, 4.52, 138.52, 2.0, 4.15, 1258.45, 2.0, 5.05, 1361.55, 2.0, 4.14, 107.02, 2.0, 1.36, 231.46, 2.0, 6.24, 1148.25, 2.0, 3.75, 628.85, 2.0, 5.62, 447.94, 2.0, 5.97, 430.53, 1.0, 0.48, 340.77, 1.0, 0.85, 6069.78, 1.0, 2.91, 215.75, 1.0, 0.71, 28.45, 1.0, 2.28, 9999.99, 1.0, 5.84, 543.92, 1.0, 6.24, 1589.07, 1.0, 2.83, 200.77, 1.0, 3.52, 497.45, 1.0, 0.72, 508.35, 1.0, 2.61, 1279.79, 1.0, 4.96, 1685.05, 1.0, 1.2, 618.56, 1.0, 4.53, 635.97, 1.0, 1.09, 184.84, 1.0, 2.41, 703.63, 1.0, 3.4, 1073.61, 1.0, 4.91, 750.1, 1.0, 1.39, 483.22, 1.0, 1.59, 1375.77, 1.0, 2.66, 134.59, 1.0, 4.21, 288.08, 1.0, 4.68, 362.86, 1.0, 2.43, 222.86, 1.0, 4.52, 38.13, 1.0, 5.01, 1581.96, 1.0, 5.59, 1788.14, 1.0, 0.77, 113.39, 1.0, 4.8, 1677.94, 1.0, 2.22, 333.66, 1.0, 5.95, 1464.64, 1.0, 4.49, 643.08, 1.0, 5.82, 416.3, 1.0, 2.51, 343.22, 1.0, 3.97, 1574.85, 1.0, 4.84, 76.27, 1.0, 6.0, 337.73, 1.0, 2.28, 1162.47, 1.0, 2.35, 120.36, 1.0, 3.67, 347.88, 1.0, 0.01, 1169.59, 1.0, 0.21, 99.16, 1.0, 2.89, 92.05, 1.0, 5.63, 17.27, 1.0, 3.76, 203.74, 1.0, 5.75, 721.65, 1.0, 3.78, 217.96, 1.0, 0.68, 46.47, 1.0, 4.86, 357.45, 1.0, 5.27, 436.89, 1.0, 3.27, 208.63, 1.0, 3.88, 565.12, 1.0, 5.99, 1905.46, 1.0, 3.69, 350.33, 1.0, 4.96, 358.93, 1.0, 0.31, 98.9, 1.0, 1.22, 62.25, 1.0, 0.87, 1692.17, 1.0, 6.17, 182.28, 1.0, 2.59, 313.21, 1.0, 1.54, 195.89, 1.0, 5.42, 312.2, 1.0, 4.71, 2001.44, 1.0, 3.81, 168.05, 16039.0, 5.73945, 7.11355, 4250.0, 4.5854, 213.2991, 1907.0, 4.7608, 220.4126, 1466.0, 5.9133, 206.1855, 1162.0, 5.6197, 14.2271, 1067.0, 3.6082, 426.5982, 239.0, 3.861, 433.712, 237.0, 5.768, 199.072, 166.0, 5.116, 3.181, 151.0, 2.736, 639.897, 131.0, 4.743, 227.526, 63.0, 0.23, 419.48, 62.0, 4.74, 103.09, 40.0, 5.47, 21.34, 40.0, 5.96, 95.98, 39.0, 5.83, 110.21, 28.0, 3.01, 647.01, 25.0, 0.99, 3.93, 19.0, 1.92, 853.2, 18.0, 4.97, 10.29, 18.0, 1.03, 412.37, 18.0, 4.2, 216.48, 18.0, 3.32, 309.28, 16.0, 3.9, 440.83, 16.0, 5.62, 117.32, 13.0, 1.18, 88.87, 11.0, 5.58, 11.05, 11.0, 5.93, 191.96, 10.0, 3.95, 209.37, 9.0, 3.39, 302.16, 8.0, 4.88, 323.51, 7.0, 0.38, 632.78, 6.0, 2.25, 522.58, 6.0, 1.06, 210.12, 5.0, 4.64, 234.64, 4.0, 3.14, 0.0, 4.0, 2.31, 515.46, 3.0, 2.2, 860.31, 3.0, 0.59, 529.69, 3.0, 4.93, 224.34, 3.0, 0.42, 625.67, 2.0, 4.77, 330.62, 2.0, 3.35, 429.78, 2.0, 3.2, 202.25, 2.0, 1.19, 1066.5, 2.0, 1.35, 405.26, 2.0, 4.16, 223.59, 2.0, 3.07, 654.12, 2.0, 1.03, 728.76, 2.0, 4.4, 124.43, 2.0, 3.09, 422.67, 2.0, 4.15, 536.8, 2.0, 5.83, 195.14, 2.0, 6.04, 742.99, 1.0, 0.38, 316.39, 1.0, 1.58, 81.75, 1.0, 2.11, 838.97, 1.0, 1.38, 735.88, 1.0, 2.33, 217.23, 1.0, 5.02, 956.29, 1.0, 1.66, 63.74, 1.0, 3.88, 269.92, 1.0, 3.73, 295.05, 1.0, 2.76, 284.15, 1.0, 3.31, 18.16, 1.0, 2.02, 831.86, 1.0, 0.71, 846.08, 1.0, 3.84, 447.94, 1.0, 4.71, 56.62, 1.0, 0.8, 1045.15, 1.0, 2.41, 203.0, 1.0, 4.27, 437.64, 1.0, 1.65, 423.42, 1.0, 6.18, 942.06, 1.0, 2.86, 184.84, 1.0, 6.26, 1059.38, 1.0, 3.43, 149.56, 1662.0, 3.9983, 7.1135, 257.0, 2.984, 220.413, 236.0, 3.902, 14.227, 149.0, 2.741, 213.299, 114.0, 3.142, 0.0, 110.0, 1.515, 206.186, 68.0, 1.72, 426.6, 40.0, 2.05, 433.71, 38.0, 1.24, 199.07, 31.0, 3.01, 227.53, 15.0, 0.83, 639.9, 9.0, 3.71, 21.34, 6.0, 2.42, 419.48, 6.0, 1.16, 647.01, 4.0, 1.45, 95.98, 4.0, 2.12, 440.83, 3.0, 4.09, 110.21, 3.0, 2.77, 412.37, 3.0, 3.01, 88.87, 3.0, 0.0, 853.2, 3.0, 0.39, 103.09, 2.0, 3.78, 117.32, 2.0, 2.83, 234.64, 2.0, 5.08, 309.28, 2.0, 2.24, 216.48, 2.0, 5.19, 302.16, 1.0, 1.55, 191.96, 1.0, 3.45, 323.51, 1.0, 4.83, 210.12, 1.0, 2.29, 209.37, 1.0, 0.3, 860.31, 1.0, 2.38, 632.78, 1.0, 4.03, 522.58, 1.0, 4.19, 515.46, 1.0, 2.17, 124.43, 124.0, 2.259, 7.114, 34.0, 2.16, 14.23, 28.0, 1.2, 220.41, 6.0, 1.22, 227.53, 5.0, 0.24, 433.71, 4.0, 6.23, 426.6, 3.0, 2.97, 199.07, 3.0, 4.29, 206.19, 2.0, 6.25, 213.3, 1.0, 5.28, 639.9, 1.0, 0.24, 440.83, 1.0, 3.14, 0.0, 1.0, 5.57, 647.01, 1.0, 0.69, 302.16, 1.0, 6.18, 191.96, 1.0, 4.88, 88.87, 1.0, 4.78, 419.48, 4330678.0, 3.6028443, 213.2990954, 240348.0, 2.852385, 426.598191, 84746.0, 0.0, 0.0, 34116.0, 0.57297, 206.18555, 30863.0, 3.48442, 220.41264, 14734.0, 2.11847, 639.89729, 9917.0, 5.79, 419.4846, 6994.0, 4.736, 7.1135, 4808.0, 5.4331, 316.3919, 4788.0, 4.9651, 110.2063, 3432.0, 2.7326, 433.7117, 1506.0, 6.013, 103.0928, 1060.0, 5.631, 529.691, 969.0, 5.204, 632.784, 942.0, 1.396, 853.196, 708.0, 3.803, 323.505, 552.0, 5.131, 202.253, 400.0, 3.359, 227.526, 319.0, 3.626, 209.367, 316.0, 1.997, 647.011, 314.0, 0.465, 217.231, 284.0, 4.886, 224.345, 236.0, 2.139, 11.046, 215.0, 5.95, 846.083, 209.0, 2.12, 415.552, 207.0, 0.73, 199.072, 179.0, 2.954, 63.736, 141.0, 0.644, 490.334, 139.0, 4.595, 14.227, 139.0, 1.998, 735.877, 135.0, 5.245, 742.99, 122.0, 3.115, 522.577, 116.0, 3.109, 216.48, 114.0, 0.963, 210.118, 96.0, 4.48, 117.32, 81.0, 1.32, 277.03, 74.0, 2.89, 149.56, 73.0, 3.06, 536.8, 69.0, 4.92, 309.28, 68.0, 2.18, 351.82, 62.0, 0.68, 1066.5, 57.0, 2.61, 440.83, 49.0, 5.79, 95.98, 48.0, 2.18, 74.78, 38.0, 5.29, 1059.38, 37.0, 6.28, 1162.47, 36.0, 1.63, 628.85, 35.0, 1.71, 1052.27, 34.0, 5.98, 412.37, 34.0, 2.46, 422.67, 34.0, 1.14, 949.18, 32.0, 4.15, 437.64, 27.0, 1.27, 860.31, 24.0, 3.07, 215.75, 24.0, 4.11, 3.93, 24.0, 2.75, 838.97, 23.0, 0.99, 210.85, 21.0, 0.14, 430.53, 21.0, 3.51, 330.62, 20.0, 2.82, 127.47, 19.0, 2.98, 137.03, 19.0, 6.27, 423.42, 18.0, 2.29, 388.47, 18.0, 6.2, 703.63, 17.0, 3.9, 214.26, 17.0, 0.17, 212.34, 17.0, 1.67, 38.13, 16.0, 4.55, 956.29, 397555.0, 5.3329, 213.299095, 49479.0, 3.14159, 0.0, 18572.0, 6.09919, 426.59819, 14801.0, 2.30586, 206.18555, 9644.0, 1.6967, 220.4126, 3757.0, 1.2543, 419.4846, 2717.0, 5.9117, 639.8973, 1455.0, 0.8516, 433.7117, 1291.0, 2.9177, 7.1135, 853.0, 0.436, 316.392, 298.0, 0.919, 632.784, 292.0, 5.316, 853.196, 284.0, 1.619, 227.526, 275.0, 3.889, 103.093, 172.0, 0.052, 647.011, 166.0, 2.444, 199.072, 158.0, 5.209, 110.206, 128.0, 1.207, 529.691, 110.0, 2.457, 217.231, 82.0, 2.76, 210.12, 81.0, 2.86, 14.23, 69.0, 1.66, 202.25, 65.0, 1.26, 216.48, 61.0, 1.25, 209.37, 59.0, 1.82, 323.51, 46.0, 0.82, 440.83, 36.0, 1.82, 224.34, 34.0, 2.84, 117.32, 33.0, 1.31, 412.37, 32.0, 1.19, 846.08, 27.0, 4.65, 1066.5, 27.0, 4.44, 11.05, 23.0, 4.13, 415.55, 21.0, 1.41, 309.28, 18.0, 5.56, 860.31, 15.0, 1.22, 63.74, 15.0, 1.34, 95.98, 15.0, 1.01, 536.8, 13.0, 2.46, 490.33, 13.0, 3.22, 277.03, 13.0, 2.27, 742.99, 13.0, 4.89, 522.58, 13.0, 0.3, 422.67, 12.0, 1.87, 423.42, 10.0, 3.12, 625.67, 10.0, 1.75, 330.62, 9.0, 0.46, 429.78, 8.0, 4.68, 215.75, 8.0, 2.42, 430.53, 7.0, 5.97, 149.56, 7.0, 1.52, 437.64, 7.0, 3.91, 351.82, 7.0, 3.01, 949.18, 6.0, 1.49, 234.64, 6.0, 0.02, 654.12, 6.0, 5.37, 735.88, 5.0, 3.81, 74.78, 5.0, 4.34, 628.85, 4.0, 5.64, 210.85, 4.0, 2.64, 3.18, 4.0, 1.73, 1059.38, 4.0, 4.99, 3.93, 4.0, 1.16, 223.59, 20630.0, 0.50482, 213.2991, 3720.0, 3.9983, 206.1855, 1627.0, 6.1819, 220.4126, 1346.0, 0.0, 0.0, 706.0, 3.039, 419.485, 365.0, 5.099, 426.598, 330.0, 5.279, 433.712, 219.0, 3.828, 639.897, 139.0, 1.043, 7.114, 104.0, 6.157, 227.526, 93.0, 1.98, 316.39, 71.0, 4.15, 199.07, 52.0, 2.88, 632.78, 49.0, 4.43, 647.01, 41.0, 3.16, 853.2, 29.0, 4.53, 210.12, 24.0, 1.12, 14.23, 21.0, 4.35, 217.23, 20.0, 5.31, 440.83, 18.0, 0.85, 110.21, 17.0, 5.68, 216.48, 16.0, 4.26, 103.09, 14.0, 3.0, 412.37, 12.0, 2.53, 529.69, 8.0, 3.32, 202.25, 7.0, 5.56, 209.37, 7.0, 0.29, 323.51, 6.0, 1.16, 117.32, 6.0, 3.61, 860.31, 6.0, 3.58, 309.28, 6.0, 2.48, 1066.5, 4.0, 3.02, 846.08, 4.0, 4.8, 625.67, 3.0, 3.77, 423.42, 3.0, 6.04, 234.64, 3.0, 4.82, 429.78, 3.0, 4.48, 654.12, 3.0, 3.29, 95.98, 3.0, 5.64, 735.88, 3.0, 0.22, 522.58, 2.0, 0.03, 415.55, 2.0, 6.25, 330.62, 2.0, 4.56, 422.67, 2.0, 5.06, 277.03, 2.0, 5.53, 536.8, 2.0, 5.54, 224.34, 2.0, 5.6, 223.59, 666.0, 1.99, 213.299, 632.0, 5.698, 206.186, 398.0, 0.0, 0.0, 188.0, 4.338, 220.413, 92.0, 4.84, 419.48, 52.0, 3.42, 433.71, 42.0, 2.38, 426.6, 26.0, 4.4, 227.53, 21.0, 5.85, 199.07, 18.0, 1.99, 639.9, 11.0, 5.37, 7.11, 10.0, 2.55, 647.01, 7.0, 3.46, 316.39, 6.0, 4.8, 632.78, 6.0, 0.02, 210.12, 6.0, 3.52, 440.83, 5.0, 5.64, 14.23, 5.0, 1.22, 853.2, 4.0, 4.71, 412.37, 3.0, 0.63, 103.09, 2.0, 3.72, 216.48, 2.0, 6.11, 217.23, 1.0, 1.69, 860.31, 1.0, 4.31, 234.64, 1.0, 5.75, 309.28, 1.0, 2.66, 654.12, 1.0, 5.69, 117.32, 1.0, 5.48, 202.25, 1.0, 0.6, 1066.5, 1.0, 0.22, 625.67, 1.0, 2.86, 429.78, 1.0, 4.52, 323.51, 80.0, 1.12, 206.19, 32.0, 3.12, 213.3, 17.0, 2.48, 220.41, 12.0, 3.14, 0.0, 9.0, 0.38, 419.48, 6.0, 1.56, 433.71, 5.0, 2.63, 227.53, 5.0, 1.28, 199.07, 1.0, 1.43, 426.6, 1.0, 0.67, 647.01, 1.0, 1.72, 440.83, 1.0, 6.18, 639.9, 1.0, 3.85, 14.23, 1.0, 3.49, 7.11, 1.0, 0.31, 412.37, 8.0, 2.82, 206.19, 1.0, 0.51, 220.41, 1.0, 3.14, 0.0, 1.0, 2.99, 199.07, 1.0, 0.78, 227.53, 1.0, 5.96, 433.71, 9.55758136E8, 0.0, 0.0, 5.2921382E7, 2.3922622, 213.29909544, 1873680.0, 5.2354961, 206.1855484, 1464664.0, 1.6476305, 426.5981909, 821891.0, 5.9352, 316.39187, 547507.0, 5.015326, 103.092774, 371684.0, 2.271148, 220.412642, 361778.0, 3.139043, 7.113547, 140618.0, 5.704067, 632.783739, 108975.0, 3.293136, 110.206321, 69007.0, 5.941, 419.48464, 61053.0, 0.94038, 639.89729, 48913.0, 1.55733, 202.2534, 34144.0, 0.19519, 277.03499, 32402.0, 5.47085, 949.17561, 20937.0, 0.46349, 735.87651, 20839.0, 1.52103, 433.71174, 20747.0, 5.33256, 199.072, 15298.0, 3.05944, 529.69097, 14296.0, 2.60434, 323.50542, 12884.0, 1.64892, 138.5175, 11993.0, 5.98051, 846.08283, 11380.0, 1.73106, 522.57742, 9796.0, 5.2048, 1265.5675, 7753.0, 5.8519, 95.9792, 6771.0, 3.0043, 14.2271, 6466.0, 0.1773, 1052.2684, 5850.0, 1.4552, 415.5525, 5307.0, 0.5974, 63.7359, 4696.0, 2.1492, 227.5262, 4044.0, 1.6401, 209.3669, 3688.0, 0.7802, 412.3711, 3461.0, 1.8509, 175.1661, 3420.0, 4.9455, 1581.9593, 3401.0, 0.5539, 350.3321, 3376.0, 3.6953, 224.3448, 2976.0, 5.6847, 210.1177, 2885.0, 1.3876, 838.9693, 2881.0, 0.1796, 853.1964, 2508.0, 3.5385, 742.9901, 2448.0, 6.1841, 1368.6603, 2406.0, 2.9656, 117.3199, 2174.0, 0.0151, 340.7709, 2024.0, 5.0541, 11.0457, 1888.0, 0.0297, 3.9322, 1861.0, 5.9336, 625.6702, 1817.0, 5.7771, 490.3341, 1781.0, 0.7631, 217.2312, 1740.0, 2.3466, 309.2783, 1611.0, 1.173, 74.7816, 1475.0, 5.6767, 203.7379, 1472.0, 1.4006, 137.033, 1463.0, 1.9259, 216.4805, 1395.0, 5.9367, 127.4718, 1315.0, 5.112, 211.8146, 1304.0, 0.7724, 647.0108, 1296.0, 4.6918, 1898.3512, 1277.0, 2.9841, 1059.3819, 1207.0, 0.7529, 351.8166, 1150.0, 5.7402, 1162.4747, 1127.0, 4.4671, 265.9893, 1099.0, 1.8177, 149.5632, 1071.0, 1.1357, 1155.3612, 1021.0, 5.9123, 1685.0521, 998.0, 2.631, 200.769, 986.0, 2.26, 956.289, 932.0, 3.67, 554.07, 664.0, 0.603, 728.763, 660.0, 4.666, 195.14, 626.0, 5.942, 1478.867, 618.0, 5.621, 942.062, 553.0, 3.411, 269.921, 534.0, 1.264, 275.551, 517.0, 4.443, 2214.743, 494.0, 2.286, 278.519, 490.0, 5.806, 191.208, 488.0, 2.794, 3.181, 482.0, 1.841, 479.288, 473.0, 1.882, 515.464, 470.0, 0.838, 1471.753, 453.0, 3.003, 302.165, 452.0, 5.645, 2001.444, 427.0, 0.057, 284.149, 405.0, 1.64, 536.805, 386.0, 1.997, 1272.681, 343.0, 5.856, 1795.258, 341.0, 2.376, 525.498, 341.0, 0.891, 628.852, 340.0, 1.402, 440.825, 303.0, 0.879, 6069.777, 295.0, 0.671, 88.866, 294.0, 0.426, 312.199, 292.0, 6.214, 210.851, 288.0, 1.122, 422.666, 277.0, 5.319, 692.587, 276.0, 0.478, 38.133, 262.0, 0.318, 1045.155, 243.0, 5.372, 1258.454, 241.0, 1.125, 388.465, 237.0, 0.908, 1375.774, 234.0, 4.228, 114.138, 231.0, 5.495, 191.958, 226.0, 0.375, 142.45, 225.0, 0.548, 1788.145, 224.0, 2.281, 330.619, 222.0, 5.946, 39.357, 219.0, 5.256, 212.336, 214.0, 4.203, 2531.135, 208.0, 5.381, 2317.836, 206.0, 0.958, 288.081, 197.0, 3.901, 52.69, 192.0, 2.959, 437.644, 188.0, 6.079, 563.631, 187.0, 6.036, 404.507, 183.0, 5.669, 2111.65, 180.0, 4.41, 408.439, 178.0, 0.382, 430.53, 177.0, 2.303, 9999.986, 175.0, 5.714, 1066.495, 173.0, 1.849, 1589.073, 172.0, 2.365, 213.251, 172.0, 5.563, 213.347, 170.0, 2.857, 99.161, 166.0, 2.637, 215.747, 165.0, 2.891, 214.262, 163.0, 3.458, 617.806, 162.0, 5.731, 203.004, 150.0, 4.407, 417.037, 146.0, 1.566, 831.856, 145.0, 5.082, 423.417, 143.0, 0.998, 76.266, 137.0, 5.439, 222.86, 132.0, 2.859, 312.46, 129.0, 2.553, 414.068, 125.0, 4.784, 205.222, 120.0, 0.043, 1361.547, 113.0, 5.031, 703.633, 112.0, 0.262, 2104.537, 110.0, 2.437, 355.749, 109.0, 1.632, 208.633, 109.0, 2.093, 207.67, 109.0, 2.855, 21.341, 107.0, 3.671, 212.778, 104.0, 3.637, 65.22, 99.0, 5.14, 1574.85, 98.0, 5.12, 2634.23, 97.0, 4.2, 305.35, 97.0, 4.84, 131.4, 97.0, 2.56, 1692.17, 96.0, 5.45, 2428.04, 95.0, 2.52, 2.45, 94.0, 2.4, 483.22, 93.0, 0.74, 831.1, 92.0, 2.95, 35.42, 91.0, 3.97, 2847.53, 91.0, 4.21, 213.82, 89.0, 5.39, 107.02, 89.0, 4.06, 128.96, 88.0, 3.87, 140.0, 87.0, 1.33, 1905.46, 86.0, 2.3, 85.83, 86.0, 4.55, 210.38, 86.0, 0.03, 860.31, 84.0, 1.18, 429.78, 84.0, 4.61, 177.87, 83.0, 1.53, 145.63, 82.0, 1.66, 62.25, 77.0, 3.15, 767.37, 74.0, 3.57, 1.48, 74.0, 3.72, 92.05, 73.0, 4.38, 425.11, 73.0, 4.63, 245.54, 72.0, 0.01, 565.12, 71.0, 0.99, 405.26, 70.0, 4.04, 173.94, 67.0, 1.08, 339.29, 67.0, 4.75, 70.85, 66.0, 2.47, 280.97, 65.0, 2.45, 267.47, 65.0, 0.09, 9.56, 64.0, 1.29, 1148.25, 64.0, 4.1, 327.44, 63.0, 2.02, 234.64, 63.0, 4.4, 214.78, 61.0, 5.12, 756.32, 59.0, 4.23, 700.66, 59.0, 2.62, 225.83, 58.0, 6.06, 1677.94, 58.0, 5.47, 347.88, 57.0, 6.27, 2420.93, 56.0, 2.07, 124.43, 56.0, 4.3, 329.73, 55.0, 1.6, 543.02, 55.0, 3.86, 342.26, 54.0, 3.71, 344.7, 54.0, 1.07, 362.86, 54.0, 4.98, 134.59, 53.0, 3.79, 343.22, 50.0, 5.76, 320.32, 50.0, 3.93, 192.69, 50.0, 5.21, 2744.43, 50.0, 3.23, 333.66, 49.0, 4.9, 217.49, 49.0, 5.33, 3127.31, 48.0, 3.15, 216.22, 48.0, 2.39, 207.88, 48.0, 3.93, 199.28, 47.0, 2.45, 207.15, 47.0, 2.07, 2008.56, 46.0, 2.09, 212.55, 46.0, 4.86, 2950.62, 46.0, 2.64, 10.29, 46.0, 4.97, 198.32, 45.0, 5.36, 218.93, 45.0, 1.78, 223.59, 45.0, 5.56, 264.5, 43.0, 1.84, 106.27, 43.0, 0.4, 357.45, 42.0, 0.08, 210.33, 42.0, 0.74, 125.99, 41.0, 2.47, 237.68, 41.0, 4.92, 1891.24, 41.0, 4.08, 621.74, 40.0, 4.01, 12.53, 39.0, 3.46, 241.61, 39.0, 3.74, 3163.92, 39.0, 4.4, 18.16, 38.0, 4.44, 160.61, 38.0, 2.06, 247.24, 37.0, 4.75, 348.85, 37.0, 1.69, 22.09, 36.0, 3.83, 56.62, 35.0, 3.44, 273.1, 35.0, 5.65, 497.45, 35.0, 5.96, 217.96, 35.0, 2.25, 487.37, 35.0, 5.63, 99.91, 35.0, 1.83, 380.13, 34.0, 6.01, 166.83, 34.0, 0.73, 750.1, 34.0, 5.31, 206.23, 34.0, 1.24, 2221.86, 34.0, 5.8, 251.43, 33.0, 2.45, 969.62, 33.0, 4.87, 209.11, 33.0, 1.07, 252.66, 33.0, 1.93, 98.9, 33.0, 2.23, 319.57, 32.0, 3.78, 33.94, 32.0, 3.58, 231.46, 32.0, 1.0, 1464.64, 32.0, 2.13, 206.14, 32.0, 3.82, 73.3, 31.0, 2.05, 282.45, 31.0, 1.96, 244.32, 31.0, 4.9, 144.15, 31.0, 2.27, 1169.59, 30.0, 3.93, 206.71, 29.0, 5.98, 2737.32, 29.0, 4.84, 905.89, 29.0, 2.22, 14.98, 29.0, 6.03, 188.92, 29.0, 5.8, 1994.33, 29.0, 0.04, 5.63, 29.0, 0.76, 488.85, 29.0, 1.69, 78.71, 28.0, 4.73, 552.59, 28.0, 2.72, 32.24, 28.0, 0.79, 546.96, 28.0, 5.18, 5.42, 28.0, 1.45, 258.88, 28.0, 6.12, 214.05, 27.0, 2.45, 254.94, 27.0, 3.58, 561.18, 27.0, 0.25, 313.21, 27.0, 4.26, 179.36, 27.0, 5.2, 148.08, 27.0, 5.54, 555.55, 27.0, 2.86, 24.38, 26.0, 1.59, 491.82, 26.0, 0.65, 654.12, 26.0, 2.1, 248.72, 26.0, 1.62, 2324.95, 26.0, 3.36, 0.96, 25.0, 5.29, 636.72, 25.0, 4.97, 3060.83, 25.0, 5.12, 168.05, 25.0, 1.78, 182.28, 24.0, 0.01, 69.15, 24.0, 0.52, 894.84, 24.0, 3.15, 240.39, 24.0, 1.6, 738.8, 24.0, 2.55, 196.62, 23.0, 3.51, 458.84, 22.0, 3.25, 681.54, 22.0, 4.76, 213.19, 22.0, 3.17, 213.41, 22.0, 0.88, 635.97, 22.0, 4.61, 3267.01, 21.0, 3.86, 116.43, 21.0, 0.63, 189.72, 21.0, 1.67, 274.07, 21.0, 1.07, 494.27, 20.0, 6.05, 173.68, 20.0, 1.84, 533.62, 20.0, 2.95, 59.8, 20.0, 2.91, 120.36, 20.0, 4.94, 121.25, 20.0, 5.59, 4.19, 20.0, 0.08, 842.15, 20.0, 2.52, 1485.98, 20.0, 2.14, 54.17, 19.0, 0.11, 218.72, 19.0, 0.55, 4.67, 19.0, 5.38, 213.09, 19.0, 2.55, 213.51, 18.0, 3.19, 295.05, 18.0, 2.71, 181.81, 18.0, 2.26, 672.14, 17.0, 2.9, 477.8, 17.0, 0.68, 151.05, 17.0, 0.71, 1781.03, 17.0, 4.74, 2207.63, 17.0, 1.63, 5856.48, 17.0, 3.53, 3480.31, 16.0, 3.26, 6283.08, 16.0, 5.39, 424.15, 16.0, 3.98, 2.92, 16.0, 0.91, 280.0, 16.0, 0.63, 358.93, 16.0, 0.98, 2538.25, 16.0, 0.6, 746.92, 16.0, 0.83, 176.65, 16.0, 4.46, 643.83, 16.0, 5.23, 135.55, 16.0, 1.19, 486.4, 16.0, 5.7, 3053.71, 15.0, 1.49, 543.92, 15.0, 5.53, 2310.72, 15.0, 2.67, 46.47, 15.0, 1.24, 2641.34, 15.0, 1.77, 569.05, 15.0, 2.92, 167.09, 15.0, 2.66, 292.01, 15.0, 6.06, 468.24, 15.0, 5.26, 472.17, 14.0, 0.22, 235.39, 14.0, 0.12, 313.68, 14.0, 0.38, 601.76, 14.0, 2.63, 618.56, 14.0, 0.82, 221.38, 14.0, 3.19, 213.56, 14.0, 4.73, 213.04, 14.0, 2.51, 1802.37, 14.0, 2.21, 228.28, 6182981.0, 0.2584352, 213.2990954, 506578.0, 0.711147, 206.185548, 341394.0, 5.796358, 426.598191, 188491.0, 0.472157, 220.412642, 186262.0, 3.141593, 0.0, 143891.0, 1.407449, 7.113547, 49621.0, 6.01744, 103.09277, 20928.0, 5.09246, 639.89729, 19953.0, 1.1756, 419.48464, 18840.0, 1.6082, 110.20632, 13877.0, 0.75886, 199.072, 12893.0, 5.9433, 433.71174, 5397.0, 1.2885, 14.2271, 4869.0, 0.8679, 323.5054, 4247.0, 0.393, 227.5262, 3252.0, 1.2585, 95.9792, 3081.0, 3.4366, 522.5774, 2909.0, 4.6068, 202.2534, 2856.0, 2.1673, 735.8765, 1988.0, 2.4505, 412.3711, 1941.0, 6.0239, 209.3669, 1581.0, 1.2919, 210.1177, 1340.0, 4.308, 853.1964, 1316.0, 1.253, 117.3199, 1203.0, 1.8665, 316.3919, 1091.0, 0.0753, 216.4805, 966.0, 0.48, 632.784, 954.0, 5.152, 647.011, 898.0, 0.983, 529.691, 882.0, 1.885, 1052.268, 874.0, 1.402, 224.345, 785.0, 3.064, 838.969, 740.0, 1.382, 625.67, 658.0, 4.144, 309.278, 650.0, 1.725, 742.99, 613.0, 3.033, 63.736, 599.0, 2.549, 217.231, 503.0, 2.13, 3.932, 413.0, 4.593, 415.552, 395.0, 0.533, 956.289, 363.0, 4.707, 302.165, 356.0, 2.303, 728.763, 345.0, 5.888, 440.825, 336.0, 1.616, 1368.66, 322.0, 0.979, 3.181, 317.0, 3.584, 515.464, 294.0, 2.816, 11.046, 291.0, 2.831, 1155.361, 278.0, 0.26, 195.14, 265.0, 2.427, 88.866, 265.0, 5.829, 149.563, 264.0, 1.285, 1059.382, 246.0, 0.907, 191.958, 245.0, 1.045, 942.062, 222.0, 5.132, 269.921, 215.0, 3.565, 490.334, 195.0, 4.567, 846.083, 183.0, 2.679, 127.472, 182.0, 4.934, 74.782, 175.0, 3.446, 137.033, 170.0, 4.635, 284.149, 166.0, 5.998, 536.805, 158.0, 2.996, 340.771, 155.0, 1.197, 265.989, 153.0, 0.27, 1272.681, 152.0, 5.439, 422.666, 152.0, 0.529, 330.619, 141.0, 1.271, 203.004, 141.0, 2.021, 1045.155, 140.0, 1.353, 1685.052, 136.0, 5.017, 351.817, 129.0, 1.143, 21.341, 128.0, 2.539, 1471.753, 127.0, 3.003, 277.035, 108.0, 4.319, 210.851, 103.0, 0.382, 203.738, 100.0, 3.614, 1066.495, 98.0, 2.56, 191.21, 97.0, 3.26, 831.86, 96.0, 0.79, 1258.45, 83.0, 0.28, 234.64, 73.0, 0.63, 1375.77, 72.0, 4.38, 860.31, 72.0, 5.58, 429.78, 71.0, 0.73, 437.64, 70.0, 0.88, 423.42, 69.0, 2.47, 949.18, 67.0, 5.45, 200.77, 67.0, 0.07, 408.44, 66.0, 2.68, 405.26, 66.0, 0.06, 1589.07, 64.0, 1.75, 1361.55, 62.0, 1.09, 2001.44, 60.0, 2.25, 1788.14, 55.0, 4.59, 628.85, 54.0, 0.28, 124.43, 51.0, 6.27, 223.59, 50.0, 3.8, 215.75, 49.0, 4.17, 138.52, 48.0, 0.84, 10.29, 47.0, 2.17, 312.2, 43.0, 3.38, 208.63, 43.0, 2.99, 1148.25, 42.0, 4.83, 288.08, 40.0, 5.18, 1478.87, 40.0, 0.28, 131.4, 39.0, 0.56, 1574.85, 37.0, 0.63, 52.69, 35.0, 4.68, 38.13, 33.0, 1.98, 142.45, 33.0, 3.28, 222.86, 33.0, 6.12, 145.63, 32.0, 5.19, 76.27, 32.0, 6.02, 1905.46, 31.0, 1.48, 1677.94, 30.0, 1.96, 2104.54, 29.0, 5.1, 654.12, 29.0, 4.96, 1795.26, 29.0, 2.75, 404.51, 28.0, 0.83, 1692.17, 28.0, 0.83, 2317.84, 28.0, 2.24, 430.53, 27.0, 5.24, 388.47, 27.0, 1.0, 107.02, 26.0, 4.28, 483.22, 26.0, 2.21, 1265.57, 25.0, 2.87, 703.63, 25.0, 6.24, 106.27, 25.0, 1.08, 99.91, 25.0, 0.81, 312.46, 24.0, 3.11, 212.34, 24.0, 0.55, 214.26, 24.0, 0.65, 207.88, 23.0, 5.08, 479.29, 23.0, 4.87, 295.05, 22.0, 4.23, 217.96, 22.0, 5.51, 343.22, 22.0, 3.9, 563.63, 22.0, 0.73, 99.16, 22.0, 6.07, 85.83, 22.0, 4.17, 2.45, 22.0, 3.8, 347.88, 21.0, 3.09, 554.07, 21.0, 0.39, 319.57, 21.0, 5.11, 333.66, 21.0, 2.69, 1464.64, 21.0, 3.29, 70.85, 21.0, 5.12, 362.86, 21.0, 1.69, 231.46, 21.0, 2.46, 18.16, 20.0, 0.23, 213.25, 20.0, 5.08, 750.1, 20.0, 3.43, 213.35, 19.0, 2.02, 313.21, 19.0, 0.05, 245.54, 18.0, 5.7, 56.62, 18.0, 3.84, 497.45, 17.0, 3.55, 218.93, 17.0, 4.72, 2111.65, 17.0, 1.41, 114.14, 16.0, 3.05, 134.59, 16.0, 1.71, 2420.93, 16.0, 4.94, 357.45, 16.0, 4.22, 565.12, 16.0, 0.27, 225.83, 16.0, 0.33, 1891.24, 16.0, 2.83, 81.75, 15.0, 1.21, 1994.33, 15.0, 1.31, 216.22, 15.0, 3.85, 1162.47, 15.0, 5.57, 344.7, 14.0, 0.45, 2008.56, 14.0, 5.71, 92.05, 14.0, 0.57, 2634.23, 13.0, 5.76, 2221.86, 13.0, 0.45, 1169.59, 13.0, 1.6, 320.32, 13.0, 3.74, 508.35, 13.0, 3.43, 258.88, 13.0, 1.64, 273.1, 13.0, 1.92, 1581.96, 13.0, 5.19, 635.97, 12.0, 1.01, 329.73, 12.0, 5.95, 543.92, 12.0, 4.45, 32.24, 12.0, 5.11, 4.67, 12.0, 4.31, 618.56, 12.0, 2.46, 721.65, 12.0, 1.76, 160.61, 12.0, 3.71, 350.33, 12.0, 2.8, 217.49, 11.0, 3.0, 198.32, 11.0, 1.89, 561.18, 11.0, 2.41, 1781.03, 11.0, 1.58, 212.78, 11.0, 0.77, 218.72, 11.0, 2.07, 213.82, 10.0, 2.41, 546.96, 10.0, 0.09, 182.28, 10.0, 0.49, 305.35, 10.0, 2.64, 416.3, 10.0, 4.05, 62.25, 10.0, 3.28, 275.55, 10.0, 1.61, 327.44, 10.0, 1.1, 113.39, 9.0, 5.46, 414.07, 9.0, 4.46, 2428.04, 9.0, 2.92, 1279.79, 9.0, 4.88, 120.36, 9.0, 0.54, 168.05, 9.0, 6.14, 621.74, 9.0, 1.83, 629.6, 9.0, 1.95, 35.42, 9.0, 2.18, 425.11, 8.0, 0.36, 617.81, 8.0, 3.77, 251.43, 8.0, 0.92, 1485.98, 8.0, 1.38, 1.48, 8.0, 5.31, 65.22, 8.0, 3.46, 424.15, 8.0, 0.35, 278.52, 8.0, 5.44, 254.94, 8.0, 0.96, 767.37, 8.0, 1.43, 2737.32, 8.0, 3.38, 144.15, 8.0, 0.94, 636.72, 8.0, 5.14, 22.09, 8.0, 0.94, 2310.72, 8.0, 5.14, 358.93, 8.0, 4.56, 280.97, 8.0, 0.1, 2324.95, 8.0, 5.75, 447.94, 8.0, 2.19, 264.5, 7.0, 4.52, 5.63, 7.0, 3.85, 214.05, 7.0, 3.39, 98.9, 7.0, 1.2, 5.42, 7.0, 1.65, 1898.35, 7.0, 1.79, 12.53, 7.0, 3.5, 9.56, 6.0, 5.31, 6076.89, 6.0, 0.45, 10007.1, 6.0, 0.33, 2950.62, 6.0, 2.12, 274.07, 6.0, 0.76, 210.38, 6.0, 3.21, 219.45, 6.0, 3.8, 339.29, 6.0, 4.59, 207.67, 6.0, 0.18, 2207.63, 6.0, 2.11, 2097.42, 6.0, 4.67, 543.02, 6.0, 5.13, 692.59, 6.0, 6.17, 650.94, 6.0, 5.95, 486.4, 6.0, 1.04, 9992.87, 6.0, 6.1, 209.11, 6.0, 5.48, 2538.25, 6.0, 3.01, 121.25, 6.0, 5.92, 6062.66, 6.0, 3.56, 1073.61, 6.0, 0.56, 116.43, 6.0, 4.4, 196.62, 6.0, 4.83, 643.08, 6.0, 0.95, 1802.37, 6.0, 0.81, 472.17, 6.0, 2.24, 1038.04, 6.0, 3.61, 125.99, 6.0, 3.84, 181.06, 5.0, 5.81, 237.68, 5.0, 6.19, 337.73, 5.0, 0.56, 192.69, 5.0, 3.82, 842.15, 5.0, 4.85, 267.47, 5.0, 0.5, 248.72, 5.0, 4.01, 205.22, 5.0, 3.36, 824.74, 5.0, 1.63, 166.83, 5.0, 0.85, 46.47, 5.0, 4.04, 487.37, 5.0, 0.85, 247.24, 5.0, 4.49, 291.26, 5.0, 2.67, 417.04, 5.0, 0.25, 129.92, 5.0, 4.18, 2744.43, 5.0, 3.74, 235.39, 5.0, 5.58, 342.26, 5.0, 1.55, 214.78, 5.0, 3.17, 148.08, 5.0, 3.67, 189.72, 4.0, 4.71, 151.05, 4.0, 3.74, 699.7, 4.0, 0.25, 128.96, 4.0, 5.69, 252.66, 4.0, 4.95, 184.09, 4.0, 5.43, 436.89, 4.0, 6.2, 268.44, 4.0, 4.19, 685.47, 4.0, 2.98, 380.13, 4.0, 5.97, 212.55, 4.0, 6.1, 2641.34, 4.0, 5.82, 491.82, 4.0, 4.87, 14.98, 4.0, 4.19, 501.38, 4.0, 1.15, 3053.71, 4.0, 3.08, 710.75, 4.0, 5.17, 114.4, 4.0, 3.46, 220.46, 4.0, 0.75, 2627.11, 4.0, 0.99, 271.41, 4.0, 4.78, 175.17, 4.0, 3.71, 204.7, 4.0, 1.27, 211.81, 4.0, 3.56, 244.32, 4.0, 4.53, 488.85, 4.0, 2.87, 411.62, 4.0, 2.22, 2.92, 4.0, 3.06, 409.92, 4.0, 5.54, 458.84, 4.0, 1.58, 643.83, 4.0, 4.51, 601.76, 4.0, 1.11, 6283.08, 4.0, 2.2, 135.34, 4.0, 3.64, 229.97, 4.0, 1.32, 69.15, 436902.0, 4.786717, 213.299095, 71923.0, 2.5007, 206.18555, 49767.0, 4.97168, 220.41264, 43221.0, 3.8694, 426.59819, 29646.0, 5.9631, 7.11355, 4721.0, 2.4753, 199.072, 4142.0, 4.1067, 433.7117, 3789.0, 3.0977, 639.8973, 2964.0, 1.3721, 103.0928, 2556.0, 2.8507, 419.4846, 2327.0, 0.0, 0.0, 2208.0, 6.2759, 110.2063, 2188.0, 5.8555, 14.2271, 1957.0, 4.9245, 227.5262, 924.0, 5.464, 323.505, 706.0, 2.971, 95.979, 546.0, 4.129, 412.371, 431.0, 5.178, 522.577, 405.0, 4.173, 209.367, 391.0, 4.481, 216.48, 374.0, 5.834, 117.32, 361.0, 3.277, 647.011, 356.0, 3.192, 210.118, 326.0, 2.269, 853.196, 207.0, 4.022, 735.877, 204.0, 0.088, 202.253, 180.0, 3.597, 632.784, 178.0, 4.097, 440.825, 154.0, 3.135, 625.67, 148.0, 0.136, 302.165, 133.0, 2.594, 191.958, 132.0, 5.933, 309.278, 123.0, 4.189, 88.866, 119.0, 5.554, 224.345, 111.0, 4.779, 838.969, 109.0, 5.293, 515.464, 100.0, 5.461, 3.181, 97.0, 4.02, 728.76, 96.0, 6.26, 742.99, 94.0, 4.38, 217.23, 81.0, 5.11, 956.29, 79.0, 5.73, 21.34, 69.0, 4.05, 3.93, 65.0, 3.78, 1052.27, 64.0, 5.81, 529.69, 63.0, 2.18, 195.14, 57.0, 3.15, 203.0, 56.0, 4.84, 234.64, 53.0, 5.08, 330.62, 53.0, 3.93, 949.18, 51.0, 2.77, 942.06, 45.0, 0.56, 269.92, 42.0, 4.79, 63.74, 41.0, 3.73, 316.39, 41.0, 4.58, 1155.36, 39.0, 3.51, 422.67, 38.0, 3.74, 1045.15, 38.0, 4.19, 536.8, 35.0, 2.91, 284.15, 35.0, 5.94, 1059.38, 34.0, 3.8, 149.56, 33.0, 4.97, 831.86, 31.0, 4.84, 1272.68, 30.0, 2.48, 860.31, 30.0, 4.35, 405.26, 30.0, 3.66, 429.78, 30.0, 1.59, 1066.5, 27.0, 1.66, 277.03, 26.0, 4.45, 223.59, 26.0, 4.82, 124.43, 26.0, 3.55, 1368.66, 24.0, 5.31, 10.29, 22.0, 2.76, 415.55, 22.0, 1.04, 11.05, 21.0, 3.62, 1265.57, 20.0, 2.52, 1258.45, 18.0, 4.31, 1471.75, 17.0, 3.49, 1361.55, 17.0, 3.28, 654.12, 16.0, 1.73, 490.33, 15.0, 5.01, 127.47, 15.0, 3.6, 265.99, 14.0, 4.69, 1148.25, 14.0, 3.05, 423.42, 13.0, 1.9, 408.44, 13.0, 0.32, 295.05, 13.0, 4.89, 437.64, 13.0, 4.62, 1589.07, 13.0, 3.14, 74.78, 12.0, 2.33, 210.85, 11.0, 5.48, 1375.77, 11.0, 4.55, 81.75, 11.0, 5.05, 191.21, 11.0, 5.03, 137.03, 10.0, 3.34, 1685.05, 10.0, 5.2, 340.77, 10.0, 3.17, 351.82, 9.0, 3.4, 1581.96, 9.0, 2.81, 99.91, 8.0, 3.23, 1677.94, 8.0, 4.04, 1788.14, 8.0, 2.36, 1574.85, 8.0, 6.08, 231.46, 8.0, 3.68, 846.08, 8.0, 3.29, 750.1, 7.0, 2.0, 131.4, 7.0, 4.38, 1464.64, 7.0, 4.83, 319.57, 7.0, 4.37, 145.63, 7.0, 5.43, 508.35, 7.0, 3.78, 313.21, 6.0, 1.34, 215.75, 6.0, 4.0, 447.94, 6.0, 4.56, 106.27, 6.0, 2.85, 138.52, 6.0, 0.55, 18.16, 6.0, 4.14, 543.92, 6.0, 4.35, 1905.46, 6.0, 1.13, 56.62, 5.0, 4.2, 721.65, 5.0, 3.63, 6076.89, 5.0, 4.5, 416.3, 5.0, 2.64, 288.08, 5.0, 5.05, 10007.1, 5.0, 2.45, 628.85, 5.0, 3.12, 1898.35, 5.0, 6.18, 483.22, 5.0, 5.92, 618.56, 5.0, 3.3, 76.27, 5.0, 3.12, 2001.44, 5.0, 5.78, 184.84, 5.0, 0.76, 333.66, 5.0, 1.27, 6062.66, 5.0, 1.2, 200.77, 5.0, 2.69, 9992.87, 5.0, 0.95, 343.22, 4.0, 0.8, 222.86, 4.0, 1.92, 497.45, 4.0, 2.9, 107.02, 4.0, 1.98, 347.88, 4.0, 2.88, 38.13, 4.0, 2.93, 1994.33, 4.0, 5.18, 404.51, 4.0, 5.45, 1692.17, 4.0, 4.12, 1781.03, 4.0, 3.12, 635.97, 4.0, 0.88, 703.63, 4.0, 3.79, 2104.54, 4.0, 3.25, 362.86, 4.0, 0.05, 32.24, 4.0, 3.48, 388.47, 4.0, 5.55, 113.39, 4.0, 5.46, 6283.08, 4.0, 4.08, 430.53, 3.0, 1.82, 70.85, 3.0, 3.52, 629.6, 3.0, 0.55, 10213.29, 3.0, 4.21, 337.73, 3.0, 3.28, 357.45, 3.0, 1.98, 203.74, 3.0, 3.88, 85.83, 3.0, 3.92, 1038.04, 3.0, 2.46, 867.42, 3.0, 1.26, 134.59, 3.0, 1.61, 1073.61, 3.0, 4.09, 1478.87, 3.0, 2.18, 1891.24, 3.0, 2.67, 52.69, 3.0, 0.41, 561.18, 3.0, 5.6, 216.22, 3.0, 5.01, 312.46, 3.0, 2.55, 6069.78, 3.0, 5.46, 258.88, 3.0, 2.19, 217.96, 3.0, 3.97, 9999.99, 3.0, 0.89, 1279.79, 3.0, 4.21, 650.94, 3.0, 1.67, 213.35, 3.0, 2.38, 181.06, 3.0, 3.91, 312.2, 3.0, 4.75, 213.25, 3.0, 5.09, 1169.59, 3.0, 5.74, 160.61, 3.0, 2.88, 643.08, 3.0, 3.62, 436.89, 3.0, 0.01, 195.89, 3.0, 1.69, 208.63, 3.0, 2.32, 565.12, 3.0, 1.13, 344.7, 3.0, 6.13, 273.1, 3.0, 5.1, 824.74, 3.0, 5.3, 444.76, 2.0, 3.58, 2420.93, 2.0, 2.96, 2214.74, 2.0, 3.46, 6275.96, 2.0, 4.74, 218.72, 2.0, 0.9, 121.25, 2.0, 4.08, 131.55, 2.0, 2.6, 305.35, 2.0, 4.22, 2221.86, 2.0, 5.18, 99.16, 2.0, 5.43, 207.88, 2.0, 3.38, 22.09, 2.0, 3.32, 358.93, 2.0, 3.95, 1795.26, 2.0, 1.61, 218.93, 2.0, 3.37, 320.32, 2.0, 4.85, 1141.13, 2.0, 4.63, 188.03, 2.0, 2.29, 2627.11, 2.0, 5.67, 28.45, 2.0, 1.69, 350.33, 2.0, 4.26, 546.96, 2.0, 0.18, 12.53, 2.0, 4.61, 182.28, 2.0, 2.9, 2310.72, 2.0, 1.31, 212.34, 2.0, 4.13, 225.83, 2.0, 3.01, 2317.84, 2.0, 1.59, 424.15, 2.0, 3.58, 329.73, 2.0, 2.24, 168.05, 2.0, 2.07, 144.15, 2.0, 2.86, 636.72, 2.0, 5.35, 45.58, 2.0, 5.05, 214.26, 2.0, 2.73, 291.26, 2.0, 2.7, 12.74, 2.0, 1.32, 219.45, 2.0, 5.56, 92.8, 2.0, 1.95, 129.92, 2.0, 3.44, 2428.04, 2.0, 3.55, 1354.43, 2.0, 4.98, 2008.56, 2.0, 6.14, 554.07, 2.0, 3.3, 1670.83, 2.0, 5.73, 1485.98, 2.0, 1.16, 235.39, 2.0, 4.51, 210.38, 2.0, 2.16, 207.67, 2.0, 5.51, 204.7, 2.0, 4.99, 1162.47, 20315.0, 3.02187, 213.2991, 8924.0, 3.1914, 220.4126, 6909.0, 4.3517, 206.1855, 4087.0, 4.2241, 7.1135, 3879.0, 2.0106, 426.5982, 1071.0, 4.2036, 199.072, 907.0, 2.283, 433.712, 606.0, 3.175, 227.526, 597.0, 4.135, 14.227, 483.0, 1.173, 639.897, 393.0, 0.0, 0.0, 229.0, 4.698, 419.485, 188.0, 4.59, 110.206, 150.0, 3.202, 103.093, 121.0, 3.768, 323.505, 102.0, 4.71, 95.979, 101.0, 5.819, 412.371, 93.0, 1.44, 647.01, 84.0, 2.63, 216.48, 73.0, 4.15, 117.32, 62.0, 2.31, 440.83, 55.0, 0.31, 853.2, 50.0, 2.39, 209.37, 45.0, 4.37, 191.96, 41.0, 0.69, 522.58, 40.0, 1.84, 302.16, 38.0, 5.94, 88.87, 32.0, 4.01, 21.34, 28.0, 5.77, 210.12, 25.0, 0.73, 515.46, 25.0, 3.06, 234.64, 21.0, 4.93, 625.67, 18.0, 1.46, 309.28, 17.0, 5.73, 728.76, 17.0, 3.53, 3.18, 13.0, 3.36, 330.62, 12.0, 5.99, 735.88, 11.0, 3.37, 224.34, 11.0, 3.42, 956.29, 11.0, 6.07, 405.26, 10.0, 0.28, 838.97, 10.0, 0.58, 860.31, 10.0, 1.59, 202.25, 9.0, 2.57, 223.59, 9.0, 2.94, 124.43, 9.0, 4.65, 632.78, 9.0, 1.76, 429.78, 8.0, 4.48, 742.99, 8.0, 4.2, 195.14, 8.0, 0.44, 831.86, 8.0, 1.46, 654.12, 7.0, 4.51, 942.06, 7.0, 5.47, 1045.15, 7.0, 1.52, 422.67, 7.0, 4.83, 316.39, 7.0, 3.42, 10.29, 6.0, 6.01, 1066.5, 6.0, 2.34, 269.92, 6.0, 0.83, 217.23, 6.0, 1.15, 284.15, 6.0, 4.18, 529.69, 6.0, 2.47, 536.8, 5.0, 2.12, 295.05, 4.0, 0.92, 203.0, 4.0, 3.23, 1272.68, 4.0, 0.11, 1155.36, 4.0, 6.01, 1052.27, 4.0, 0.06, 81.75, 3.0, 4.33, 1258.45, 3.0, 0.19, 1148.25, 3.0, 2.19, 447.94, 3.0, 1.89, 149.56, 3.0, 5.64, 3.93, 3.0, 5.41, 1361.55, 3.0, 4.97, 1677.94, 3.0, 0.92, 508.35, 3.0, 3.0, 1589.07, 3.0, 2.31, 543.92, 3.0, 3.71, 408.44, 2.0, 4.24, 1059.38, 2.0, 3.22, 319.57, 2.0, 5.73, 313.21, 2.0, 1.3, 184.84, 2.0, 5.88, 721.65, 2.0, 0.52, 416.3, 2.0, 6.18, 1464.64, 2.0, 6.23, 1471.75, 2.0, 2.41, 337.73, 2.0, 5.17, 2854.64, 2.0, 2.41, 131.55, 2.0, 5.62, 11.05, 2.0, 0.54, 635.97, 2.0, 5.59, 1038.04, 2.0, 1.82, 436.89, 2.0, 1.51, 750.1, 2.0, 6.12, 1073.61, 2.0, 4.58, 1994.33, 2.0, 0.03, 423.42, 2.0, 2.58, 2090.31, 2.0, 2.95, 437.64, 2.0, 1.75, 195.89, 2.0, 5.97, 1781.03, 2.0, 0.56, 2324.95, 2.0, 6.15, 490.33, 2.0, 0.61, 210.85, 2.0, 3.85, 1251.34, 1.0, 0.27, 497.45, 1.0, 0.99, 643.08, 1.0, 5.35, 1354.43, 1.0, 3.29, 1884.12, 1.0, 1.5, 430.53, 1.0, 0.85, 415.55, 1.0, 5.33, 2538.25, 1.0, 4.12, 1574.85, 1.0, 5.58, 1382.89, 1.0, 0.7, 867.42, 1.0, 3.79, 1567.73, 1.0, 2.29, 2420.93, 1.0, 1.41, 2634.23, 1.0, 0.48, 824.74, 1.0, 2.97, 241.75, 1.0, 3.11, 2200.52, 1.0, 5.13, 25.27, 1.0, 4.7, 113.39, 1.0, 1.8, 618.56, 1.0, 3.96, 1891.24, 1.0, 3.78, 1375.77, 1.0, 3.73, 131.4, 1.0, 4.48, 2214.74, 1.0, 0.79, 127.47, 1.0, 5.42, 1279.79, 1.0, 0.05, 63.74, 1.0, 4.8, 1987.22, 1.0, 5.85, 215.75, 1.0, 4.06, 231.46, 1.0, 1.09, 362.86, 1.0, 4.23, 1802.37, 1.0, 5.33, 2428.04, 1.0, 5.91, 265.99, 1.0, 0.74, 16.67, 1.0, 6.26, 2015.67, 1.0, 5.99, 2524.02, 1.0, 1.92, 483.22, 1.0, 2.66, 145.63, 1.0, 2.97, 934.95, 1.0, 6.26, 2.45, 1.0, 3.16, 2207.63, 1.0, 0.09, 628.85, 1.0, 1.24, 74.78, 1.0, 5.87, 1368.66, 1.0, 2.9, 2008.56, 1.0, 2.38, 2228.97, 1.0, 2.28, 1478.87, 1.0, 1.16, 3053.71, 1.0, 4.7, 1670.83, 1.0, 5.92, 1685.05, 1.0, 3.13, 56.62, 1202.0, 1.415, 220.4126, 708.0, 1.162, 213.299, 516.0, 6.24, 206.186, 427.0, 2.469, 7.114, 268.0, 0.187, 426.598, 170.0, 5.959, 199.072, 150.0, 0.48, 433.712, 145.0, 1.442, 227.526, 121.0, 2.405, 14.227, 47.0, 5.57, 639.9, 19.0, 5.86, 647.01, 17.0, 0.53, 440.83, 16.0, 2.9, 110.21, 15.0, 0.3, 419.48, 14.0, 1.3, 412.37, 13.0, 2.09, 323.51, 11.0, 0.22, 95.98, 11.0, 2.46, 117.32, 10.0, 3.14, 0.0, 9.0, 1.56, 88.87, 9.0, 2.28, 21.34, 9.0, 0.68, 216.48, 8.0, 1.27, 234.64, 8.0, 4.49, 853.2, 8.0, 3.59, 302.16, 6.0, 5.17, 103.09, 5.0, 2.59, 515.46, 4.0, 4.97, 860.31, 4.0, 0.02, 191.96, 4.0, 5.97, 654.12, 4.0, 1.6, 330.62, 4.0, 1.6, 405.26, 4.0, 3.3, 210.12, 3.0, 2.73, 522.58, 3.0, 0.75, 209.37, 3.0, 1.32, 728.76, 2.0, 1.19, 124.43, 2.0, 0.49, 447.94, 2.0, 3.28, 203.0, 2.0, 0.73, 625.67, 2.0, 6.15, 429.78, 2.0, 0.75, 295.05, 2.0, 3.89, 1066.5, 2.0, 2.0, 831.86, 2.0, 0.09, 942.06, 2.0, 0.82, 223.59, 2.0, 1.4, 224.34, 2.0, 3.02, 184.84, 2.0, 5.41, 824.74, 2.0, 5.96, 422.67, 1.0, 2.12, 529.69, 1.0, 0.72, 536.8, 1.0, 1.65, 17.41, 1.0, 1.9, 956.29, 1.0, 5.97, 195.14, 1.0, 1.12, 838.97, 1.0, 0.89, 721.65, 1.0, 1.59, 735.88, 1.0, 3.06, 1574.85, 1.0, 1.01, 1045.15, 1.0, 5.36, 316.39, 1.0, 4.93, 56.62, 1.0, 2.72, 508.35, 1.0, 1.11, 1169.59, 129.0, 5.913, 220.413, 32.0, 0.69, 7.11, 27.0, 5.91, 227.53, 20.0, 4.95, 433.71, 20.0, 0.67, 14.23, 14.0, 2.67, 206.19, 14.0, 1.46, 199.07, 13.0, 4.59, 426.6, 7.0, 4.63, 213.3, 5.0, 3.61, 639.9, 4.0, 4.9, 440.83, 3.0, 4.07, 647.01, 3.0, 4.66, 191.96, 3.0, 0.49, 323.51, 3.0, 3.18, 419.48, 2.0, 3.7, 88.87, 2.0, 3.32, 95.98, 2.0, 0.56, 117.32, 2.0, 5.33, 302.16, 2.0, 0.0, 0.0, 2.0, 2.67, 853.2, 2.0, 0.86, 515.46, 1.0, 5.83, 234.64, 1.0, 0.16, 412.37, 1.0, 5.98, 3.18, 1.0, 5.23, 216.48, 1.0, 5.05, 124.43, 1.0, 0.37, 28.45};
        return XL0;
    }

    private static double[] getXL0_7() {
        double[] XL0 = new double[]{1.0E8, 20.0, 539.0, 836.0, 980.0, 1070.0, 1085.0, 1088.0, 1193.0, 1271.0, 1307.0, 1322.0, 1325.0, 1325.0, 2150.0, 2660.0, 2936.0, 3089.0, 3122.0, 3122.0, 5.48129294E8, 0.0, 0.0, 9260408.0, 0.8910642, 74.7815986, 1504248.0, 3.6271926, 1.4844727, 365982.0, 1.899622, 73.297126, 272328.0, 3.358237, 149.563197, 70328.0, 5.39254, 63.7359, 68893.0, 6.09292, 76.26607, 61999.0, 2.26952, 2.96895, 61951.0, 2.85099, 11.0457, 26469.0, 3.14152, 71.81265, 25711.0, 6.1138, 454.90937, 21079.0, 4.36059, 148.07872, 17819.0, 1.74437, 36.64856, 14613.0, 4.73732, 3.93215, 11163.0, 5.82682, 224.3448, 10998.0, 0.48865, 138.5175, 9527.0, 2.9552, 35.1641, 7546.0, 5.2363, 109.9457, 4220.0, 3.2333, 70.8494, 4052.0, 2.2775, 151.0477, 3490.0, 5.4831, 146.5943, 3355.0, 1.0655, 4.4534, 3144.0, 4.752, 77.7505, 2927.0, 4.629, 9.5612, 2922.0, 5.3524, 85.8273, 2273.0, 4.366, 70.3282, 2149.0, 0.6075, 38.133, 2051.0, 1.5177, 0.1119, 1992.0, 4.9244, 277.035, 1667.0, 3.6274, 380.1278, 1533.0, 2.5859, 52.6902, 1376.0, 2.0428, 65.2204, 1372.0, 4.1964, 111.4302, 1284.0, 3.1135, 202.2534, 1282.0, 0.5427, 222.8603, 1244.0, 0.9161, 2.4477, 1221.0, 0.199, 108.4612, 1151.0, 4.179, 33.6796, 1150.0, 0.9334, 3.1814, 1090.0, 1.775, 12.5302, 1072.0, 0.2356, 62.2514, 946.0, 1.192, 127.472, 708.0, 5.183, 213.299, 653.0, 0.966, 78.714, 628.0, 0.182, 984.6, 607.0, 5.432, 529.691, 559.0, 3.358, 0.521, 524.0, 2.013, 299.126, 483.0, 2.106, 0.963, 471.0, 1.407, 184.727, 467.0, 0.415, 145.11, 434.0, 5.521, 183.243, 405.0, 5.987, 8.077, 399.0, 0.338, 415.552, 396.0, 5.87, 351.817, 379.0, 2.35, 56.622, 310.0, 5.833, 145.631, 300.0, 5.644, 22.091, 294.0, 5.839, 39.618, 252.0, 1.637, 221.376, 249.0, 4.746, 225.829, 239.0, 2.35, 137.033, 224.0, 0.516, 84.343, 223.0, 2.843, 0.261, 220.0, 1.922, 67.668, 217.0, 6.142, 5.938, 216.0, 4.778, 340.771, 208.0, 5.58, 68.844, 202.0, 1.297, 0.048, 199.0, 0.956, 152.532, 194.0, 1.888, 456.394, 193.0, 0.916, 453.425, 187.0, 1.319, 0.16, 182.0, 3.536, 79.235, 173.0, 1.539, 160.609, 172.0, 5.68, 219.891, 170.0, 3.677, 5.417, 169.0, 5.879, 18.159, 165.0, 1.424, 106.977, 163.0, 3.05, 112.915, 158.0, 0.738, 54.175, 147.0, 1.263, 59.804, 143.0, 1.3, 35.425, 139.0, 5.386, 32.195, 139.0, 4.26, 909.819, 124.0, 1.374, 7.114, 110.0, 2.027, 554.07, 109.0, 5.706, 77.963, 104.0, 5.028, 0.751, 104.0, 1.458, 24.379, 103.0, 0.681, 14.978, 95.0, 0.91, 74.67, 94.0, 3.94, 74.89, 89.0, 0.52, 181.76, 86.0, 1.71, 82.86, 85.0, 5.89, 256.54, 85.0, 0.37, 186.21, 83.0, 2.93, 265.99, 80.0, 3.01, 297.64, 80.0, 1.01, 6.59, 77.0, 4.59, 6.22, 75.0, 4.63, 69.36, 74.0, 6.24, 447.8, 73.0, 4.28, 87.31, 73.0, 2.85, 462.02, 70.0, 1.19, 66.7, 70.0, 0.87, 305.35, 70.0, 3.76, 131.4, 69.0, 4.44, 39.36, 62.0, 0.17, 479.29, 62.0, 3.19, 77.23, 58.0, 1.59, 60.77, 58.0, 2.67, 381.61, 58.0, 3.67, 51.21, 57.0, 1.63, 143.63, 55.0, 1.5, 71.6, 54.0, 5.52, 128.96, 50.0, 1.12, 20.61, 46.0, 4.36, 75.74, 45.0, 0.48, 14.01, 42.0, 3.82, 81.0, 40.0, 4.57, 46.21, 40.0, 0.7, 218.41, 40.0, 6.06, 293.19, 39.0, 5.59, 99.16, 39.0, 3.44, 153.5, 38.0, 6.07, 211.81, 36.0, 1.67, 258.02, 35.0, 1.97, 835.04, 35.0, 3.72, 692.59, 35.0, 1.03, 203.74, 35.0, 0.39, 1.37, 34.0, 1.08, 191.21, 34.0, 2.94, 140.0, 34.0, 6.06, 275.55, 33.0, 4.22, 200.77, 32.0, 5.51, 72.33, 30.0, 1.89, 269.92, 30.0, 3.87, 259.51, 29.0, 0.17, 528.21, 28.0, 2.18, 125.99, 27.0, 2.1, 209.37, 27.0, 4.75, 41.1, 27.0, 6.28, 28.57, 27.0, 4.48, 373.91, 26.0, 4.77, 284.15, 26.0, 5.81, 75.3, 26.0, 6.2, 134.59, 26.0, 3.63, 490.33, 26.0, 0.54, 41.64, 26.0, 0.75, 278.52, 25.0, 5.43, 116.43, 25.0, 4.71, 378.64, 24.0, 3.19, 81.37, 23.0, 3.58, 1.6, 23.0, 0.93, 288.08, 23.0, 0.53, 1514.29, 22.0, 1.84, 617.81, 22.0, 4.59, 404.51, 22.0, 5.87, 45.58, 22.0, 0.06, 173.94, 21.0, 2.74, 28.31, 21.0, 1.98, 114.4, 21.0, 5.62, 55.66, 21.0, 2.64, 105.49, 21.0, 0.89, 255.06, 20.0, 0.1, 195.14, 20.0, 3.78, 135.55, 19.0, 1.49, 0.89, 19.0, 6.22, 329.84, 19.0, 2.84, 159.12, 19.0, 0.51, 67.36, 19.0, 2.3, 5.11, 7.502543122E9, 0.0, 0.0, 154458.0, 5.242017, 74.781599, 24456.0, 1.71256, 1.48447, 9258.0, 0.4284, 11.0457, 8266.0, 1.5022, 63.7359, 7842.0, 1.3198, 149.5632, 3899.0, 0.4648, 3.9322, 2284.0, 4.1737, 76.2661, 1927.0, 0.5301, 2.9689, 1233.0, 1.5863, 70.8494, 791.0, 5.436, 3.181, 767.0, 1.996, 73.297, 482.0, 2.984, 85.827, 450.0, 4.138, 138.517, 446.0, 3.723, 224.345, 427.0, 4.731, 71.813, 354.0, 2.583, 148.079, 348.0, 2.454, 9.561, 317.0, 5.579, 52.69, 206.0, 2.363, 2.448, 189.0, 4.202, 56.622, 184.0, 0.284, 151.048, 180.0, 5.684, 12.53, 171.0, 3.001, 78.714, 158.0, 2.909, 0.963, 155.0, 5.591, 4.453, 154.0, 4.652, 35.164, 152.0, 2.942, 77.751, 143.0, 2.59, 62.251, 121.0, 4.148, 127.472, 116.0, 3.732, 65.22, 102.0, 4.188, 145.631, 102.0, 6.034, 0.112, 88.0, 3.99, 18.16, 88.0, 6.16, 202.25, 81.0, 2.64, 22.09, 72.0, 6.05, 70.33, 69.0, 4.05, 77.96, 59.0, 3.7, 67.67, 47.0, 3.54, 351.82, 44.0, 5.91, 7.11, 43.0, 5.72, 5.42, 39.0, 4.92, 222.86, 36.0, 5.9, 33.68, 36.0, 3.29, 8.08, 36.0, 3.33, 71.6, 35.0, 5.08, 38.13, 31.0, 5.62, 984.6, 31.0, 5.5, 59.8, 31.0, 5.46, 160.61, 30.0, 1.66, 447.8, 29.0, 1.15, 462.02, 29.0, 4.52, 84.34, 27.0, 5.54, 131.4, 27.0, 6.15, 299.13, 26.0, 4.99, 137.03, 25.0, 5.74, 380.13, 23.0, 2.25, 111.43, 22.0, 0.93, 213.3, 22.0, 2.81, 69.36, 19.0, 1.86, 108.46, 19.0, 3.56, 54.17, 16.0, 3.1, 14.98, 14.0, 1.54, 340.77, 14.0, 2.69, 225.83, 14.0, 4.38, 5.94, 13.0, 1.95, 87.31, 13.0, 5.88, 6.22, 12.0, 0.33, 51.21, 12.0, 3.6, 269.92, 12.0, 5.34, 152.53, 12.0, 0.33, 35.42, 12.0, 1.75, 79.24, 11.0, 3.38, 72.33, 11.0, 1.69, 45.58, 11.0, 5.97, 265.99, 11.0, 3.07, 284.15, 10.0, 4.17, 24.38, 10.0, 3.52, 529.69, 10.0, 4.65, 77.23, 10.0, 5.5, 153.5, 10.0, 1.01, 68.84, 10.0, 0.5, 209.37, 10.0, 5.6, 82.86, 9.0, 3.54, 41.64, 9.0, 3.93, 39.62, 9.0, 4.49, 20.61, 9.0, 1.97, 195.14, 9.0, 3.89, 60.77, 8.0, 4.41, 134.59, 8.0, 2.44, 146.59, 8.0, 5.73, 184.73, 8.0, 0.17, 120.36, 8.0, 5.36, 75.74, 8.0, 5.77, 73.82, 8.0, 4.44, 14.01, 7.0, 2.19, 145.11, 7.0, 4.12, 191.21, 7.0, 2.13, 116.43, 53033.0, 0.0, 0.0, 2358.0, 2.2601, 74.7816, 769.0, 4.526, 11.046, 552.0, 3.258, 63.736, 542.0, 2.276, 3.932, 529.0, 4.923, 1.484, 258.0, 3.691, 3.181, 239.0, 5.858, 149.563, 182.0, 6.218, 70.849, 54.0, 1.44, 76.27, 49.0, 6.03, 56.62, 45.0, 3.91, 2.45, 45.0, 0.81, 85.83, 38.0, 1.78, 52.69, 37.0, 4.46, 2.97, 33.0, 0.86, 9.56, 29.0, 5.1, 73.3, 24.0, 2.11, 18.16, 22.0, 5.99, 138.52, 22.0, 4.82, 78.71, 21.0, 2.4, 77.96, 21.0, 2.17, 224.34, 17.0, 2.54, 145.63, 17.0, 3.47, 12.53, 12.0, 0.02, 22.09, 11.0, 0.08, 127.47, 10.0, 5.16, 71.6, 10.0, 4.46, 62.25, 9.0, 4.26, 7.11, 8.0, 5.5, 67.67, 7.0, 1.25, 5.42, 6.0, 3.36, 447.8, 6.0, 5.45, 65.22, 6.0, 4.52, 151.05, 6.0, 5.73, 462.02, 6.0, 5.61, 148.08, 6.0, 1.83, 202.25, 5.0, 1.06, 131.4, 5.0, 3.52, 59.8, 5.0, 3.36, 4.45, 5.0, 1.2, 71.81, 4.0, 0.68, 77.75, 4.0, 1.76, 351.82, 4.0, 4.57, 454.91, 3.0, 3.84, 45.58, 3.0, 3.32, 160.61, 3.0, 6.15, 77.23, 3.0, 5.36, 269.92, 121.0, 0.024, 74.782, 68.0, 4.12, 3.93, 53.0, 2.39, 11.05, 46.0, 0.0, 0.0, 45.0, 2.04, 3.18, 44.0, 2.96, 1.48, 25.0, 4.89, 63.74, 21.0, 4.55, 70.85, 20.0, 2.31, 149.56, 9.0, 1.58, 56.62, 4.0, 0.23, 18.16, 4.0, 5.39, 76.27, 4.0, 0.95, 77.96, 3.0, 4.98, 85.83, 3.0, 4.13, 52.69, 3.0, 0.37, 78.71, 2.0, 0.86, 145.63, 2.0, 5.66, 9.56, 2.0, 2.68, 7.11, 2.0, 0.49, 71.6, 1.0, 5.2, 73.3, 1.0, 4.87, 224.34, 1.0, 1.25, 12.53, 1.0, 3.93, 22.09, 1.0, 2.19, 127.47, 1.0, 3.98, 462.02, 1.0, 5.06, 447.8, 1.0, 1.06, 138.52, 1.0, 0.35, 5.63, 1.0, 2.94, 131.4, 114.0, 3.142, 0.0, 6.0, 4.58, 74.78, 3.0, 0.35, 11.05, 1.0, 3.42, 56.62, 1.0, 4.66, 18.16, 1.0, 3.14, 0.0, 1346278.0, 2.6187781, 74.7815986, 62341.0, 5.08111, 149.5632, 61601.0, 3.14159, 0.0, 9964.0, 1.616, 76.2661, 9926.0, 0.5763, 73.2971, 3259.0, 1.2612, 224.3448, 2972.0, 2.2437, 1.4845, 2010.0, 6.0555, 148.0787, 1522.0, 0.2796, 63.7359, 924.0, 4.038, 151.048, 761.0, 6.14, 71.813, 522.0, 3.321, 138.517, 463.0, 0.743, 85.827, 437.0, 3.381, 529.691, 435.0, 0.341, 77.751, 431.0, 3.554, 213.299, 420.0, 5.213, 11.046, 245.0, 0.788, 2.969, 233.0, 2.257, 222.86, 216.0, 1.591, 38.133, 180.0, 3.725, 299.126, 175.0, 1.236, 146.594, 174.0, 1.937, 380.128, 160.0, 5.336, 111.43, 144.0, 5.962, 35.164, 116.0, 5.739, 70.849, 106.0, 0.941, 70.328, 102.0, 2.619, 78.714, 86.0, 0.7, 39.62, 73.0, 0.21, 225.83, 71.0, 0.83, 109.95, 58.0, 2.67, 108.46, 54.0, 3.35, 184.73, 44.0, 2.74, 152.53, 41.0, 3.22, 160.61, 206366.0, 4.123943, 74.781599, 8563.0, 0.3382, 149.5632, 1726.0, 2.1219, 73.2971, 1374.0, 0.0, 0.0, 1369.0, 3.0686, 76.2661, 451.0, 3.777, 1.484, 400.0, 2.848, 224.345, 307.0, 1.255, 148.079, 154.0, 3.786, 63.736, 112.0, 5.573, 151.048, 111.0, 5.329, 138.517, 83.0, 3.59, 71.81, 56.0, 3.4, 85.83, 54.0, 1.7, 77.75, 42.0, 1.21, 11.05, 41.0, 4.45, 78.71, 32.0, 3.77, 222.86, 30.0, 2.56, 2.97, 27.0, 5.34, 213.3, 26.0, 0.42, 380.13, 23.0, 2.49, 146.59, 20.0, 3.7, 70.85, 20.0, 5.93, 529.69, 20.0, 5.37, 299.13, 19.0, 3.83, 38.13, 19.0, 1.09, 111.43, 9212.0, 5.8004, 74.7816, 557.0, 0.0, 0.0, 286.0, 2.177, 149.563, 95.0, 3.84, 73.3, 45.0, 4.88, 76.27, 20.0, 5.46, 1.48, 15.0, 0.88, 138.52, 14.0, 2.85, 148.08, 14.0, 5.07, 63.74, 10.0, 5.0, 224.34, 8.0, 6.27, 78.71, 5.0, 5.16, 71.81, 268.0, 1.251, 74.782, 11.0, 3.14, 0.0, 6.0, 4.01, 149.56, 3.0, 5.78, 73.3, 2.0, 1.06, 63.74, 6.0, 2.85, 74.78, 1.921264848E9, 0.0, 0.0, 8.8784984E7, 5.60377527, 74.78159857, 3440836.0, 0.328361, 73.2971259, 2055653.0, 1.7829517, 149.5631971, 649322.0, 4.522473, 76.266071, 602248.0, 3.860038, 63.735898, 496404.0, 1.401399, 454.909367, 338526.0, 1.580027, 138.517497, 243508.0, 1.570866, 71.812653, 190522.0, 1.998094, 1.484473, 161858.0, 2.791379, 148.078724, 143706.0, 1.383686, 11.0457, 93192.0, 0.17437, 36.64856, 89806.0, 3.66105, 109.94569, 71424.0, 4.24509, 224.3448, 46677.0, 1.39977, 35.16409, 39026.0, 3.36235, 277.03499, 39010.0, 1.66971, 70.84945, 36755.0, 3.88649, 146.59425, 30349.0, 0.701, 151.04767, 29156.0, 3.18056, 77.75054, 25786.0, 3.78538, 85.8273, 25620.0, 5.25656, 380.12777, 22637.0, 0.72519, 529.69097, 20473.0, 2.7964, 70.32818, 20472.0, 1.55589, 202.2534, 17901.0, 0.55455, 2.96895, 15503.0, 5.35405, 38.13304, 14702.0, 4.90434, 108.46122, 12897.0, 2.62154, 111.43016, 12328.0, 5.96039, 127.4718, 11959.0, 1.75044, 984.60033, 11853.0, 0.99343, 52.6902, 11696.0, 3.29826, 3.93215, 11495.0, 0.43774, 65.22037, 10793.0, 1.42105, 213.2991, 9111.0, 4.9964, 62.2514, 8421.0, 5.2535, 222.8603, 8402.0, 5.0388, 415.5525, 7449.0, 0.7949, 351.8166, 7329.0, 3.9728, 183.2428, 6046.0, 5.6796, 78.7138, 5524.0, 3.115, 9.5612, 5445.0, 5.1058, 145.1098, 5238.0, 2.6296, 33.6796, 4079.0, 3.2206, 340.7709, 3919.0, 4.2502, 39.6175, 3802.0, 6.1099, 184.7273, 3781.0, 3.4584, 456.3938, 3687.0, 2.4872, 453.4249, 3102.0, 4.1403, 219.8914, 2963.0, 0.8298, 56.6224, 2942.0, 0.4239, 299.1264, 2940.0, 2.1464, 137.033, 2938.0, 3.6766, 140.002, 2865.0, 0.31, 12.5302, 2538.0, 4.8546, 131.4039, 2364.0, 0.4425, 554.07, 2183.0, 2.9404, 305.3462, 1979.0, 6.1284, 106.9767, 1963.0, 0.0411, 221.3759, 1963.0, 5.2434, 84.3428, 1849.0, 2.9111, 909.8187, 1830.0, 4.0111, 68.8437, 1656.0, 1.9643, 79.235, 1643.0, 0.3556, 67.6681, 1632.0, 4.2306, 22.0914, 1585.0, 3.1627, 225.8293, 1563.0, 1.4792, 112.9146, 1507.0, 5.2419, 181.7583, 1482.0, 5.662, 152.5321, 1477.0, 4.3221, 256.5399, 1439.0, 1.5305, 447.7958, 1409.0, 4.4192, 462.0229, 1404.0, 5.6356, 4.4534, 1401.0, 1.3908, 265.9893, 1250.0, 6.2448, 160.6089, 1249.0, 5.4403, 54.1747, 1248.0, 4.8898, 479.2884, 1228.0, 5.977, 59.8037, 1197.0, 2.5219, 145.631, 1091.0, 4.1539, 77.963, 1072.0, 1.7429, 528.2065, 906.0, 5.62, 74.67, 900.0, 2.373, 74.893, 845.0, 0.129, 82.858, 759.0, 2.137, 692.587, 719.0, 4.0, 128.956, 710.0, 5.416, 218.407, 710.0, 4.22, 381.612, 710.0, 4.49, 293.189, 705.0, 0.455, 835.037, 700.0, 0.04, 143.625, 690.0, 3.081, 69.365, 652.0, 4.423, 18.159, 642.0, 2.711, 87.312, 630.0, 4.461, 275.551, 598.0, 0.358, 269.921, 594.0, 3.838, 32.195, 594.0, 4.501, 8.077, 588.0, 5.083, 186.212, 576.0, 5.896, 66.705, 575.0, 5.579, 2.448, 570.0, 1.639, 77.229, 557.0, 1.072, 1059.382, 549.0, 5.628, 3.181, 545.0, 5.694, 203.738, 542.0, 5.395, 278.519, 540.0, 6.208, 71.6, 516.0, 3.233, 284.149, 503.0, 5.839, 191.208, 496.0, 2.651, 200.769, 488.0, 0.064, 60.767, 477.0, 2.894, 39.357, 464.0, 2.354, 211.815, 464.0, 1.434, 297.642, 455.0, 2.593, 490.334, 455.0, 4.084, 99.161, 449.0, 0.28, 617.806, 437.0, 0.528, 209.367, 436.0, 2.082, 51.206, 436.0, 2.101, 1514.291, 436.0, 2.794, 75.745, 429.0, 3.08, 41.102, 420.0, 2.254, 81.001, 414.0, 0.09, 258.024, 410.0, 3.05, 404.507, 405.0, 6.123, 24.379, 387.0, 0.686, 230.565, 380.0, 0.058, 378.643, 368.0, 0.712, 125.987, 365.0, 5.595, 255.055, 359.0, 0.009, 35.425, 359.0, 0.352, 426.598, 358.0, 4.714, 173.942, 354.0, 4.657, 329.837, 326.0, 4.72, 134.585, 324.0, 4.829, 195.14, 320.0, 5.486, 14.978, 308.0, 3.924, 116.426, 306.0, 3.761, 344.703, 305.0, 2.555, 6208.294, 302.0, 0.132, 565.116, 296.0, 4.211, 1364.728, 293.0, 3.995, 72.334, 287.0, 1.85, 153.495, 262.0, 3.837, 831.105, 256.0, 1.167, 177.874, 250.0, 4.242, 75.303, 248.0, 1.063, 105.492, 245.0, 5.949, 20.607, 241.0, 1.605, 81.374, 234.0, 2.971, 46.21, 234.0, 4.481, 628.852, 225.0, 0.407, 114.399, 220.0, 0.196, 180.274, 220.0, 2.961, 120.358, 219.0, 0.248, 294.673, 217.0, 3.429, 241.61, 211.0, 4.931, 103.093, 205.0, 2.304, 259.509, 194.0, 6.117, 414.068, 192.0, 5.767, 291.704, 189.0, 2.236, 5.417, 188.0, 2.045, 408.439, 187.0, 3.035, 135.549, 182.0, 0.784, 417.037, 182.0, 0.707, 391.173, 179.0, 4.824, 366.486, 178.0, 3.98, 10138.504, 176.0, 1.96, 756.323, 176.0, 5.508, 7.114, 172.0, 5.217, 41.644, 171.0, 2.309, 98.9, 170.0, 4.95, 206.186, 170.0, 4.51, 288.081, 169.0, 4.043, 55.659, 168.0, 5.258, 518.645, 167.0, 4.922, 422.666, 164.0, 5.225, 67.359, 162.0, 3.273, 443.864, 162.0, 4.995, 73.818, 161.0, 3.823, 451.94, 157.0, 0.663, 220.413, 155.0, 4.32, 760.256, 154.0, 4.278, 45.577, 154.0, 4.707, 543.024, 152.0, 4.647, 155.783, 146.0, 2.657, 465.955, 143.0, 2.078, 457.878, 142.0, 1.27, 159.124, 134.0, 5.309, 14.015, 133.0, 2.889, 373.908, 129.0, 0.363, 96.873, 127.0, 0.424, 331.322, 125.0, 4.305, 339.286, 123.0, 2.383, 141.486, 117.0, 3.95, 74.26, 117.0, 1.837, 1289.947, 116.0, 4.435, 5.938, 116.0, 2.512, 296.157, 115.0, 6.249, 767.369, 113.0, 4.654, 80.198, 113.0, 0.831, 100.384, 113.0, 0.081, 558.002, 112.0, 1.212, 329.725, 111.0, 0.75, 80.719, 111.0, 0.387, 216.922, 108.0, 3.773, 142.45, 107.0, 2.394, 347.884, 107.0, 1.821, 306.831, 106.0, 0.816, 1087.693, 105.0, 5.945, 328.353, 104.0, 2.994, 6.22, 103.0, 0.698, 358.93, 101.0, 1.057, 92.308, 99.0, 4.33, 74.52, 98.0, 3.73, 75.04, 97.0, 0.69, 977.49, 96.0, 5.55, 969.62, 95.0, 0.8, 342.26, 94.0, 4.54, 28.57, 94.0, 4.99, 403.13, 91.0, 5.17, 144.15, 91.0, 0.22, 333.66, 90.0, 0.37, 0.96, 90.0, 3.8, 986.08, 89.0, 2.19, 74.83, 89.0, 5.88, 74.73, 89.0, 4.74, 604.47, 89.0, 4.44, 154.02, 87.0, 5.62, 300.61, 86.0, 2.83, 983.12, 85.0, 5.8, 6.59, 85.0, 1.26, 142.14, 84.0, 1.84, 227.31, 83.0, 1.88, 387.24, 83.0, 2.21, 74.94, 83.0, 5.86, 74.62, 80.0, 2.98, 526.72, 79.0, 5.67, 267.47, 78.0, 2.73, 110.21, 76.0, 2.78, 88.11, 76.0, 4.66, 101.87, 76.0, 5.41, 50.4, 75.0, 5.37, 373.01, 75.0, 1.35, 350.33, 74.0, 6.21, 312.46, 73.0, 0.58, 367.97, 71.0, 3.17, 23.58, 71.0, 3.65, 894.84, 71.0, 0.56, 92.94, 71.0, 4.66, 44.73, 70.0, 1.52, 552.59, 70.0, 3.74, 546.96, 70.0, 3.95, 187.7, 69.0, 2.45, 555.55, 69.0, 2.42, 235.39, 69.0, 4.77, 991.71, 67.0, 0.86, 522.58, 66.0, 5.05, 30.71, 65.0, 4.24, 771.3, 65.0, 0.69, 152.74, 65.0, 3.74, 536.8, 65.0, 5.27, 68.19, 64.0, 2.37, 157.64, 64.0, 0.1, 681.54, 63.0, 4.6, 67.88, 63.0, 2.9, 79.89, 63.0, 0.29, 119.51, 63.0, 5.36, 92.05, 63.0, 0.34, 561.18, 62.0, 2.68, 130.44, 62.0, 2.32, 74.03, 61.0, 0.58, 253.57, 1479896.0, 3.6720571, 74.7815986, 71212.0, 6.22601, 63.7359, 68627.0, 6.13411, 149.5632, 24060.0, 3.14159, 0.0, 21468.0, 2.60177, 76.26607, 20857.0, 5.24625, 11.0457, 11405.0, 0.01848, 70.84945, 7497.0, 0.4236, 73.2971, 4244.0, 1.4169, 85.8273, 3927.0, 3.1551, 71.8127, 3578.0, 2.3116, 224.3448, 3506.0, 2.5835, 138.5175, 3229.0, 5.255, 3.9322, 3060.0, 0.1532, 1.4845, 2564.0, 0.9808, 148.0787, 2429.0, 3.9944, 52.6902, 1645.0, 2.6535, 127.4718, 1584.0, 1.4305, 78.7138, 1508.0, 5.06, 151.0477, 1490.0, 2.6756, 56.6224, 1413.0, 4.5746, 202.2534, 1403.0, 1.3699, 77.7505, 1228.0, 1.047, 62.2514, 1033.0, 0.2646, 131.4039, 992.0, 2.172, 65.22, 862.0, 5.055, 351.817, 744.0, 3.076, 35.164, 687.0, 2.499, 77.963, 647.0, 4.473, 70.328, 624.0, 0.863, 9.561, 604.0, 0.907, 984.6, 575.0, 3.231, 447.796, 562.0, 2.718, 462.023, 530.0, 5.917, 213.299, 528.0, 5.151, 2.969, 494.0, 0.463, 145.631, 487.0, 0.706, 380.128, 460.0, 4.223, 12.53, 444.0, 2.156, 67.668, 406.0, 1.23, 22.091, 381.0, 3.851, 3.181, 373.0, 5.051, 529.691, 348.0, 1.749, 71.6, 339.0, 2.538, 18.159, 272.0, 3.384, 222.86, 269.0, 6.241, 340.771, 259.0, 3.921, 59.804, 256.0, 2.957, 84.343, 255.0, 3.504, 38.133, 238.0, 2.049, 269.921, 234.0, 0.278, 108.461, 225.0, 3.91, 160.609, 222.0, 3.647, 137.033, 212.0, 0.68, 111.43, 206.0, 1.534, 284.149, 201.0, 1.249, 69.365, 196.0, 4.772, 299.126, 189.0, 4.413, 265.989, 163.0, 4.341, 33.68, 153.0, 5.218, 209.367, 151.0, 1.99, 54.175, 137.0, 0.403, 195.14, 128.0, 2.403, 39.618, 117.0, 0.396, 87.312, 107.0, 1.23, 225.829, 106.0, 0.698, 2.448, 106.0, 0.171, 79.235, 105.0, 4.436, 305.346, 104.0, 2.922, 134.585, 104.0, 1.816, 72.334, 104.0, 2.576, 191.208, 100.0, 4.941, 120.358, 97.0, 3.81, 152.53, 95.0, 4.03, 82.86, 94.0, 5.02, 51.21, 93.0, 3.09, 77.23, 86.0, 0.53, 145.11, 85.0, 0.62, 116.43, 85.0, 5.72, 68.84, 85.0, 5.56, 344.7, 78.0, 1.64, 479.29, 77.0, 0.08, 45.58, 76.0, 4.2, 73.82, 76.0, 3.79, 75.74, 72.0, 4.31, 565.12, 72.0, 3.71, 408.44, 72.0, 3.94, 153.5, 71.0, 2.38, 60.77, 65.0, 1.56, 106.98, 64.0, 1.94, 41.64, 63.0, 4.19, 184.73, 62.0, 3.24, 422.67, 62.0, 4.39, 453.42, 62.0, 3.9, 4.45, 60.0, 0.6, 74.89, 59.0, 1.56, 456.39, 58.0, 5.33, 220.41, 57.0, 0.84, 146.59, 55.0, 1.6, 14.98, 54.0, 3.73, 7.11, 53.0, 4.45, 426.6, 53.0, 5.2, 358.93, 53.0, 3.5, 125.99, 52.0, 6.09, 404.51, 52.0, 1.76, 8.08, 51.0, 0.37, 206.19, 51.0, 0.53, 490.33, 49.0, 5.85, 112.91, 49.0, 4.26, 5.42, 49.0, 0.94, 99.16, 49.0, 3.63, 81.0, 48.0, 1.97, 288.08, 46.0, 5.35, 152.74, 44.0, 3.04, 20.61, 43.0, 1.26, 1514.29, 42.0, 0.05, 128.96, 42.0, 2.51, 24.38, 41.0, 2.34, 277.03, 40.0, 5.1, 35.42, 39.0, 5.49, 200.77, 39.0, 0.74, 347.88, 39.0, 4.95, 92.94, 38.0, 2.06, 333.66, 38.0, 3.62, 173.94, 36.0, 3.73, 96.87, 34.0, 3.68, 66.92, 33.0, 6.26, 1059.38, 33.0, 1.38, 74.67, 32.0, 4.38, 221.38, 32.0, 0.54, 203.74, 31.0, 0.8, 373.01, 31.0, 2.05, 230.56, 31.0, 2.54, 977.49, 30.0, 0.71, 109.95, 30.0, 0.19, 387.24, 29.0, 5.43, 58.11, 29.0, 3.11, 991.71, 28.0, 4.77, 415.55, 28.0, 0.37, 80.2, 27.0, 2.15, 140.0, 27.0, 2.03, 536.8, 27.0, 1.36, 0.96, 26.0, 4.53, 454.91, 26.0, 3.47, 144.15, 26.0, 5.43, 546.96, 26.0, 2.57, 522.58, 25.0, 1.8, 143.63, 25.0, 5.12, 81.37, 25.0, 0.55, 181.76, 25.0, 3.04, 14.01, 24.0, 3.3, 617.81, 24.0, 2.2, 628.85, 24.0, 5.67, 443.86, 24.0, 5.6, 32.2, 24.0, 4.95, 561.18, 24.0, 0.66, 46.21, 23.0, 3.81, 55.14, 23.0, 5.85, 297.64, 22.0, 4.82, 135.55, 22.0, 4.62, 391.17, 22.0, 4.59, 241.61, 22.0, 1.23, 41.1, 21.0, 5.27, 159.12, 21.0, 4.19, 329.73, 21.0, 0.24, 465.96, 21.0, 0.91, 76.48, 20.0, 3.16, 186.21, 20.0, 0.66, 66.7, 20.0, 1.3, 518.65, 20.0, 4.91, 909.82, 22440.0, 0.69953, 74.7816, 4727.0, 1.699, 63.7359, 1682.0, 4.6483, 70.8494, 1650.0, 3.0966, 11.0457, 1434.0, 3.5212, 149.5632, 770.0, 0.0, 0.0, 500.0, 6.172, 76.266, 461.0, 0.767, 3.932, 390.0, 4.496, 56.622, 390.0, 5.527, 85.827, 292.0, 0.204, 52.69, 287.0, 3.534, 73.297, 273.0, 3.847, 138.517, 220.0, 1.964, 131.404, 216.0, 0.848, 77.963, 205.0, 3.248, 78.714, 149.0, 4.898, 127.472, 129.0, 2.081, 3.181, 117.0, 4.934, 447.796, 114.0, 4.787, 145.631, 113.0, 1.014, 462.023, 104.0, 3.586, 71.6, 99.0, 6.16, 224.34, 91.0, 0.68, 18.16, 89.0, 0.23, 202.25, 88.0, 2.93, 62.25, 71.0, 6.1, 454.91, 64.0, 3.39, 1.48, 64.0, 3.96, 67.67, 62.0, 3.3, 351.82, 59.0, 5.56, 9.56, 58.0, 4.91, 22.09, 51.0, 3.87, 65.22, 49.0, 3.75, 269.92, 44.0, 5.9, 71.81, 44.0, 1.93, 59.8, 42.0, 6.14, 284.15, 42.0, 2.62, 151.05, 42.0, 2.09, 12.53, 37.0, 5.91, 984.6, 36.0, 5.4, 77.75, 31.0, 4.59, 148.08, 31.0, 2.27, 195.14, 28.0, 4.58, 77.23, 28.0, 4.91, 277.03, 27.0, 3.53, 209.37, 26.0, 0.66, 120.36, 24.0, 5.87, 69.36, 23.0, 1.04, 84.34, 23.0, 1.71, 160.61, 21.0, 2.2, 45.58, 20.0, 2.32, 2.45, 17.0, 4.37, 54.17, 17.0, 4.78, 213.3, 17.0, 1.86, 340.77, 16.0, 0.4, 265.99, 16.0, 3.65, 152.74, 15.0, 5.44, 408.44, 14.0, 3.39, 358.93, 13.0, 1.53, 422.67, 13.0, 5.25, 137.03, 13.0, 1.26, 134.59, 13.0, 4.43, 87.31, 13.0, 3.03, 92.94, 12.0, 1.33, 51.21, 12.0, 3.24, 116.43, 12.0, 5.1, 191.21, 12.0, 4.66, 41.64, 12.0, 3.73, 220.41, 12.0, 4.17, 60.55, 11.0, 2.03, 7.11, 11.0, 1.08, 72.33, 10.0, 1.19, 344.7, 10.0, 0.33, 70.33, 10.0, 5.97, 35.16, 10.0, 3.06, 2.97, 10.0, 0.39, 415.55, 9.0, 2.44, 565.12, 9.0, 6.05, 146.38, 9.0, 5.19, 225.83, 9.0, 6.01, 5.42, 9.0, 5.82, 153.5, 9.0, 5.25, 347.88, 8.0, 3.91, 333.66, 8.0, 4.49, 70.12, 8.0, 3.72, 14.98, 8.0, 2.27, 299.13, 8.0, 2.26, 206.19, 8.0, 5.72, 55.14, 8.0, 0.9, 222.86, 7.0, 1.51, 991.71, 7.0, 1.18, 96.87, 1164.0, 4.7345, 74.7816, 212.0, 3.343, 63.736, 196.0, 2.98, 70.849, 105.0, 0.958, 11.046, 73.0, 1.0, 149.56, 72.0, 0.03, 56.62, 55.0, 2.59, 3.93, 36.0, 5.65, 77.96, 34.0, 3.82, 76.27, 32.0, 3.6, 131.4, 30.0, 3.44, 85.83, 28.0, 0.43, 3.18, 27.0, 2.55, 52.69, 25.0, 5.14, 78.71, 19.0, 5.13, 18.16, 18.0, 0.0, 0.0, 16.0, 5.2, 71.6, 16.0, 0.37, 447.8, 15.0, 2.97, 145.63, 15.0, 5.57, 462.02, 15.0, 3.86, 73.3, 11.0, 6.03, 138.52, 11.0, 3.58, 224.34, 8.0, 2.62, 22.09, 8.0, 0.3, 127.47, 8.0, 1.45, 1.48, 7.0, 5.44, 269.92, 7.0, 0.01, 151.05, 6.0, 4.37, 284.15, 6.0, 4.23, 373.01, 5.0, 4.16, 195.14, 5.0, 0.78, 62.25, 5.0, 1.84, 202.25, 5.0, 2.78, 120.36, 4.0, 3.96, 9.56, 4.0, 1.84, 72.33, 4.0, 1.86, 152.74, 4.0, 1.89, 209.37, 4.0, 1.05, 92.94, 4.0, 2.0, 65.22, 4.0, 1.17, 153.5, 4.0, 3.93, 124.29, 3.0, 1.54, 148.08, 3.0, 1.41, 351.82, 3.0, 2.99, 387.24, 3.0, 5.84, 160.61, 3.0, 6.04, 12.53, 3.0, 0.79, 572.23, 3.0, 5.65, 134.59, 3.0, 2.77, 213.3, 3.0, 1.99, 450.98, 53.0, 3.01, 74.78, 10.0, 1.91, 56.62, 7.0, 5.09, 11.05, 7.0, 5.43, 149.56, 4.0, 5.23, 131.4, 3.0, 1.3, 85.83, 3.0, 3.14, 0.0, 3.0, 0.44, 63.74, 2.0, 6.21, 358.93, 2.0, 0.92, 145.63, 2.0, 2.23, 440.68};
        return XL0;
    }

    private static double[] getXL0_8() {
        double[] XL0 = new double[]{1.0E8, 20.0, 188.0, 260.0, 281.0, 293.0, 299.0, 302.0, 359.0, 404.0, 419.0, 422.0, 425.0, 425.0, 638.0, 701.0, 743.0, 746.0, 746.0, 746.0, 5.31188633E8, 0.0, 0.0, 1798476.0, 2.9010127, 38.1330356, 1019728.0, 0.4858092, 1.4844727, 124532.0, 4.830081, 36.648563, 42064.0, 5.41055, 2.96895, 37715.0, 6.09222, 35.16409, 33785.0, 1.24489, 76.26607, 16483.0, 8.0E-5, 491.55793, 9199.0, 4.9375, 39.6175, 8994.0, 0.2746, 175.1661, 4216.0, 1.9871, 73.2971, 3365.0, 1.0359, 33.6796, 2285.0, 4.2061, 4.4534, 1434.0, 2.7834, 74.7816, 900.0, 2.076, 109.946, 745.0, 3.19, 71.813, 506.0, 5.748, 114.399, 400.0, 0.35, 1021.249, 345.0, 3.462, 41.102, 340.0, 3.304, 77.751, 323.0, 2.248, 32.195, 306.0, 0.497, 0.521, 287.0, 4.505, 0.048, 282.0, 2.246, 146.594, 267.0, 4.889, 0.963, 252.0, 5.782, 388.465, 245.0, 1.247, 9.561, 233.0, 2.505, 137.033, 227.0, 1.797, 453.425, 170.0, 3.324, 108.461, 151.0, 2.192, 33.94, 150.0, 2.997, 5.938, 148.0, 0.859, 111.43, 119.0, 3.677, 2.448, 109.0, 2.416, 183.243, 103.0, 0.041, 0.261, 103.0, 4.404, 70.328, 102.0, 5.705, 0.112, 98.0, 2.81, 8.08, 86.0, 4.23, 490.07, 82.0, 5.2, 493.04, 78.0, 4.16, 4.19, 74.0, 1.33, 529.69, 72.0, 5.3, 350.33, 64.0, 3.55, 168.05, 63.0, 0.15, 182.28, 58.0, 3.5, 145.11, 48.0, 1.11, 112.91, 48.0, 0.13, 484.44, 48.0, 2.58, 219.89, 47.0, 4.57, 46.21, 47.0, 4.5, 173.68, 47.0, 3.02, 498.67, 45.0, 5.47, 176.65, 39.0, 1.67, 213.3, 39.0, 2.39, 2.92, 3.837687717E9, 0.0, 0.0, 16604.0, 4.86319, 1.48447, 15807.0, 2.27923, 38.13304, 3335.0, 3.682, 76.2661, 1306.0, 3.6732, 2.9689, 605.0, 1.505, 35.164, 179.0, 3.453, 39.618, 107.0, 2.451, 4.453, 106.0, 2.755, 33.68, 73.0, 5.49, 36.65, 57.0, 1.86, 114.4, 57.0, 5.22, 0.52, 35.0, 4.52, 74.78, 32.0, 5.9, 77.75, 30.0, 3.67, 388.47, 29.0, 5.17, 9.56, 29.0, 5.17, 2.45, 26.0, 5.25, 168.05, 25.0, 4.73, 182.28, 20.0, 5.79, 1021.25, 19.0, 1.83, 484.44, 19.0, 1.32, 498.67, 15.0, 3.99, 32.2, 15.0, 4.95, 137.03, 53893.0, 0.0, 0.0, 296.0, 1.855, 1.484, 281.0, 1.191, 38.133, 270.0, 5.721, 76.266, 23.0, 1.21, 2.97, 9.0, 4.43, 35.16, 7.0, 0.54, 2.45, 31.0, 0.0, 0.0, 15.0, 1.35, 76.27, 12.0, 6.04, 1.48, 12.0, 6.11, 38.13, 114.0, 3.142, 0.0, 1.0, 3.18, 76.27, 1.0, 3.14, 0.0, 3088623.0, 1.4410437, 38.1330356, 27780.0, 5.91272, 76.26607, 27624.0, 0.0, 0.0, 15448.0, 3.50877, 39.61751, 15355.0, 2.52124, 36.64856, 2000.0, 1.51, 74.7816, 1968.0, 4.3778, 1.4845, 1015.0, 3.2156, 35.1641, 606.0, 2.802, 73.297, 595.0, 2.129, 41.102, 589.0, 3.187, 2.969, 402.0, 4.169, 114.399, 280.0, 1.682, 77.751, 262.0, 3.767, 213.299, 254.0, 3.271, 453.425, 206.0, 4.257, 529.691, 140.0, 3.53, 137.033, 99.0, 4.17, 33.68, 68.0, 4.67, 71.81, 227279.0, 3.807931, 38.133036, 1803.0, 1.9758, 76.2661, 1433.0, 3.1416, 0.0, 1386.0, 4.8256, 36.6486, 1073.0, 6.0805, 39.6175, 148.0, 3.858, 74.782, 136.0, 0.478, 1.484, 70.0, 6.19, 35.16, 52.0, 5.05, 73.3, 43.0, 0.31, 114.4, 37.0, 4.89, 41.1, 37.0, 5.76, 2.97, 26.0, 5.22, 213.3, 19.0, 0.9, 453.42, 17.0, 4.26, 77.75, 9691.0, 5.5712, 38.133, 79.0, 3.63, 76.27, 72.0, 0.45, 36.65, 59.0, 3.14, 0.0, 30.0, 1.61, 39.62, 273.0, 1.017, 38.133, 6.0, 2.67, 38.13, 3.007013206E9, 0.0, 0.0, 2.7062259E7, 1.32999459, 38.13303564, 1691764.0, 3.2518614, 36.6485629, 807831.0, 5.185928, 1.484473, 537761.0, 4.521139, 35.16409, 495726.0, 1.571057, 491.557929, 274572.0, 1.845523, 175.16606, 135134.0, 3.372206, 39.617508, 121802.0, 5.797544, 76.266071, 100895.0, 0.377027, 73.297126, 69792.0, 3.79617, 2.96895, 46688.0, 5.74938, 33.67962, 24594.0, 0.50802, 109.94569, 16939.0, 1.59422, 71.81265, 14230.0, 1.07786, 74.7816, 12012.0, 1.92062, 1021.24889, 8395.0, 0.6782, 146.5943, 7572.0, 1.0715, 388.4652, 5721.0, 2.5906, 4.4534, 4840.0, 1.9069, 41.102, 4483.0, 2.9057, 529.691, 4421.0, 1.7499, 108.4612, 4354.0, 0.6799, 32.1951, 4270.0, 3.4134, 453.4249, 3381.0, 0.8481, 183.2428, 2881.0, 1.986, 137.033, 2879.0, 3.6742, 350.3321, 2636.0, 3.0976, 213.2991, 2530.0, 5.7984, 490.0735, 2523.0, 0.4863, 493.0424, 2306.0, 2.8096, 70.3282, 2087.0, 0.6186, 33.9402, 1977.0, 5.117, 168.0525, 1905.0, 1.7219, 182.2796, 1654.0, 1.9278, 145.1098, 1499.0, 1.0162, 219.8914, 1435.0, 1.7001, 484.4444, 1403.0, 6.0766, 173.6816, 1403.0, 4.5891, 498.6715, 1399.0, 0.7622, 176.6505, 1228.0, 1.5988, 77.7505, 1129.0, 5.9666, 9.5612, 835.0, 3.971, 114.399, 811.0, 3.003, 46.21, 732.0, 2.104, 181.758, 705.0, 1.187, 256.54, 616.0, 2.979, 106.977, 530.0, 4.241, 111.43, 502.0, 1.387, 5.938, 437.0, 2.27, 1550.94, 422.0, 5.532, 525.498, 421.0, 1.891, 30.711, 400.0, 1.256, 8.077, 382.0, 3.3, 983.116, 355.0, 2.278, 218.407, 345.0, 1.359, 293.189, 333.0, 5.751, 39.096, 321.0, 1.506, 454.909, 314.0, 3.959, 381.352, 309.0, 2.855, 72.073, 307.0, 0.32, 601.764, 306.0, 2.725, 6244.943, 294.0, 4.891, 528.206, 292.0, 4.024, 68.844, 281.0, 4.542, 44.725, 280.0, 1.541, 98.9, 268.0, 5.133, 112.915, 251.0, 3.54, 312.199, 248.0, 3.411, 37.612, 246.0, 1.015, 141.226, 240.0, 3.164, 143.625, 236339.0, 0.70498, 38.133036, 13220.0, 3.32015, 1.48447, 8622.0, 6.2163, 35.1641, 2702.0, 1.8814, 39.6175, 2155.0, 2.0943, 2.9689, 2153.0, 5.1687, 76.2661, 1603.0, 0.0, 0.0, 1464.0, 1.1842, 33.6796, 1136.0, 3.9189, 36.6486, 898.0, 5.241, 388.465, 790.0, 0.533, 168.053, 760.0, 0.021, 182.28, 607.0, 1.077, 1021.249, 572.0, 3.401, 484.444, 561.0, 2.887, 498.671, 490.0, 3.468, 137.033, 271.0, 3.274, 71.813, 264.0, 0.862, 4.453, 204.0, 2.418, 32.195, 155.0, 0.365, 41.102, 133.0, 3.602, 9.561, 4247.0, 5.8991, 38.133, 218.0, 0.346, 1.484, 163.0, 2.239, 168.053, 156.0, 4.594, 182.28, 127.0, 2.848, 35.164, 118.0, 5.103, 484.444, 112.0, 1.19, 498.671, 99.0, 3.42, 175.17, 77.0, 0.02, 491.56, 65.0, 3.46, 388.47, 50.0, 4.07, 76.27, 39.0, 6.1, 1021.25, 37.0, 5.97, 2.97, 36.0, 5.17, 137.03, 166.0, 4.552, 38.133};
        return XL0;
    }

    public static double XL0_calc(int xt, int zn, double t, int n) {
        t /= 10.0;
        double v = 0.0;
        double tn = 1.0;
        double c = 0.0;
        double[] F = XL0[xt];
        int pn = zn * 6 + 1;
        double N0 = F[pn + 1] - F[pn];
        int i = 0;
        while (i < 6) {
            int n1 = (int)F[pn + i];
            int n2 = (int)F[pn + 1 + i];
            double n0 = n2 - n1;
            if (n != 0) {
                int N;
                if (n < 0) {
                    N = n2;
                } else {
                    N = (int)Math.floor((double)(3 * n) * n0 / N0 + 0.5) + n1;
                    if (i != 0) {
                        N += 3;
                    }
                    if (N > n2) {
                        N = n2;
                    }
                }
                c = 0.0;
                for (int j = n1; j < N; j += 3) {
                    c += F[j] * Math.cos(F[j + 1] + t * F[j + 2]);
                }
                v += c * tn;
            }
            ++i;
            tn *= t;
        }
        v /= F[0];
        if (xt == 0) {
            double t2 = t * t;
            double t3 = t2 * t;
            if (zn == 0) {
                v += (-0.0728 - 2.7702 * t - 1.1019 * t2 - 0.0996 * t3) / 206264.80624709636;
            }
            if (zn == 1) {
                v += (0.0 + 4.0E-4 * t + 4.0E-4 * t2 - 0.0026 * t3) / 206264.80624709636;
            }
            if (zn == 2) {
                v += (-0.002 + 0.0044 * t + 0.0213 * t2 - 0.025 * t3) / 1000000.0;
            }
        } else {
            double dv = XL0_xzb[(xt - 1) * 3 + zn];
            if (zn == 0) {
                v += -3.0 * t / 206264.80624709636;
            }
            v = zn == 2 ? (v += dv / 1000000.0) : (v += dv / 206264.80624709636);
        }
        return v;
    }

    public static double XL1_calc(int zn, double t, int n) {
        double[][] ob = XL1[zn];
        double tn = 1.0;
        BigDecimal v = new BigDecimal(0);
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double tx = t - 10.0;
        if (zn == 0) {
            v = v.add(new BigDecimal((3.81034409 + 8399.684730072 * t - 3.319E-5 * t2 + 3.11E-8 * t3 - 2.033E-10 * t4) * 206264.80624709636));
            v = v.add(new BigDecimal(5028.792262 * t + 1.1124406 * t2 + 7.699E-5 * t3 - 2.3479E-5 * t4 - 1.78E-8 * t5));
            if (tx > 0.0) {
                v = v.add(new BigDecimal(-0.866 + 1.43 * tx + 0.054 * tx * tx));
            }
        }
        t2 /= 10000.0;
        t3 /= 1.0E8;
        t4 /= 1.0E8;
        if ((n *= 6) < 0) {
            n = ob[0].length;
        }
        int i = 0;
        while (i < ob.length) {
            double[] F = ob[i];
            int N = (int)Math.floor((double)(n * F.length / ob[0].length) + 0.5);
            if (i != 0) {
                N += 6;
            }
            if (N >= F.length) {
                N = F.length;
            }
            BigDecimal c = new BigDecimal("0.0");
            for (int j = 0; j < N; j += 6) {
                c = c.add(new BigDecimal(F[j] * Math.cos(F[j + 1] + t * F[j + 2] + t2 * F[j + 3] + t3 * F[j + 4] + t4 * F[j + 5])));
            }
            v = v.add(c.multiply(new BigDecimal(tn)));
            ++i;
            tn *= t;
        }
        if (zn != 2) {
            v = v.divide(new BigDecimal(206264.80624709636), 13, 4);
        }
        return v.doubleValue();
    }

    public static int year2Ayear(String c) {
        int year;
        Pattern pattern = Pattern.compile("[^0-9Bb*-]");
        String y = pattern.matcher(c).replaceAll("");
        pattern = Pattern.compile("[Bb*-]{2,}");
        y = pattern.matcher(y).replaceFirst("B");
        String q = CommonUtils.subString(y, 0, 1);
        if (q.equals("B") || q.equals("b") || q.equals("*")) {
            year = 1 - Integer.parseInt(CommonUtils.subString(y, 1));
            if (year > 0) {
                throw new AlmanacException("\u901a\u7528\u7eaa\u6cd5\u7684\u516c\u5143\u524d\u7eaa\u6cd5\u4eceB.C.1\u5e74\u5f00\u59cb\u3002\u5e76\u4e14\u6ca1\u6709\u516c\u51430\u5e74");
            }
        } else {
            year = Integer.parseInt(y);
        }
        if (year < -4712) {
            throw new AlmanacException("\u8d85\u8fc7B.C. 4713\u4e0d\u51c6");
        }
        if (year > 9999) {
            throw new AlmanacException("\u8d85\u8fc79999\u5e74\u7684\u519c\u5386\u8ba1\u7b97\u5f88\u4e0d\u51c6\u3002");
        }
        return year;
    }

    /*
     * Opcode count of 29006 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        CommonUtils.XL0[0] = CommonUtils.getXL0_1();
        CommonUtils.XL0[1] = CommonUtils.getXL0_2();
        CommonUtils.XL0[2] = CommonUtils.getXL0_3();
        CommonUtils.XL0[3] = CommonUtils.getXL0_4();
        CommonUtils.XL0[4] = CommonUtils.getXL0_5();
        CommonUtils.XL0[5] = CommonUtils.getXL0_6();
        CommonUtils.XL0[6] = CommonUtils.getXL0_7();
        CommonUtils.XL0[7] = CommonUtils.getXL0_8();
        XL0_xzb = new double[]{-0.08631, 3.9E-4, -8.0E-5, -0.07447, 6.0E-5, 1.7E-4, -0.07135, -2.6E-4, -0.00176, -0.20239, 0.00273, -0.00347, -0.25486, 0.00276, 0.42926, 0.24588, 0.00345, -14.46266, -0.95116, 0.02481, 58.30651};
        XL1 = new double[][][]{new double[][]{{22639.586, 0.78475822, 8328.691424623, 1.5229241, 25.0719, -0.123598, 4586.438, 0.1873974, 7214.06286536, -2.184756, -18.86, 0.0828, 2369.914, 2.542952, 15542.75428998, -0.661832, 6.212, -0.0408, 769.026, 3.140313, 16657.38284925, 3.04585, 50.144, -0.2472, 666.418, 1.527671, 628.30195521, -0.02664, 0.062, -0.0054, 411.596, 4.826607, 16866.932315, -1.28012, -1.07, -0.0059, 211.656, 4.115028, -1114.6285593, -3.70768, -43.93, 0.2064, 205.436, 0.230523, 6585.7609101, -2.15812, -18.92, 0.0882, 191.956, 4.898507, 23871.4457146, 0.86109, 31.28, -0.164, 164.729, 2.586078, 14914.4523348, -0.6352, 6.15, -0.035, 147.321, 5.4553, -7700.3894694, -1.5496, -25.01, 0.118, 124.988, 0.48608, 7771.377145, -0.3309, 3.11, -0.02, 109.38, 3.88323, 8956.9933798, 1.4963, 25.13, -0.129, 55.177, 5.57033, -1324.178025, 0.6183, 7.3, -0.035, 45.1, 0.89898, 25195.62374, 0.2428, 24.0, -0.129, 39.533, 3.81213, -8538.24089, 2.803, 26.1, -0.118, 38.43, 4.30115, 22756.817155, -2.8466, -12.6, 0.042, 36.124, 5.49587, 24986.074274, 4.5688, 75.2, -0.371, 30.773, 1.94559, 14428.125731, -4.3695, -37.7, 0.166, 28.397, 3.28586, 7842.364821, -2.2114, -18.8, 0.077, 24.358, 5.64142, 16171.056245, -0.6885, 6.3, -0.046, 18.585, 4.41371, -557.31428, -1.8538, -22.0, 0.1, 17.954, 3.58454, 8399.6791, -0.3576, 3.2, -0.03, 14.53, 4.9416, 23243.143759, 0.888, 31.2, -0.16, 14.38, 0.9709, 32200.137139, 2.384, 56.4, -0.29, 14.251, 5.7641, -2.3012, 1.523, 25.1, -0.12, 13.899, 0.3735, 31085.50858, -1.324, 12.4, -0.08, 13.194, 1.7595, -9443.319984, -5.231, -69.0, 0.33, 9.679, 3.0997, -16029.080894, -3.072, -50.1, 0.24, 9.366, 0.3016, 24080.99518, -3.465, -19.9, 0.08, 8.606, 4.1582, -1742.930514, -3.681, -44.0, 0.21, 8.453, 2.8416, 16100.06857, 1.192, 28.2, -0.14, 8.05, 2.6292, 14286.15038, -0.609, 6.1, -0.03, 7.63, 6.2388, 17285.684804, 3.019, 50.2, -0.25, 7.447, 1.4845, 1256.60391, -0.053, 0.1, -0.01, 7.371, 0.2736, 5957.458955, -2.131, -19.0, 0.09, 7.063, 5.6715, 33.757047, -0.308, -3.6, 0.02, 6.383, 4.7843, 7004.5134, 2.141, 32.4, -0.16, 5.742, 2.6572, 32409.686605, -1.942, 5.0, -0.05, 4.374, 4.3443, 22128.5152, -2.82, -13.0, 0.05, 3.998, 3.2545, 33524.31516, 1.766, 49.0, -0.25, 3.21, 2.2443, 14985.44001, -2.516, -16.0, 0.06, 2.915, 1.7138, 24499.74767, 0.834, 31.0, -0.17, 2.732, 1.9887, 13799.82378, -4.343, -38.0, 0.17, 2.568, 5.4122, -7072.08751, -1.576, -25.0, 0.11, 2.521, 3.2427, 8470.66678, -2.238, -19.0, 0.07, 2.489, 4.0719, -486.3266, -3.734, -44.0, 0.2, 2.146, 5.6135, -1952.47998, 0.645, 7.0, -0.03, 1.978, 2.7291, 39414.2, 0.199, 37.0, -0.21, 1.934, 1.5682, 33314.7657, 6.092, 100.0, -0.5, 1.871, 0.4166, 30457.20662, -1.297, 12.0, -0.1, 1.753, 2.0582, -8886.0057, -3.38, -47.0, 0.2, 1.437, 2.386, -695.87607, 0.59, 7.0, 0.0, 1.373, 3.026, -209.54947, 4.33, 51.0, -0.2, 1.262, 5.94, 16728.37052, 1.17, 28.0, -0.1, 1.224, 6.172, 6656.74859, -4.04, -41.0, 0.2, 1.187, 5.873, 6099.43431, -5.89, -63.0, 0.3, 1.177, 1.014, 31571.83518, 2.41, 56.0, -0.3, 1.162, 3.84, 9585.29534, 1.47, 25.0, -0.1, 1.143, 5.639, 8364.73984, -2.18, -19.0, 0.1, 1.078, 1.229, 70.98768, -1.88, -22.0, 0.1, 1.059, 3.326, 40528.82856, 3.91, 81.0, -0.4, 0.99, 5.013, 40738.37803, -0.42, 30.0, -0.2, 0.948, 5.687, -17772.01141, -6.75, -94.0, 0.5, 0.876, 0.298, -0.35232, 0.0, 0.0, 0.0, 0.822, 2.994, 393.02097, 0.0, 0.0, 0.0, 0.788, 1.836, 8326.39022, 3.05, 50.0, -0.2, 0.752, 4.985, 22614.8418, 0.91, 31.0, -0.2, 0.74, 2.875, 8330.99262, 0.0, 0.0, 0.0, 0.669, 0.744, -24357.77232, -4.6, -75.0, 0.4, 0.644, 1.314, 8393.12577, -2.18, -19.0, 0.1, 0.639, 5.888, 575.33849, 0.0, 0.0, 0.0, 0.635, 1.116, 23385.11911, -2.87, -13.0, 0.0, 0.584, 5.197, 24428.75999, 2.71, 53.0, -0.3, 0.583, 3.513, -9095.55517, 0.95, 4.0, 0.0, 0.572, 6.059, 29970.88002, -5.03, -32.0, 0.1, 0.565, 2.96, 0.32863, 1.52, 25.0, -0.1, 0.561, 4.001, -17981.56087, -2.43, -43.0, 0.2, 0.557, 0.529, 7143.07519, -0.3, 3.0, 0.0, 0.546, 2.311, 25614.37623, 4.54, 75.0, -0.4, 0.536, 4.229, 15752.30376, -4.99, -45.0, 0.2, 0.493, 3.316, -8294.9344, -1.83, -29.0, 0.1, 0.491, 1.744, 8362.4485, 1.21, 21.0, -0.1, 0.478, 1.803, -10071.6219, -5.2, -69.0, 0.3, 0.454, 0.857, 15333.2048, 3.66, 57.0, -0.3, 0.445, 2.071, 8311.7707, -2.18, -19.0, 0.1, 0.426, 0.345, 23452.6932, -3.44, -20.0, 0.1, 0.42, 4.941, 33733.8646, -2.56, -2.0, 0.0, 0.413, 1.642, 17495.2343, -1.31, -1.0, 0.0, 0.404, 1.458, 23314.1314, -0.99, 9.0, -0.1, 0.395, 2.132, 38299.5714, -3.51, -6.0, 0.0, 0.382, 2.7, 31781.3846, -1.92, 5.0, 0.0, 0.375, 4.827, 6376.2114, 2.17, 32.0, -0.2, 0.361, 3.867, 16833.1753, -0.97, 3.0, 0.0, 0.358, 5.044, 15056.4277, -4.4, -38.0, 0.2, 0.35, 5.157, -8257.7037, -3.4, -47.0, 0.2, 0.344, 4.233, 157.7344, 0.0, 0.0, 0.0, 0.34, 2.672, 13657.8484, -0.58, 6.0, 0.0, 0.329, 5.61, 41853.0066, 3.29, 74.0, -0.4, 0.325, 5.895, -39.8149, 0.0, 0.0, 0.0, 0.309, 4.387, 21500.2132, -2.79, -13.0, 0.1, 0.302, 1.278, 786.0419, 0.0, 0.0, 0.0, 0.302, 5.341, -24567.3218, -0.27, -24.0, 0.1, 0.301, 1.045, 5889.8848, -1.57, -12.0, 0.0, 0.294, 4.201, -2371.2325, -3.65, -44.0, 0.2, 0.293, 3.704, 21642.1886, -6.55, -57.0, 0.2, 0.29, 4.069, 32828.4391, 2.36, 56.0, -0.3, 0.289, 3.472, 31713.8105, -1.35, 12.0, -0.1, 0.285, 5.407, -33.7814, 0.31, 4.0, 0.0, 0.283, 5.998, -16.9207, -3.71, -44.0, 0.2, 0.283, 2.772, 38785.898, 0.23, 37.0, -0.2, 0.274, 5.343, 15613.742, -2.54, -16.0, 0.1, 0.263, 3.997, 25823.9257, 0.22, 24.0, -0.1, 0.254, 0.6, 24638.3095, -1.61, 2.0, 0.0, 0.253, 1.344, 6447.1991, 0.29, 10.0, -0.1, 0.25, 0.887, 141.9754, -3.76, -44.0, 0.2, 0.247, 0.317, 5329.157, -2.1, -19.0, 0.1, 0.245, 0.141, 36.0484, -3.71, -44.0, 0.2, 0.231, 2.287, 14357.1381, -2.49, -16.0, 0.1, 0.227, 5.158, 2.6298, 0.0, 0.0, 0.0, 0.219, 5.085, 47742.8914, 1.72, 63.0, -0.3, 0.211, 2.145, 6638.7244, -2.18, -19.0, 0.1, 0.201, 4.415, 39623.7495, -4.13, -14.0, 0.0, 0.194, 2.091, 588.4927, 0.0, 0.0, 0.0, 0.193, 3.057, -15400.7789, -3.1, -50.0, 0.0, 0.186, 5.598, 16799.3582, -0.72, 6.0, 0.0, 0.185, 3.886, 1150.677, 0.0, 0.0, 0.0, 0.183, 1.619, 7178.0144, 1.52, 25.0, 0.0, 0.181, 2.635, 8328.3391, 1.52, 25.0, 0.0, 0.181, 2.077, 8329.0437, 1.52, 25.0, 0.0, 0.179, 3.215, -9652.8694, -0.9, -18.0, 0.0, 0.176, 1.716, -8815.018, -5.26, -69.0, 0.0, 0.175, 5.673, 550.7553, 0.0, 0.0, 0.0, 0.17, 2.06, 31295.058, -5.6, -39.0, 0.0, 0.167, 1.239, 7211.7617, -0.7, 6.0, 0.0, 0.165, 4.499, 14967.4158, -0.7, 6.0, 0.0, 0.164, 3.595, 15540.4531, 0.9, 31.0, 0.0, 0.164, 4.237, 522.3694, 0.0, 0.0, 0.0, 0.163, 4.633, 15545.0555, -2.2, -19.0, 0.0, 0.161, 0.478, 6428.0209, -2.2, -19.0, 0.0, 0.158, 2.03, 13171.5218, -4.3, -38.0, 0.0, 0.157, 2.28, 7216.3641, -3.7, -44.0, 0.0, 0.154, 5.65, 7935.6705, 1.5, 25.0, 0.0, 0.152, 0.46, 29828.9047, -1.3, 12.0, 0.0, 0.151, 1.19, -0.7113, 0.0, 0.0, 0.0, 0.15, 1.42, 23942.4334, -1.0, 9.0, 0.0, 0.144, 2.75, 7753.3529, 1.5, 25.0, 0.0, 0.137, 2.08, 7213.7105, -2.2, -19.0, 0.0, 0.137, 1.44, 7214.4152, -2.2, -19.0, 0.0, 0.136, 4.46, -1185.6162, -1.8, -22.0, 0.0, 0.136, 3.03, 8000.1048, -2.2, -19.0, 0.0, 0.134, 2.83, 14756.7124, -0.7, 6.0, 0.0, 0.131, 5.05, 6821.0419, -2.2, -19.0, 0.0, 0.128, 5.99, -17214.6971, -4.9, -72.0, 0.0, 0.127, 5.35, 8721.7124, 1.5, 25.0, 0.0, 0.126, 4.49, 46628.2629, -2.0, 19.0, 0.0, 0.125, 5.94, 7149.6285, 1.5, 25.0, 0.0, 0.124, 1.09, 49067.0695, 1.1, 55.0, 0.0, 0.121, 2.88, 15471.7666, 1.2, 28.0, 0.0, 0.111, 3.92, 41643.4571, 7.6, 125.0, -1.0, 0.11, 1.96, 8904.0299, 1.5, 25.0, 0.0, 0.106, 3.3, -18.0489, -2.2, -19.0, 0.0, 0.105, 2.3, -4.931, 1.5, 25.0, 0.0, 0.104, 2.22, -6.559, -1.9, -22.0, 0.0, 0.101, 1.44, 1884.9059, -0.1, 0.0, 0.0, 0.1, 5.92, 5471.1324, -5.9, -63.0, 0.0, 0.099, 1.12, 15149.7333, -0.7, 6.0, 0.0, 0.096, 4.73, 15508.9972, -0.4, 10.0, 0.0, 0.095, 5.18, 7230.9835, 1.5, 25.0, 0.0, 0.093, 3.37, 39900.5266, 3.9, 81.0, 0.0, 0.092, 2.01, 25057.0619, 2.7, 53.0, 0.0, 0.092, 1.21, -79.6298, 0.0, 0.0, 0.0, 0.092, 1.65, -26310.2523, -4.0, -68.0, 0.0, 0.091, 1.01, 42062.5561, -1.0, 23.0, 0.0, 0.09, 6.1, 29342.5781, -5.0, -32.0, 0.0, 0.09, 4.43, 15542.402, -0.7, 6.0, 0.0, 0.09, 3.8, 15543.1066, -0.7, 6.0, 0.0, 0.089, 4.15, 6063.3859, -2.2, -19.0, 0.0, 0.086, 4.03, 52.9691, 0.0, 0.0, 0.0, 0.085, 0.49, 47952.4409, -2.6, 11.0, 0.0, 0.085, 1.6, 7632.8154, 2.1, 32.0, 0.0, 0.084, 0.22, 14392.0773, -0.7, 6.0, 0.0, 0.083, 6.22, 6028.4466, -4.0, -41.0, 0.0, 0.083, 0.63, -7909.9389, 2.8, 26.0, 0.0, 0.083, 5.2, -77.5523, 0.0, 0.0, 0.0, 0.082, 2.74, 8786.1467, -2.2, -19.0, 0.0, 0.08, 2.43, 9166.5428, -2.8, -26.0, 0.0, 0.08, 3.7, -25405.1732, 4.1, 27.0, 0.0, 0.078, 5.68, 48857.52, 5.4, 106.0, -1.0, 0.077, 1.85, 8315.5735, -2.2, -19.0, 0.0, 0.075, 5.46, -18191.1103, 1.9, 8.0, 0.0, 0.075, 1.41, -16238.6304, 1.3, 1.0, 0.0, 0.074, 5.06, 40110.0761, -0.4, 30.0, 0.0, 0.072, 2.1, 64.4343, -3.7, -44.0, 0.0, 0.071, 2.17, 37671.2695, -3.5, -6.0, 0.0, 0.069, 1.71, 16693.4313, -0.7, 6.0, 0.0, 0.069, 3.33, -26100.7028, -8.3, -119.0, 1.0, 0.068, 1.09, 8329.4028, 1.5, 25.0, 0.0, 0.068, 3.62, 8327.9801, 1.5, 25.0, 0.0, 0.068, 2.41, 16833.1509, -1.0, 3.0, 0.0, 0.067, 3.4, 24709.2971, -3.5, -20.0, 0.0, 0.067, 1.65, 8346.7156, -0.3, 3.0, 0.0, 0.066, 2.61, 22547.2677, 1.5, 39.0, 0.0, 0.066, 3.5, 15576.5113, -1.0, 3.0, 0.0, 0.065, 5.76, 33037.9886, -2.0, 5.0, 0.0, 0.065, 4.58, 8322.1325, -0.3, 3.0, 0.0, 0.065, 6.2, 17913.9868, 3.0, 50.0, 0.0, 0.065, 1.5, 22685.8295, -1.0, 9.0, 0.0, 0.065, 2.37, 7180.3058, -1.9, -15.0, 0.0, 0.064, 1.06, 30943.5332, 2.4, 56.0, 0.0, 0.064, 1.89, 8288.8765, 1.5, 25.0, 0.0, 0.064, 4.7, 6.0335, 0.3, 4.0, 0.0, 0.063, 2.83, 8368.5063, 1.5, 25.0, 0.0, 0.063, 5.66, -2580.7819, 0.7, 7.0, 0.0, 0.062, 3.78, 7056.3285, -2.2, -19.0, 0.0, 0.061, 1.49, 8294.91, 1.8, 29.0, 0.0, 0.061, 0.12, -10281.1714, -0.9, -18.0, 0.0, 0.061, 3.06, -8362.4729, -1.2, -21.0, 0.0, 0.061, 4.43, 8170.9571, 1.5, 25.0, 0.0, 0.059, 5.78, -13.1179, -3.7, -44.0, 0.0, 0.059, 5.97, 6625.5702, -2.2, -19.0, 0.0, 0.058, 5.01, -0.508, -0.3, 0.0, 0.0, 0.058, 2.73, 7161.0938, -2.2, -19.0, 0.0, 0.057, 0.19, 7214.0629, -2.2, -19.0, 0.0, 0.057, 4.0, 22199.5029, -4.7, -35.0, 0.0, 0.057, 5.38, 8119.142, 5.8, 76.0, 0.0, 0.056, 1.07, 7542.6495, 1.5, 25.0, 0.0, 0.056, 0.28, 8486.4258, 1.5, 25.0, 0.0, 0.054, 4.19, 16655.0816, 4.6, 75.0, 0.0, 0.053, 0.72, 7267.032, -2.2, -19.0, 0.0, 0.053, 3.12, 12.6192, 0.6, 7.0, 0.0, 0.052, 2.99, -32896.013, -1.8, -49.0, 0.0, 0.052, 3.46, 1097.708, 0.0, 0.0, 0.0, 0.051, 5.37, -6443.786, -1.6, -25.0, 0.0, 0.051, 1.35, 7789.401, -2.2, -19.0, 0.0, 0.051, 5.83, 40042.502, 0.2, 38.0, 0.0, 0.051, 3.63, 9114.733, 1.5, 25.0, 0.0, 0.05, 1.51, 8504.484, -2.5, -22.0, 0.0, 0.05, 5.23, 16659.684, 1.5, 25.0, 0.0, 0.05, 1.15, 7247.82, -2.5, -23.0, 0.0, 0.047, 0.25, -1290.421, 0.3, 0.0, 0.0, 0.047, 4.67, -32686.464, -6.1, -100.0, 0.0, 0.047, 3.49, 548.678, 0.0, 0.0, 0.0, 0.047, 2.37, 6663.308, -2.2, -19.0, 0.0, 0.046, 0.98, 1572.084, 0.0, 0.0, 0.0, 0.046, 2.04, 14954.262, -0.7, 6.0, 0.0, 0.046, 3.72, 6691.693, -2.2, -19.0, 0.0, 0.045, 6.19, -235.287, 0.0, 0.0, 0.0, 0.044, 2.96, 32967.001, -0.1, 27.0, 0.0, 0.044, 3.82, -1671.943, -5.6, -66.0, 0.0, 0.043, 5.82, 1179.063, 0.0, 0.0, 0.0, 0.043, 0.07, 34152.617, 1.7, 49.0, 0.0, 0.043, 3.71, 6514.773, -0.3, 0.0, 0.0, 0.043, 5.62, 15.732, -2.5, -23.0, 0.0, 0.043, 5.8, 8351.233, -2.2, -19.0, 0.0, 0.042, 0.27, 7740.199, 1.5, 25.0, 0.0, 0.042, 6.14, 15385.02, -0.7, 6.0, 0.0, 0.042, 6.13, 7285.051, -4.1, -41.0, 0.0, 0.041, 1.27, 32757.451, 4.2, 78.0, 0.0, 0.041, 4.46, 8275.722, 1.5, 25.0, 0.0, 0.04, 0.23, 8381.661, 1.5, 25.0, 0.0, 0.04, 5.87, -766.864, 2.5, 29.0, 0.0, 0.04, 1.66, 254.431, 0.0, 0.0, 0.0, 0.04, 0.4, 9027.981, -0.4, 0.0, 0.0, 0.04, 2.96, 7777.936, 1.5, 25.0, 0.0, 0.039, 4.67, 33943.068, 6.1, 100.0, 0.0, 0.039, 3.52, 8326.062, 1.5, 25.0, 0.0, 0.039, 3.75, 21013.887, -6.5, -57.0, 0.0, 0.039, 5.6, 606.978, 0.0, 0.0, 0.0, 0.039, 1.19, 8331.321, 1.5, 25.0, 0.0, 0.039, 2.84, 7211.433, -2.2, -19.0, 0.0, 0.038, 0.67, 7216.693, -2.2, -19.0, 0.0, 0.038, 6.22, 25161.867, 0.6, 28.0, 0.0, 0.038, 4.4, 7806.322, 1.5, 25.0, 0.0, 0.038, 4.16, 9179.168, -2.2, -19.0, 0.0, 0.037, 4.73, 14991.999, -0.7, 6.0, 0.0, 0.036, 0.35, 67.514, -0.6, -7.0, 0.0, 0.036, 3.7, 25266.611, -1.6, 0.0, 0.0, 0.036, 5.39, 16328.796, -0.7, 6.0, 0.0, 0.035, 1.44, 7174.248, -2.2, -19.0, 0.0, 0.035, 5.0, 15684.73, -4.4, -38.0, 0.0, 0.035, 0.39, -15.419, -2.2, -19.0, 0.0, 0.035, 6.07, 15020.385, -0.7, 6.0, 0.0, 0.034, 6.01, 7371.797, -2.2, -19.0, 0.0, 0.034, 0.96, -16623.626, -3.4, -54.0, 0.0, 0.033, 6.24, 9479.368, 1.5, 25.0, 0.0, 0.033, 3.21, 23661.896, 5.2, 82.0, 0.0, 0.033, 4.06, 8311.418, -2.2, -19.0, 0.0, 0.033, 2.4, 1965.105, 0.0, 0.0, 0.0, 0.033, 5.17, 15489.785, -0.7, 6.0, 0.0, 0.033, 5.03, 21986.54, 0.9, 31.0, 0.0, 0.033, 4.1, 16691.14, 2.7, 46.0, 0.0, 0.033, 5.13, 47114.589, 1.7, 63.0, 0.0, 0.033, 4.45, 8917.184, 1.5, 25.0, 0.0, 0.033, 4.23, 2.078, 0.0, 0.0, 0.0, 0.032, 2.33, 75.251, 1.5, 25.0, 0.0, 0.032, 2.1, 7253.878, -2.2, -19.0, 0.0, 0.032, 3.11, -0.224, 1.5, 25.0, 0.0, 0.032, 4.43, 16640.462, -0.7, 6.0, 0.0, 0.032, 5.68, 8328.363, 0.0, 0.0, 0.0, 0.031, 5.32, 8329.02, 3.0, 50.0, 0.0, 0.031, 3.7, 16118.093, -0.7, 6.0, 0.0, 0.03, 3.67, 16721.817, -0.7, 6.0, 0.0, 0.03, 5.27, -1881.492, -1.2, -15.0, 0.0, 0.03, 5.72, 8157.839, -2.2, -19.0, 0.0, 0.029, 5.73, -18400.313, -6.7, -94.0, 0.0, 0.029, 2.76, 16.0, -2.2, -19.0, 0.0, 0.029, 1.75, 8879.447, 1.5, 25.0, 0.0, 0.029, 0.32, 8851.061, 1.5, 25.0, 0.0, 0.029, 0.9, 14704.903, 3.7, 57.0, 0.0, 0.028, 2.9, 15595.723, -0.7, 6.0, 0.0, 0.028, 5.88, 16864.631, 0.2, 24.0, 0.0, 0.028, 0.63, 16869.234, -2.8, -26.0, 0.0, 0.028, 4.04, -18609.863, -2.4, -43.0, 0.0, 0.027, 5.83, 6727.736, -5.9, -63.0, 0.0, 0.027, 6.12, 418.752, 4.3, 51.0, 0.0, 0.027, 0.14, 41157.131, 3.9, 81.0, 0.0, 0.026, 3.8, 15.542, 0.0, 0.0, 0.0, 0.026, 1.68, 50181.698, 4.8, 99.0, -1.0, 0.026, 0.32, 315.469, 0.0, 0.0, 0.0, 0.025, 5.67, 19.188, 0.3, 0.0, 0.0, 0.025, 3.16, 62.133, -2.2, -19.0, 0.0, 0.025, 3.76, 15502.939, -0.7, 6.0, 0.0, 0.025, 4.53, 45999.961, -2.0, 19.0, 0.0, 0.024, 3.21, 837.851, -4.4, -51.0, 0.0, 0.024, 2.82, 38157.596, 0.3, 37.0, 0.0, 0.024, 5.21, 15540.124, -0.7, 6.0, 0.0, 0.024, 0.26, 14218.576, 0.0, 13.0, 0.0, 0.024, 3.01, 15545.384, -0.7, 6.0, 0.0, 0.024, 1.16, -17424.247, -0.6, -21.0, 0.0, 0.023, 2.34, -67.574, 0.6, 7.0, 0.0, 0.023, 2.44, 18.024, -1.9, -22.0, 0.0, 0.023, 3.7, 469.4, 0.0, 0.0, 0.0, 0.023, 0.72, 7136.511, -2.2, -19.0, 0.0, 0.023, 4.5, 15582.569, -0.7, 6.0, 0.0, 0.023, 2.8, -16586.395, -4.9, -72.0, 0.0, 0.023, 1.51, 80.182, 0.0, 0.0, 0.0, 0.023, 1.09, 5261.583, -1.5, -12.0, 0.0, 0.023, 0.56, 54956.954, -0.5, 44.0, 0.0, 0.023, 4.01, 8550.86, -2.2, -19.0, 0.0, 0.023, 4.46, 38995.448, -4.1, -14.0, 0.0, 0.023, 3.82, 2358.126, 0.0, 0.0, 0.0, 0.022, 3.77, 32271.125, 0.5, 34.0, 0.0, 0.022, 0.82, 15935.775, -0.7, 6.0, 0.0, 0.022, 1.07, 24013.421, -2.9, -13.0, 0.0, 0.022, 0.4, 8940.078, -2.2, -19.0, 0.0, 0.022, 2.06, 15700.489, -0.7, 6.0, 0.0, 0.022, 4.27, 15124.002, -5.0, -45.0, 0.0, 0.021, 1.16, 56071.583, 3.2, 88.0, 0.0, 0.021, 5.58, 9572.189, -2.2, -19.0, 0.0, 0.02, 1.7, -17.273, -3.7, -44.0, 0.0, 0.02, 3.05, 214.617, 0.0, 0.0, 0.0, 0.02, 4.41, 8391.048, -2.2, -19.0, 0.0, 0.02, 5.95, 23869.145, 2.4, 56.0, 0.0, 0.02, 0.42, 40947.927, -4.7, -21.0, 0.0, 0.019, 1.39, 5818.897, 0.3, 10.0, 0.0, 0.019, 0.71, 23873.747, -0.7, 6.0, 0.0, 0.019, 2.81, 7291.615, -2.2, -19.0, 0.0, 0.019, 5.09, 8428.018, -2.2, -19.0, 0.0, 0.019, 4.14, 6518.187, -1.6, -12.0, 0.0, 0.019, 3.85, 21.33, 0.0, 0.0, 0.0, 0.018, 0.66, 14445.046, -0.7, 6.0, 0.0, 0.018, 1.65, 0.966, -4.0, -48.0, 0.0, 0.018, 5.64, -17143.709, -6.8, -94.0, 0.0, 0.018, 6.01, 7736.432, -2.2, -19.0, 0.0, 0.018, 2.74, 31153.083, -1.9, 5.0, 0.0, 0.018, 4.58, 6116.355, -2.2, -19.0, 0.0, 0.018, 2.28, 46.401, 0.3, 0.0, 0.0, 0.018, 3.8, 10213.597, 1.4, 25.0, 0.0, 0.018, 2.84, 56281.132, -1.1, 36.0, 0.0, 0.018, 3.53, 8249.062, 1.5, 25.0, 0.0, 0.017, 4.43, 20871.911, -3.0, -13.0, 0.0, 0.017, 4.44, 627.596, 0.0, 0.0, 0.0, 0.017, 1.85, 628.308, 0.0, 0.0, 0.0, 0.017, 1.19, 8408.321, 2.0, 25.0, 0.0, 0.017, 1.95, 7214.056, -2.0, -19.0, 0.0, 0.017, 1.57, 7214.07, -2.0, -19.0, 0.0, 0.017, 1.65, 13870.811, -6.0, -60.0, 0.0, 0.017, 0.3, 22.542, -4.0, -44.0, 0.0, 0.017, 2.62, -119.445, 0.0, 0.0, 0.0, 0.016, 4.87, 5747.909, 2.0, 32.0, 0.0, 0.016, 4.45, 14339.108, -1.0, 6.0, 0.0, 0.016, 1.83, 41366.68, 0.0, 30.0, 0.0, 0.016, 4.53, 16309.618, -3.0, -23.0, 0.0, 0.016, 2.54, 15542.754, -1.0, 6.0, 0.0, 0.016, 6.05, 1203.646, 0.0, 0.0, 0.0, 0.015, 5.2, 2751.147, 0.0, 0.0, 0.0, 0.015, 1.8, -10699.924, -5.0, -69.0, 0.0, 0.015, 0.4, 22824.391, -3.0, -20.0, 0.0, 0.015, 2.1, 30666.756, -6.0, -39.0, 0.0, 0.015, 2.1, 6010.417, -2.0, -19.0, 0.0, 0.015, 0.7, -23729.47, -5.0, -75.0, 0.0, 0.015, 1.4, 14363.691, -1.0, 6.0, 0.0, 0.015, 5.8, 16900.689, -2.0, 0.0, 0.0, 0.015, 5.2, 23800.458, 3.0, 53.0, 0.0, 0.015, 5.3, 6035.0, -2.0, -19.0, 0.0, 0.015, 1.2, 8251.139, 2.0, 25.0, 0.0, 0.015, 3.6, -8.86, 0.0, 0.0, 0.0, 0.015, 0.8, 882.739, 0.0, 0.0, 0.0, 0.015, 3.0, 1021.329, 0.0, 0.0, 0.0, 0.015, 0.6, 23296.107, 1.0, 31.0, 0.0, 0.014, 5.4, 7227.181, 2.0, 25.0, 0.0, 0.014, 0.1, 7213.352, -2.0, -19.0, 0.0, 0.014, 4.0, 15506.706, 3.0, 50.0, 0.0, 0.014, 3.4, 7214.774, -2.0, -19.0, 0.0, 0.014, 4.6, 6665.385, -2.0, -19.0, 0.0, 0.014, 0.1, -8.636, -2.0, -22.0, 0.0, 0.014, 3.1, 15465.202, -1.0, 6.0, 0.0, 0.014, 4.9, 508.863, 0.0, 0.0, 0.0, 0.014, 3.5, 8406.244, 2.0, 25.0, 0.0, 0.014, 1.3, 13313.497, -8.0, -82.0, 0.0, 0.014, 2.8, 49276.619, -3.0, 0.0, 0.0, 0.014, 0.1, 30528.194, -3.0, -10.0, 0.0, 0.013, 1.7, 25128.05, 1.0, 31.0, 0.0, 0.013, 2.9, 14128.405, -1.0, 6.0, 0.0, 0.013, 3.4, 57395.761, 3.0, 80.0, 0.0, 0.013, 2.7, 13029.546, -1.0, 6.0, 0.0, 0.013, 3.9, 7802.556, -2.0, -19.0, 0.0, 0.013, 1.6, 8258.802, -2.0, -19.0, 0.0, 0.013, 2.2, 8417.709, -2.0, -19.0, 0.0, 0.013, 0.7, 9965.21, -2.0, -19.0, 0.0, 0.013, 3.4, 50391.247, 0.0, 48.0, 0.0, 0.013, 3.0, 7134.433, -2.0, -19.0, 0.0, 0.013, 2.9, 30599.182, -5.0, -31.0, 0.0, 0.013, 3.6, -9723.857, 1.0, 0.0, 0.0, 0.013, 4.8, 7607.084, -2.0, -19.0, 0.0, 0.012, 0.8, 23837.689, 1.0, 35.0, 0.0, 0.012, 3.6, 4.409, -4.0, -44.0, 0.0, 0.012, 5.0, 16657.031, 3.0, 50.0, 0.0, 0.012, 4.4, 16657.735, 3.0, 50.0, 0.0, 0.012, 1.1, 15578.803, -4.0, -38.0, 0.0, 0.012, 6.0, -11.49, 0.0, 0.0, 0.0, 0.012, 1.9, 8164.398, 0.0, 0.0, 0.0, 0.012, 2.4, 31852.372, -4.0, -17.0, 0.0, 0.012, 2.4, 6607.085, -2.0, -19.0, 0.0, 0.012, 4.2, 8359.87, 0.0, 0.0, 0.0, 0.012, 0.5, 5799.713, -2.0, -19.0, 0.0, 0.012, 2.7, 7220.622, 0.0, 0.0, 0.0, 0.012, 4.3, -139.72, 0.0, 0.0, 0.0, 0.012, 2.3, 13728.836, -2.0, -16.0, 0.0, 0.011, 3.6, 14912.146, 1.0, 31.0, 0.0, 0.011, 4.7, 14916.748, -2.0, -19.0, 0.0}, {1.6768, 4.66926, 628.301955, -0.0266, 0.1, -0.005, 0.51642, 3.3721, 6585.76091, -2.158, -18.9, 0.09, 0.41383, 5.7277, 14914.452335, -0.635, 6.2, -0.04, 0.37115, 3.9695, 7700.389469, 1.55, 25.0, -0.12, 0.2756, 0.7416, 8956.99338, 1.496, 25.1, -0.13, 0.24599, 4.2253, -2.3012, 1.523, 25.1, -0.12, 0.07118, 0.1443, 7842.36482, -2.211, -19.0, 0.08, 0.06128, 2.4998, 16171.05625, -0.688, 6.0, 0.0, 0.04516, 0.443, 8399.6791, -0.36, 3.0, 0.0, 0.04048, 5.771, 14286.15038, -0.61, 6.0, 0.0, 0.03747, 4.626, 1256.60391, -0.05, 0.0, 0.0, 0.03707, 3.415, 5957.45895, -2.13, -19.0, 0.1, 0.03649, 1.8, 23243.14376, 0.89, 31.0, -0.2, 0.02438, 0.042, 16029.08089, 3.07, 50.0, -0.2, 0.02165, 1.017, -1742.93051, -3.68, -44.0, 0.2, 0.01923, 3.097, 17285.6848, 3.02, 50.0, -0.3, 0.01692, 1.28, 0.3286, 1.52, 25.0, -0.1, 0.01361, 0.298, 8326.3902, 3.05, 50.0, -0.2, 0.01293, 4.013, 7072.0875, 1.58, 25.0, -0.1, 0.01276, 4.413, 8330.9926, 0.0, 0.0, 0.0, 0.0127, 0.101, 8470.6668, -2.24, -19.0, 0.1, 0.01097, 1.203, 22128.5152, -2.82, -13.0, 0.0, 0.01088, 2.545, 15542.7543, -0.66, 6.0, 0.0, 0.00835, 0.19, 7214.0629, -2.18, -19.0, 0.1, 0.00734, 4.855, 24499.7477, 0.83, 31.0, -0.2, 0.00686, 5.13, 13799.8238, -4.34, -38.0, 0.2, 0.00631, 0.93, -486.3266, -3.73, -44.0, 0.0, 0.00585, 0.699, 9585.2953, 1.5, 25.0, 0.0, 0.00566, 4.073, 8328.3391, 1.5, 25.0, 0.0, 0.00566, 0.638, 8329.0437, 1.5, 25.0, 0.0, 0.00539, 2.472, -1952.48, 0.6, 7.0, 0.0, 0.00509, 2.88, -0.7113, 0.0, 0.0, 0.0, 0.00469, 3.56, 30457.2066, -1.3, 12.0, 0.0, 0.00387, 0.78, -0.3523, 0.0, 0.0, 0.0, 0.00378, 1.84, 22614.8418, 0.9, 31.0, 0.0, 0.00362, 5.53, -695.8761, 0.6, 7.0, 0.0, 0.00317, 2.8, 16728.3705, 1.2, 28.0, 0.0, 0.00303, 6.07, 157.7344, 0.0, 0.0, 0.0, 0.003, 2.53, 33.757, -0.3, -4.0, 0.0, 0.00295, 4.16, 31571.8352, 2.4, 56.0, 0.0, 0.00289, 5.98, 7211.7617, -0.7, 6.0, 0.0, 0.00285, 2.06, 15540.4531, 0.9, 31.0, 0.0, 0.00283, 2.65, 2.6298, 0.0, 0.0, 0.0, 0.00282, 6.17, 15545.0555, -2.2, -19.0, 0.0, 0.00278, 1.23, -39.8149, 0.0, 0.0, 0.0, 0.00272, 3.82, 7216.3641, -3.7, -44.0, 0.0, 0.0027, 4.37, 70.9877, -1.9, -22.0, 0.0, 0.00256, 5.81, 13657.8484, -0.6, 6.0, 0.0, 0.00244, 5.64, -0.2237, 1.5, 25.0, 0.0, 0.0024, 2.96, 8311.7707, -2.2, -19.0, 0.0, 0.00239, 0.87, -33.7814, 0.3, 4.0, 0.0, 0.00216, 2.31, 15.9995, -2.2, -19.0, 0.0, 0.00186, 3.46, 5329.157, -2.1, -19.0, 0.0, 0.00169, 2.4, 24357.772, 4.6, 75.0, 0.0, 0.00161, 5.8, 8329.403, 1.5, 25.0, 0.0, 0.00161, 5.2, 8327.98, 1.5, 25.0, 0.0, 0.0016, 4.26, 23385.119, -2.9, -13.0, 0.0, 0.00156, 1.26, 550.755, 0.0, 0.0, 0.0, 0.00155, 1.25, 21500.213, -2.8, -13.0, 0.0, 0.00152, 0.6, -16.921, -3.7, -44.0, 0.0, 0.0015, 2.71, -79.63, 0.0, 0.0, 0.0, 0.0015, 5.29, 15.542, 0.0, 0.0, 0.0, 0.00148, 1.06, -2371.232, -3.7, -44.0, 0.0, 0.00141, 0.77, 8328.691, 1.5, 25.0, 0.0, 0.00141, 3.67, 7143.075, -0.3, 0.0, 0.0, 0.00138, 5.45, 25614.376, 4.5, 75.0, 0.0, 0.00129, 4.9, 23871.446, 0.9, 31.0, 0.0, 0.00126, 4.03, 141.975, -3.8, -44.0, 0.0, 0.00124, 6.01, 522.369, 0.0, 0.0, 0.0, 0.0012, 4.94, -10071.622, -5.2, -69.0, 0.0, 0.00118, 5.07, -15.419, -2.2, -19.0, 0.0, 0.00107, 3.49, 23452.693, -3.4, -20.0, 0.0, 0.00104, 4.78, 17495.234, -1.3, 0.0, 0.0, 0.00103, 1.44, -18.049, -2.2, -19.0, 0.0, 0.00102, 5.63, 15542.402, -0.7, 6.0, 0.0, 0.00102, 2.59, 15543.107, -0.7, 6.0, 0.0, 0.001, 4.11, -6.559, -1.9, -22.0, 0.0, 9.7E-4, 0.08, 15400.779, 3.1, 50.0, 0.0, 9.6E-4, 5.84, 31781.385, -1.9, 5.0, 0.0, 9.4E-4, 1.08, 8328.363, 0.0, 0.0, 0.0, 9.4E-4, 2.46, 16799.358, -0.7, 6.0, 0.0, 9.4E-4, 1.69, 6376.211, 2.2, 32.0, 0.0, 9.3E-4, 3.64, 8329.02, 3.0, 50.0, 0.0, 9.3E-4, 2.65, 16655.082, 4.6, 75.0, 0.0, 9.0E-4, 1.9, 15056.428, -4.4, -38.0, 0.0, 8.9E-4, 1.59, 52.969, 0.0, 0.0, 0.0, 8.8E-4, 2.02, -8257.704, -3.4, -47.0, 0.0, 8.8E-4, 3.02, 7213.711, -2.2, -19.0, 0.0, 8.7E-4, 0.5, 7214.415, -2.2, -19.0, 0.0, 8.7E-4, 0.49, 16659.684, 1.5, 25.0, 0.0, 8.2E-4, 5.64, -4.931, 1.5, 25.0, 0.0, 7.9E-4, 5.17, 13171.522, -4.3, -38.0, 0.0, 7.6E-4, 3.6, 29828.905, -1.3, 12.0, 0.0, 7.6E-4, 4.08, 24567.322, 0.3, 24.0, 0.0, 7.6E-4, 4.58, 1884.906, -0.1, 0.0, 0.0, 7.3E-4, 0.33, 31713.811, -1.4, 12.0, 0.0, 7.3E-4, 0.93, 32828.439, 2.4, 56.0, 0.0, 7.1E-4, 5.91, 38785.898, 0.2, 37.0, 0.0, 6.9E-4, 2.2, 15613.742, -2.5, -16.0, 0.0, 6.6E-4, 3.87, 15.732, -2.5, -23.0, 0.0, 6.6E-4, 0.86, 25823.926, 0.2, 24.0, 0.0, 6.5E-4, 2.52, 8170.957, 1.5, 25.0, 0.0, 6.3E-4, 0.18, 8322.132, -0.3, 0.0, 0.0, 6.0E-4, 5.84, 8326.062, 1.5, 25.0, 0.0, 6.0E-4, 5.15, 8331.321, 1.5, 25.0, 0.0, 6.0E-4, 2.18, 8486.426, 1.5, 25.0, 0.0, 5.8E-4, 2.3, -1.731, -4.0, -44.0, 0.0, 5.8E-4, 5.43, 14357.138, -2.0, -16.0, 0.0, 5.7E-4, 3.09, 8294.91, 2.0, 29.0, 0.0, 5.7E-4, 4.67, -8362.473, -1.0, -21.0, 0.0, 5.6E-4, 4.15, 16833.151, -1.0, 0.0, 0.0, 5.4E-4, 1.93, 7056.329, -2.0, -19.0, 0.0, 5.4E-4, 5.27, 8315.574, -2.0, -19.0, 0.0, 5.2E-4, 5.6, 8311.418, -2.0, -19.0, 0.0, 5.2E-4, 2.7, -77.552, 0.0, 0.0, 0.0, 5.1E-4, 4.3, 7230.984, 2.0, 25.0, 0.0, 5.0E-4, 0.4, -0.508, 0.0, 0.0, 0.0, 4.9E-4, 5.4, 7211.433, -2.0, -19.0, 0.0, 4.9E-4, 4.4, 7216.693, -2.0, -19.0, 0.0, 4.9E-4, 4.3, 16864.631, 0.0, 24.0, 0.0, 4.9E-4, 2.2, 16869.234, -3.0, -26.0, 0.0, 4.7E-4, 6.1, 627.596, 0.0, 0.0, 0.0, 4.7E-4, 5.0, 12.619, 1.0, 7.0, 0.0, 4.5E-4, 4.9, -8815.018, -5.0, -69.0, 0.0, 4.4E-4, 1.6, 62.133, -2.0, -19.0, 0.0, 4.2E-4, 2.9, -13.118, -4.0, -44.0, 0.0, 4.2E-4, 4.1, -119.445, 0.0, 0.0, 0.0, 4.1E-4, 4.3, 22756.817, -3.0, -13.0, 0.0, 4.1E-4, 3.6, 8288.877, 2.0, 25.0, 0.0, 4.0E-4, 0.5, 6663.308, -2.0, -19.0, 0.0, 4.0E-4, 1.1, 8368.506, 2.0, 25.0, 0.0, 3.9E-4, 4.1, 6443.786, 2.0, 25.0, 0.0, 3.9E-4, 3.1, 16657.383, 3.0, 50.0, 0.0, 3.8E-4, 0.1, 16657.031, 3.0, 50.0, 0.0, 3.8E-4, 3.0, 16657.735, 3.0, 50.0, 0.0, 3.8E-4, 4.6, 23942.433, -1.0, 9.0, 0.0, 3.7E-4, 4.3, 15385.02, -1.0, 6.0, 0.0, 3.7E-4, 5.0, 548.678, 0.0, 0.0, 0.0, 3.6E-4, 1.8, 7213.352, -2.0, -19.0, 0.0, 3.6E-4, 1.7, 7214.774, -2.0, -19.0, 0.0, 3.5E-4, 1.1, 7777.936, 2.0, 25.0, 0.0, 3.5E-4, 1.6, -8.86, 0.0, 0.0, 0.0, 3.5E-4, 4.4, 23869.145, 2.0, 56.0, 0.0, 3.5E-4, 2.0, 6691.693, -2.0, -19.0, 0.0, 3.4E-4, 1.3, -1185.616, -2.0, -22.0, 0.0, 3.4E-4, 2.2, 23873.747, -1.0, 6.0, 0.0, 3.3E-4, 2.0, -235.287, 0.0, 0.0, 0.0, 3.3E-4, 3.1, 17913.987, 3.0, 50.0, 0.0, 3.3E-4, 1.0, 8351.233, -2.0, -19.0, 0.0}, {0.00487, 4.6693, 628.30196, -0.027, 0.0, -0.01, 0.00228, 2.6746, -2.3012, 1.523, 25.0, -0.12, 0.0015, 3.372, 6585.76091, -2.16, -19.0, 0.1, 0.0012, 5.728, 14914.45233, -0.64, 6.0, 0.0, 0.00108, 3.969, 7700.38947, 1.55, 25.0, -0.1, 8.0E-4, 0.742, 8956.99338, 1.5, 25.0, -0.1, 2.54E-4, 6.002, 0.3286, 1.52, 25.0, -0.1, 2.1E-4, 0.144, 7842.3648, -2.21, -19.0, 0.0, 1.8E-4, 2.5, 16171.0562, -0.7, 6.0, 0.0, 1.3E-4, 0.44, 8399.6791, -0.4, 3.0, 0.0, 1.26E-4, 5.03, 8326.3902, 3.0, 50.0, 0.0, 1.2E-4, 5.77, 14286.1504, -0.6, 6.0, 0.0, 1.18E-4, 5.96, 8330.9926, 0.0, 0.0, 0.0, 1.1E-4, 1.8, 23243.1438, 0.9, 31.0, 0.0, 1.1E-4, 3.42, 5957.459, -2.1, -19.0, 0.0, 1.1E-4, 4.63, 1256.6039, -0.1, 0.0, 0.0, 9.9E-5, 4.7, -0.7113, 0.0, 0.0, 0.0, 7.0E-5, 0.04, 16029.0809, 3.1, 50.0, 0.0, 7.0E-5, 5.14, 8328.3391, 1.5, 25.0, 0.0, 7.0E-5, 5.85, 8329.0437, 1.5, 25.0, 0.0, 6.0E-5, 1.02, -1742.9305, -3.7, -44.0, 0.0, 6.0E-5, 3.1, 17285.6848, 3.0, 50.0, 0.0, 5.4E-5, 5.69, -0.352, 0.0, 0.0, 0.0, 4.3E-5, 0.52, 15.542, 0.0, 0.0, 0.0, 4.1E-5, 2.03, 2.63, 0.0, 0.0, 0.0, 4.0E-5, 0.1, 8470.667, -2.2, -19.0, 0.0, 4.0E-5, 4.01, 7072.088, 1.6, 25.0, 0.0, 3.6E-5, 2.93, -8.86, -0.3, 0.0, 0.0, 3.0E-5, 1.2, 22128.515, -2.8, -13.0, 0.0, 3.0E-5, 2.54, 15542.754, -0.7, 6.0, 0.0, 2.7E-5, 4.43, 7211.762, -0.7, 6.0, 0.0, 2.6E-5, 0.51, 15540.453, 0.9, 31.0, 0.0, 2.6E-5, 1.44, 15545.055, -2.2, -19.0, 0.0, 2.5E-5, 5.37, 7216.364, -3.7, -44.0, 0.0}, {1.2E-5, 1.041, -2.3012, 1.52, 25.0, -0.1, 1.7E-6, 0.31, -0.711, 0.0, 0.0, 0.0}}, new double[][]{{18461.24, 0.05710892, 8433.466157492, -0.6400617, -0.5345, -0.00294, 1010.167, 2.412663, 16762.15758211, 0.88286, 24.537, -0.1265, 999.694, 5.440038, -104.77473287, 2.16299, 25.606, -0.1207, 623.652, 0.915047, 7109.28813249, -0.02177, 6.746, -0.0379, 199.484, 1.815303, 15647.5290228, -2.82482, -19.39, 0.0799, 166.574, 4.842677, -1219.4032921, -1.5447, -18.33, 0.086, 117.261, 4.17086, 23976.2204475, -1.3019, 5.68, -0.044, 61.912, 4.76822, 25090.8490067, 2.4058, 49.61, -0.25, 33.357, 3.2706, 15437.979557, 1.5012, 31.8, -0.161, 31.76, 1.51241, 8223.916692, 3.6859, 50.7, -0.244, 29.577, 0.95817, 6480.986177, 0.0049, 6.7, -0.032, 15.566, 2.4871, -9548.094717, -3.068, -43.4, 0.21, 15.122, 0.2432, 32304.911872, 0.221, 30.7, -0.17, 12.094, 4.0135, 7737.590088, -0.048, 6.8, -0.04, 8.868, 1.8584, 15019.227068, -2.798, -19.5, 0.09, 8.045, 5.3812, 8399.70911, -0.332, 3.1, -0.02, 7.959, 4.214, 23347.918492, -1.275, 5.6, -0.04, 7.435, 4.8858, -1847.705247, -1.518, -18.4, 0.09, 6.731, 3.8274, -16133.855627, -0.91, -24.5, 0.12, 6.58, 2.6732, 14323.350998, -2.207, -12.1, 0.04, 6.46, 3.1556, 9061.768113, -0.667, -0.5, -0.01, 6.296, 0.1713, 25300.398472, -1.92, -1.6, -0.01, 5.632, 0.8, 733.076688, -2.19, -26.0, 0.12, 5.368, 2.114, 16204.843302, -0.971, 3.0, -0.02, 5.311, 5.5111, 17390.459537, 0.856, 25.0, -0.13, 5.076, 2.2553, 523.52722, 2.136, 26.0, -0.13, 4.84, 6.183, -7805.1642, 0.613, 1.0, 0.0, 4.806, 5.1414, -662.08901, 0.309, 4.0, -0.02, 3.984, 0.8406, 33419.54043, 3.929, 75.0, -0.37, 3.674, 5.0288, 22652.04242, -0.684, 13.0, -0.08, 2.998, 5.9291, 31190.28331, -3.487, -13.0, 0.04, 2.799, 2.1842, -16971.70705, 3.443, 27.0, -0.11, 2.414, 3.5735, 22861.59189, -5.01, -38.0, 0.16, 2.186, 3.9424, -9757.64418, 1.258, 8.0, -0.03, 2.146, 5.6262, 23766.67098, 3.024, 57.0, -0.29, 1.766, 3.3137, 14809.6776, 1.528, 32.0, -0.2, 1.624, 2.6013, 7318.8376, -4.35, -44.0, 0.2, 1.581, 3.868, 16552.60812, 5.21, 76.0, -0.4, 1.52, 2.599, 40633.6033, 1.74, 56.0, -0.3, 1.516, 0.132, -17876.78614, -4.59, -68.0, 0.3, 1.51, 3.927, 8399.68473, -0.33, 3.0, 0.0, 1.318, 4.914, 16275.83098, -2.85, -19.0, 0.1, 1.264, 0.986, 24604.5224, -1.33, 6.0, 0.0, 1.192, 2.001, 39518.97474, -1.96, 12.0, -0.1, 1.135, 0.286, 31676.60992, 0.25, 31.0, -0.2, 1.086, 1.001, 5852.68422, 0.03, 7.0, 0.0, 1.019, 2.527, 33629.0899, -0.4, 23.0, -0.1, 0.823, 0.086, 16066.28151, 1.47, 32.0, -0.2, 0.804, 1.957, -33.78706, 0.28, 4.0, 0.0, 0.803, 5.212, 16833.14526, -1.0, 3.0, 0.0, 0.793, 1.472, -24462.54705, -2.43, -50.0, 0.2, 0.791, 1.658, -591.10134, -1.57, -18.0, 0.1, 0.667, 4.47, 24533.53473, 0.55, 28.0, -0.1, 0.65, 2.53, -10176.39667, -3.04, -43.0, 0.2, 0.639, 1.583, 25719.15096, 2.38, 50.0, -0.3, 0.634, 0.318, 5994.65957, -3.73, -37.0, 0.2, 0.631, 2.147, 8435.76736, -2.16, -26.0, 0.1, 0.63, 1.109, 8431.16496, 0.88, 25.0, -0.1, 0.596, 2.716, 13695.04904, -2.18, -12.0, 0.1, 0.589, 1.214, 7666.60241, 1.83, 29.0, -0.1, 0.473, 1.101, 30980.7338, 0.84, 38.0, -0.2, 0.456, 0.116, -71.0177, 1.85, 22.0, -0.1, 0.43, 2.786, -8990.7804, -1.21, -21.0, 0.1, 0.416, 1.454, 16728.4005, 1.19, 28.0, -0.1, 0.415, 5.072, 22023.7405, -0.66, 13.0, -0.1, 0.383, 4.257, 22719.6165, -1.25, 6.0, 0.0, 0.352, 2.972, 14880.6653, -0.35, 10.0, -0.1, 0.339, 5.972, 30561.9814, -3.46, -13.0, 0.0, 0.329, 1.587, -18086.3356, -0.26, -17.0, 0.1, 0.326, 1.016, 8467.2232, -0.95, -4.0, 0.0, 0.315, 1.902, 14390.9251, -2.77, -20.0, 0.1, 0.313, 4.611, 8852.2186, 3.66, 51.0, -0.2, 0.305, 0.616, 6551.9739, -1.88, -15.0, 0.1, 0.301, 4.728, -7595.6147, -3.71, -51.0, 0.2, 0.299, 1.874, 7143.0452, -0.33, 3.0, 0.0, 0.291, 3.156, -1428.9528, 2.78, 33.0, -0.2, 0.269, 4.929, -2476.0072, -1.49, -18.0, 0.1, 0.263, 3.196, 41748.2319, 5.45, 100.0, -0.5, 0.254, 3.387, -1009.8538, -5.87, -70.0, 0.3, 0.245, 1.93, 32514.4613, -4.1, -20.0, 0.1, 0.237, 3.342, 32933.2138, 0.19, 31.0, -0.2, 0.214, 3.617, 22233.2899, -4.98, -38.0, 0.2, 0.213, 4.357, 47847.6662, -0.44, 37.0, -0.2, 0.206, 3.872, 23418.9062, -3.16, -16.0, 0.1, 0.172, 5.772, 14951.653, -2.2, -12.0, 0.0, 0.158, 2.04, 38890.6728, -1.9, 12.0, 0.0, 0.146, 1.7, 32095.3624, 4.5, 82.0, 0.0, 0.145, 4.29, 40843.1528, -2.6, 5.0, 0.0, 0.139, 2.9, 7876.1519, -2.5, -23.0, 0.0, 0.138, 4.95, 48962.2947, 3.3, 81.0, 0.0, 0.134, 3.97, 8365.892, -0.1, 7.0, 0.0, 0.134, 4.06, -26205.4776, -6.1, -94.0, 0.0, 0.13, 1.4, -8643.0156, 5.0, 52.0, 0.0, 0.129, 5.67, 23138.369, 3.1, 57.0, 0.0, 0.124, 2.64, 40005.3013, 1.8, 56.0, 0.0, 0.118, 4.88, 41957.7813, 1.1, 49.0, 0.0, 0.113, 3.78, -15505.5537, -0.9, -24.0, 0.0, 0.113, 4.87, 16904.1329, -2.9, -19.0, 0.0, 0.113, 1.84, 23280.3444, -0.7, 13.0, 0.0, 0.11, 0.43, -17319.4719, -2.7, -47.0, 0.0, 0.105, 1.61, 37.2006, -1.6, -18.0, 0.0, 0.102, 1.28, 25161.8367, 0.5, 28.0, 0.0, 0.095, 0.76, 1361.3786, -2.2, -25.0, 0.0, 0.094, 0.5, 29866.1053, -2.9, -6.0, 0.0, 0.092, 6.22, 24881.2995, 6.7, 101.0, 0.0, 0.088, 3.99, -10385.9461, 1.3, 8.0, 0.0, 0.085, 4.71, 70.9933, -1.9, -22.0, 0.0, 0.084, 0.86, 15613.772, -2.5, -16.0, 0.0, 0.081, 4.43, 21537.4139, -4.4, -31.0, 0.0, 0.08, 1.86, -8365.9521, 0.0, -7.0, 0.0, 0.08, 0.0, 16728.3762, 1.2, 28.0, 0.0, 0.079, 2.44, -8919.7928, -3.1, -43.0, 0.0, 0.078, 3.69, -452.5395, -4.0, -48.0, 0.0, 0.075, 5.4, -32791.2385, -4.0, -75.0, 0.0, 0.073, 5.8, -1185.6462, -1.9, -22.0, 0.0, 0.07, 3.46, 16759.8564, 2.4, 50.0, 0.0, 0.069, 3.36, 14181.3756, 1.6, 32.0, 0.0, 0.068, 4.5, 16764.4588, -0.6, -1.0, 0.0, 0.067, 4.74, 8446.0854, 0.0, 7.0, 0.0, 0.066, 5.86, 24185.7699, -5.6, -46.0, 0.0, 0.064, 0.54, 32862.2262, 2.1, 53.0, 0.0, 0.063, 2.44, 24394.9729, 3.0, 57.0, 0.0, 0.063, 1.77, 5785.1101, 0.6, 14.0, 0.0, 0.062, 2.64, 6690.5356, -4.3, -45.0, 0.0, 0.062, 2.21, 1151.8292, 2.1, 26.0, 0.0, 0.062, 3.94, 34047.8424, 3.9, 75.0, 0.0, 0.06, 1.4, 38404.3462, -5.7, -32.0, 0.0, 0.058, 0.33, 31048.308, 0.3, 31.0, 0.0, 0.057, 3.11, 9690.0701, -0.7, 0.0, 0.0, 0.057, 1.14, 30352.4319, 0.9, 38.0, 0.0, 0.056, 6.0, 8504.4538, -2.5, -22.0, 0.0, 0.055, 5.47, 18018.7615, 0.8, 25.0, 0.0, 0.055, 0.17, -18505.0881, -4.6, -69.0, 0.0, 0.055, 0.76, -9129.3422, 1.2, 8.0, 0.0, 0.054, 5.7, 7947.1396, -4.4, -44.0, 0.0, 0.053, 0.36, 5366.358, -3.7, -37.0, 0.0, 0.052, 4.01, -68.726, -1.5, -18.0, 0.0, 0.051, 2.74, 31818.585, -3.5, -13.0, 0.0, 0.051, 0.98, 16798.206, -2.8, -19.0, 0.0, 0.05, 5.94, 8293.747, -0.3, 0.0, 0.0, 0.049, 1.52, 15090.215, -4.7, -41.0, 0.0, 0.048, 3.46, 39309.425, 2.4, 63.0, 0.0, 0.046, 3.21, 23942.463, -1.0, 9.0, 0.0, 0.046, 3.35, 7143.07, -0.3, 0.0, 0.0, 0.042, 3.76, 46733.038, -4.1, -7.0, 0.0, 0.042, 5.18, 8288.351, 0.0, 7.0, 0.0, 0.04, 3.37, 16795.915, 0.6, 21.0, 0.0, 0.039, 4.54, -1776.718, -3.4, -40.0, 0.0, 0.039, 0.04, 8439.5, -0.3, 0.0, 0.0, 0.037, 3.91, 8479.867, -0.3, 0.0, 0.0, 0.037, 2.86, 38194.797, -1.3, 19.0, 0.0, 0.036, 1.04, 5224.382, 0.1, 7.0, 0.0, 0.036, 3.57, 15995.294, 3.4, 54.0, 0.0, 0.036, 5.33, 23209.357, 1.2, 35.0, 0.0, 0.035, 1.02, 8452.654, -0.3, 0.0, 0.0, 0.035, 4.31, 8294.904, 1.8, 29.0, 0.0, 0.035, 2.76, 13066.747, -2.2, -12.0, 0.0, 0.034, 6.07, 15508.967, -0.4, 10.0, 0.0, 0.032, 1.89, -17529.021, 1.6, 0.0, 0.0, 0.031, 5.7, 41261.905, 1.7, 56.0, 0.0, 0.031, 5.33, 30075.655, -7.2, -57.0, 0.0, 0.031, 5.97, -40.34, -1.5, -18.0, 0.0, 0.03, 2.87, 6533.95, 0.0, 7.0, 0.0, 0.03, 0.36, 49171.844, -1.1, 30.0, 0.0, 0.03, 4.4, 47219.364, -0.4, 37.0, 0.0, 0.03, 0.39, 23489.894, -5.0, -38.0, 0.0, 0.029, 5.12, 21395.439, -0.6, 13.0, 0.0, 0.029, 2.62, 8715.153, -0.3, 0.0, 0.0, 0.029, 2.94, 16826.592, -2.8, -19.0, 0.0, 0.028, 6.23, 31747.598, -1.6, 9.0, 0.0, 0.028, 0.43, 56176.358, 1.1, 62.0, 0.0, 0.027, 2.32, 8792.706, -0.3, 0.0, 0.0, 0.026, 3.02, 14252.363, -0.3, 10.0, 0.0, 0.025, 5.1, 40147.277, -2.0, 12.0, 0.0, 0.025, 4.59, 8433.795, 0.9, 25.0, 0.0, 0.025, 4.95, 8433.138, -2.2, -26.0, 0.0, 0.025, 1.03, -9338.545, -7.4, -95.0, 0.0, 0.024, 0.68, 17180.91, 5.2, 76.0, 0.0, 0.024, 3.81, 25057.092, 2.7, 53.0, 0.0, 0.024, 6.02, 29933.679, -3.4, -13.0, 0.0, 0.024, 2.37, -15924.306, -5.2, -76.0, 0.0, 0.024, 3.46, 8681.372, 0.0, 7.0, 0.0, 0.023, 2.8, 7108.936, 0.0, 7.0, 0.0, 0.023, 2.17, 7109.64, 0.0, 7.0, 0.0, 0.023, 2.57, -10804.699, -3.0, -44.0, 0.0, 0.022, 1.21, 6323.246, 0.0, 7.0, 0.0, 0.022, 3.22, 8259.965, 0.0, 7.0, 0.0, 0.022, 1.97, 7106.987, 1.5, 32.0, 0.0, 0.022, 3.0, 7111.589, -1.5, -18.0, 0.0, 0.022, 1.22, 14532.9, -6.5, -63.0, 0.0, 0.021, 0.66, 5923.672, -1.8, -15.0, 0.0, 0.021, 0.69, 24047.208, -3.2, -16.0, 0.0, 0.02, 5.51, -26415.027, -1.8, -42.0, 0.0, 0.02, 3.7, 16745.237, -2.8, -19.0, 0.0, 0.02, 1.26, 7038.3, 1.9, 29.0, 0.0, 0.02, 5.78, 6716.267, 0.0, 7.0, 0.0, 0.02, 3.76, 7895.33, 0.0, 7.0, 0.0, 0.019, 0.44, -121.695, -1.5, -18.0, 0.0, 0.018, 2.16, 15576.541, -0.9, 0.0, 0.0, 0.018, 0.09, -17248.484, -4.6, -68.0, 0.0, 0.018, 6.14, -7176.862, 0.6, 0.0, 0.0, 0.018, 5.55, 50076.923, 7.0, 125.0, -1.0, 0.017, 2.47, 8257.674, 3.0, 47.0, 0.0, 0.017, 4.2, 31609.036, 1.0, 38.0, 0.0, 0.017, 0.5, 175.762, -4.0, -48.0, 0.0, 0.017, 3.2, -2057.255, 3.0, 33.0, 0.0}, {0.0743, 4.0998, 6480.98618, 0.005, 7.0, -0.03, 0.03043, 0.872, 7737.59009, -0.05, 7.0, 0.0, 0.02229, 5.0, 15019.22707, -2.8, -19.0, 0.1, 0.01999, 1.072, 23347.91849, -1.28, 6.0, 0.0, 0.01869, 1.744, -1847.70525, -1.52, -18.0, 0.1, 0.01696, 5.597, 16133.8556, 0.91, 24.0, -0.1, 0.01623, 0.014, 9061.7681, -0.67, 0.0, 0.0, 0.01419, 3.942, 733.0767, -2.19, -26.0, 0.1, 0.01338, 2.37, 17390.4595, 0.86, 25.0, -0.1, 0.01304, 5.633, 8399.6847, -0.33, 3.0, 0.0, 0.01279, 0.886, -523.5272, -2.14, -26.0, 0.1, 0.01215, 3.242, 7805.1642, -0.61, -1.0, 0.0, 0.01088, 3.686, 8435.7674, -2.16, -26.0, 0.1, 0.01088, 5.853, 8431.165, 0.88, 25.0, -0.1, 0.00546, 4.143, 5852.6842, 0.0, 7.0, 0.0, 0.00443, 0.17, 14809.6776, 1.5, 32.0, 0.0, 0.00342, 2.24, 8399.7091, -0.3, 3.0, 0.0, 0.0033, 1.77, 16275.831, -2.9, -19.0, 0.0, 0.00318, 4.13, 24604.5224, -1.3, 6.0, 0.0, 0.00296, 0.9, 7109.2881, 0.0, 7.0, 0.0, 0.00285, 3.43, 31676.6099, 0.2, 31.0, 0.0, 0.00207, 3.23, 16066.2815, 1.5, 32.0, 0.0, 0.00202, 2.07, 16833.1453, -1.0, 3.0, 0.0, 0.00202, 5.1, -33.7871, 0.3, 4.0, 0.0, 0.002, 1.67, 24462.5471, 2.4, 50.0, 0.0, 0.00198, 4.8, -591.1013, -1.6, -18.0, 0.0, 0.00193, 1.12, 22719.6165, -1.2, 6.0, 0.0, 0.00164, 5.67, -10176.397, -3.0, -43.0, 0.0, 0.00161, 4.73, 25719.151, 2.4, 50.0, 0.0, 0.00158, 5.04, 14390.925, -2.8, -20.0, 0.0, 0.00149, 5.86, 13695.049, -2.2, -12.0, 0.0, 0.00135, 1.79, -2476.007, -1.5, -18.0, 0.0, 0.00121, 1.93, 16759.856, 2.4, 50.0, 0.0, 0.00117, 6.04, 16764.459, -0.6, 0.0, 0.0, 0.00104, 1.93, 22023.74, -0.7, 13.0, 0.0, 8.5E-4, 2.83, 30561.981, -3.5, -13.0, 0.0, 7.9E-4, 4.81, -8852.219, -3.7, -51.0, 0.0, 7.6E-4, 1.59, -7595.615, -3.7, -51.0, 0.0, 7.5E-4, 2.91, 8433.795, 0.9, 25.0, 0.0, 7.5E-4, 0.35, 8433.138, -2.2, -26.0, 0.0, 7.3E-4, 0.13, 70.993, -1.9, -22.0, 0.0, 6.9E-4, 1.7, 16728.376, 1.2, 28.0, 0.0, 6.8E-4, 0.83, 8365.892, -0.1, 7.0, 0.0, 6.0E-4, 0.2, 32933.214, 0.2, 31.0, 0.0, 6.0E-4, 0.31, 8446.085, 0.0, 7.0, 0.0}, {2.2E-4, 4.1, 6480.9862, 0.0, 7.0, 0.0, 1.01E-4, 5.24, 8435.7674, -2.2, -26.0, 0.0, 1.01E-4, 4.3, 8431.165, 0.9, 25.0, 0.0, 9.0E-5, 0.87, 7737.5901, 0.0, 7.0, 0.0, 6.0E-5, 1.07, 23347.9185, -1.3, 6.0, 0.0, 6.0E-5, 5.0, 15019.2271, -2.8, -19.0, 0.0, 5.0E-5, 1.74, -1847.705, -1.5, -18.0, 0.0, 5.0E-5, 5.6, 16133.856, 0.9, 24.0, 0.0, 5.0E-5, 0.01, 9061.768, -0.7, 0.0, 0.0, 4.0E-5, 3.24, 7805.164, -0.6, 0.0, 0.0, 4.0E-5, 3.94, 733.077, -2.2, -26.0, 0.0, 4.0E-5, 0.89, -523.527, -2.1, -26.0, 0.0}}, new double[][]{{385000.51, 0.0, 0.0, 0.0, 0.0, 0.0, 20905.354, 5.4971472, 8328.691424623, 1.522924, 25.0719, -0.1236, 3699.111, 4.8997864, 7214.06286536, -2.184756, -18.86, 0.0828, 2955.967, 0.972156, 15542.75428998, -0.66183, 6.212, -0.0408, 569.925, 1.569516, 16657.3828492, 3.04585, 50.14, -0.2472, 246.158, 5.68582, -1114.6285593, -3.7077, -43.93, 0.206, 204.586, 1.01528, 14914.4523348, -0.6352, 6.15, -0.035, 170.733, 3.32771, 23871.4457146, 0.8611, 31.28, -0.164, 152.138, 4.94291, 6585.7609101, -2.1581, -18.92, 0.088, 129.62, 0.74291, -7700.3894694, -1.5496, -25.01, 0.118, 108.743, 5.19847, 7771.377145, -0.3309, 3.1, -0.02, 104.755, 2.31243, 8956.99338, 1.4963, 25.1, -0.129, 79.661, 5.38293, -8538.24089, 2.803, 26.1, -0.118, 48.888, 6.24006, 628.301955, -0.0266, 0.1, -0.005, 34.783, 2.73035, 22756.817155, -2.847, -12.6, 0.04, 30.824, 4.0706, 16171.056245, -0.688, 6.3, -0.05, 24.208, 1.7151, 7842.364821, -2.211, -18.8, 0.08, 23.21, 3.9251, 24986.074274, 4.569, 75.2, -0.37, 21.636, 0.3748, 14428.125731, -4.37, -37.7, 0.17, 16.675, 2.0137, 8399.6791, -0.358, 3.2, -0.03, 14.403, 3.3303, -9443.319984, -5.231, -69.0, 0.33, 12.831, 3.3708, 23243.143759, 0.888, 31.2, -0.16, 11.65, 5.0859, 31085.50858, -1.324, 12.0, -0.08, 10.445, 5.6833, 32200.13714, 2.384, 56.0, -0.29, 10.321, 0.8579, -1324.17803, 0.618, 7.0, -0.03, 10.056, 5.729, -1742.93051, -3.681, -44.0, 0.21, 9.884, 1.0584, 14286.15038, -0.609, 6.0, -0.03, 8.752, 4.7856, -9652.86945, -0.905, -18.0, 0.09, 8.379, 5.9845, -557.31428, -1.854, -22.0, 0.1, 7.003, 4.6705, -16029.08089, -3.072, -50.0, 0.24, 6.322, 1.2708, 16100.06857, 1.192, 28.0, -0.14, 5.751, 4.668, 17285.6848, 3.019, 50.0, -0.25, 4.95, 4.986, 5957.45895, -2.131, -19.0, 0.09, 4.421, 4.5969, -209.54947, 4.326, 51.0, -0.24, 4.131, 3.2135, 7004.5134, 2.141, 32.0, -0.16, 3.958, 2.7735, 22128.5152, -2.82, -13.0, 0.05, 3.258, 0.6735, 14985.44001, -2.52, -16.0, 0.1, 3.148, 0.114, 16866.93231, -1.28, -1.0, 0.0, 2.616, 0.143, 24499.74767, 0.83, 31.0, -0.2, 2.354, 1.672, 8470.66678, -2.24, -19.0, 0.1, 2.117, 0.7, -7072.08751, -1.58, -25.0, 0.1, 1.897, 0.418, 13799.82378, -4.34, -38.0, 0.2, 1.739, 3.629, -8886.0057, -3.38, -47.0, 0.2, 1.571, 5.129, 30457.20662, -1.3, 12.0, -0.1, 1.423, 1.158, 39414.2, 0.2, 37.0, -0.2, 1.419, 6.171, 23314.13143, -0.99, 9.0, -0.1, 1.166, 2.269, 9585.29534, 1.47, 25.0, -0.1, 1.117, 6.281, 33314.7657, 6.09, 100.0, -0.5, 1.066, 6.197, 1256.60391, -0.05, 0.0, 0.0, 1.059, 4.068, 8364.73984, -2.18, -19.0, 0.1, 0.933, 4.369, 16728.3705, 1.17, 28.0, -0.1, 0.862, 4.601, 6656.7486, -4.04, -41.0, 0.2, 0.851, 2.8, 70.9877, -1.88, -22.0, 0.1, 0.849, 5.726, 31571.8352, 2.41, 56.0, -0.3, 0.796, 5.084, -9095.5552, 0.95, 4.0, 0.0, 0.779, 0.975, -17772.0114, -6.75, -94.0, 0.5, 0.774, 2.658, 15752.3038, -4.99, -45.0, 0.2, 0.728, 0.266, 8326.3902, 3.05, 50.0, -0.2, 0.683, 1.304, 8330.9926, 0.0, 0.0, 0.0, 0.67, 1.756, 40528.8286, 3.91, 81.0, -0.4, 0.658, 3.414, 22614.8418, 0.91, 31.0, -0.2, 0.657, 0.901, -1952.48, 0.64, 7.0, 0.0, 0.598, 6.026, 8393.1258, -2.18, -19.0, 0.1, 0.596, 5.014, 24080.9952, -3.46, -20.0, 0.1, 0.579, 5.829, 23385.1191, -2.87, -13.0, 0.0, 0.514, 4.302, 6099.4343, -5.89, -63.0, 0.3, 0.508, 1.83, 14218.5763, -0.04, 13.0, -0.1, 0.498, 5.242, 7143.0752, -0.3, 3.0, 0.0, 0.495, 3.373, -10071.6219, -5.2, -69.0, 0.3, 0.473, 2.43, -17981.5609, -2.43, -43.0, 0.2, 0.456, 4.887, -8294.9344, -1.83, -29.0, 0.1, 0.453, 0.173, 8362.4485, 1.21, 21.0, -0.1, 0.423, 4.489, 29970.88, -5.03, -32.0, 0.1, 0.422, 2.315, -24357.7723, -4.6, -75.0, 0.4, 0.411, 1.102, 13657.8484, -0.58, 6.0, 0.0, 0.41, 0.5, 8311.7707, -2.18, -19.0, 0.1, 0.379, 3.626, 24428.76, 2.71, 53.0, 0.0, 0.355, 0.74, 25614.3762, 4.54, 75.0, 0.0, 0.343, 5.772, -2371.2325, -3.7, -44.0, 0.0, 0.335, 0.857, 9166.5428, -2.8, -26.0, 0.0, 0.332, 0.444, -8257.7037, -3.4, -47.0, 0.0, 0.323, 4.829, -10281.1714, -0.9, -18.0, 0.0, 0.322, 5.758, 5889.8848, -1.6, -12.0, 0.0, 0.287, 0.56, 38299.5714, -3.5, -6.0, 0.0, 0.284, 5.57, 15333.2048, 3.7, 57.0, 0.0, 0.279, 2.82, 21500.2132, -2.8, -13.0, 0.0, 0.256, 0.72, 14357.1381, -2.5, -16.0, 0.0, 0.248, 2.2, -7909.9389, 2.8, 26.0, 0.0, 0.245, 1.9, 31713.8105, -1.4, 12.0, 0.0, 0.237, 3.47, 15056.4277, -4.4, -38.0, 0.0, 0.213, 3.77, 15613.742, -2.5, -16.0, 0.0, 0.213, 2.5, 32828.4391, 2.4, 56.0, 0.0, 0.209, 3.26, 6376.2114, 2.2, 32.0, 0.0, 0.205, 2.93, 14967.4158, -0.7, 6.0, 0.0, 0.205, 2.02, 15540.4531, 0.9, 31.0, 0.0, 0.204, 3.06, 15545.0555, -2.2, -19.0, 0.0, 0.203, 1.2, 38785.898, 0.2, 37.0, 0.0, 0.201, 6.06, 6447.1991, 0.3, 10.0, 0.0, 0.186, 6.13, -16238.6304, 1.3, 1.0, 0.0, 0.183, 2.13, 21642.1886, -6.6, -57.0, 0.0, 0.169, 3.29, -8815.018, -5.3, -69.0, 0.0, 0.167, 1.06, 8328.3391, 1.5, 25.0, 0.0, 0.167, 0.51, 8329.0437, 1.5, 25.0, 0.0, 0.167, 1.26, 14756.7124, -0.7, 6.0, 0.0, 0.158, 0.07, 17495.2343, -1.3, -1.0, 0.0, 0.157, 0.57, 6638.7244, -2.2, -19.0, 0.0, 0.157, 6.21, 22685.8295, -1.0, 9.0, 0.0, 0.148, 5.03, 5329.157, -2.1, -19.0, 0.0, 0.148, 4.03, 16799.3582, -0.7, 6.0, 0.0, 0.145, 0.05, 7178.0144, 1.5, 25.0, 0.0, 0.144, 5.64, -486.3266, -3.7, -44.0, 0.0, 0.139, 3.51, 47742.8914, 1.7, 63.0, 0.0, 0.138, 4.07, 7935.6705, 1.5, 25.0, 0.0, 0.136, 4.63, -15400.7789, -3.1, -50.0, 0.0, 0.136, 3.96, -695.8761, 0.6, 7.0, 0.0, 0.135, 5.95, 7211.7617, -0.7, 6.0, 0.0, 0.128, 5.17, 29828.9047, -1.3, 12.0, 0.0, 0.127, 1.18, 7753.3529, 1.5, 25.0, 0.0, 0.127, 0.71, 7216.3641, -3.7, -44.0, 0.0, 0.124, 5.83, 15149.7333, -0.7, 6.0, 0.0, 0.121, 1.46, 8000.1048, -2.2, -19.0, 0.0, 0.12, 3.78, 8721.7124, 1.5, 25.0, 0.0, 0.116, 5.19, 6428.0209, -2.2, -19.0, 0.0, 0.114, 2.89, -1185.6162, -1.8, -22.0, 0.0, 0.112, 2.85, 15542.402, -0.7, 6.0, 0.0, 0.112, 2.23, 15543.1066, -0.7, 6.0, 0.0, 0.11, 0.51, 7213.7105, -2.2, -19.0, 0.0, 0.11, 6.15, 7214.4152, -2.2, -19.0, 0.0, 0.11, 1.31, 15471.7666, 1.2, 28.0, 0.0, 0.109, 2.46, 141.9754, -3.8, -44.0, 0.0, 0.108, 0.46, 13171.5218, -4.3, -38.0, 0.0, 0.108, 6.13, 23942.4334, -1.0, 9.0, 0.0, 0.107, 3.15, 15508.9972, -0.4, 10.0, 0.0, 0.105, 0.39, 8904.03, 1.5, 25.0, 0.0, 0.105, 4.93, 14392.077, -0.7, 6.0, 0.0, 0.103, 2.47, 25195.624, 0.2, 24.0, 0.0, 0.101, 3.48, 6821.042, -2.2, -19.0, 0.0, 0.099, 4.37, 7149.629, 1.5, 25.0, 0.0, 0.099, 1.27, -17214.697, -4.9, -72.0, 0.0, 0.096, 1.93, 15576.511, -1.0, 0.0, 0.0, 0.086, 2.92, 46628.263, -2.0, 19.0, 0.0, 0.085, 6.22, 8504.484, -2.5, -22.0, 0.0, 0.08, 3.4, -2438.807, -3.1, -37.0, 0.0, 0.08, 1.17, 8786.147, -2.2, -19.0, 0.0, 0.077, 3.61, 7230.984, 1.5, 25.0, 0.0, 0.071, 0.28, 8315.574, -2.2, -19.0, 0.0, 0.067, 4.53, 29342.578, -5.0, -32.0, 0.0, 0.065, 2.24, 31642.823, 0.5, 34.0, 0.0, 0.063, 5.8, 8329.403, 1.5, 25.0, 0.0, 0.063, 2.05, 8327.98, 1.5, 25.0, 0.0, 0.062, 0.08, 8346.716, -0.3, 0.0, 0.0, 0.061, 4.85, 36.048, -3.7, -44.0, 0.0, 0.061, 2.58, 6063.386, -2.2, -19.0, 0.0, 0.061, 4.3, -766.864, 2.5, 29.0, 0.0, 0.06, 3.01, 8322.132, -0.3, 0.0, 0.0, 0.059, 0.44, 25057.062, 2.7, 53.0, 0.0, 0.059, 0.31, 8288.877, 1.5, 25.0, 0.0, 0.059, 2.35, 41643.457, 7.6, 125.0, -1.0, 0.059, 1.26, 8368.506, 1.5, 25.0, 0.0, 0.058, 1.8, 39900.527, 3.9, 81.0, 0.0, 0.058, 1.87, 13590.274, 0.0, 13.0, 0.0, 0.057, 0.47, 14954.262, -0.7, 6.0, 0.0, 0.057, 6.2, 8294.91, 1.8, 29.0, 0.0, 0.056, 4.63, -8362.473, -1.2, -21.0, 0.0, 0.055, 2.86, 8170.957, 1.5, 25.0, 0.0, 0.055, 0.03, 7632.815, 2.1, 32.0, 0.0, 0.053, 0.8, 7180.306, -1.9, -15.0, 0.0, 0.053, 4.64, 6028.447, -4.0, -41.0, 0.0, 0.053, 4.57, 15385.02, -0.7, 6.0, 0.0, 0.052, 0.6, 37671.269, -3.5, -6.0, 0.0, 0.052, 4.99, 8486.426, 1.5, 25.0, 0.0, 0.051, 4.62, 17913.987, 3.0, 50.0, 0.0, 0.05, 1.64, 837.851, -4.4, -51.0, 0.0, 0.049, 5.79, 7542.649, 1.5, 25.0, 0.0, 0.049, 2.06, 9114.733, 1.5, 25.0, 0.0, 0.049, 2.21, 7056.329, -2.2, -19.0, 0.0, 0.049, 4.9, 7214.063, -2.2, -19.0, 0.0, 0.048, 5.39, -1671.943, -5.6, -66.0, 0.0, 0.047, 4.9, -26100.703, -8.3, -119.0, 1.0, 0.047, 1.6, -9024.567, -0.9, -18.0, 0.0, 0.046, 1.16, 7161.094, -2.2, -19.0, 0.0, 0.046, 5.77, 30943.533, 2.4, 56.0, 0.0, 0.046, 2.43, 22199.503, -4.7, -35.0, 0.0, 0.046, 3.16, 14991.999, -0.7, 6.0, 0.0, 0.044, 4.11, 48857.52, 5.4, 106.0, -1.0, 0.044, 4.39, 6625.57, -2.2, -19.0, 0.0, 0.044, 6.06, 7789.401, -2.2, -19.0, 0.0, 0.043, 0.14, 16693.431, -0.7, 6.0, 0.0, 0.043, 4.5, 15020.385, -0.7, 6.0, 0.0, 0.043, 4.35, 5471.132, -5.9, -63.0, 0.0, 0.043, 4.32, 575.338, 0.0, 0.0, 0.0, 0.043, 5.43, 7267.032, -2.2, -19.0, 0.0, 0.043, 3.82, 16328.796, -0.7, 6.0, 0.0, 0.042, 2.73, -17424.247, -0.6, -21.0, 0.0, 0.041, 3.6, 15489.785, -0.7, 6.0, 0.0, 0.04, 2.62, 16655.082, 4.6, 75.0, 0.0, 0.04, 4.23, 8351.233, -2.2, -19.0, 0.0, 0.039, 0.66, -6443.786, -1.6, -25.0, 0.0, 0.039, 2.13, 16118.093, -0.7, 6.0, 0.0, 0.039, 5.86, 7247.82, -2.5, -23.0, 0.0, 0.038, 4.56, 7285.051, -4.1, -41.0, 0.0, 0.038, 2.59, 9179.168, -2.2, -19.0, 0.0, 0.038, 1.42, 393.021, 0.0, 0.0, 0.0, 0.038, 4.94, 8381.661, 1.5, 25.0, 0.0, 0.037, 5.06, 23452.693, -3.4, -20.0, 0.0, 0.037, 5.11, 9027.981, -0.4, 0.0, 0.0, 0.037, 4.98, 7740.199, 1.5, 25.0, 0.0, 0.037, 3.66, 16659.684, 1.5, 25.0, 0.0, 0.037, 2.89, 8275.722, 1.5, 25.0, 0.0, 0.037, 4.26, 40042.502, 0.2, 38.0, 0.0, 0.036, 1.95, 8326.062, 1.5, 25.0, 0.0, 0.036, 5.9, 8331.321, 1.5, 25.0, 0.0, 0.035, 1.33, 15595.723, -0.7, 6.0, 0.0, 0.035, 1.39, 7777.936, 2.0, 25.0, 0.0, 0.035, 0.8, 6663.308, -2.0, -19.0, 0.0, 0.035, 0.53, 64.434, -4.0, -44.0, 0.0, 0.034, 2.15, 6691.693, -2.0, -19.0, 0.0, 0.034, 1.9, -8467.253, 1.0, 0.0, 0.0, 0.033, 2.83, 7806.322, 2.0, 25.0, 0.0, 0.033, 4.67, 9479.368, 2.0, 25.0, 0.0, 0.033, 1.41, 418.752, 4.0, 51.0, 0.0}, {0.5139, 4.1569, 14914.452335, -0.635, 6.2, -0.04, 0.3824, 1.8013, 6585.76091, -2.158, -19.0, 0.09, 0.3265, 2.3987, 7700.38947, 1.55, 25.0, -0.12, 0.264, 5.454, 8956.99338, 1.496, 25.0, -0.13, 0.123, 3.0985, 628.30196, -0.027, 0.0, 0.0, 0.0775, 0.929, 16171.05625, -0.69, 6.0, 0.0, 0.0607, 4.857, 7842.36482, -2.21, -19.0, 0.1, 0.0497, 4.2, 14286.15038, -0.61, 6.0, 0.0, 0.0419, 5.155, 8399.6791, -0.36, 3.0, 0.0, 0.0322, 0.229, 23243.1438, 0.89, 31.0, -0.2, 0.0253, 2.587, -1742.9305, -3.68, -44.0, 0.2, 0.0249, 1.844, 5957.459, -2.13, -19.0, 0.1, 0.0176, 4.754, 16029.0809, 3.07, 50.0, -0.2, 0.0145, 1.526, 17285.6848, 3.02, 50.0, -0.3, 0.0137, 1.004, 15542.7543, -0.66, 6.0, 0.0, 0.0126, 5.01, 8326.3902, 3.05, 50.0, 0.0, 0.0119, 4.814, 8470.6668, -2.24, -19.0, 0.0, 0.0118, 2.843, 8330.9926, 0.0, 0.0, 0.0, 0.0107, 2.442, 7072.0875, 1.6, 25.0, 0.0, 0.0099, 5.92, 22128.5152, -2.8, -13.0, 0.0, 0.0066, 3.28, 24499.7477, 0.8, 31.0, 0.0, 0.0065, 4.9, 7214.0629, -2.2, -19.0, 0.0, 0.0059, 5.41, 9585.2953, 1.5, 25.0, 0.0, 0.0054, 3.06, 1256.6039, -0.1, 0.0, 0.0, 0.0052, 2.5, 8328.3391, 1.5, 25.0, 0.0, 0.0052, 5.35, 8329.0437, 1.5, 25.0, 0.0, 0.0048, 3.56, 13799.8238, -4.3, -38.0, 0.0, 0.0039, 1.99, 30457.2066, -1.3, 12.0, 0.0, 0.0035, 0.49, 15540.4531, 0.9, 31.0, 0.0, 0.0035, 4.6, 15545.0555, -2.2, -19.0, 0.0, 0.0033, 0.27, 22614.842, 0.9, 31.0, 0.0, 0.0031, 4.24, 13657.848, -0.6, 6.0, 0.0, 0.0023, 1.23, 16728.371, 1.2, 28.0, 0.0, 0.0023, 5.5, 8328.691, 1.5, 25.0, 0.0, 0.0023, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0023, 4.41, 7211.762, -0.7, 6.0, 0.0, 0.0022, 1.39, 8311.771, -2.2, -19.0, 0.0, 0.0022, 2.25, 7216.364, -3.7, -44.0, 0.0, 0.0021, 5.94, 70.988, -1.9, -22.0, 0.0, 0.0021, 2.58, 31571.835, 2.4, 56.0, 0.0, 0.0017, 2.63, -2371.232, -3.7, -44.0, 0.0, 0.0016, 4.04, -1952.48, 0.6, 7.0, 0.0, 0.0015, 4.23, 8329.403, 1.5, 25.0, 0.0, 0.0015, 3.63, 8327.98, 1.5, 25.0, 0.0, 0.0015, 2.69, 23385.119, -2.9, -13.0, 0.0, 0.0014, 5.96, 21500.213, -2.8, -13.0, 0.0, 0.0013, 4.06, 15542.402, -0.7, 6.0, 0.0, 0.0013, 1.02, 15543.107, -0.7, 6.0, 0.0, 0.0013, 2.1, 7143.075, -0.3, 0.0, 0.0, 0.0012, 0.23, -10071.622, -5.2, -69.0, 0.0, 0.0011, 3.33, 23871.446, 1.0, 31.0, 0.0, 0.0011, 1.89, 5329.157, -2.0, -19.0, 0.0}, {0.00149, 4.157, 14914.45233, -0.64, 6.0, 0.0, 0.00111, 1.801, 6585.7609, -2.16, -19.0, 0.1, 9.5E-4, 2.399, 7700.3895, 1.55, 25.0, -0.1, 7.7E-4, 5.454, 8956.9934, 1.5, 25.0, -0.1, 3.6E-4, 3.098, 628.302, 0.0, 0.0, 0.0, 2.3E-4, 0.93, 16171.0562, -0.7, 6.0, 0.0, 1.8E-4, 4.86, 7842.3648, -2.2, -19.0, 0.0, 1.4E-4, 4.2, 14286.1504, -0.6, 6.0, 0.0, 1.2E-4, 5.16, 8399.6791, -0.4, 0.0, 0.0, 1.16E-4, 3.46, 8326.39, 3.0, 50.0, 0.0, 1.09E-4, 4.39, 8330.993, 0.0, 0.0, 0.0, 9.0E-5, 0.23, 23243.144, 0.9, 31.0, 0.0}}};
    }
}

