/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.dto.AddressDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChinaAddressUtils {
    public static List<AddressDTO> addressResolution(String address) {
        String regex = "(?<province>.*?\u7701|.*?\u5e02)?(?<city>.*?\u5e02|.*?\u53bf|.*?\u533a)?(?<county>.*?\u5e02|.*?\u53bf|.*?\u533a)(?<village>.*?\u5c0f\u533a|.*?\u6751)(?<building>.*?\u53f7\u697c|.*?\u697c|.*?\u680b|.*?\u961f|.*?\u7ec4|.*?\u53f7|.*?\u5ba4)?(?<other>.*)";
        ArrayList<AddressDTO> addressDTOS = new ArrayList<AddressDTO>();
        Matcher matcher = Pattern.compile(regex).matcher(address);
        while (matcher.find()) {
            AddressDTO addressDTO = new AddressDTO();
            addressDTO.setProvince(matcher.group("province"));
            addressDTO.setCity(matcher.group("city"));
            addressDTO.setCounty(matcher.group("county"));
            addressDTO.setVillage(matcher.group("village"));
            addressDTO.setBuilding(matcher.group("building"));
            addressDTO.setOther(matcher.group("other"));
            addressDTOS.add(addressDTO);
        }
        return addressDTOS;
    }
}

