/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.utils.CommonUtils;

public class AstronomyArithmeticUtils {
    static double Julian_Shijishu;

    public static double gxc_sunLon(double t) {
        double v = -0.043126 + 628.301955 * t - 2.732E-6 * t * t;
        double e = 0.016708634 - 4.2037E-5 * t - 1.267E-7 * t * t;
        return -20.49552 * (1.0 + e * Math.cos(v)) / 206264.80624709636;
    }

    public static double gxc_moonLon(double t) {
        return -3.4E-6;
    }

    public static double E_Lon(double t, int n) {
        return CommonUtils.XL0_calc(0, 0, t, n);
    }

    public static double M_Lon(double t, int n) {
        return CommonUtils.XL1_calc(0, t, n);
    }

    public static double E_v(double t) {
        double f = 628.307585 * t;
        double b = 628.332 + 21.0 * Math.sin(1.527 + f) + 0.44 * Math.sin(1.48 + f * 2.0) + 0.129 * Math.sin(5.82 + f) * t + 5.5E-4 * Math.sin(4.21 + f) * t * t;
        return b;
    }

    public static double M_v(double t) {
        double v = 8399.71 - 914.0 * Math.sin(0.7848 + 8328.691425 * t + 1.523E-4 * t * t);
        return v -= 179.0 * Math.sin(2.543 + 15542.7543 * t) + 160.0 * Math.sin(0.1874 + 7214.0629 * t) + 62.0 * Math.sin(3.14 + 16657.3828 * t) + 34.0 * Math.sin(4.827 + 16866.9323 * t) + 22.0 * Math.sin(4.9 + 23871.4457 * t) + 12.0 * Math.sin(2.59 + 14914.4523 * t) + 7.0 * Math.sin(0.23 + 6585.7609 * t) + 5.0 * Math.sin(0.9 + 25195.624 * t) + 5.0 * Math.sin(2.32 - 7700.3895 * t) + 5.0 * Math.sin(3.88 + 8956.9934 * t) + 5.0 * Math.sin(0.49 + 7771.3771 * t);
    }

    public static double MS_aLon(double t, int Mn, int Sn) {
        return AstronomyArithmeticUtils.M_Lon(t, Mn) + AstronomyArithmeticUtils.gxc_moonLon(t) - (AstronomyArithmeticUtils.E_Lon(t, Sn) + AstronomyArithmeticUtils.gxc_sunLon(t) + Math.PI);
    }

    public static double S_aLon(double t, int n) {
        return AstronomyArithmeticUtils.E_Lon(t, n) + CommonUtils.nutationLon2(t) + AstronomyArithmeticUtils.gxc_sunLon(t) + Math.PI;
    }

    public static double getJulian_Shijishu() {
        return Julian_Shijishu;
    }

    public static void setJulian_Shijishu(double julian_Shijishu) {
        Julian_Shijishu = julian_Shijishu;
    }

    public static double MS_aLon_t(double W) {
        double v = 7771.37714500204;
        double t = (W + 1.08472) / v;
        t += (W - AstronomyArithmeticUtils.MS_aLon(t, 3, 3)) / v;
        AstronomyArithmeticUtils.setJulian_Shijishu(t);
        v = AstronomyArithmeticUtils.M_v(t) - AstronomyArithmeticUtils.E_v(t);
        t += (W - AstronomyArithmeticUtils.MS_aLon(t, 20, 10)) / v;
        t += (W - AstronomyArithmeticUtils.MS_aLon(t, -1, 60)) / v;
        return t;
    }

    public static double S_aLon_t(double W) {
        double v = 628.3319653318;
        double t = (W - 1.75347 - Math.PI) / v;
        v = AstronomyArithmeticUtils.E_v(t);
        t += (W - AstronomyArithmeticUtils.S_aLon(t, 10)) / v;
        v = AstronomyArithmeticUtils.E_v(t);
        t += (W - AstronomyArithmeticUtils.S_aLon(t, -1)) / v;
        return t;
    }

    public static double MS_aLon_t2(double W) {
        double v = 7771.37714500204;
        double t = (W + 1.08472) / v;
        double t2 = t * t;
        t -= (-3.309E-5 * t2 + 0.10976 * Math.cos(0.784758 + 8328.6914246 * t + 1.52292E-4 * t2) + 0.02224 * Math.cos(0.1874 + 7214.0628654 * t - 2.1848E-4 * t2) - 0.03342 * Math.cos(4.669257 + 628.307585 * t)) / v;
        double L = AstronomyArithmeticUtils.M_Lon(t, 20) - (4.8950632 + 628.3319653318 * t + 5.297E-6 * t * t + 0.0334166 * Math.cos(4.669257 + 628.307585 * t) + 2.061E-4 * Math.cos(2.67823 + 628.307585 * t) * t + 3.49E-4 * Math.cos(4.6261 + 1256.61517 * t) - 9.938680462745487E-5);
        v = 7771.38 - 914.0 * Math.sin(0.7848 + 8328.691425 * t + 1.523E-4 * t * t) - 179.0 * Math.sin(2.543 + 15542.7543 * t) - 160.0 * Math.sin(0.1874 + 7214.0629 * t);
        return t += (W - L) / v;
    }

    public static double S_aLon_t2(double W) {
        double v = 628.3319653318;
        double t = (W - 1.75347 - Math.PI) / v;
        t -= (5.297E-6 * t * t + 0.0334166 * Math.cos(4.669257 + 628.307585 * t) + 2.061E-4 * Math.cos(2.67823 + 628.307585 * t) * t) / v;
        t += (W - AstronomyArithmeticUtils.E_Lon(t, 8) - Math.PI + (20.5 + 17.2 * Math.sin(2.1824 - 33.75705 * t)) / 206264.80624709636) / v;
        return t;
    }
}

