/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.utils;

import cn.huangdayu.almanac.aggregates.astronomical.Astronomical;
import cn.huangdayu.almanac.aggregates.era.Era;
import cn.huangdayu.almanac.aggregates.holiday.Holiday;
import cn.huangdayu.almanac.aggregates.islamic.Islamic;
import cn.huangdayu.almanac.aggregates.julian.Julian;
import cn.huangdayu.almanac.aggregates.lunar.Lunar;
import cn.huangdayu.almanac.aggregates.moon_phase.MoonPhase;
import cn.huangdayu.almanac.aggregates.qishuo.QiShuo;
import cn.huangdayu.almanac.aggregates.solar_term.SolarTerm;
import cn.huangdayu.almanac.aggregates.sunrise_moonset.SunriseMoonset;
import cn.huangdayu.almanac.dto.AlmanacDTO;
import cn.huangdayu.almanac.dto.TimeZoneDTO;

public class AlmanacUtils {
    private AlmanacUtils() {
    }

    public static AlmanacDTO ofDay(TimeZoneDTO timeZoneDTO) {
        int index = timeZoneDTO.getDay() - 1;
        return AlmanacUtils.handler(timeZoneDTO, index)[index];
    }

    public static AlmanacDTO[] ofMonth(TimeZoneDTO timeZoneDTO) {
        return AlmanacUtils.handler(timeZoneDTO, -1);
    }

    public static AlmanacDTO[][] ofYear(TimeZoneDTO timeZoneDTO) {
        AlmanacDTO[][] almanacDTOS = new AlmanacDTO[12][];
        for (int i = 1; i <= 12; ++i) {
            timeZoneDTO.setMonth(i);
            almanacDTOS[i - 1] = AlmanacUtils.ofMonth(new TimeZoneDTO(timeZoneDTO));
        }
        return almanacDTOS;
    }

    private static AlmanacDTO[] handler(TimeZoneDTO timeZoneDTO, int dayIndex) {
        int i;
        QiShuo qiShuo = new QiShuo();
        Julian julianOfMonth = new Julian(timeZoneDTO.getEraYear(), timeZoneDTO.getMonth());
        AlmanacDTO[] almanacDTOS = new AlmanacDTO[julianOfMonth.getNumberDayOfMonth()];
        Astronomical astronomical = new Astronomical(julianOfMonth.getFirstJulianDayOfMonth());
        boolean forDay = dayIndex >= 0;
        int n = i = forDay ? dayIndex : 0;
        while (forDay ? i <= dayIndex : i < julianOfMonth.getNumberDayOfMonth()) {
            TimeZoneDTO timeZoneForToday = timeZoneDTO.nextDay(i, julianOfMonth);
            int julianDayForToday = julianOfMonth.getFirstJulianDayOfMonth() + i;
            SunriseMoonset sunriseMoonset = new SunriseMoonset(timeZoneForToday);
            Islamic islamic = new Islamic(julianDayForToday);
            Lunar lunar = new Lunar(timeZoneForToday, julianDayForToday, qiShuo);
            SolarTerm solarTermDTO = new SolarTerm(julianDayForToday, qiShuo, astronomical);
            Era era = new Era(julianDayForToday, lunar, timeZoneForToday);
            Julian julian = new Julian(julianDayForToday, qiShuo);
            Holiday holiday = new Holiday(timeZoneForToday, lunar, solarTermDTO, era);
            MoonPhase moonPhase = new MoonPhase(julianDayForToday, julianOfMonth, astronomical);
            almanacDTOS[i] = AlmanacDTO.builder().era(era).holiday(holiday).islamic(islamic).julian(julian).lunar(lunar).solarTerm(solarTermDTO).sunriseMoonset(sunriseMoonset).timeZoneDTO(timeZoneForToday).moonPhase(moonPhase).build();
            ++i;
        }
        return almanacDTOS;
    }
}

