/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.dto;

import cn.huangdayu.almanac.aggregates.julian.Julian;
import cn.huangdayu.almanac.exception.AlmanacException;
import cn.huangdayu.almanac.utils.AreaUtils;
import cn.huangdayu.almanac.utils.ConstantsUtils;
import cn.huangdayu.almanac.utils.DateTimeUtils;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeZoneDTO {
    private int era;
    private double index;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int week;
    private String timeZone;
    private String province;
    private String area;
    private String address;
    private String position;
    private GregorianCalendar gregorianCalendar;
    private int dayIndexOfMonth;
    private int daysOfMonth;
    private int weeksOfMonth;
    private int weekFirstOfMonth;
    private int weekOfCurrentDay;
    private int weekIndexOfMonth;

    private TimeZoneDTO() {
    }

    public TimeZoneDTO(String province, String area, String dateTime) {
        this(province, area, DateTimeUtils.toDate(dateTime));
    }

    public TimeZoneDTO(String province, String area, Instant instant) {
        this(province, area, DateTimeUtils.timeInMillisToCalendar(instant.toEpochMilli()));
    }

    public TimeZoneDTO(String province, String area, Calendar calendar) {
        this(province, area, DateTimeUtils.timeInMillisToCalendar(calendar.getTimeInMillis()));
    }

    public TimeZoneDTO(String province, String area, Date date) {
        this(province, area, DateTimeUtils.timeInMillisToCalendar(date.getTime()));
    }

    public TimeZoneDTO(String province, String area, GregorianCalendar gregorianCalendar) {
        this(gregorianCalendar, province, area);
    }

    public TimeZoneDTO(String province, String area, long currentTimeMillis) {
        this(province, area, DateTimeUtils.timeInMillisToCalendar(currentTimeMillis));
    }

    public TimeZoneDTO(String province, String area, int year, int month, int day, int hourOfDay, int minute, int second) {
        this(province, area, new GregorianCalendar(year, month - 1, day, hourOfDay, minute, second));
    }

    public TimeZoneDTO(int year, int month, int day, int hourOfDay, int minute, int second) {
        this(new GregorianCalendar(year, month - 1, day, hourOfDay, minute, second));
    }

    private TimeZoneDTO(GregorianCalendar gregorianCalendar) {
        this.gregorianCalendar = gregorianCalendar;
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2) + 1;
        this.day = gregorianCalendar.get(5);
        this.week = gregorianCalendar.get(7) - (gregorianCalendar.getFirstDayOfWeek() == 1 ? 1 : 0);
        this.hour = gregorianCalendar.get(11);
        this.minute = gregorianCalendar.get(12);
        this.second = gregorianCalendar.get(13);
        this.era = gregorianCalendar.get(0);
        this.index = DateTimeUtils.getTimZoneInt(gregorianCalendar);
        String format = DateTimeUtils.formatDateByFormat(gregorianCalendar, "Z");
        String value = format.substring(1, 3);
        int i = 1;
        int j = Integer.parseInt(value);
        i = j > 0 ? Integer.parseInt(value) : Integer.parseInt(value.substring(1));
        this.timeZone = format.contains("-") ? format + " \u897f" + ConstantsUtils.TIMEZONE[i - 1] + "\u533a" : format + " \u4e1c" + ConstantsUtils.TIMEZONE[i - 1] + "\u533a";
    }

    public TimeZoneDTO(TimeZoneDTO timeZoneDTO) {
        this(new GregorianCalendar(timeZoneDTO.getEraYear(), timeZoneDTO.getMonth() - 1, timeZoneDTO.getDay(), timeZoneDTO.getHour(), timeZoneDTO.getMinute(), timeZoneDTO.getSecond()));
        try {
            this.address = timeZoneDTO.getAddress();
            this.timeZone = timeZoneDTO.getTimeZone();
            this.position = timeZoneDTO.getPosition();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlmanacException("\u65f6\u95f4\u4e0e\u5730\u5740\u6784\u9020\u5f02\u5e38", e);
        }
    }

    public TimeZoneDTO(GregorianCalendar gregorianCalendar, String ... names) {
        this(gregorianCalendar);
        try {
            if (names != null && names.length > 0) {
                if (names.length == 2) {
                    this.province = names[0];
                    this.area = names[1];
                } else if (names.length == 1) {
                    String name = names[0];
                    String[] nameList = name.trim().split("[\u7701\u5e02\u533a\u53bf\u9547]");
                    if (nameList.length < 2) {
                        this.province = "\u5e7f\u4e1c";
                        this.area = "\u5f90\u95fb";
                    } else if (nameList.length == 2) {
                        this.province = nameList[0];
                        this.area = nameList[1];
                    } else {
                        this.province = nameList[0];
                        this.area = nameList[2];
                    }
                }
            } else {
                this.province = "\u5e7f\u4e1c";
                this.area = "\u5f90\u95fb";
            }
            this.address = AreaUtils.judgeArea(this.province, this.area)[1];
            this.position = this.province.replaceAll("\u7701", "") + " " + this.area.replaceAll("\u5e02", "").replaceAll("\u533a", "").replaceAll("\u53bf", "").replaceAll("\u9547", "").replaceAll("\u4e61", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AlmanacException("\u65f6\u95f4\u4e0e\u5730\u5740\u6784\u9020\u5f02\u5e38", e);
        }
    }

    public TimeZoneDTO nextDay(int day, Julian julian) {
        this.setDay(day + 1);
        TimeZoneDTO timeZoneDTO = new TimeZoneDTO(this);
        timeZoneDTO.setDayIndexOfMonth(day);
        timeZoneDTO.setDaysOfMonth(julian.getNumberDayOfMonth());
        timeZoneDTO.setWeekFirstOfMonth(julian.getWeekFirstDayOfMonth());
        timeZoneDTO.setWeekOfCurrentDay((julian.getWeekFirstDayOfMonth() + day) % 7);
        timeZoneDTO.setWeekIndexOfMonth((julian.getWeekFirstDayOfMonth() + day) / 7);
        timeZoneDTO.setWeeksOfMonth((julian.getWeekFirstDayOfMonth() + julian.getNumberDayOfMonth() - 1) / 7 + 1);
        return timeZoneDTO;
    }

    public int getEraYear() {
        return this.getEra() == 0 ? -this.getYear() + 1 : this.getYear();
    }

    public String getDateTimeInfo() {
        return this.getEraYear() + "-" + this.add0(this.month) + "-" + this.add0(this.day) + " " + this.add0(this.hour) + ":" + this.add0(this.minute) + ":" + this.add0(this.second);
    }

    public String getDateInfo() {
        return this.getEraYear() + "-" + this.add0(this.month) + "-" + this.add0(this.day);
    }

    private String add0(int value) {
        return value < 10 ? "0" + value : "" + value;
    }

    public String getInfo() {
        return (this.era == 0 ? "\u516c\u5143\u524d" : "") + this.getDateTimeInfo() + " " + ConstantsUtils.WEEK_NAME[this.week];
    }

    public String toString() {
        return "TimeZoneDTO{year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", week=" + this.week + ", timeZone='" + this.timeZone + '\'' + ", province='" + this.province + '\'' + ", area='" + this.area + '\'' + ", address='" + this.address + '\'' + ", position='" + this.position + '\'' + '}';
    }

    public int getEra() {
        return this.era;
    }

    public double getIndex() {
        return this.index;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getWeek() {
        return this.week;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getProvince() {
        return this.province;
    }

    public String getArea() {
        return this.area;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPosition() {
        return this.position;
    }

    public GregorianCalendar getGregorianCalendar() {
        return this.gregorianCalendar;
    }

    public int getDayIndexOfMonth() {
        return this.dayIndexOfMonth;
    }

    public int getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public int getWeeksOfMonth() {
        return this.weeksOfMonth;
    }

    public int getWeekFirstOfMonth() {
        return this.weekFirstOfMonth;
    }

    public int getWeekOfCurrentDay() {
        return this.weekOfCurrentDay;
    }

    public int getWeekIndexOfMonth() {
        return this.weekIndexOfMonth;
    }

    public void setEra(int era) {
        this.era = era;
    }

    public void setIndex(double index) {
        this.index = index;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public void setSecond(int second) {
        this.second = second;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setGregorianCalendar(GregorianCalendar gregorianCalendar) {
        this.gregorianCalendar = gregorianCalendar;
    }

    public void setDayIndexOfMonth(int dayIndexOfMonth) {
        this.dayIndexOfMonth = dayIndexOfMonth;
    }

    public void setDaysOfMonth(int daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    public void setWeeksOfMonth(int weeksOfMonth) {
        this.weeksOfMonth = weeksOfMonth;
    }

    public void setWeekFirstOfMonth(int weekFirstOfMonth) {
        this.weekFirstOfMonth = weekFirstOfMonth;
    }

    public void setWeekOfCurrentDay(int weekOfCurrentDay) {
        this.weekOfCurrentDay = weekOfCurrentDay;
    }

    public void setWeekIndexOfMonth(int weekIndexOfMonth) {
        this.weekIndexOfMonth = weekIndexOfMonth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeZoneDTO)) {
            return false;
        }
        TimeZoneDTO other = (TimeZoneDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEra() != other.getEra()) {
            return false;
        }
        if (Double.compare(this.getIndex(), other.getIndex()) != 0) {
            return false;
        }
        if (this.getYear() != other.getYear()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getHour() != other.getHour()) {
            return false;
        }
        if (this.getMinute() != other.getMinute()) {
            return false;
        }
        if (this.getSecond() != other.getSecond()) {
            return false;
        }
        if (this.getWeek() != other.getWeek()) {
            return false;
        }
        if (this.getDayIndexOfMonth() != other.getDayIndexOfMonth()) {
            return false;
        }
        if (this.getDaysOfMonth() != other.getDaysOfMonth()) {
            return false;
        }
        if (this.getWeeksOfMonth() != other.getWeeksOfMonth()) {
            return false;
        }
        if (this.getWeekFirstOfMonth() != other.getWeekFirstOfMonth()) {
            return false;
        }
        if (this.getWeekOfCurrentDay() != other.getWeekOfCurrentDay()) {
            return false;
        }
        if (this.getWeekIndexOfMonth() != other.getWeekIndexOfMonth()) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$province = this.getProvince();
        String other$province = other.getProvince();
        if (this$province == null ? other$province != null : !this$province.equals(other$province)) {
            return false;
        }
        String this$area = this.getArea();
        String other$area = other.getArea();
        if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$position = this.getPosition();
        String other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        GregorianCalendar this$gregorianCalendar = this.getGregorianCalendar();
        GregorianCalendar other$gregorianCalendar = other.getGregorianCalendar();
        return !(this$gregorianCalendar == null ? other$gregorianCalendar != null : !((Object)this$gregorianCalendar).equals(other$gregorianCalendar));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimeZoneDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEra();
        long $index = Double.doubleToLongBits(this.getIndex());
        result = result * 59 + (int)($index >>> 32 ^ $index);
        result = result * 59 + this.getYear();
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getDay();
        result = result * 59 + this.getHour();
        result = result * 59 + this.getMinute();
        result = result * 59 + this.getSecond();
        result = result * 59 + this.getWeek();
        result = result * 59 + this.getDayIndexOfMonth();
        result = result * 59 + this.getDaysOfMonth();
        result = result * 59 + this.getWeeksOfMonth();
        result = result * 59 + this.getWeekFirstOfMonth();
        result = result * 59 + this.getWeekOfCurrentDay();
        result = result * 59 + this.getWeekIndexOfMonth();
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $province = this.getProvince();
        result = result * 59 + ($province == null ? 43 : $province.hashCode());
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        GregorianCalendar $gregorianCalendar = this.getGregorianCalendar();
        result = result * 59 + ($gregorianCalendar == null ? 43 : ((Object)$gregorianCalendar).hashCode());
        return result;
    }
}

