/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.dto;

import cn.huangdayu.almanac.aggregates.era.Era;
import cn.huangdayu.almanac.aggregates.holiday.Holiday;
import cn.huangdayu.almanac.aggregates.islamic.Islamic;
import cn.huangdayu.almanac.aggregates.julian.Julian;
import cn.huangdayu.almanac.aggregates.lunar.Lunar;
import cn.huangdayu.almanac.aggregates.moon_phase.MoonPhase;
import cn.huangdayu.almanac.aggregates.solar_term.SolarTerm;
import cn.huangdayu.almanac.aggregates.sunrise_moonset.SunriseMoonset;
import cn.huangdayu.almanac.dto.TimeZoneDTO;
import java.util.LinkedHashMap;
import java.util.Map;

public class AlmanacDTO {
    private Lunar lunar;
    private Era era;
    private Holiday holiday;
    private Islamic islamic;
    private Julian julian;
    private SolarTerm solarTerm;
    private SunriseMoonset sunriseMoonset;
    private TimeZoneDTO timeZoneDTO;
    private MoonPhase moonPhase;

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("\u5730\u70b9", this.getTimeZoneDTO().getPosition());
        map.put("\u897f\u5386", this.getTimeZoneDTO().getInfo());
        map.put("\u5e74\u53f7", this.lunar.getYearName());
        map.put("\u519c\u5386", this.lunar.getInfo());
        map.put("\u5e72\u652f", this.era.getInfo());
        map.put("\u8282\u6c14", this.solarTerm.getInfo());
        map.put("\u9ec4\u5e1d\u7eaa\u5e74", this.lunar.getKingChronologyName());
        map.put("\u5112\u7565\u5386", this.julian.getInfo());
        map.put("\u56de\u5386", this.islamic.getInfo());
        map.put("\u8282\u5047\u65e5", this.holiday.getInfo());
        map.put("\u7ecf\u5ea6", this.sunriseMoonset.getLongitude());
        map.put("\u7eac\u5ea6", this.sunriseMoonset.getLatitude());
        map.put("\u65f6\u533a", this.getTimeZoneDTO().getTimeZone());
        map.put("\u6e2f\u53e3", this.sunriseMoonset.getPortName());
        map.put("\u663c\u957f", this.sunriseMoonset.getDiurnalTime());
        map.put("\u591c\u957f", this.sunriseMoonset.getNightTime());
        map.put("\u5929\u4eae", this.sunriseMoonset.getDawnTime());
        map.put("\u65e5\u51fa", this.sunriseMoonset.getSunRiseTime());
        map.put("\u4e2d\u5929", this.sunriseMoonset.getMidDayTime());
        map.put("\u65e5\u843d", this.sunriseMoonset.getSunSetTime());
        map.put("\u5929\u9ed1", this.sunriseMoonset.getDarkTime());
        map.put("\u6708\u51fa", this.sunriseMoonset.getMoonRiseTime());
        map.put("\u6708\u4e2d", this.sunriseMoonset.getMoonMiddleTime());
        map.put("\u6708\u843d", this.sunriseMoonset.getMoonSetTime());
        map.put("\u6708\u76f8", this.moonPhase.getInfo());
        map.put("\u6708\u671f", String.valueOf(this.lunar.getDaysOfMonth()));
        map.put("\u95f0\u6708", String.valueOf(this.lunar.getLeapMonth()));
        map.put("\u95f0\u5e74", String.valueOf(this.lunar.getLeapYear()));
        return map;
    }

    AlmanacDTO(Lunar lunar, Era era, Holiday holiday, Islamic islamic, Julian julian, SolarTerm solarTerm, SunriseMoonset sunriseMoonset, TimeZoneDTO timeZoneDTO, MoonPhase moonPhase) {
        this.lunar = lunar;
        this.era = era;
        this.holiday = holiday;
        this.islamic = islamic;
        this.julian = julian;
        this.solarTerm = solarTerm;
        this.sunriseMoonset = sunriseMoonset;
        this.timeZoneDTO = timeZoneDTO;
        this.moonPhase = moonPhase;
    }

    public static AlmanacDTOBuilder builder() {
        return new AlmanacDTOBuilder();
    }

    public Lunar getLunar() {
        return this.lunar;
    }

    public Era getEra() {
        return this.era;
    }

    public Holiday getHoliday() {
        return this.holiday;
    }

    public Islamic getIslamic() {
        return this.islamic;
    }

    public Julian getJulian() {
        return this.julian;
    }

    public SolarTerm getSolarTerm() {
        return this.solarTerm;
    }

    public SunriseMoonset getSunriseMoonset() {
        return this.sunriseMoonset;
    }

    public TimeZoneDTO getTimeZoneDTO() {
        return this.timeZoneDTO;
    }

    public MoonPhase getMoonPhase() {
        return this.moonPhase;
    }

    public void setLunar(Lunar lunar) {
        this.lunar = lunar;
    }

    public void setEra(Era era) {
        this.era = era;
    }

    public void setHoliday(Holiday holiday) {
        this.holiday = holiday;
    }

    public void setIslamic(Islamic islamic) {
        this.islamic = islamic;
    }

    public void setJulian(Julian julian) {
        this.julian = julian;
    }

    public void setSolarTerm(SolarTerm solarTerm) {
        this.solarTerm = solarTerm;
    }

    public void setSunriseMoonset(SunriseMoonset sunriseMoonset) {
        this.sunriseMoonset = sunriseMoonset;
    }

    public void setTimeZoneDTO(TimeZoneDTO timeZoneDTO) {
        this.timeZoneDTO = timeZoneDTO;
    }

    public void setMoonPhase(MoonPhase moonPhase) {
        this.moonPhase = moonPhase;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlmanacDTO)) {
            return false;
        }
        AlmanacDTO other = (AlmanacDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Lunar this$lunar = this.getLunar();
        Lunar other$lunar = other.getLunar();
        if (this$lunar == null ? other$lunar != null : !this$lunar.equals(other$lunar)) {
            return false;
        }
        Era this$era = this.getEra();
        Era other$era = other.getEra();
        if (this$era == null ? other$era != null : !this$era.equals(other$era)) {
            return false;
        }
        Holiday this$holiday = this.getHoliday();
        Holiday other$holiday = other.getHoliday();
        if (this$holiday == null ? other$holiday != null : !this$holiday.equals(other$holiday)) {
            return false;
        }
        Islamic this$islamic = this.getIslamic();
        Islamic other$islamic = other.getIslamic();
        if (this$islamic == null ? other$islamic != null : !this$islamic.equals(other$islamic)) {
            return false;
        }
        Julian this$julian = this.getJulian();
        Julian other$julian = other.getJulian();
        if (this$julian == null ? other$julian != null : !this$julian.equals(other$julian)) {
            return false;
        }
        SolarTerm this$solarTerm = this.getSolarTerm();
        SolarTerm other$solarTerm = other.getSolarTerm();
        if (this$solarTerm == null ? other$solarTerm != null : !this$solarTerm.equals(other$solarTerm)) {
            return false;
        }
        SunriseMoonset this$sunriseMoonset = this.getSunriseMoonset();
        SunriseMoonset other$sunriseMoonset = other.getSunriseMoonset();
        if (this$sunriseMoonset == null ? other$sunriseMoonset != null : !this$sunriseMoonset.equals(other$sunriseMoonset)) {
            return false;
        }
        TimeZoneDTO this$timeZoneDTO = this.getTimeZoneDTO();
        TimeZoneDTO other$timeZoneDTO = other.getTimeZoneDTO();
        if (this$timeZoneDTO == null ? other$timeZoneDTO != null : !((Object)this$timeZoneDTO).equals(other$timeZoneDTO)) {
            return false;
        }
        MoonPhase this$moonPhase = this.getMoonPhase();
        MoonPhase other$moonPhase = other.getMoonPhase();
        return !(this$moonPhase == null ? other$moonPhase != null : !this$moonPhase.equals(other$moonPhase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlmanacDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Lunar $lunar = this.getLunar();
        result = result * 59 + ($lunar == null ? 43 : $lunar.hashCode());
        Era $era = this.getEra();
        result = result * 59 + ($era == null ? 43 : $era.hashCode());
        Holiday $holiday = this.getHoliday();
        result = result * 59 + ($holiday == null ? 43 : $holiday.hashCode());
        Islamic $islamic = this.getIslamic();
        result = result * 59 + ($islamic == null ? 43 : $islamic.hashCode());
        Julian $julian = this.getJulian();
        result = result * 59 + ($julian == null ? 43 : $julian.hashCode());
        SolarTerm $solarTerm = this.getSolarTerm();
        result = result * 59 + ($solarTerm == null ? 43 : $solarTerm.hashCode());
        SunriseMoonset $sunriseMoonset = this.getSunriseMoonset();
        result = result * 59 + ($sunriseMoonset == null ? 43 : $sunriseMoonset.hashCode());
        TimeZoneDTO $timeZoneDTO = this.getTimeZoneDTO();
        result = result * 59 + ($timeZoneDTO == null ? 43 : ((Object)$timeZoneDTO).hashCode());
        MoonPhase $moonPhase = this.getMoonPhase();
        result = result * 59 + ($moonPhase == null ? 43 : $moonPhase.hashCode());
        return result;
    }

    public String toString() {
        return "AlmanacDTO(lunar=" + this.getLunar() + ", era=" + this.getEra() + ", holiday=" + this.getHoliday() + ", islamic=" + this.getIslamic() + ", julian=" + this.getJulian() + ", solarTerm=" + this.getSolarTerm() + ", sunriseMoonset=" + this.getSunriseMoonset() + ", timeZoneDTO=" + this.getTimeZoneDTO() + ", moonPhase=" + this.getMoonPhase() + ")";
    }

    public static class AlmanacDTOBuilder {
        private Lunar lunar;
        private Era era;
        private Holiday holiday;
        private Islamic islamic;
        private Julian julian;
        private SolarTerm solarTerm;
        private SunriseMoonset sunriseMoonset;
        private TimeZoneDTO timeZoneDTO;
        private MoonPhase moonPhase;

        AlmanacDTOBuilder() {
        }

        public AlmanacDTOBuilder lunar(Lunar lunar) {
            this.lunar = lunar;
            return this;
        }

        public AlmanacDTOBuilder era(Era era) {
            this.era = era;
            return this;
        }

        public AlmanacDTOBuilder holiday(Holiday holiday) {
            this.holiday = holiday;
            return this;
        }

        public AlmanacDTOBuilder islamic(Islamic islamic) {
            this.islamic = islamic;
            return this;
        }

        public AlmanacDTOBuilder julian(Julian julian) {
            this.julian = julian;
            return this;
        }

        public AlmanacDTOBuilder solarTerm(SolarTerm solarTerm) {
            this.solarTerm = solarTerm;
            return this;
        }

        public AlmanacDTOBuilder sunriseMoonset(SunriseMoonset sunriseMoonset) {
            this.sunriseMoonset = sunriseMoonset;
            return this;
        }

        public AlmanacDTOBuilder timeZoneDTO(TimeZoneDTO timeZoneDTO) {
            this.timeZoneDTO = timeZoneDTO;
            return this;
        }

        public AlmanacDTOBuilder moonPhase(MoonPhase moonPhase) {
            this.moonPhase = moonPhase;
            return this;
        }

        public AlmanacDTO build() {
            return new AlmanacDTO(this.lunar, this.era, this.holiday, this.islamic, this.julian, this.solarTerm, this.sunriseMoonset, this.timeZoneDTO, this.moonPhase);
        }

        public String toString() {
            return "AlmanacDTO.AlmanacDTOBuilder(lunar=" + this.lunar + ", era=" + this.era + ", holiday=" + this.holiday + ", islamic=" + this.islamic + ", julian=" + this.julian + ", solarTerm=" + this.solarTerm + ", sunriseMoonset=" + this.sunriseMoonset + ", timeZoneDTO=" + this.timeZoneDTO + ", moonPhase=" + this.moonPhase + ")";
        }
    }
}

