/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.solar_term;

import cn.huangdayu.almanac.aggregates.BaseAlmanac;
import cn.huangdayu.almanac.aggregates.astronomical.Astronomical;
import cn.huangdayu.almanac.aggregates.qishuo.QiShuo;
import cn.huangdayu.almanac.utils.AnnalsUtils;
import cn.huangdayu.almanac.utils.ConstantsUtils;
import cn.huangdayu.almanac.utils.JulianCalendarUtils;
import java.util.ArrayList;
import java.util.List;

public class SolarTerm
extends BaseAlmanac {
    private Integer index;
    private String name;
    private Integer julianDay;
    private Integer afterDay;
    private String dateTime;
    private String desc;
    private double julianTime;
    private List<SolarTerm> next;

    private SolarTerm() {
    }

    public SolarTerm(int julianDayForToday, QiShuo qiShuo, Astronomical astronomical) {
        int qk = (int)Math.floor((double)(julianDayForToday - qiShuo.zhongQi[0] - 7) / 15.2184);
        if (qk < 23 && julianDayForToday >= qiShuo.zhongQi[qk + 1]) {
            ++qk;
        }
        double sunLonValue = astronomical.getSolarRetina();
        ArrayList<SolarTerm> solarTermAfterDTOS = new ArrayList<SolarTerm>();
        int qj = 24;
        int qi = qk;
        while (qi < qj) {
            double sunLonTime = AnnalsUtils.qi_accurate(sunLonValue);
            this.julianDay = (int)Math.floor(sunLonTime + 0.5);
            int qn = (int)Math.floor(sunLonValue / (Math.PI * 2) * 24.0 + 2.400000601E7) % 24;
            sunLonValue += 0.2617993877991494;
            this.julianDay = 2451545 + this.julianDay;
            int afterDays = this.julianDay - 2451545 - julianDayForToday;
            SolarTerm solarTerm = afterDays == 0 ? this : new SolarTerm();
            solarTerm.setJulianTime(sunLonTime);
            solarTerm.setDateTime(JulianCalendarUtils.julianDays2str(2451545.0 + sunLonTime));
            solarTerm.setIndex(qn);
            solarTerm.setName(AnnalsUtils.JIEQI[qn]);
            solarTerm.setJulianDay(this.julianDay);
            solarTerm.setDesc(ConstantsUtils.getDesc(AnnalsUtils.JIEQI[qn]));
            solarTerm.setAfterDay(afterDays);
            solarTermAfterDTOS.add(solarTerm);
            if (++qi != 24) continue;
            qi = 0;
            qj = qk;
        }
        this.setNext(solarTermAfterDTOS);
    }

    public SolarTerm getNextOne() {
        for (SolarTerm solarTerm : this.next) {
            if (solarTerm.getAfterDay() <= 0) continue;
            return solarTerm;
        }
        return this.next.get(0);
    }

    public SolarTerm getByName(String name) {
        for (SolarTerm solarTerm : this.next) {
            if (!solarTerm.getName().equalsIgnoreCase(name)) continue;
            return solarTerm;
        }
        return this.next.get(0);
    }

    @Override
    public String getInfo() {
        return this.name != null ? this.name + " " + this.dateTime : this.getNextOne().getInfo();
    }

    public String toString() {
        return "SolarTermDTO{index=" + this.index + ", name='" + this.name + '\'' + ", julianDay=" + this.julianDay + ", afterDay=" + this.afterDay + ", date='" + this.dateTime + '\'' + ", julianTime=" + this.julianTime + '}';
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setJulianDay(Integer julianDay) {
        this.julianDay = julianDay;
    }

    public void setAfterDay(Integer afterDay) {
        this.afterDay = afterDay;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setJulianTime(double julianTime) {
        this.julianTime = julianTime;
    }

    public void setNext(List<SolarTerm> next) {
        this.next = next;
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Integer getJulianDay() {
        return this.julianDay;
    }

    public Integer getAfterDay() {
        return this.afterDay;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getDesc() {
        return this.desc;
    }

    public double getJulianTime() {
        return this.julianTime;
    }

    public List<SolarTerm> getNext() {
        return this.next;
    }
}

