/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.qishuo;

import cn.huangdayu.almanac.utils.AnnalsUtils;
import cn.huangdayu.almanac.utils.AstronomyArithmeticUtils;
import cn.huangdayu.almanac.utils.CommonUtils;

public class QiShuo {
    private static String sCorrectTable = "";
    private static String qCorrectTable = "";
    private static final double[] S_FITTING_PARAMETERS = new double[]{1457698.231017, 29.53067166, 1546082.512234, 29.53085106, 1640640.7353, 29.5306, 1642472.151543, 29.53085439, 1683430.5093, 29.53086148, 1752148.041079, 29.53085097, 1807665.420323, 29.53059851, 1883618.1141, 29.5306, 1907360.7047, 29.5306, 1936596.2249, 29.5306, 1939135.6753, 29.5306, 1947168.0};
    private static final double[] Q_FITTING_PARAMETERS = new double[]{1640650.479938, 15.218425, 1642476.703182, 15.21874996, 1683430.515601, 15.218750011, 1752157.640664, 15.218749978, 1807675.003759, 15.218620279, 1883627.765182, 15.218612292, 1907369.1281, 15.218449176, 1936603.140413, 15.218425, 1939145.52418, 15.218466998, 1947180.7983, 15.218524844, 1964362.041824, 15.218533526, 1987372.340971, 15.218513908, 1999653.819126, 15.218530782, 2007445.469786, 15.218535181, 2021324.917146, 15.218526248, 2047257.232342, 15.218519654, 2070282.898213, 15.218425, 2073204.87285, 15.218515221, 2080144.500926, 15.218530782, 2086703.688963, 15.218523776, 2110033.182763, 15.218425, 2111190.300888, 15.218425, 2113731.271005, 15.218515671, 2120670.840263, 15.218425, 2123973.309063, 15.218425, 2125068.997336, 15.218477932, 2136026.312633, 15.218472436, 2156099.495538, 15.218425, 2159021.324663, 15.218425, 2162308.575254, 15.218461742, 2178485.706538, 15.218425, 2178759.662849, 15.218445786, 2185334.0208, 15.218425, 2187525.481425, 15.218425, 2188621.191481, 15.218437494, 2322147.76};
    public int leapMonthIndex = 0;
    public String[] monthNames = new String[14];
    private int[] monthIndex = new int[14];
    public int[] zhongQi = new int[27];
    public int[] heShuo = new int[15];
    public int[] monthValue = new int[15];

    private static double sLowCalculate(double w) {
        double v = 7771.37714500204;
        double t = (w + 1.08472) / v;
        t -= (-3.31E-5 * t * t + 0.10976 * Math.cos(0.785 + 8328.6914 * t) + 0.02224 * Math.cos(0.187 + 7214.0629 * t) - 0.03342 * Math.cos(4.669 + 628.3076 * t)) / v + (32.0 * (t + 1.8) * (t + 1.8) - 20.0) / 86400.0 / 36525.0;
        return t * 36525.0 + 0.3333333333333333;
    }

    private static double qLowCalculate(double w) {
        double v = 628.3319653318;
        double t = (w - 4.895062166) / v;
        t -= (53.0 * t * t + 334116.0 * Math.cos(4.67 + 628.307585 * t) + 2061.0 * Math.cos(2.678 + 628.3076 * t) * t) / v / 1.0E7;
        double l = 4.895062166E7 + 6.283319653318E9 * t + 53.0 * t * t + 334166.0 * Math.cos(4.669257 + 628.307585 * t) + 3489.0 * Math.cos(4.6261 + 1256.61517 * t) + 2060.6 * Math.cos(2.67823 + 628.307585 * t) * t - 994.0 - 834.0 * Math.sin(2.1824 - 33.75705 * t);
        t -= (l / 1.0E7 - w) / 628.332 + (32.0 * (t + 1.8) * (t + 1.8) - 20.0) / 86400.0 / 36525.0;
        return t * 36525.0 + 0.3333333333333333;
    }

    private static double qHighCalculate(double w) {
        double t = AstronomyArithmeticUtils.S_aLon_t2(w) * 36525.0;
        double v = ((t = t - CommonUtils.dtT(t) + 0.3333333333333333) + 0.5) % 1.0 * 86400.0;
        if (v < 1200.0 || v > 85200.0) {
            t = AstronomyArithmeticUtils.S_aLon_t(w) * 36525.0 - CommonUtils.dtT(t) + 0.3333333333333333;
        }
        return t;
    }

    private static double sHighCalculate(double w) {
        double t = AstronomyArithmeticUtils.MS_aLon_t2(w) * 36525.0;
        double v = ((t = t - CommonUtils.dtT(t) + 0.3333333333333333) + 0.5) % 1.0 * 86400.0;
        if (v < 1800.0 || v > 84600.0) {
            t = AstronomyArithmeticUtils.MS_aLon_t(w) * 36525.0 - CommonUtils.dtT(t) + 0.3333333333333333;
        }
        return t;
    }

    private static String unzipCorrectTableValue(String s) {
        String o = "0000000000";
        String o2 = o + o;
        s = s.replace("/J/g", "00");
        s = s.replace("/I/g", "000");
        s = s.replace("/H/g", "0000");
        s = s.replace("/G/g", "00000");
        s = s.replace("/t/g", "02");
        s = s.replace("/s/g", "002");
        s = s.replace("/r/g", "0002");
        s = s.replace("/q/g", "00002");
        s = s.replace("/p/g", "000002");
        s = s.replace("/o/g", "0000002");
        s = s.replace("/n/g", "00000002");
        s = s.replace("/m/g", "000000002");
        s = s.replace("/l/g", "0000000002");
        s = s.replace("/k/g", "01");
        s = s.replace("/j/g", "0101");
        s = s.replace("/i/g", "001");
        s = s.replace("/h/g", "001001");
        s = s.replace("/g/g", "0001");
        s = s.replace("/f/g", "00001");
        s = s.replace("/e/g", "000001");
        s = s.replace("/d/g", "0000001");
        s = s.replace("/c/g", "00000001");
        s = s.replace("/b/g", "000000001");
        s = s.replace("/a/g", "0000000001");
        s = s.replace("/A/g", o2 + o2 + o2);
        s = s.replace("/B/g", o2 + o2 + o);
        s = s.replace("/C/g", o2 + o2);
        s = s.replace("/D/g", o2 + o);
        s = s.replace("/E/g", o2);
        s = s.replace("/F/g", o);
        return s;
    }

    private static int calculateJulianDay(double julianDay, String qs) {
        julianDay += 2451545.0;
        double D = 0.0;
        double[] B = S_FITTING_PARAMETERS;
        int pc = 14;
        if (qs.equals("\u6c14")) {
            B = Q_FITTING_PARAMETERS;
            pc = 7;
        }
        double f1 = B[0] - (double)pc;
        double f2 = B[B.length - 1] - (double)pc;
        double f3 = 2436935.0;
        if (julianDay < f1 || julianDay >= f3) {
            if (qs.equals("\u6c14")) {
                return (int)Math.floor(QiShuo.qHighCalculate(Math.floor((julianDay + (double)pc - 2451259.0) / 365.2422 * 24.0) * Math.PI / 12.0) + 0.5);
            }
            return (int)Math.floor(QiShuo.sHighCalculate(Math.floor((julianDay + (double)pc - 2451551.0) / 29.5306) * Math.PI * 2.0) + 0.5);
        }
        if (julianDay >= f1 && julianDay < f2) {
            int i;
            for (i = 0; i < B.length && !(julianDay + (double)pc < B[i + 2]); i += 2) {
            }
            D = B[i] + B[i + 1] * Math.floor((julianDay + (double)pc - B[i]) / B[i + 1]);
            if ((int)(D = Math.floor(D + 0.5)) == 1683460) {
                D += 1.0;
            }
            return (int)(D - 2451545.0);
        }
        if (julianDay >= f2 && julianDay < f3) {
            String n;
            if (qs.equals("\u6c14")) {
                D = Math.floor(QiShuo.qLowCalculate(Math.floor((julianDay + (double)pc - 2451259.0) / 365.2422 * 24.0) * Math.PI / 12.0) + 0.5);
                int index = (int)Math.floor((julianDay - f2) / 365.2422 * 24.0);
                n = CommonUtils.subString(qCorrectTable, index, index + 1);
            } else {
                D = Math.floor(QiShuo.sLowCalculate(Math.floor((julianDay + (double)pc - 2451551.0) / 29.5306) * Math.PI * 2.0) + 0.5);
                int index = (int)Math.floor((julianDay - f2) / 29.5306);
                n = CommonUtils.subString(sCorrectTable, index, index + 1);
            }
            if (n.equals("1")) {
                return (int)(D + 1.0);
            }
            if (n.equals("2")) {
                return (int)(D - 1.0);
            }
            return (int)D;
        }
        return (int)D;
    }

    public void calculateMonth(int julianDay) {
        int i;
        int[] zhongQiValue = this.zhongQi;
        int[] heShuoValue = this.heShuo;
        double j = Math.floor((double)(julianDay - 355 + 183) / 365.2422) * 365.2422 + 355.0;
        if (QiShuo.calculateJulianDay(j, "\u6c14") > julianDay) {
            j -= 365.2422;
        }
        for (i = 0; i < 25; ++i) {
            zhongQiValue[i] = QiShuo.calculateJulianDay(j + 15.2184 * (double)i, "\u6c14");
        }
        zhongQiValue[25] = QiShuo.calculateJulianDay(j - 15.2, "\u6c14");
        zhongQiValue[26] = QiShuo.calculateJulianDay(j - 30.4, "\u6c14");
        double k = QiShuo.calculateJulianDay(zhongQiValue[0], "\u6714");
        if (k > (double)zhongQiValue[0]) {
            k -= 29.53;
        }
        for (i = 0; i < 15; ++i) {
            heShuoValue[i] = QiShuo.calculateJulianDay(k + 29.5306 * (double)i, "\u6714");
        }
        this.leapMonthIndex = 0;
        for (i = 0; i < 14; ++i) {
            this.monthValue[i] = this.heShuo[i + 1] - this.heShuo[i];
            this.monthIndex[i] = i;
        }
        int year = (int)(Math.floor((double)(this.zhongQi[0] + 10 + 180) / 365.2422) + 2000.0);
        if (year >= -721 && year <= -104) {
            Object[] objects = new Object[10];
            for (i = 0; i < 3; ++i) {
                int yearIndex = year + i - 1;
                if (yearIndex >= -721) {
                    objects[i] = QiShuo.calculateJulianDay(-993847.0 + Math.floor(0.342 + (double)(yearIndex + 721) * 12.368422) * 29.5306, "\u6714");
                    objects[i + 3] = "\u5341\u4e09";
                    objects[i + 6] = 2;
                }
                if (yearIndex >= -479) {
                    objects[i] = QiShuo.calculateJulianDay(-905462.0 + Math.floor(0.5 + (double)(yearIndex + 479) * 12.368422) * 29.5306, "\u6714");
                    objects[i + 3] = "\u5341\u4e09";
                    objects[i + 6] = 2;
                }
                if (yearIndex < -220) continue;
                objects[i] = QiShuo.calculateJulianDay(-810904.0 + Math.floor(0.866 + (double)(yearIndex + 220) * 12.369) * 29.5306, "\u6714");
                objects[i + 3] = "\u540e\u4e5d";
                objects[i + 6] = 11;
            }
            for (i = 0; i < 14; ++i) {
                int objectIndex;
                for (objectIndex = 2; objectIndex >= 0 && this.heShuo[i] < Integer.parseInt(objects[objectIndex].toString()); --objectIndex) {
                }
                int monthNumber = (int)Math.floor((double)(this.heShuo[i] - Integer.parseInt(objects[objectIndex].toString()) + 15) / 29.5306);
                this.monthNames[i] = monthNumber < 12 ? AnnalsUtils.MONTH_NAME_BIG_CN[(monthNumber + Integer.parseInt(objects[objectIndex + 6].toString())) % 12] : objects[objectIndex + 3].toString();
            }
            return;
        }
        if (heShuoValue[13] <= zhongQiValue[24]) {
            for (i = 1; heShuoValue[i + 1] > zhongQiValue[2 * i] && i < 13; ++i) {
            }
            this.leapMonthIndex = i;
            while (i < 14) {
                int n = i++;
                this.monthIndex[n] = this.monthIndex[n] - 1;
            }
        }
        for (i = 0; i < 14; ++i) {
            int julianDayValue = this.heShuo[i] + 2451545;
            int monthIndexValue = this.monthIndex[i];
            String monthName = AnnalsUtils.MONTH_NAME_BIG_CN[monthIndexValue % 12];
            if (julianDayValue >= 1724360 && julianDayValue <= 1729794) {
                monthName = AnnalsUtils.MONTH_NAME_BIG_CN[(monthIndexValue + 1) % 12];
            } else if (julianDayValue >= 1807724 && julianDayValue <= 1808699) {
                monthName = AnnalsUtils.MONTH_NAME_BIG_CN[(monthIndexValue + 1) % 12];
            } else if (julianDayValue >= 1999349 && julianDayValue <= 1999467) {
                monthName = AnnalsUtils.MONTH_NAME_BIG_CN[(monthIndexValue + 2) % 12];
            } else if (julianDayValue >= 1973067 && julianDayValue <= 1977052) {
                if (monthIndexValue % 12 == 0) {
                    monthName = "\u6b63";
                }
                if (monthIndexValue == 2) {
                    monthName = "\u4e00";
                }
            }
            if (julianDayValue == 1729794 || julianDayValue == 1808699) {
                monthName = "\u62fe\u8d30";
            }
            this.monthNames[i] = monthName;
        }
    }

    static {
        String sCorrectTableValue = "EqoFscDcrFpmEsF2DfFideFelFpFfFfFiaipqti1ksttikptikqckstekqttgkqttgkqteksttikptikq2fjstgjqttjkqttgkqt";
        sCorrectTableValue = sCorrectTableValue + "ekstfkptikq2tijstgjiFkirFsAeACoFsiDaDiADc1AFbBfgdfikijFifegF1FhaikgFag1E2btaieeibggiffdeigFfqDfaiBkF";
        sCorrectTableValue = sCorrectTableValue + "1kEaikhkigeidhhdiegcFfakF1ggkidbiaedksaFffckekidhhdhdikcikiakicjF1deedFhFccgicdekgiFbiaikcfi1kbFibef";
        sCorrectTableValue = sCorrectTableValue + "gEgFdcFkFeFkdcfkF1kfkcickEiFkDacFiEfbiaejcFfffkhkdgkaiei1ehigikhdFikfckF1dhhdikcfgjikhfjicjicgiehdik";
        sCorrectTableValue = sCorrectTableValue + "cikggcifgiejF1jkieFhegikggcikFegiegkfjebhigikggcikdgkaFkijcfkcikfkcifikiggkaeeigefkcdfcfkhkdgkegieid";
        sCorrectTableValue = sCorrectTableValue + "hijcFfakhfgeidieidiegikhfkfckfcjbdehdikggikgkfkicjicjF1dbidikFiggcifgiejkiegkigcdiegfggcikdbgfgefjF1";
        sCorrectTableValue = sCorrectTableValue + "kfegikggcikdgFkeeijcfkcikfkekcikdgkabhkFikaffcfkhkdgkegbiaekfkiakicjhfgqdq2fkiakgkfkhfkfcjiekgFebicg";
        sCorrectTableValue = sCorrectTableValue + "gbedF1jikejbbbiakgbgkacgiejkijjgigfiakggfggcibFifjefjF1kfekdgjcibFeFkijcfkfhkfkeaieigekgbhkfikidfcje";
        sCorrectTableValue = sCorrectTableValue + "aibgekgdkiffiffkiakF1jhbakgdki1dj1ikfkicjicjieeFkgdkicggkighdF1jfgkgfgbdkicggfggkidFkiekgijkeigfiski";
        sCorrectTableValue = sCorrectTableValue + "ggfaidheigF1jekijcikickiggkidhhdbgcfkFikikhkigeidieFikggikhkffaffijhidhhakgdkhkijF1kiakF1kfheakgdkif";
        sCorrectTableValue = sCorrectTableValue + "iggkigicjiejkieedikgdfcggkigieeiejfgkgkigbgikicggkiaideeijkefjeijikhkiggkiaidheigcikaikffikijgkiahi1";
        sCorrectTableValue = sCorrectTableValue + "hhdikgjfifaakekighie1hiaikggikhkffakicjhiahaikggikhkijF1kfejfeFhidikggiffiggkigicjiekgieeigikggiffig";
        sCorrectTableValue = sCorrectTableValue + "gkidheigkgfjkeigiegikifiggkidhedeijcfkFikikhkiggkidhh1ehigcikaffkhkiggkidhh1hhigikekfiFkFikcidhh1hit";
        sCorrectTableValue = sCorrectTableValue + "cikggikhkfkicjicghiediaikggikhkijbjfejfeFhaikggifikiggkigiejkikgkgieeigikggiffiggkigieeigekijcijikgg";
        sCorrectTableValue = sCorrectTableValue + "ifikiggkideedeijkefkfckikhkiggkidhh1ehijcikaffkhkiggkidhh1hhigikhkikFikfckcidhh1hiaikgjikhfjicjicgie";
        sCorrectTableValue = sCorrectTableValue + "hdikcikggifikigiejfejkieFhegikggifikiggfghigkfjeijkhigikggifikiggkigieeijcijcikfksikifikiggkidehdeij";
        sCorrectTableValue = sCorrectTableValue + "cfdckikhkiggkhghh1ehijikifffffkhsFngErD1pAfBoDd1BlEtFqA2AqoEpDqElAEsEeB2BmADlDkqBtC1FnEpDqnEmFsFsAFn";
        sCorrectTableValue = sCorrectTableValue + "llBbFmDsDiCtDmAB2BmtCgpEplCpAEiBiEoFqFtEqsDcCnFtADnFlEgdkEgmEtEsCtDmADqFtAFrAtEcCqAE1BoFqC1F1DrFtBmF";
        sCorrectTableValue = sCorrectTableValue + "tAC2ACnFaoCgADcADcCcFfoFtDlAFgmFqBq2bpEoAEmkqnEeCtAE1bAEqgDfFfCrgEcBrACfAAABqAAB1AAClEnFeCtCgAADqDoB";
        sCorrectTableValue = sCorrectTableValue + "mtAAACbFiAAADsEtBqAB2FsDqpFqEmFsCeDtFlCeDtoEpClEqAAFrAFoCgFmFsFqEnAEcCqFeCtFtEnAEeFtAAEkFnErAABbFkAD";
        sCorrectTableValue = sCorrectTableValue + "nAAeCtFeAfBoAEpFtAABtFqAApDcCGJ";
        String qCorrectTableValue = "FrcFs22AFsckF2tsDtFqEtF1posFdFgiFseFtmelpsEfhkF2anmelpFlF1ikrotcnEqEq2FfqmcDsrFor22FgFrcgDscFs22FgEe";
        qCorrectTableValue = qCorrectTableValue + "FtE2sfFs22sCoEsaF2tsD1FpeE2eFsssEciFsFnmelpFcFhkF2tcnEqEpFgkrotcnEqrEtFermcDsrE222FgBmcmr22DaEfnaF22";
        qCorrectTableValue = qCorrectTableValue + "2sD1FpeForeF2tssEfiFpEoeFssD1iFstEqFppDgFstcnEqEpFg11FscnEqrAoAF2ClAEsDmDtCtBaDlAFbAEpAAAAAD2FgBiBqo";
        qCorrectTableValue = qCorrectTableValue + "BbnBaBoAAAAAAAEgDqAdBqAFrBaBoACdAAf1AACgAAAeBbCamDgEifAE2AABa1C1BgFdiAAACoCeE1ADiEifDaAEqAAFe1AcFbcA";
        qCorrectTableValue = qCorrectTableValue + "AAAAF1iFaAAACpACmFmAAAAAAAACrDaAAADG0";
        sCorrectTable = QiShuo.unzipCorrectTableValue(sCorrectTableValue);
        qCorrectTable = QiShuo.unzipCorrectTableValue(qCorrectTableValue);
    }
}

