/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.moon_phase;

import cn.huangdayu.almanac.aggregates.BaseAlmanac;
import cn.huangdayu.almanac.aggregates.astronomical.Astronomical;
import cn.huangdayu.almanac.aggregates.julian.Julian;
import cn.huangdayu.almanac.utils.AnnalsUtils;
import cn.huangdayu.almanac.utils.JulianCalendarUtils;
import java.util.ArrayList;
import java.util.List;

public class MoonPhase
extends BaseAlmanac {
    private Integer index;
    private String name;
    private Integer julianDay;
    private Integer afterDay;
    private String dateTime;
    private String desc;
    private double julianTime;
    private List<MoonPhase> next;

    private MoonPhase() {
    }

    public MoonPhase(int julianDayForToday, Julian julianOfMonth, Astronomical astronomical) {
        ArrayList<MoonPhase> moonPhasesList = new ArrayList<MoonPhase>();
        int julianDays = julianOfMonth.getFirstJulianDayOfMonth() + julianOfMonth.getNumberDayOfMonth();
        double moonLon = astronomical.getLunarRetina();
        for (int j = 0; j < julianOfMonth.getNumberDayOfMonth(); ++j) {
            double moonLonValue = AnnalsUtils.so_accurate(moonLon);
            this.julianDay = (int)Math.floor(moonLonValue + 0.5);
            int xn = (int)Math.floor(moonLon / (Math.PI * 2) * 4.0 + 4000000.01) % 4;
            moonLon += 1.5707963267948966;
            if (this.julianDay < julianOfMonth.getFirstJulianDayOfMonth() || this.julianDay >= julianDays) continue;
            this.julianDay = 2451545 + this.julianDay;
            int afterDays = this.julianDay - 2451545 - julianDayForToday;
            MoonPhase moonPhase = afterDays == 0 ? this : new MoonPhase();
            moonPhase.setName(AnnalsUtils.YUEXIANG[xn]);
            moonPhase.setJulianTime(2451545.0 + moonLonValue);
            moonPhase.setDateTime(JulianCalendarUtils.julianDays2str(2451545.0 + moonLonValue));
            moonPhase.setAfterDay(afterDays);
            moonPhasesList.add(moonPhase);
        }
        this.setNext(moonPhasesList);
    }

    public MoonPhase getNextOne() {
        for (MoonPhase moonPhase : this.next) {
            if (moonPhase.getAfterDay() <= 0) continue;
            return moonPhase;
        }
        return this.next.get(0);
    }

    @Override
    public String getInfo() {
        return this.name != null ? this.name + " " + this.dateTime : this.getNextOne().getInfo();
    }

    public String toString() {
        return "MoonPhase{index=" + this.index + ", name='" + this.name + '\'' + ", julianDay=" + this.julianDay + ", afterDay=" + this.afterDay + ", dateTime='" + this.dateTime + '\'' + ", desc='" + this.desc + '\'' + ", julianTime=" + this.julianTime + ", next=" + this.next + '}';
    }

    public Integer getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public Integer getJulianDay() {
        return this.julianDay;
    }

    public Integer getAfterDay() {
        return this.afterDay;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public String getDesc() {
        return this.desc;
    }

    public double getJulianTime() {
        return this.julianTime;
    }

    public List<MoonPhase> getNext() {
        return this.next;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setJulianDay(Integer julianDay) {
        this.julianDay = julianDay;
    }

    public void setAfterDay(Integer afterDay) {
        this.afterDay = afterDay;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setJulianTime(double julianTime) {
        this.julianTime = julianTime;
    }

    public void setNext(List<MoonPhase> next) {
        this.next = next;
    }
}

