/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.lunar;

import cn.huangdayu.almanac.aggregates.BaseAlmanac;
import cn.huangdayu.almanac.aggregates.qishuo.QiShuo;
import cn.huangdayu.almanac.dto.TimeZoneDTO;
import cn.huangdayu.almanac.utils.AnnalsUtils;
import cn.huangdayu.almanac.utils.ConstantsUtils;

public class Lunar
extends BaseAlmanac {
    private int monthOffset;
    private String year;
    private String month;
    private String day;
    private String time;
    private int daysOfMonth;
    private Boolean leapMonth = false;
    private Boolean leapYear = false;
    private String nextMonth;
    private int kingChronology;
    private int yearChronology;
    public int monthChronologySum;
    private int monthChronology;
    private String zodiac;
    private String yearName;
    private String kingChronologyName;

    public Lunar(TimeZoneDTO timeZoneDTO, int julianDayForToday, QiShuo qiShuo) {
        int mk;
        if (julianDayForToday < qiShuo.zhongQi[0] || julianDayForToday >= qiShuo.zhongQi[24]) {
            qiShuo.calculateMonth(julianDayForToday);
        }
        if ((mk = (julianDayForToday - qiShuo.heShuo[0]) / 30) < 13 && qiShuo.heShuo[mk + 1] <= julianDayForToday) {
            ++mk;
        }
        this.setMonthOffset(julianDayForToday - qiShuo.heShuo[mk]);
        this.setDay(AnnalsUtils.DAY_NAME[julianDayForToday - qiShuo.heShuo[mk]]);
        this.setLeapYear(qiShuo.leapMonthIndex > 0);
        this.setMonth(qiShuo.monthNames[mk]);
        this.setDaysOfMonth(qiShuo.monthValue[mk]);
        this.setLeapMonth(qiShuo.leapMonthIndex != 0 && qiShuo.leapMonthIndex == mk);
        this.setNextMonth(mk < 13 ? qiShuo.monthNames[mk + 1] : "\u672a\u77e5");
        int sum = (int)((double)timeZoneDTO.getHour() + 0.01 * (double)timeZoneDTO.getMinute());
        int index = (sum + 1) / 2;
        if (index >= 12) {
            index = 0;
        }
        String lunarTime = AnnalsUtils.DIZHI[index] + "\u65f6" + ConstantsUtils.GENG[index];
        if (timeZoneDTO.getMinute() % 15 > 13) {
            int k = (timeZoneDTO.getMinute() + 3) / 15;
            lunarTime = lunarTime + ConstantsUtils.KE[k];
        }
        this.setTime(lunarTime);
        int value = qiShuo.heShuo[2];
        for (int l = 0; l < 14; ++l) {
            if (!"\u6b63".equals(qiShuo.monthNames[l]) || qiShuo.leapMonthIndex == l && l != 0 || julianDayForToday >= (value = qiShuo.heShuo[l])) continue;
            value -= 365;
            break;
        }
        int lunarYears = (int)Math.floor((double)(value += 5810) / 365.2422 + 0.5);
        value = lunarYears + 12000;
        int kingChronology = lunarYears + 1984 + 2698;
        this.setKingChronology(kingChronology);
        this.setKingChronologyName("\u5f00\u5143" + kingChronology + "\u5e74");
        this.setYear(AnnalsUtils.TIANGAN[value % 10] + AnnalsUtils.DIZHI[value % 12]);
        this.setZodiac(AnnalsUtils.SHENGXIAO[value % 12]);
        this.setYearName(AnnalsUtils.getYearName(timeZoneDTO.getEraYear()));
        value = (int)((double)(qiShuo.zhongQi[3] + (julianDayForToday < qiShuo.zhongQi[3] ? -365 : 0)) + 5844.0 - 35.0);
        this.setYearChronology((int)Math.floor((double)value / 365.2422 + 0.5));
        mk = (int)Math.floor((double)(julianDayForToday - qiShuo.zhongQi[0]) / 30.43685);
        if (mk < 12 && julianDayForToday >= qiShuo.zhongQi[2 * mk + 1]) {
            ++mk;
        }
        value = mk + (int)Math.floor((double)(qiShuo.zhongQi[12] + 390) / 365.2422) * 12 + 900000;
        this.setMonthChronologySum(value);
        this.setMonthChronology(value % 12);
    }

    @Override
    public String getInfo() {
        return this.year + this.zodiac + "\u5e74" + this.month + (this.month.length() < 2 ? "\u6708" : "") + this.day + this.time;
    }

    public String toString() {
        return "LunarDTO{monthOffset=" + this.monthOffset + ", month='" + this.month + '\'' + ", day='" + this.day + '\'' + ", time='" + this.time + '\'' + ", daysOfMonth=" + this.daysOfMonth + ", leapDesc='" + this.leapMonth + '\'' + ", leapYear=" + this.leapYear + ", nextMonth='" + this.nextMonth + '\'' + ", kingChronology=" + this.kingChronology + ", yearChronology=" + this.yearChronology + ", monthChronology=" + this.monthChronology + ", zodiac='" + this.zodiac + '\'' + ", yearName='" + this.yearName + '\'' + ", kingChronologyName='" + this.kingChronologyName + '\'' + '}';
    }

    public int getMonthOffset() {
        return this.monthOffset;
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDay() {
        return this.day;
    }

    public String getTime() {
        return this.time;
    }

    public int getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public Boolean getLeapMonth() {
        return this.leapMonth;
    }

    public Boolean getLeapYear() {
        return this.leapYear;
    }

    public String getNextMonth() {
        return this.nextMonth;
    }

    public int getKingChronology() {
        return this.kingChronology;
    }

    public int getYearChronology() {
        return this.yearChronology;
    }

    public int getMonthChronologySum() {
        return this.monthChronologySum;
    }

    public int getMonthChronology() {
        return this.monthChronology;
    }

    public String getZodiac() {
        return this.zodiac;
    }

    public String getYearName() {
        return this.yearName;
    }

    public String getKingChronologyName() {
        return this.kingChronologyName;
    }

    public void setMonthOffset(int monthOffset) {
        this.monthOffset = monthOffset;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setDaysOfMonth(int daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    public void setLeapMonth(Boolean leapMonth) {
        this.leapMonth = leapMonth;
    }

    public void setLeapYear(Boolean leapYear) {
        this.leapYear = leapYear;
    }

    public void setNextMonth(String nextMonth) {
        this.nextMonth = nextMonth;
    }

    public void setKingChronology(int kingChronology) {
        this.kingChronology = kingChronology;
    }

    public void setYearChronology(int yearChronology) {
        this.yearChronology = yearChronology;
    }

    public void setMonthChronologySum(int monthChronologySum) {
        this.monthChronologySum = monthChronologySum;
    }

    public void setMonthChronology(int monthChronology) {
        this.monthChronology = monthChronology;
    }

    public void setZodiac(String zodiac) {
        this.zodiac = zodiac;
    }

    public void setYearName(String yearName) {
        this.yearName = yearName;
    }

    public void setKingChronologyName(String kingChronologyName) {
        this.kingChronologyName = kingChronologyName;
    }
}

