/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.julian;

import cn.huangdayu.almanac.aggregates.BaseAlmanac;
import cn.huangdayu.almanac.aggregates.qishuo.QiShuo;
import cn.huangdayu.almanac.utils.AnnalsUtils;
import cn.huangdayu.almanac.utils.JulianCalendarUtils;

public class Julian
extends BaseAlmanac {
    private int firstJulianDayOfMonth;
    private int numberDayOfMonth;
    private int weekFirstDayOfMonth;
    private Integer days;
    private String constellation;

    public Julian(int julianDayForToday, QiShuo qiShuo) {
        this.days = julianDayForToday + 2451545;
        int mk = (int)Math.floor((double)(julianDayForToday - qiShuo.zhongQi[0] - 15) / 30.43685);
        if (mk < 11 && julianDayForToday >= qiShuo.zhongQi[2 * mk + 2]) {
            ++mk;
        }
        this.setConstellation(AnnalsUtils.XINGZUO[(mk + 12) % 12] + "\u5ea7");
    }

    public Julian(int year, int month) {
        this.firstJulianDayOfMonth = (int)(Math.floor(JulianCalendarUtils.getJulianDayNumber(year, month)) - 2451545.0);
        int nextMonth = month + 1;
        int nextYear = year;
        if (nextMonth > 12) {
            nextMonth -= 12;
            nextYear = year + 1;
        }
        this.numberDayOfMonth = (int)(Math.floor(JulianCalendarUtils.getJulianDayNumber(nextYear, nextMonth)) - 2451545.0 - (double)this.firstJulianDayOfMonth);
        this.weekFirstDayOfMonth = (this.firstJulianDayOfMonth + 2451545 + 1 + 7000000) % 7;
    }

    @Override
    public String getInfo() {
        return this.getDays() + " " + this.getConstellation();
    }

    public String toString() {
        return "JulianDTO{days=" + this.days + ", constellation='" + this.constellation + '\'' + '}';
    }

    public void setFirstJulianDayOfMonth(int firstJulianDayOfMonth) {
        this.firstJulianDayOfMonth = firstJulianDayOfMonth;
    }

    public void setNumberDayOfMonth(int numberDayOfMonth) {
        this.numberDayOfMonth = numberDayOfMonth;
    }

    public void setWeekFirstDayOfMonth(int weekFirstDayOfMonth) {
        this.weekFirstDayOfMonth = weekFirstDayOfMonth;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public void setConstellation(String constellation) {
        this.constellation = constellation;
    }

    public int getFirstJulianDayOfMonth() {
        return this.firstJulianDayOfMonth;
    }

    public int getNumberDayOfMonth() {
        return this.numberDayOfMonth;
    }

    public int getWeekFirstDayOfMonth() {
        return this.weekFirstDayOfMonth;
    }

    public Integer getDays() {
        return this.days;
    }

    public String getConstellation() {
        return this.constellation;
    }
}

