/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.holiday;

import cn.huangdayu.almanac.aggregates.BaseAlmanac;
import cn.huangdayu.almanac.aggregates.era.Era;
import cn.huangdayu.almanac.aggregates.lunar.Lunar;
import cn.huangdayu.almanac.aggregates.solar_term.SolarTerm;
import cn.huangdayu.almanac.dto.TimeZoneDTO;
import cn.huangdayu.almanac.utils.AnnalsUtils;
import cn.huangdayu.almanac.utils.FestivalHolidayUtils;

public class Holiday
extends BaseAlmanac {
    private String happyDay;
    private String majorDay;
    private String otherDay;
    private int flag;

    public Holiday(TimeZoneDTO timeZoneDTO, Lunar lunar, SolarTerm solarTerm, Era era) {
        AnnalsUtils.getHolidayInfo(this, lunar, solarTerm, era);
        FestivalHolidayUtils.getDayName(timeZoneDTO, this);
    }

    @Override
    public String getInfo() {
        return this.getHappyDay() + " " + this.getMajorDay() + " " + this.getOtherDay();
    }

    public String toString() {
        return "HolidayDTO{happyDay='" + this.happyDay + '\'' + ", majorDay='" + this.majorDay + '\'' + ", otherDay='" + this.otherDay + '\'' + ", flag=" + this.flag + '}';
    }

    public String getHappyDay() {
        return this.happyDay;
    }

    public String getMajorDay() {
        return this.majorDay;
    }

    public String getOtherDay() {
        return this.otherDay;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setHappyDay(String happyDay) {
        this.happyDay = happyDay;
    }

    public void setMajorDay(String majorDay) {
        this.majorDay = majorDay;
    }

    public void setOtherDay(String otherDay) {
        this.otherDay = otherDay;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }
}

