/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.era;

import cn.huangdayu.almanac.aggregates.BaseAlmanac;
import cn.huangdayu.almanac.aggregates.lunar.Lunar;
import cn.huangdayu.almanac.dto.TimeZoneDTO;
import cn.huangdayu.almanac.utils.AnnalsUtils;

public class Era
extends BaseAlmanac {
    private String year;
    private String month;
    private String day;
    private String time;

    public Era(int julianDayForToday, Lunar lunar, TimeZoneDTO timeZoneDTO) {
        int value = lunar.getYearChronology() + 12000;
        this.setYear(AnnalsUtils.TIANGAN[value % 10] + AnnalsUtils.DIZHI[value % 12]);
        value = lunar.getMonthChronologySum();
        this.setMonth(AnnalsUtils.TIANGAN[value % 10] + AnnalsUtils.DIZHI[value % 12]);
        value = julianDayForToday - 6 + 9000000;
        this.setDay(AnnalsUtils.TIANGAN[value % 10] + AnnalsUtils.DIZHI[value % 12]);
        int hour = (timeZoneDTO.getHour() + 1) / 2;
        this.setTime(AnnalsUtils.TIANGAN[(hour + value * 12) % 10] + AnnalsUtils.DIZHI[hour % 12]);
    }

    @Override
    public String getInfo() {
        return this.year + "\u5e74" + this.month + "\u6708" + this.day + "\u65e5" + this.time + "\u65f6";
    }

    public String toString() {
        return "EraDTO{year='" + this.year + '\'' + ", month='" + this.month + '\'' + ", day='" + this.day + '\'' + ", time='" + this.time + '\'' + '}';
    }

    public void setYear(String year) {
        this.year = year;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getYear() {
        return this.year;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDay() {
        return this.day;
    }

    public String getTime() {
        return this.time;
    }
}

