/*
 * Decompiled with CFR 0.152.
 */
package cn.huangdayu.almanac.aggregates.astronomical;

import cn.huangdayu.almanac.aggregates.BaseAlmanac;
import cn.huangdayu.almanac.utils.AstronomyArithmeticUtils;
import cn.huangdayu.almanac.utils.CommonUtils;

public class Astronomical
extends BaseAlmanac {
    private double solarRetina;
    private double lunarRetina;

    public Astronomical(int firstJulianDayOfMonth) {
        double jd2 = (double)firstJulianDayOfMonth + CommonUtils.dtT(firstJulianDayOfMonth) - 0.3333333333333333;
        this.solarRetina = AstronomyArithmeticUtils.S_aLon(jd2 / 36525.0, 3);
        this.solarRetina = (double)((int)Math.floor((this.solarRetina - 0.13) / (Math.PI * 2) * 24.0)) * (Math.PI * 2) / 24.0;
        this.lunarRetina = AstronomyArithmeticUtils.MS_aLon(jd2 / 36525.0, 10, 3);
        this.lunarRetina = (double)((int)Math.floor((this.lunarRetina - 0.78) / Math.PI * 2.0)) * Math.PI / 2.0;
    }

    @Override
    public String getInfo() {
        return this.solarRetina + " " + this.lunarRetina;
    }

    public double getSolarRetina() {
        return this.solarRetina;
    }

    public double getLunarRetina() {
        return this.lunarRetina;
    }

    public void setSolarRetina(double solarRetina) {
        this.solarRetina = solarRetina;
    }

    public void setLunarRetina(double lunarRetina) {
        this.lunarRetina = lunarRetina;
    }
}

