/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.util;

import cn.hserver.plugin.web.annotation.validate.AssertFalse;
import cn.hserver.plugin.web.annotation.validate.AssertTrue;
import cn.hserver.plugin.web.annotation.validate.Length;
import cn.hserver.plugin.web.annotation.validate.Max;
import cn.hserver.plugin.web.annotation.validate.Min;
import cn.hserver.plugin.web.annotation.validate.NotBlank;
import cn.hserver.plugin.web.annotation.validate.NotEmpty;
import cn.hserver.plugin.web.annotation.validate.NotNull;
import cn.hserver.plugin.web.annotation.validate.Null;
import cn.hserver.plugin.web.annotation.validate.Pattern;
import cn.hserver.plugin.web.annotation.validate.Size;
import cn.hserver.plugin.web.exception.ValidateException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public class ValidateUtil {
    private static final Class[] validate = new Class[]{Null.class, NotNull.class, NotEmpty.class, NotBlank.class, AssertFalse.class, AssertTrue.class, Length.class, Max.class, Min.class, Pattern.class, Size.class};

    public static boolean isValidate(Method method) {
        if (method != null) {
            Class<?>[] parameterTypes;
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                Field[] declaredFields = parameterType.getDeclaredFields();
                for (Class aClass : validate) {
                    for (Field declaredField : declaredFields) {
                        if (declaredField.getAnnotation(aClass) == null) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static void validate(Object object) throws ValidateException {
        if (object == null) {
            return;
        }
        try {
            Field[] fields = object.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                Object obj = field.get(object);
                ValidateUtil.nullValidate(field, obj);
                ValidateUtil.notNull(field, obj);
                ValidateUtil.notEmpty(field, obj);
                ValidateUtil.notBlank(field, obj);
                ValidateUtil.assertFalse(field, obj);
                ValidateUtil.assertTrue(field, obj);
                ValidateUtil.lengthValidate(field, obj);
                ValidateUtil.max(field, obj);
                ValidateUtil.min(field, obj);
                ValidateUtil.pattern(field, obj);
                ValidateUtil.sizeValidate(field, obj);
            }
        }
        catch (Exception e) {
            throw new ValidateException(e.getMessage());
        }
    }

    private static void assertFalse(Field field, Object obj) throws ValidateException {
        AssertFalse assertFalse = field.getAnnotation(AssertFalse.class);
        if (assertFalse != null) {
            if (obj == null) {
                throw new ValidateException(assertFalse.message(), field, obj);
            }
            if (Boolean.parseBoolean(obj.toString())) {
                throw new ValidateException(assertFalse.message(), field, obj);
            }
        }
    }

    private static void assertTrue(Field field, Object obj) throws ValidateException {
        AssertTrue assertTrue = field.getAnnotation(AssertTrue.class);
        if (assertTrue != null) {
            if (obj == null) {
                throw new ValidateException(assertTrue.message(), field, obj);
            }
            if (!Boolean.parseBoolean(obj.toString())) {
                throw new ValidateException(assertTrue.message(), field, obj);
            }
        }
    }

    private static void lengthValidate(Field field, Object obj) throws ValidateException {
        Length length = field.getAnnotation(Length.class);
        if (length != null) {
            CharSequence obj1;
            if (obj == null) {
                throw new ValidateException(length.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && (long)(obj1 = (CharSequence)obj).length() != length.value()) {
                throw new ValidateException(length.message(), field, obj);
            }
        }
    }

    private static void max(Field field, Object obj) throws ValidateException {
        Max max = field.getAnnotation(Max.class);
        if (max != null && (obj == null || Long.parseLong(obj.toString()) < max.value())) {
            throw new ValidateException(max.message(), field, obj);
        }
    }

    private static void min(Field field, Object obj) throws ValidateException {
        Min min = field.getAnnotation(Min.class);
        if (min != null && (obj == null || Long.parseLong(obj.toString()) > min.value())) {
            throw new ValidateException(min.message(), field, obj);
        }
    }

    private static void notBlank(Field field, Object obj) throws ValidateException {
        NotBlank notBlank = field.getAnnotation(NotBlank.class);
        if (notBlank != null && (obj == null || obj.toString().trim().length() == 0)) {
            throw new ValidateException(notBlank.message(), field, obj);
        }
    }

    private static void notEmpty(Field field, Object obj) throws ValidateException {
        NotEmpty notEmpty = field.getAnnotation(NotEmpty.class);
        if (notEmpty != null) {
            if (obj == null) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && ((CharSequence)obj).length() == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (Collection.class.isAssignableFrom(field.getType()) && ((Collection)obj).size() == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (Map.class.isAssignableFrom(field.getType()) && ((Map)obj).size() == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (field.getType().isArray() && ((Object[])obj).length == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
        }
    }

    private static void notNull(Field field, Object obj) throws ValidateException {
        NotNull notNull = field.getAnnotation(NotNull.class);
        if (notNull != null && obj == null) {
            throw new ValidateException(notNull.message(), field, obj);
        }
    }

    private static void nullValidate(Field field, Object obj) throws ValidateException {
        Null isNull = field.getAnnotation(Null.class);
        if (isNull != null && obj != null) {
            throw new ValidateException(isNull.message(), field, obj);
        }
    }

    private static void pattern(Field field, Object obj) throws ValidateException {
        Pattern pattern = field.getAnnotation(Pattern.class);
        if (pattern != null) {
            if (obj == null) {
                throw new ValidateException(pattern.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && !java.util.regex.Pattern.matches(pattern.value(), obj.toString())) {
                throw new ValidateException(pattern.message(), field, obj);
            }
        }
    }

    private static void sizeValidate(Field field, Object obj) throws ValidateException {
        Size size = field.getAnnotation(Size.class);
        if (size != null) {
            int length;
            if (obj == null) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && ((long)(length = ((CharSequence)obj).length()) < size.min() || (long)length > size.max())) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (Collection.class.isAssignableFrom(field.getType()) && ((long)(length = ((Collection)obj).size()) < size.min() || (long)length > size.max())) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (Map.class.isAssignableFrom(field.getType()) && ((long)(length = ((Map)obj).size()) < size.min() || (long)length > size.max())) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (field.getType().isArray()) {
                assert (obj instanceof Object[]);
                length = ((Object[])obj).length;
                if ((long)length < size.min() || (long)length > size.max()) {
                    throw new ValidateException(size.message(), field, obj);
                }
            }
        }
    }
}

