/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.util;

import cn.hserver.core.server.util.ExceptionUtil;
import cn.hserver.core.server.util.PropUtil;
import cn.hserver.plugin.web.context.WebConstConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContextUtil {
    private static final Logger log = LoggerFactory.getLogger(SslContextUtil.class);

    private static SslProvider defaultSslProvider() {
        log.debug("SSL:{}", (Object)(OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK));
        return OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK;
    }

    public static void setSsl() {
        PropUtil instance = PropUtil.getInstance();
        String certFilePath = instance.get("web.certPath");
        String privateKeyPath = instance.get("web.privateKeyPath");
        String privateKeyPwd = instance.get("web.privateKeyPwd");
        if (privateKeyPath == null || certFilePath == null || privateKeyPath.trim().length() == 0 || certFilePath.trim().length() == 0) {
            return;
        }
        try {
            File cfile = new File(certFilePath);
            File pfile = new File(privateKeyPath);
            if (cfile.isFile() && pfile.isFile()) {
                SslContextBuilder sslContext = SslContextBuilder.forServer((File)cfile, (File)pfile, (String)privateKeyPwd).sslProvider(SslContextUtil.defaultSslProvider());
                WebConstConfig.sslContext = sslContext.build();
                return;
            }
            InputStream cinput = SslContextUtil.class.getResourceAsStream("/ssl/" + certFilePath);
            InputStream pinput = SslContextUtil.class.getResourceAsStream("/ssl/" + privateKeyPath);
            if (cinput != null && pinput != null) {
                SslContextBuilder sslContext = SslContextBuilder.forServer((InputStream)cinput, (InputStream)pinput, (String)privateKeyPwd).sslProvider(SslContextUtil.defaultSslProvider());
                WebConstConfig.sslContext = sslContext.build();
                cinput.close();
                pinput.close();
            }
        }
        catch (Exception s) {
            log.error(ExceptionUtil.getMessage((Throwable)s));
        }
    }
}

