/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.util;

import cn.hserver.plugin.web.util.IpUtil;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;

public class RequestIdGen {
    private static final AtomicLong lastId = new AtomicLong();
    private static final String HEXIP = RequestIdGen.hexIp(IpUtil.getLocalIP());
    private static final String PROCESSON = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];

    public static long getRequestCount() {
        return lastId.get();
    }

    public static String getId() {
        return HEXIP + "-" + Long.toString(System.currentTimeMillis(), 36) + "-" + PROCESSON + "-" + lastId.incrementAndGet();
    }

    private static String hexIp(String ip) {
        try {
            StringBuilder sb = new StringBuilder();
            for (String seg : ip.split("\\.")) {
                String h = Integer.toHexString(Integer.parseInt(seg));
                if (h.length() == 1) {
                    sb.append("0");
                }
                sb.append(h);
            }
            return sb.toString();
        }
        catch (Exception exception) {
            return "7f000001";
        }
    }
}

