/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.util;

import cn.hserver.core.server.util.ExceptionUtil;
import cn.hserver.core.server.util.ObjConvertUtil;
import cn.hserver.plugin.web.context.HServerContext;
import cn.hserver.plugin.web.context.MimeType;
import cn.hserver.plugin.web.context.WebConstConfig;
import cn.hserver.plugin.web.exception.ValidateException;
import cn.hserver.plugin.web.interfaces.HttpRequest;
import cn.hserver.plugin.web.interfaces.HttpResponse;
import cn.hserver.plugin.web.util.ValidateUtil;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterUtil {
    private static final Logger log = LoggerFactory.getLogger(ParameterUtil.class);
    private static final ConcurrentHashMap<Class, ConcurrentHashMap<Method, ControllerParameter>> PARAM_NAME_MAP = new ConcurrentHashMap();

    public static Object[] getMethodArgs(Class cs, Method method, HServerContext hServerContext) throws Exception {
        Parameter[] parameterTypes = method.getParameters();
        if (parameterTypes.length == 0) {
            return null;
        }
        Object[] objects = new Object[parameterTypes.length];
        ControllerParameter controllerParameter = PARAM_NAME_MAP.get(cs).get(method);
        String[] strings = controllerParameter.getName();
        if (parameterTypes.length != strings.length) {
            throw new Exception(method.getName() + "-\u65b9\u6cd5\u53c2\u6570\u83b7\u53d6\u5f02\u5e38");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].getParameterizedType() == HttpRequest.class) {
                objects[i] = hServerContext.getRequest();
                continue;
            }
            if (parameterTypes[i].getParameterizedType() == HttpResponse.class) {
                objects[i] = hServerContext.getResponse();
                continue;
            }
            Parameter parameterType = parameterTypes[i];
            String typeName = strings[i];
            Map<String, List<String>> requestParams = hServerContext.getRequest().getRequestParams();
            try {
                Object convert = ObjConvertUtil.convert(parameterType.getType(), requestParams.get(typeName) == null ? null : requestParams.get(typeName).get(0));
                if (convert != null) {
                    objects[i] = convert;
                    continue;
                }
                String type = hServerContext.getRequest().getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
                if (type != null && type.contains(MimeType.get("json"))) {
                    String rawData = hServerContext.getRequest().getRawData();
                    if (rawData != null) {
                        objects[i] = WebConstConfig.JSONADAPTER.convertObject(rawData, parameterType);
                    }
                } else if (requestParams.size() > 0) {
                    objects[i] = WebConstConfig.JSONADAPTER.convertMapToObject(ParameterUtil.invokeData(requestParams), parameterType.getType());
                }
                if (!controllerParameter.isValidate) continue;
                ValidateUtil.validate(objects[i]);
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof ValidateException)) continue;
                throw e;
            }
        }
        return objects;
    }

    private static Map<String, String> invokeData(Map<String, List<String>> requestParams) {
        ConcurrentHashMap<String, String> data = new ConcurrentHashMap<String, String>();
        requestParams.forEach((k, v) -> {
            if (k != null && v.size() > 0) {
                data.put((String)k, (String)v.get(0));
            }
        });
        return data;
    }

    private static String[] getParamNames(Method method) {
        try {
            Class<?> clazz = method.getDeclaringClass();
            ClassPool pool = ClassPool.getDefault();
            CtClass clz = pool.get(clazz.getName());
            clz.freeze();
            clz.defrost();
            CtClass[] params = new CtClass[method.getParameterTypes().length];
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                ClassClassPath classPath = new ClassClassPath(method.getParameterTypes()[i]);
                pool.insertClassPath((ClassPath)classPath);
                params[i] = pool.getCtClass(method.getParameterTypes()[i].getName());
            }
            CtMethod cm = clz.getDeclaredMethod(method.getName(), params);
            MethodInfo methodInfo = cm.getMethodInfo();
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
            String[] paramNames = new String[cm.getParameterTypes().length];
            for (int i = 0; i < attr.tableLength(); ++i) {
                if (attr.index(i) < pos || attr.index(i) >= paramNames.length + pos) continue;
                paramNames[attr.index((int)i) - pos] = attr.variableName(i);
            }
            return paramNames;
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtil.getMessage((Throwable)e));
            return new String[0];
        }
    }

    public static void addParam(Class cs, Method method) throws Exception {
        String[] paramNames = ParameterUtil.getParamNames(method);
        boolean validate = ValidateUtil.isValidate(method);
        if (method.getParameterTypes().length == paramNames.length) {
            if (PARAM_NAME_MAP.containsKey(cs)) {
                ConcurrentHashMap<Method, ControllerParameter> concurrentHashMap = PARAM_NAME_MAP.get(cs);
                concurrentHashMap.put(method, new ControllerParameter(paramNames, validate));
                PARAM_NAME_MAP.put(cs, concurrentHashMap);
            } else {
                ConcurrentHashMap<Method, ControllerParameter> concurrentHashMap = new ConcurrentHashMap<Method, ControllerParameter>();
                concurrentHashMap.put(method, new ControllerParameter(paramNames, validate));
                PARAM_NAME_MAP.put(cs, concurrentHashMap);
            }
        } else {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
    }

    public static class ControllerParameter {
        private final String[] name;
        private final boolean isValidate;

        public ControllerParameter(String[] name, boolean isValidate) {
            this.name = name;
            this.isValidate = isValidate;
        }

        public String[] getName() {
            return this.name;
        }

        public boolean isValidate() {
            return this.isValidate;
        }
    }
}

