/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.router;

import cn.hserver.core.server.util.ExceptionUtil;
import cn.hserver.plugin.web.annotation.RequestMethod;
import cn.hserver.plugin.web.context.HServerContext;
import cn.hserver.plugin.web.context.PatternUri;
import cn.hserver.plugin.web.context.Request;
import cn.hserver.plugin.web.exception.MethodNotSupportException;
import cn.hserver.plugin.web.router.RouterInfo;
import cn.hserver.plugin.web.router.RouterPermission;
import io.netty.handler.codec.http.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterManager {
    private static final Logger log = LoggerFactory.getLogger(RouterManager.class);
    private static final Map<String, Map<String, RouterInfo>> router2 = new ConcurrentHashMap<String, Map<String, RouterInfo>>();
    private static final Map<String, Map<String, PatternUri>> ISPAURI = new ConcurrentHashMap<String, Map<String, PatternUri>>();
    private static final Map<HttpMethod, Map<String, RouterPermission>> routerPermission = new ConcurrentHashMap<HttpMethod, Map<String, RouterPermission>>();

    private static Map<String, RouterPermission> routerPermission(HttpMethod method) {
        Map<String, RouterPermission> stringRouterPermissionMap = routerPermission.get(method);
        if (stringRouterPermissionMap == null) {
            stringRouterPermissionMap = new ConcurrentHashMap<String, RouterPermission>();
            routerPermission.put(method, stringRouterPermissionMap);
        }
        return stringRouterPermissionMap;
    }

    public static void addRouter(RouterInfo routerInfo) {
        if (routerInfo != null) {
            Map<String, RouterInfo> httpMethodRouterInfoMap;
            String url = routerInfo.getUrl();
            List<String> pattern = RouterManager.isPattern(url);
            if (pattern.size() > 0) {
                String s = url;
                for (int i = 0; i < pattern.size(); ++i) {
                    s = i == pattern.size() - 1 ? s.replaceAll("\\{" + pattern.get(i) + "\\}", "(.+)") : s.replaceAll("\\{" + pattern.get(i) + "\\}", "(.+?)");
                }
                s = "^" + s;
                Map<String, PatternUri> ispauri = ISPAURI.get(s);
                if (ispauri == null) {
                    ispauri = new ConcurrentHashMap<String, PatternUri>();
                    ISPAURI.put(s, ispauri);
                }
                ispauri.put(routerInfo.getReqMethodName().name(), new PatternUri(pattern, url, s, routerInfo.getReqMethodName().name()));
            }
            if ((httpMethodRouterInfoMap = router2.get(url)) == null) {
                httpMethodRouterInfoMap = new ConcurrentHashMap<String, RouterInfo>();
                router2.put(url, httpMethodRouterInfoMap);
            }
            if (httpMethodRouterInfoMap.containsKey(routerInfo.getReqMethodName().name())) {
                log.warn("url< {} >\u6620\u5c04\u8def\u5f84\u5df2\u7ecf\u5b58\u5728\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u7a0b\u5e8f\u4f7f\u7528\uff0cclass:{},method:{}", new Object[]{url, routerInfo.getaClass().getName(), routerInfo.getMethod().getName()});
            }
            httpMethodRouterInfoMap.put(routerInfo.getReqMethodName().name(), routerInfo);
        }
    }

    private static List<String> isPattern(String url) {
        String regex = "(\\{.*?\\})";
        Matcher matcher = Pattern.compile(regex).matcher(url);
        ArrayList<String> patterns = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group(1);
            if (group == null) continue;
            patterns.add(group.substring(1, group.length() - 1));
        }
        return patterns;
    }

    private static PatternUri isPattern(String url, HttpMethod method) throws MethodNotSupportException {
        for (String next : ISPAURI.keySet()) {
            Map<String, PatternUri> stringPatternUriMap;
            if (!Pattern.compile(next).matcher(url).find() || (stringPatternUriMap = ISPAURI.get(next)) == null) continue;
            PatternUri patternUri = stringPatternUriMap.get(method.name());
            if (patternUri != null) {
                return patternUri;
            }
            throw new MethodNotSupportException();
        }
        return null;
    }

    public static void addPermission(RouterPermission routerPermission) {
        if (routerPermission != null) {
            String url = routerPermission.getUrl();
            Map<String, RouterPermission> stringRouterPermissionMap = RouterManager.routerPermission(routerPermission.getReqMethodName());
            if (stringRouterPermissionMap.containsKey(url)) {
                log.warn("url< {} >\u6743\u9650\u6620\u5c04\u5df2\u7ecf\u5b58\u5728\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u7a0b\u5e8f\u4f7f\u7528", (Object)url);
            }
            stringRouterPermissionMap.put(url, routerPermission);
        }
    }

    public static RouterInfo getRouterInfo(String url, HttpMethod requestType, HServerContext hServerContext) throws MethodNotSupportException {
        Request request = hServerContext.getRequest();
        Map<String, RouterInfo> router = router2.get(url);
        if (router == null) {
            PatternUri pattern = RouterManager.isPattern(url, requestType);
            if (pattern != null) {
                Map<String, RouterInfo> stringRouterInfoMap;
                Matcher matcher = Pattern.compile(pattern.getPatternUrl()).matcher(url);
                if (matcher.find()) {
                    for (int i = 0; i < pattern.getKeys().size(); ++i) {
                        try {
                            request.addReqParams(pattern.getKeys().get(i), URLDecoder.decode(matcher.group(i + 1), "UTF-8"));
                            request.addReqUrlParams(pattern.getKeys().get(i), URLDecoder.decode(matcher.group(i + 1), "UTF-8"));
                            continue;
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error(ExceptionUtil.getMessage((Throwable)e));
                        }
                    }
                }
                if ((stringRouterInfoMap = router2.get(pattern.getOrgUrl())) == null) {
                    return null;
                }
                return stringRouterInfoMap.get(pattern.getRequestType());
            }
            return null;
        }
        RouterInfo routerInfo = router.get(requestType.name());
        if (routerInfo != null) {
            return routerInfo;
        }
        throw new MethodNotSupportException();
    }

    public static RouterPermission getRouterPermission(String url, HttpMethod requestType) {
        Map<String, RouterPermission> stringRouterPermissionMap = RouterManager.routerPermission(requestType);
        RouterPermission routerPermission = stringRouterPermissionMap.get(url);
        if (routerPermission != null) {
            return routerPermission;
        }
        try {
            PatternUri pattern = RouterManager.isPattern(url, requestType);
            if (pattern != null) {
                return stringRouterPermissionMap.get(pattern.getOrgUrl());
            }
        }
        catch (MethodNotSupportException e) {
            return null;
        }
        return null;
    }

    public static List<RouterPermission> getRouterPermissions() {
        String[] requestMethodAll;
        ArrayList<RouterPermission> permissions = new ArrayList<RouterPermission>();
        for (String s : requestMethodAll = RequestMethod.getRequestMethodAll()) {
            HttpMethod httpMethod = HttpMethod.valueOf((String)s);
            Map<String, RouterPermission> stringRouterPermissionMap = RouterManager.routerPermission(httpMethod);
            stringRouterPermissionMap.forEach((a, b) -> permissions.add((RouterPermission)b));
        }
        return permissions;
    }
}

