/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.protocol;

import cn.hserver.core.interfaces.ProtocolDispatcherAdapter;
import cn.hserver.core.ioc.annotation.Bean;
import cn.hserver.core.ioc.annotation.Order;
import cn.hserver.plugin.web.context.WebConstConfig;
import cn.hserver.plugin.web.handlers.HServerContentHandler;
import cn.hserver.plugin.web.handlers.RouterHandler;
import cn.hserver.plugin.web.handlers.WebSocketServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.OptionalSslHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import java.util.concurrent.ScheduledExecutorService;

@Order(value=3)
@Bean
public class DispatchHttp
implements ProtocolDispatcherAdapter {
    private static GlobalTrafficShapingHandler globalTrafficShapingHandler;

    public boolean dispatcher(ChannelHandlerContext ctx, ChannelPipeline pipeline, byte[] headers) {
        if (this.isHttp(headers[0], headers[1])) {
            DispatchHttp.httpHandler(ctx);
            return true;
        }
        if (this.isHttps(headers[0], headers[1], headers[2])) {
            if (WebConstConfig.sslContext != null) {
                pipeline.addLast(new ChannelHandler[]{new OptionalSslHandler(WebConstConfig.sslContext)});
                DispatchHttp.httpHandler(ctx);
            }
            return true;
        }
        return false;
    }

    public static void httpHandler(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        if (WebConstConfig.WRITE_LIMIT != null && WebConstConfig.READ_LIMIT != null) {
            if (globalTrafficShapingHandler == null) {
                globalTrafficShapingHandler = new GlobalTrafficShapingHandler((ScheduledExecutorService)ctx.executor(), WebConstConfig.WRITE_LIMIT.longValue(), WebConstConfig.READ_LIMIT.longValue());
            }
            pipeline.addLast(WebConstConfig.BUSINESS_EVENT, new ChannelHandler[]{globalTrafficShapingHandler});
        }
        pipeline.addLast(WebConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(WebConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new HttpObjectAggregator(WebConstConfig.HTTP_CONTENT_SIZE.intValue())});
        if (WebSocketServerHandler.WEB_SOCKET_ROUTER.size() > 0) {
            pipeline.addLast(WebConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new WebSocketServerHandler()});
        }
        pipeline.addLast(WebConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new HServerContentHandler()});
        pipeline.addLast(WebConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new RouterHandler()});
    }

    private boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    private boolean isHttps(int magic1, int magic2, int magic3) {
        return magic1 == 22 && magic2 == 3 && magic3 == 1;
    }
}

