/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.json;

import cn.hserver.core.server.util.ExceptionUtil;
import cn.hserver.plugin.web.context.WebConstConfig;
import cn.hserver.plugin.web.json.JsonAdapter;
import com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JackSonJsonAdapter
implements JsonAdapter {
    private static final Logger log = LoggerFactory.getLogger(JackSonJsonAdapter.class);

    @Override
    public Object convertObject(String data, Parameter type) {
        try {
            if (Collection.class.isAssignableFrom(type.getType()) || Map.class.isAssignableFrom(type.getType())) {
                return WebConstConfig.OBJECT_MAPPER.readValue(data, this.getParameterizedTypeImplType((ParameterizedType)type.getParameterizedType()));
            }
            return WebConstConfig.OBJECT_MAPPER.readValue(data, type.getType());
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public Object convertObject(String data, Class type) {
        try {
            return WebConstConfig.OBJECT_MAPPER.readValue(data, type);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public Object convertMapToObject(Map data, Class type) {
        return WebConstConfig.OBJECT_MAPPER.convertValue((Object)data, type);
    }

    @Override
    public String convertString(Object data) {
        try {
            return WebConstConfig.OBJECT_MAPPER.writeValueAsString(data);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage((Throwable)e));
            return null;
        }
    }

    private Class<?> getTypeClass(Type rawType) {
        if (rawType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)rawType).getRawType();
        }
        return (Class)rawType;
    }

    private JavaType getParameterizedTypeImplType(ParameterizedType parameterizedType) {
        Type rawType = parameterizedType.getRawType();
        Class<?> typeClass = this.getTypeClass(rawType);
        if (Collection.class.isAssignableFrom(typeClass)) {
            Type listActualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            if (listActualTypeArgument instanceof ParameterizedType) {
                return WebConstConfig.OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new JavaType[]{this.getParameterizedTypeImplType((ParameterizedType)listActualTypeArgument)});
            }
            return WebConstConfig.OBJECT_MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{this.getTypeClass(parameterizedType.getActualTypeArguments()[0])});
        }
        if (Map.class.isAssignableFrom(typeClass)) {
            Type mapActualTypeArgument = parameterizedType.getActualTypeArguments()[1];
            if (mapActualTypeArgument instanceof ParameterizedType) {
                JavaType keyType = WebConstConfig.OBJECT_MAPPER.getTypeFactory().constructType(this.getTypeClass(parameterizedType.getActualTypeArguments()[0]));
                return WebConstConfig.OBJECT_MAPPER.getTypeFactory().constructParametricType(Map.class, new JavaType[]{keyType, this.getParameterizedTypeImplType((ParameterizedType)mapActualTypeArgument)});
            }
            return WebConstConfig.OBJECT_MAPPER.getTypeFactory().constructParametricType(Map.class, new Class[]{this.getTypeClass(parameterizedType.getActualTypeArguments()[0]), this.getTypeClass(parameterizedType.getActualTypeArguments()[1])});
        }
        return null;
    }
}

