/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.handlers;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.server.util.ByteBufUtil;
import cn.hserver.plugin.web.context.WsType;
import cn.hserver.plugin.web.handlers.Ws;
import cn.hserver.plugin.web.interfaces.WebSocketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerHandler.class);
    public static final Map<String, String> WEB_SOCKET_ROUTER = new ConcurrentHashMap<String, String>();
    private StringBuilder frameBuffer = null;
    private WebSocketServerHandshaker handshake;
    private WebSocketHandler webSocketHandler;
    private String uid;
    private HttpRequest request;

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ReferenceCountUtil.retain((Object)msg);
            ctx.fireChannelRead(msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.request != null && this.uid != null) {
            this.webSocketHandler.disConnect(new Ws(ctx, this.uid, this.request, WsType.CLOSE));
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        if (this.isWebSocketRequest(req)) {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(req.uri(), null, true);
            this.handshake = wsFactory.newHandshaker(req);
            if (this.handshake == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshake.handshake(ctx.channel(), req);
                String uri = this.getReqUri(req);
                this.request = req;
                this.uid = ctx.channel().id().asLongText();
                this.webSocketHandler = (WebSocketHandler)IocUtil.getBean((String)WEB_SOCKET_ROUTER.get(uri));
                this.webSocketHandler.onConnect(new Ws(ctx, this.uid, this.request, WsType.INIT));
            }
        } else {
            ReferenceCountUtil.retain((Object)req);
            ctx.fireChannelRead((Object)req);
        }
    }

    private String getReqUri(HttpRequest req) {
        int i = req.uri().indexOf("?");
        if (i > 0) {
            String uri = req.uri();
            return uri.substring(0, i);
        }
        return req.uri();
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshake.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            if (frame.isFinalFragment()) {
                this.webSocketHandler.onMessage(new Ws(ctx, ((TextWebSocketFrame)frame).text(), this.uid, this.request, WsType.TEXT));
                return;
            }
            this.frameBuffer = new StringBuilder();
            this.frameBuffer.append(((TextWebSocketFrame)frame).text());
        } else {
            if (frame instanceof BinaryWebSocketFrame) {
                this.webSocketHandler.onMessage(new Ws(ctx, ByteBufUtil.byteBufToBytes((ByteBuf)frame.content()), this.uid, this.request, WsType.BINARY));
                return;
            }
            if (frame instanceof ContinuationWebSocketFrame) {
                if (this.frameBuffer != null) {
                    this.frameBuffer.append(((ContinuationWebSocketFrame)frame).text());
                } else {
                    log.warn("ContinuationWebSocketFrame \u5e27\u4e0d\u5b8c\u6574\uff0c\u7f13\u5b58\u51fa\u73b0\u4e86null");
                }
            }
        }
        if (frame.isFinalFragment()) {
            this.webSocketHandler.onMessage(new Ws(ctx, this.frameBuffer.toString(), this.uid, this.request, WsType.TEXT));
            this.frameBuffer = null;
        }
    }

    private boolean isWebSocketRequest(HttpRequest req) {
        return req != null && WEB_SOCKET_ROUTER.get(this.getReqUri(req)) != null && req.decoderResult().isSuccess() && "websocket".equals(req.headers().get("Upgrade"));
    }
}

