/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.handlers;

import cn.hserver.core.server.util.ByteBufUtil;
import cn.hserver.core.server.util.HServerIpUtil;
import cn.hserver.plugin.web.context.HServerContext;
import cn.hserver.plugin.web.context.HServerContextHolder;
import cn.hserver.plugin.web.context.HeadMap;
import cn.hserver.plugin.web.context.Request;
import cn.hserver.plugin.web.context.Response;
import cn.hserver.plugin.web.context.Webkit;
import cn.hserver.plugin.web.handlers.BuildResponse;
import cn.hserver.plugin.web.util.RequestIdGen;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HServerContentHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HServerContentHandler.class);
    private static final DefaultHttpDataFactory FACTORY = new DefaultHttpDataFactory(16384L);
    public Channel outboundChannel;

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest req) throws Exception {
        HServerContext hServerContext = new HServerContext();
        Request request = new Request();
        hServerContext.setRequest(request);
        request.setHandler(this);
        String id = RequestIdGen.getId();
        request.setRequestId(id);
        request.setIp(HServerIpUtil.getClientIp((ChannelHandlerContext)channelHandlerContext));
        request.setPort(HServerIpUtil.getClientPort((ChannelHandlerContext)channelHandlerContext));
        request.setCtx(channelHandlerContext);
        request.setNettyUri(req.uri());
        request.setNettyRequest((FullHttpRequest)new DefaultFullHttpRequest(req.protocolVersion(), req.method(), req.uri(), Unpooled.copiedBuffer((ByteBuf)req.content()), req.headers(), req.trailingHeaders()));
        this.handlerUrl(request, req);
        this.handlerBody(request, req);
        int i = req.uri().indexOf("?");
        if (i > 0) {
            String uri = req.uri();
            request.setUri(uri.substring(0, i));
        } else {
            request.setUri(req.uri());
        }
        request.setRequestType(req.method());
        HeadMap headers = new HeadMap();
        req.headers().names().forEach(a -> headers.put((String)a, req.headers().get(a)));
        request.setHeaders(headers);
        hServerContext.setRequest(request);
        hServerContext.setResponse(new Response());
        Webkit webkit = new Webkit();
        webkit.httpRequest = hServerContext.getRequest();
        webkit.httpResponse = hServerContext.getResponse();
        webkit.httpResponse.setHeader("hRequestId", id);
        webkit.httpResponse.setHeader("HServer-Web", "3.0.M5");
        webkit.httpResponse.setHeader("Server", "HServer-Web");
        hServerContext.setWebkit(webkit);
        HServerContextHolder.setWebKit(webkit);
        channelHandlerContext.fireChannelRead((Object)hServerContext);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        BuildResponse.writeException(ctx, cause);
    }

    private void handlerUrl(Request request, FullHttpRequest req) {
        try {
            Map<String, List<String>> requestParams = request.getRequestParams();
            QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
            Map params = decoder.parameters();
            for (Map.Entry next : params.entrySet()) {
                requestParams.put((String)next.getKey(), (List<String>)next.getValue());
                for (String s : (List)next.getValue()) {
                    request.addReqUrlParams((String)next.getKey(), s);
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    private void handlerBody(Request request, FullHttpRequest req) {
        ByteBuf body = req.content().duplicate();
        request.setBody(ByteBufUtil.byteBufToBytes((ByteBuf)body));
        try {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)FACTORY, (HttpRequest)req);
            List bodyHttpDates = decoder.getBodyHttpDatas();
            bodyHttpDates.forEach(request::writeHttpData);
            decoder.destroy();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }
}

