/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.handlers;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.server.util.ExceptionUtil;
import cn.hserver.plugin.web.context.HServerContext;
import cn.hserver.plugin.web.context.HServerContextHolder;
import cn.hserver.plugin.web.context.Request;
import cn.hserver.plugin.web.context.Response;
import cn.hserver.plugin.web.context.StaticFile;
import cn.hserver.plugin.web.context.Webkit;
import cn.hserver.plugin.web.exception.BusinessException;
import cn.hserver.plugin.web.exception.MethodNotSupportException;
import cn.hserver.plugin.web.exception.NotFoundException;
import cn.hserver.plugin.web.handlers.BuildResponse;
import cn.hserver.plugin.web.handlers.StaticHandler;
import cn.hserver.plugin.web.interfaces.FilterAdapter;
import cn.hserver.plugin.web.interfaces.GlobalException;
import cn.hserver.plugin.web.interfaces.LimitAdapter;
import cn.hserver.plugin.web.interfaces.PermissionAdapter;
import cn.hserver.plugin.web.interfaces.ResponseAdapter;
import cn.hserver.plugin.web.router.RouterInfo;
import cn.hserver.plugin.web.router.RouterManager;
import cn.hserver.plugin.web.router.RouterPermission;
import cn.hserver.plugin.web.util.ParameterUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherHandler {
    private static final Logger log = LoggerFactory.getLogger(DispatcherHandler.class);
    private static final StaticHandler STATIC_HANDLER = new StaticHandler();

    static HServerContext staticFile(HServerContext hServerContext) {
        StaticFile handler = STATIC_HANDLER.handler(hServerContext.getRequest().getUri(), hServerContext);
        if (handler != null) {
            hServerContext.setStaticFile(true);
            hServerContext.setStaticFile(handler);
        }
        return hServerContext;
    }

    static HServerContext permission(HServerContext hServerContext) {
        RouterPermission routerPermission;
        if (hServerContext.isStaticFile()) {
            return hServerContext;
        }
        List listBean = IocUtil.getListBean(PermissionAdapter.class);
        if (listBean != null && (routerPermission = RouterManager.getRouterPermission(hServerContext.getRequest().getUri(), hServerContext.getRequest().getRequestType())) != null) {
            for (PermissionAdapter permissionAdapter : listBean) {
                if (routerPermission.getRequiresPermissions() != null) {
                    try {
                        permissionAdapter.requiresPermissions(routerPermission.getRequiresPermissions(), hServerContext.getWebkit());
                        if (hServerContext.getWebkit().httpResponse.hasData()) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u6743\u9650\u9a8c\u8bc1", e, hServerContext.getWebkit());
                    }
                }
                if (routerPermission.getRequiresRoles() != null) {
                    try {
                        permissionAdapter.requiresRoles(routerPermission.getRequiresRoles(), hServerContext.getWebkit());
                        if (hServerContext.getWebkit().httpResponse.hasData()) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u89d2\u8272\u9a8c\u8bc1", e, hServerContext.getWebkit());
                    }
                }
                if (routerPermission.getSign() == null) continue;
                try {
                    permissionAdapter.sign(routerPermission.getSign(), hServerContext.getWebkit());
                    if (!hServerContext.getWebkit().httpResponse.hasData()) continue;
                    break;
                }
                catch (Exception e) {
                    throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "Sign\u9a8c\u8bc1", e, hServerContext.getWebkit());
                }
            }
        }
        return hServerContext;
    }

    public static HServerContext filter(HServerContext hServerContext) {
        List listBean;
        if (hServerContext.isStaticFile()) {
            return hServerContext;
        }
        if (IocUtil.getListBean(LimitAdapter.class) != null) {
            try {
                listBean = IocUtil.getListBean(LimitAdapter.class);
                for (LimitAdapter limitAdapter : listBean) {
                    limitAdapter.doLimit(hServerContext.getWebkit());
                    if (!hServerContext.getWebkit().httpResponse.hasData()) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u62e6\u622a\u5668\u5f02\u5e38", e, hServerContext.getWebkit());
            }
        }
        if (hServerContext.getWebkit().httpResponse.hasData()) {
            return hServerContext;
        }
        if (IocUtil.getListBean(FilterAdapter.class) != null) {
            try {
                listBean = IocUtil.getListBean(FilterAdapter.class);
                for (FilterAdapter filterAdapter : listBean) {
                    filterAdapter.doFilter(hServerContext.getWebkit());
                    if (!hServerContext.getWebkit().httpResponse.hasData()) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u62e6\u622a\u5668\u5f02\u5e38", e, hServerContext.getWebkit());
            }
        }
        return hServerContext;
    }

    static HServerContext findController(HServerContext hServerContext) {
        block15: {
            if (hServerContext.isStaticFile()) {
                return hServerContext;
            }
            if (hServerContext.getWebkit().httpResponse.hasData()) {
                return hServerContext;
            }
            RouterInfo routerInfo = null;
            try {
                routerInfo = RouterManager.getRouterInfo(hServerContext.getRequest().getUri(), hServerContext.getRequest().getRequestType(), hServerContext);
                if (routerInfo == null) {
                    StringBuilder error = new StringBuilder();
                    error.append("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u63a7\u5236\u5668\uff0c\u8bf7\u6c42\u65b9\u5f0f\uff1a").append(hServerContext.getRequest().getRequestType().toString()).append("\uff0c\u8bf7\u6c42\u8def\u5f84\uff1a").append(hServerContext.getRequest().getUri()).append("\uff0c\u6765\u6e90IP\uff1a").append(hServerContext.getRequest().getIpAddress());
                    throw new BusinessException(HttpResponseStatus.NOT_FOUND.code(), error.toString(), new NotFoundException("\u4e0d\u80fd\u627e\u5230\u5904\u7406\u5f53\u524d\u8bf7\u6c42\u7684\u8d44\u6e90"), hServerContext.getWebkit());
                }
            }
            catch (MethodNotSupportException e) {
                StringBuilder error = new StringBuilder();
                error.append("\u63a7\u5236\u5668\u4e0d\u5141\u8bb8\u7684\u8bf7\u6c42\u65b9\u6cd5\uff1a").append(hServerContext.getRequest().getRequestType().toString()).append("\uff0c\u8bf7\u6c42\u8def\u5f84\uff1a").append(hServerContext.getRequest().getUri()).append("\uff0c\u6765\u6e90IP\uff1a").append(hServerContext.getRequest().getIpAddress());
                throw new BusinessException(HttpResponseStatus.METHOD_NOT_ALLOWED.code(), error.toString(), e, hServerContext.getWebkit());
            }
            Method method = routerInfo.getMethod();
            Class<?> aClass = routerInfo.getaClass();
            Object bean = IocUtil.getBean(aClass);
            try {
                Object[] methodArgs;
                try {
                    methodArgs = ParameterUtil.getMethodArgs(aClass, method, hServerContext);
                }
                catch (Exception e) {
                    throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u63a7\u5236\u5668\u65b9\u6cd5\u8c03\u7528\u65f6\u4f20\u5165\u7684\u53c2\u6570\u5f02\u5e38", e, hServerContext.getWebkit());
                }
                method.setAccessible(true);
                Object res = method.invoke(bean, methodArgs);
                if (res == null) {
                    if (hServerContext.getResponse().getResult() == null) {
                        hServerContext.getResponse().sendNull();
                    }
                    break block15;
                }
                if (String.class.getName().equals(res.getClass().getName())) {
                    hServerContext.getResponse().sendText(res.toString());
                    break block15;
                }
                try {
                    hServerContext.getResponse().sendJson(res);
                }
                catch (Exception e) {
                    throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u8fd4\u56de\u7684\u6570\u636e\u975e\u5b57\u7b26\u4e32\u88ab\u8f6c\u6362JSON\u5f02\u5e38", e, hServerContext.getWebkit());
                }
            }
            catch (InvocationTargetException e) {
                throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u8c03\u7528\u65b9\u6cd5\u5931\u8d25", e.getTargetException(), hServerContext.getWebkit());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u8c03\u7528\u63a7\u5236\u5668\u65f6\u53c2\u6570\u5f02\u5e38", e, hServerContext.getWebkit());
            }
        }
        return hServerContext;
    }

    static FullHttpResponse buildResponse(HServerContext hServerContext) {
        try {
            FullHttpResponse response = null;
            if (hServerContext.getResponse().isProxy()) {
                return null;
            }
            if (hServerContext.isStaticFile()) {
                response = BuildResponse.buildStaticShowType(hServerContext);
            } else if (hServerContext.getResponse().isDownload()) {
                response = BuildResponse.buildControllerDownloadType(hServerContext.getResponse());
            } else if (hServerContext.getResponse().getResult() != null) {
                String tempResult = hServerContext.getResponse().getResult();
                List responseAdapters = IocUtil.getListBean(ResponseAdapter.class);
                if (responseAdapters != null) {
                    for (ResponseAdapter responseAdapter : responseAdapters) {
                        tempResult = responseAdapter.result(hServerContext.getResponse().getResult());
                    }
                }
                hServerContext.getResponse().setResult(tempResult);
                response = BuildResponse.buildHttpResponseData(hServerContext.getResponse());
            } else if (hServerContext.getResponse().isProxy()) {
                return null;
            }
            return BuildResponse.buildEnd(hServerContext.getRequest(), response, hServerContext.getResponse());
        }
        catch (Exception e) {
            throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u6784\u5efaResponse\u5bf9\u8c61\u5f02\u5e38", e, hServerContext.getWebkit());
        }
    }

    private static FullHttpResponse buildExceptionResponse(Webkit webkit) {
        FullHttpResponse response = null;
        Response httpResponse = (Response)webkit.httpResponse;
        if (httpResponse.isDownload()) {
            response = BuildResponse.buildControllerDownloadType(httpResponse);
        } else if (httpResponse.getResult() != null) {
            String tempResult = httpResponse.getResult();
            List responseAdapters = IocUtil.getListBean(ResponseAdapter.class);
            if (responseAdapters != null) {
                for (ResponseAdapter responseAdapter : responseAdapters) {
                    tempResult = responseAdapter.result(httpResponse.getResult());
                }
            }
            httpResponse.setResult(tempResult);
            response = BuildResponse.buildHttpResponseData(httpResponse);
        }
        if (response == null) {
            response = BuildResponse.buildString("\u4f60\u5f00\u542f\u4e86\u5168\u5c40\u5f02\u5e38\u5904\u7406\uff0c\u4f46\u662f\u4f60\u6ca1\u6709\u5904\u7406.");
        }
        return BuildResponse.buildEnd((Request)webkit.httpRequest, response, httpResponse);
    }

    static FullHttpResponse handleException(Throwable e) {
        try {
            if (e.getCause() instanceof BusinessException) {
                BusinessException e1 = (BusinessException)e.getCause();
                List listBean = IocUtil.getListBean(GlobalException.class);
                if (listBean != null) {
                    for (GlobalException globalException : listBean) {
                        globalException.handler(e1.getThrowable(), e1.getHttpCode(), e1.getErrorDescription(), e1.getWebkit());
                        if (!e1.getWebkit().httpResponse.hasData()) continue;
                        break;
                    }
                    return DispatcherHandler.buildExceptionResponse(e1.getWebkit());
                }
                if (e1.getHttpCode().intValue() == HttpResponseStatus.NOT_FOUND.code()) {
                    log.error(e1.getErrorDescription());
                } else {
                    log.error(ExceptionUtil.getMessage((Throwable)e1.getThrowable()));
                }
                return BuildResponse.buildError(e1);
            }
            log.error(ExceptionUtil.getMessage((Throwable)e));
            return BuildResponse.buildError(e);
        }
        catch (Exception e2) {
            return BuildResponse.buildError(e2);
        }
    }

    static void writeResponse(ChannelHandlerContext ctx, CompletableFuture<HServerContext> future, FullHttpResponse msg) {
        if (msg != null) {
            List responseAdapters = IocUtil.getListBean(ResponseAdapter.class);
            if (responseAdapters != null) {
                for (ResponseAdapter responseAdapter : responseAdapters) {
                    msg = responseAdapter.response(msg);
                }
            }
            if (log.isDebugEnabled()) {
                try {
                    Request request = future.get().getRequest();
                    log.debug("\u5730\u5740\uff1a{} \u65b9\u6cd5\uff1a{} \u8017\u65f6\uff1a{}/ms \u6765\u6e90:{}", new Object[]{request.getNettyUri(), request.getRequestType().name(), System.currentTimeMillis() - request.getCreateTime(), request.getIpAddress()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ctx.writeAndFlush((Object)msg);
            HServerContextHolder.remove();
            future.complete(null);
        }
    }
}

