/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web.api;

import cn.hserver.core.ioc.ref.ClasspathPackageScanner;
import cn.hserver.core.ioc.ref.PackageScanner;
import cn.hserver.plugin.web.annotation.CONNECT;
import cn.hserver.plugin.web.annotation.Controller;
import cn.hserver.plugin.web.annotation.DELETE;
import cn.hserver.plugin.web.annotation.GET;
import cn.hserver.plugin.web.annotation.HEAD;
import cn.hserver.plugin.web.annotation.OPTIONS;
import cn.hserver.plugin.web.annotation.PATCH;
import cn.hserver.plugin.web.annotation.POST;
import cn.hserver.plugin.web.annotation.PUT;
import cn.hserver.plugin.web.annotation.RequestMapping;
import cn.hserver.plugin.web.annotation.RequestMethod;
import cn.hserver.plugin.web.annotation.TRACE;
import cn.hserver.plugin.web.annotation.apidoc.ApiImplicitParam;
import cn.hserver.plugin.web.annotation.apidoc.ApiImplicitParams;
import cn.hserver.plugin.web.api.ApiData;
import cn.hserver.plugin.web.api.ApiResult;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ApiDoc {
    private PackageScanner packageScanner;

    public ApiDoc(final Class<?> baseClass) {
        this.packageScanner = new ClasspathPackageScanner((Set)new HashSet<String>(){
            {
                this.add(baseClass.getPackage().getName());
            }
        });
    }

    public ApiDoc(final String packageName) {
        this.packageScanner = new ClasspathPackageScanner((Set)new HashSet<String>(){
            {
                this.add(packageName);
            }
        });
    }

    public List<ApiResult> getApiData() throws Exception {
        ArrayList<ApiResult> apiResults = new ArrayList<ApiResult>();
        Set annotationList = this.packageScanner.getAnnotationList(Controller.class);
        for (Class aClass : annotationList) {
            Controller controller = aClass.getAnnotation(Controller.class);
            ApiResult apiResult = new ApiResult();
            boolean flag = false;
            Method[] methods = aClass.getMethods();
            ArrayList<ApiData> amiDates = new ArrayList<ApiData>();
            for (Method method : methods) {
                ApiImplicitParams annotation = method.getAnnotation(ApiImplicitParams.class);
                if (annotation == null) continue;
                flag = true;
                ApiImplicitParam[] value = annotation.value();
                ArrayList<ApiData.ReqData> reqDataList = new ArrayList<ApiData.ReqData>();
                for (ApiImplicitParam apiImplicitParam : value) {
                    ApiData.ReqData reqData = new ApiData.ReqData();
                    reqData.setDataType(apiImplicitParam.dataType());
                    reqData.setName(apiImplicitParam.name());
                    reqData.setRequired(apiImplicitParam.required());
                    reqData.setValue(apiImplicitParam.value());
                    reqDataList.add(reqData);
                }
                ApiData apiData = new ApiData();
                apiData.setName(annotation.name());
                apiData.setNote(annotation.note());
                apiData.setReqDataList(reqDataList);
                ApiData reqMethods = this.getReqMethods(method, controller.value().trim());
                apiData.setUrl(reqMethods.getUrl());
                apiData.setRequestMethod(reqMethods.getRequestMethod());
                amiDates.add(apiData);
            }
            if (!flag) continue;
            apiResult.setApiData(amiDates);
            if (controller.name().trim().length() == 0) {
                apiResult.setName(aClass.getName());
            } else {
                apiResult.setName(controller.name());
            }
            apiResults.add(apiResult);
        }
        return this.sort(apiResults);
    }

    private List<ApiResult> sort(List<ApiResult> apiData) {
        for (ApiResult apiDatum : apiData) {
            List<ApiData> apiData1 = apiDatum.getApiData();
            Collections.sort(apiData1, (o1, o2) -> {
                Collator collator = Collator.getInstance(Locale.CHINA);
                return collator.compare(o1.getName(), o2.getName());
            });
        }
        Collections.sort(apiData, (o1, o2) -> {
            Collator collator = Collator.getInstance(Locale.CHINA);
            return collator.compare(o1.getName(), o2.getName());
        });
        return apiData;
    }

    private ApiData getReqMethods(Method method, String controllerPath) {
        Class[] classes = new Class[]{GET.class, HEAD.class, POST.class, PUT.class, PATCH.class, DELETE.class, OPTIONS.class, CONNECT.class, TRACE.class, RequestMapping.class};
        ArrayList<String> reqNames = new ArrayList<String>();
        ApiData apiData = new ApiData();
        for (Class aClass1 : classes) {
            Object annotation = method.getAnnotation(aClass1);
            if (annotation == null) continue;
            try {
                Method value = annotation.getClass().getMethod("value", new Class[0]);
                value.setAccessible(true);
                Object invoke = value.invoke(annotation, new Object[0]);
                apiData.setUrl(controllerPath + invoke.toString().trim());
            }
            catch (Exception value) {
                // empty catch block
            }
            if (aClass1 == RequestMapping.class) {
                RequestMapping annotation1 = (RequestMapping)annotation;
                if (annotation1.method().length == 0) {
                    String[] requestMethodAll = RequestMethod.getRequestMethodAll();
                    Collections.addAll(reqNames, requestMethodAll);
                    continue;
                }
                for (RequestMethod requestMethod : annotation1.method()) {
                    reqNames.add(requestMethod.toString());
                }
                continue;
            }
            reqNames.add(aClass1.getSimpleName());
        }
        apiData.setRequestMethod(reqNames);
        return apiData;
    }
}

