/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.web;

import cn.hserver.core.interfaces.PluginAdapter;
import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.ioc.ref.PackageScanner;
import cn.hserver.core.log.HServerPatternLayout;
import cn.hserver.core.server.util.ExceptionUtil;
import cn.hserver.core.server.util.PropUtil;
import cn.hserver.core.server.util.TTLUtil;
import cn.hserver.plugin.web.annotation.CONNECT;
import cn.hserver.plugin.web.annotation.Controller;
import cn.hserver.plugin.web.annotation.DELETE;
import cn.hserver.plugin.web.annotation.GET;
import cn.hserver.plugin.web.annotation.HEAD;
import cn.hserver.plugin.web.annotation.OPTIONS;
import cn.hserver.plugin.web.annotation.PATCH;
import cn.hserver.plugin.web.annotation.POST;
import cn.hserver.plugin.web.annotation.PUT;
import cn.hserver.plugin.web.annotation.Request;
import cn.hserver.plugin.web.annotation.RequestMapping;
import cn.hserver.plugin.web.annotation.RequestMethod;
import cn.hserver.plugin.web.annotation.RequiresPermissions;
import cn.hserver.plugin.web.annotation.RequiresRoles;
import cn.hserver.plugin.web.annotation.Sign;
import cn.hserver.plugin.web.annotation.TRACE;
import cn.hserver.plugin.web.annotation.WebSocket;
import cn.hserver.plugin.web.context.WebConstConfig;
import cn.hserver.plugin.web.handlers.WebSocketServerHandler;
import cn.hserver.plugin.web.interfaces.FilterAdapter;
import cn.hserver.plugin.web.interfaces.GlobalException;
import cn.hserver.plugin.web.interfaces.LimitAdapter;
import cn.hserver.plugin.web.interfaces.PermissionAdapter;
import cn.hserver.plugin.web.interfaces.ResponseAdapter;
import cn.hserver.plugin.web.log.RequestIdClassicConverter;
import cn.hserver.plugin.web.router.RouterInfo;
import cn.hserver.plugin.web.router.RouterManager;
import cn.hserver.plugin.web.router.RouterPermission;
import cn.hserver.plugin.web.util.ParameterUtil;
import cn.hserver.plugin.web.util.SslContextUtil;
import io.netty.handler.codec.http.HttpMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPlugin
implements PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebPlugin.class);

    public void startApp() {
        HServerPatternLayout.defaultConverterMap.put("requestId", RequestIdClassicConverter.class.getName());
    }

    public void startIocInit() {
        Integer businessPool;
        PropUtil instance = PropUtil.getInstance();
        if (instance.get("web.readLimit").trim().length() > 0) {
            WebConstConfig.READ_LIMIT = Long.valueOf(instance.get("web.readLimit"));
        }
        if (instance.get("web.writeLimit").trim().length() > 0) {
            WebConstConfig.WRITE_LIMIT = Long.valueOf(instance.get("web.writeLimit"));
        }
        if (instance.get("web.httpContentSize").trim().length() > 0) {
            WebConstConfig.HTTP_CONTENT_SIZE = instance.getInt("web.httpContentSize");
        }
        if ((businessPool = instance.getInt("web.businessPool")) != null && businessPool > 0) {
            WebConstConfig.BUSINESS_EVENT = TTLUtil.getEventLoop((int)businessPool, (String)"hserver_business");
        }
        WebConstConfig.BUSINESS_EVENT = businessPool != null && businessPool < 0 ? null : TTLUtil.getEventLoop((int)50, (String)"hserver_business");
    }

    public boolean iocInitBean(Class aClass) {
        try {
            if (GlobalException.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean((String)GlobalException.class.getName(), aClass.newInstance());
                return true;
            }
            if (PermissionAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean((String)PermissionAdapter.class.getName(), aClass.newInstance());
                return true;
            }
            if (FilterAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean((String)FilterAdapter.class.getName(), aClass.newInstance());
                return true;
            }
            if (LimitAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean((String)LimitAdapter.class.getName(), aClass.newInstance());
                return true;
            }
            if (ResponseAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean((String)ResponseAdapter.class.getName(), aClass.newInstance());
                return true;
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage((Throwable)e));
        }
        return false;
    }

    public void iocInit(PackageScanner scan) {
        try {
            WebPlugin.initWebSocket(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage((Throwable)e));
        }
        try {
            WebPlugin.initController(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage((Throwable)e));
        }
    }

    public void iocInitEnd() {
    }

    public void startInjection() {
    }

    public void injectionEnd() {
        SslContextUtil.setSsl();
    }

    private static void initWebSocket(PackageScanner scan) throws Exception {
        Set clasps = scan.getAnnotationList(WebSocket.class);
        for (Class aClass : clasps) {
            WebSocket annotation = aClass.getAnnotation(WebSocket.class);
            IocUtil.addBean((String)aClass.getName(), aClass.newInstance());
            WebSocketServerHandler.WEB_SOCKET_ROUTER.put(annotation.value(), aClass.getName());
        }
    }

    private static void initController(PackageScanner scan) throws Exception {
        Set clasps = scan.getAnnotationList(Controller.class);
        for (Class aClass : clasps) {
            Method[] methods;
            for (Method method : methods = aClass.getDeclaredMethods()) {
                String[] requestMethod;
                Class[] classes;
                Controller controller = aClass.getAnnotation(Controller.class);
                String controllerPath = controller.value().trim();
                Annotation[] annotations = method.getAnnotations();
                if (Arrays.stream(annotations).noneMatch(annotation -> annotation.annotationType().getAnnotation(Request.class) != null)) continue;
                try {
                    ParameterUtil.addParam(aClass, method);
                }
                catch (Exception ignored) {
                    continue;
                }
                for (Class aClass1 : classes = new Class[]{GET.class, POST.class, HEAD.class, PUT.class, PATCH.class, DELETE.class, OPTIONS.class, CONNECT.class, TRACE.class}) {
                    Object annotation2 = method.getAnnotation(aClass1);
                    if (annotation2 == null) continue;
                    Method value = aClass1.getMethod("value", new Class[0]);
                    value.setAccessible(true);
                    String path = controllerPath + value.invoke(annotation2, new Object[0]).toString();
                    RouterInfo routerInfo = new RouterInfo();
                    method.setAccessible(true);
                    routerInfo.setMethod(method);
                    routerInfo.setaClass(aClass);
                    routerInfo.setUrl(path);
                    routerInfo.setReqMethodName(HttpMethod.valueOf((String)aClass1.getSimpleName()));
                    RouterManager.addRouter(routerInfo);
                    Sign sign = method.getAnnotation(Sign.class);
                    RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
                    RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
                    if (sign == null && requiresRoles == null && requiresPermissions == null) continue;
                    RouterPermission routerPermission = new RouterPermission();
                    routerPermission.setUrl(path);
                    routerPermission.setReqMethodName(HttpMethod.valueOf((String)aClass1.getSimpleName()));
                    routerPermission.setSign(sign);
                    routerPermission.setRequiresRoles(requiresRoles);
                    routerPermission.setRequiresPermissions(requiresPermissions);
                    routerPermission.setControllerPackageName(aClass.getName());
                    routerPermission.setControllerName(controller.name().trim());
                    RouterManager.addPermission(routerPermission);
                }
                RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                if (requestMapping == null) continue;
                RequestMethod[] requestMethods = requestMapping.method();
                if (requestMethods.length == 0) {
                    requestMethod = RequestMethod.getRequestMethodAll();
                } else {
                    String[] rm = new String[requestMethods.length];
                    for (int i = 0; i < requestMethods.length; ++i) {
                        rm[i] = requestMethods[i].name();
                    }
                    requestMethod = rm;
                }
                for (String s : requestMethod) {
                    String path = controllerPath + requestMapping.value();
                    RouterInfo routerInfo = new RouterInfo();
                    method.setAccessible(true);
                    routerInfo.setMethod(method);
                    routerInfo.setUrl(path);
                    routerInfo.setaClass(aClass);
                    routerInfo.setReqMethodName(HttpMethod.valueOf((String)s));
                    RouterManager.addRouter(routerInfo);
                    Sign sign = method.getAnnotation(Sign.class);
                    RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
                    RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
                    if (sign == null && requiresRoles == null && requiresPermissions == null) continue;
                    RouterPermission routerPermission = new RouterPermission();
                    routerPermission.setUrl(path);
                    routerPermission.setReqMethodName(HttpMethod.valueOf((String)s));
                    routerPermission.setSign(sign);
                    routerPermission.setRequiresRoles(requiresRoles);
                    routerPermission.setRequiresPermissions(requiresPermissions);
                    routerPermission.setControllerPackageName(aClass.getName());
                    routerPermission.setControllerName(controller.name().trim());
                    RouterManager.addPermission(routerPermission);
                }
            }
            IocUtil.addBean((String)aClass.getName(), aClass.newInstance());
        }
    }
}

