/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.runner;

import cn.hserver.runner.JarURLStreamHandler;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class JarURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final ClassLoader classLoader;
    private URLStreamHandlerFactory chainFac;

    public JarURLStreamHandlerFactory(ClassLoader cl) {
        this.classLoader = cl;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if ("in-jar:".equals(protocol + ":")) {
            return new JarURLStreamHandler(this.classLoader, true);
        }
        if ("out-jar:".equals(protocol + ":")) {
            return new JarURLStreamHandler(this.classLoader, false);
        }
        if (this.chainFac != null) {
            return this.chainFac.createURLStreamHandler(protocol);
        }
        return null;
    }

    public void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        this.chainFac = fac;
    }
}

