/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.runner;

import cn.hserver.runner.AesUtil;
import cn.hserver.runner.Runner;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class JarURLConnection
extends URLConnection {
    private final ClassLoader classLoader;
    private final boolean inJar;

    public JarURLConnection(URL url, ClassLoader classLoader, boolean inJar) {
        super(url);
        this.classLoader = classLoader;
        this.inJar = inJar;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inJar) {
            String file = URLDecoder.decode(this.url.getFile(), "UTF-8");
            InputStream result = this.classLoader.getResourceAsStream(file);
            if (result == null) {
                throw new MalformedURLException("Could not open InputStream for URL '" + this.url + "'");
            }
            if (Runner.password != null && !Runner.password.trim().isEmpty()) {
                try {
                    return AesUtil.decrypt(result, Runner.password);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }
        if (Files.exists(Paths.get(this.url.getFile(), new String[0]), new LinkOption[0])) {
            if (Runner.password != null && !Runner.password.trim().isEmpty()) {
                try {
                    return AesUtil.decrypt(Files.newInputStream(Paths.get(this.url.getFile(), new String[0]), new OpenOption[0]), Runner.password);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return Files.newInputStream(Paths.get(this.url.getFile(), new String[0]), new OpenOption[0]);
        }
        return null;
    }
}

