/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.runner;

import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarInfo {
    private boolean type;
    private boolean encrypt;
    private URL[] libs;
    private String mainClass;

    public boolean isType() {
        return this.type;
    }

    public boolean isEncrypt() {
        return this.encrypt;
    }

    public URL[] getLibs() {
        return this.libs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public static JarInfo getManifestInfo() {
        try {
            ProtectionDomain protectionDomain = JarInfo.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource == null ? null : codeSource.getLocation().toURI();
            String path = location == null ? null : location.getSchemeSpecificPart();
            JarFile jarFile = new JarFile(path);
            Manifest manifest = jarFile.getManifest();
            JarInfo jarInfo = new JarInfo();
            Attributes mainAttribs = manifest.getMainAttributes();
            jarInfo.mainClass = mainAttribs.getValue("App-Main-Class");
            jarInfo.encrypt = Boolean.parseBoolean(mainAttribs.getValue("Encrypt"));
            jarInfo.type = Boolean.parseBoolean(mainAttribs.getValue("Type"));
            String[] libs = mainAttribs.getValue("Libs").split(",");
            URL[] urlLibs = new URL[libs.length];
            if (jarInfo.type) {
                for (int i = 0; i < libs.length; ++i) {
                    urlLibs[i] = new URL("in-jar:" + libs[i]);
                }
            } else {
                for (int i = 0; i < libs.length; ++i) {
                    urlLibs[i] = new URL("out-jar:" + libs[i]);
                }
            }
            jarInfo.libs = urlLibs;
            jarFile.close();
            return jarInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}

