/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.runner;

import cn.hserver.runner.JarInJarURLStreamHandlerFactory;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarLoader {
    public static URL[] urls;

    public static ClassLoader init() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL.setURLStreamHandlerFactory(new JarInJarURLStreamHandlerFactory(cl));
        try {
            String path;
            ProtectionDomain protectionDomain = JarLoader.class.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URI location = codeSource == null ? null : codeSource.getLocation().toURI();
            String string = path = location == null ? null : location.getSchemeSpecificPart();
            if (path == null) {
                throw new IllegalStateException("Unable to determine code source archive");
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            JarFile externalJarFile = new JarFile(path);
            for (JarEntry entry : Collections.list(externalJarFile.entries())) {
                if (!entry.getName().endsWith(".jar") || entry.getName().equals(path)) continue;
                String internalJarPath = entry.getName();
                urlList.add(new URL("jarinjar:file:" + path + "!/" + internalJarPath + "!/"));
            }
            urls = urlList.toArray(new URL[0]);
            Thread.currentThread().setContextClassLoader(new URLClassLoader(urls, cl));
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
            return null;
        }
    }
}

