/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.runner;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class JarInJarURLConnection
extends URLConnection {
    private ClassLoader classLoader;

    public JarInJarURLConnection(URL url, ClassLoader classLoader) {
        super(url);
        this.classLoader = classLoader;
    }

    @Override
    public void connect() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getInputStream() throws IOException {
        InputStream result = null;
        ZipInputStream jarInputStream = null;
        try {
            int bytesRead;
            JarEntry entry;
            String[] jarInPath = this.getJarInPath(this.url.getPath());
            if (jarInPath == null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                return byteArrayInputStream;
            }
            result = this.classLoader.getResourceAsStream(jarInPath[0]);
            jarInputStream = new JarInputStream(result);
            do {
                if ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) == null) return new ByteArrayInputStream(new byte[0]);
            } while (!entry.getName().equals(jarInPath[1]));
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((bytesRead = jarInputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String[] getJarInPath(String path) {
        System.out.println("\u89e3\u6790\uff1a" + path);
        String[] paths = new String[2];
        String[] split = path.split("!/");
        if (split.length == 3) {
            paths[0] = split[1];
            paths[1] = split[2];
            return paths;
        }
        System.err.println(path);
        return null;
    }
}

