/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.rpc.core.mode;

import cn.hserver.plugin.rpc.bean.RpcServer;
import cn.hserver.plugin.rpc.client.RpcClient;
import cn.hserver.plugin.rpc.codec.RpcAdapter;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosMode
implements RpcAdapter {
    private static final Logger log = LoggerFactory.getLogger(NacosMode.class);
    private String registerAddress;
    private String registerName;
    private String registerMyIp;
    private Integer registerMyPort;
    private String groupName = "DEFAULT_GROUP";

    public void setRegisterAddress(String registerAddress) {
        this.registerAddress = registerAddress;
    }

    public void setRegisterName(String registerName) {
        this.registerName = registerName;
    }

    public void setRegisterMyIp(String registerMyIp) {
        this.registerMyIp = registerMyIp;
    }

    public void setRegisterMyPort(Integer registerMyPort) {
        this.registerMyPort = registerMyPort;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public void rpcMode(List<RpcServer> rpcServers, List<String> serverNames) {
        if (this.registerAddress == null) {
            throw new NullPointerException("Nacos\u6ce8\u518c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.registerName == null) {
            throw new NullPointerException("Nacos\u6ce8\u518c\u7684\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.registerMyIp == null) {
            throw new NullPointerException("Nacos\u6ce8\u518c\u7684\u81ea\u5df1\u7684IP\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.registerMyPort == null) {
            throw new NullPointerException("Nacos\u6ce8\u518c\u7684\u81ea\u5df1\u7684Port\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            NamingService naming = NamingFactory.createNamingService((String)this.registerAddress);
            naming.registerInstance(this.registerName, this.groupName, this.registerMyIp, this.registerMyPort.intValue(), this.registerName);
            this.subProviderInfo(naming, rpcServers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void subProviderInfo(NamingService naming, List<RpcServer> rpcServers) {
        rpcServers.forEach(regServerName -> {
            try {
                EventListener listener = event -> {
                    if (event instanceof NamingEvent) {
                        NamingEvent evn = (NamingEvent)event;
                        List instances = evn.getInstances();
                        log.info("\u670d\u52a1\u53d8\u5316\uff1a" + instances);
                        RpcClient.remove(regServerName);
                        for (Instance instance : instances) {
                            RpcServer rpcServer = new RpcServer();
                            rpcServer.setServerName(regServerName.getServerName());
                            rpcServer.setPort(instance.getPort());
                            rpcServer.setIp(instance.getIp());
                            RpcClient.reg(rpcServer);
                        }
                    }
                };
                naming.subscribe(regServerName.getServerName(), listener);
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        });
    }
}

