/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.rpc.client;

import cn.hserver.core.server.util.ExceptionUtil;
import cn.hserver.plugin.rpc.bean.RpcServer;
import cn.hserver.plugin.rpc.client.ChannelPool;
import cn.hserver.plugin.rpc.client.NettyChannel;
import cn.hserver.plugin.rpc.codec.DynamicRoundRobin;
import cn.hserver.plugin.rpc.codec.InvokeServiceData;
import cn.hserver.plugin.rpc.codec.Msg;
import cn.hserver.plugin.rpc.codec.MsgType;
import cn.hserver.plugin.rpc.codec.ServiceData;
import cn.hserver.plugin.rpc.exception.RpcException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient {
    private static final Logger log = LoggerFactory.getLogger(RpcClient.class);
    private static final Map<String, DynamicRoundRobin> S_DATA = new ConcurrentHashMap<String, DynamicRoundRobin>();
    public static Map<String, CompletableFuture> mapping = new ConcurrentHashMap<String, CompletableFuture>();

    public static CompletableFuture call(InvokeServiceData invokeServiceData) {
        try {
            DynamicRoundRobin dynamicRoundRobin = S_DATA.get(invokeServiceData.getServerName());
            if (dynamicRoundRobin == null) {
                throw new RpcException("\u6682\u65e0\u670d\u52a1:" + invokeServiceData.getServerName());
            }
            ServiceData choose = dynamicRoundRobin.choose();
            if (choose == null) {
                throw new RpcException("\u6682\u65e0\u670d\u52a1:" + invokeServiceData.getServerName());
            }
            ChannelPool channelPool = choose.getChannelPool();
            NettyChannel resource = channelPool.getResource();
            Msg<InvokeServiceData> msg = new Msg<InvokeServiceData>(MsgType.INVOKER);
            msg.setData(invokeServiceData);
            CompletableFuture objectCompletableFuture = new CompletableFuture();
            mapping.put(invokeServiceData.getRequestId(), objectCompletableFuture);
            if (!resource.getCh().isActive()) {
                throw new RpcException("RPC\u8fde\u63a5\u5f02\u5e38:" + invokeServiceData.getServerName());
            }
            resource.getCh().writeAndFlush(msg);
            channelPool.returnResource(resource);
            return objectCompletableFuture;
        }
        catch (Exception e) {
            throw new RpcException("\u8c03\u7528\u5f02\u5e38:" + ExceptionUtil.getMessage((Throwable)e));
        }
    }

    public static void remove(RpcServer rpcServer) {
        DynamicRoundRobin dynamicRoundRobin = S_DATA.get(rpcServer.getServerName());
        if (dynamicRoundRobin != null) {
            List<ServiceData> all = dynamicRoundRobin.getAll();
            for (ServiceData serviceData : all) {
                serviceData.closeChannelPool();
            }
            S_DATA.remove(rpcServer.getServerName());
        }
    }

    public static void reg(RpcServer rpcServer) {
        log.debug("\u670d\u52a1{}\u6dfb\u52a0\u5230client\u7684\u6c60\u5b50\u91cc", (Object)rpcServer);
        ServiceData serviceData = new ServiceData();
        serviceData.setServerName(rpcServer.getServerName());
        serviceData.setPort(rpcServer.getPort());
        serviceData.setIp(rpcServer.getIp());
        DynamicRoundRobin dynamicRoundRobin = S_DATA.get(serviceData.getServerName());
        if (dynamicRoundRobin != null) {
            dynamicRoundRobin.add(serviceData);
        } else {
            dynamicRoundRobin = new DynamicRoundRobin();
            dynamicRoundRobin.add(serviceData);
            S_DATA.put(serviceData.getServerName(), dynamicRoundRobin);
        }
        serviceData.initChannelPool();
    }
}

