/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.rpc.client;

import cn.hserver.plugin.rpc.client.NettyChannel;
import cn.hserver.plugin.rpc.client.RpcClient;
import cn.hserver.plugin.rpc.codec.Msg;
import cn.hserver.plugin.rpc.codec.MsgType;
import cn.hserver.plugin.rpc.codec.ResultData;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandler
extends SimpleChannelInboundHandler<Msg> {
    private static final Logger log = LoggerFactory.getLogger(ClientHandler.class);
    private NettyChannel nettyChannel;

    public ClientHandler(NettyChannel nettyChannel) {
        this.nettyChannel = nettyChannel;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Msg msg) throws Exception {
        if (msg.getMsgType() == MsgType.RESULT) {
            ResultData data = (ResultData)msg.getData();
            CompletableFuture data1 = (CompletableFuture)data.getData();
            CompletableFuture completableFuture = RpcClient.mapping.get(data.getRequestId());
            RpcClient.mapping.remove(data.getRequestId());
            completableFuture.complete(data1.get());
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent event;
        if (IdleStateEvent.class.isAssignableFrom(evt.getClass()) && (event = (IdleStateEvent)evt).state() != IdleState.READER_IDLE) {
            if (event.state() == IdleState.WRITER_IDLE) {
                ctx.channel().writeAndFlush(new Msg(MsgType.HEART));
                log.debug("\u5199\u7a7a\u95f2\uff0c\u53d1\u9001\u5fc3\u8df3");
            } else if (event.state() == IdleState.ALL_IDLE) {
                log.debug("\u8bfb\u5199\u7a7a\u95f2\uff0c\u53d1\u9001\u5fc3\u8df3");
                ctx.channel().writeAndFlush(new Msg(MsgType.HEART));
            }
        }
    }

    public void channelInactive(final ChannelHandlerContext ctx) throws Exception {
        EventLoop loop = ctx.channel().eventLoop();
        loop.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientHandler.this.nettyChannel.connect();
                    log.warn("channelInactive \u65ad\u5f00\u94fe\u63a5\u91cd\u8fde \u6210\u529f {}", (Object)ctx.channel().localAddress().toString());
                }
                catch (Exception e) {
                    log.error("channelInactive \u65ad\u5f00\u94fe\u63a5\u91cd\u8fde\u5931\u8d25");
                }
            }
        }, 1L, TimeUnit.SECONDS);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u65ad\u5f00\u5f02\u5e38\u4fe1\u606f\uff1a\r\n{}", (Object)cause.getMessage());
        ctx.close();
    }
}

