/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.rpc;

import cn.hserver.core.interfaces.PluginAdapter;
import cn.hserver.core.ioc.IocUtil;
import cn.hserver.plugin.rpc.annotation.Resource;
import cn.hserver.plugin.rpc.annotation.RpcService;
import cn.hserver.plugin.rpc.config.RpcConfig;
import cn.hserver.plugin.rpc.core.ClientProxy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcPlugin
implements PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(RpcPlugin.class);
    private static Set<String> ServerNames = new CopyOnWriteArraySet<String>();

    public void startIocInit() {
    }

    public void iocInitEnd() {
    }

    public void startInjection() {
    }

    public void injectionEnd() {
        this.rpc();
        this.serverReg();
    }

    private void serverReg() {
        RpcConfig bean = (RpcConfig)IocUtil.getBean(RpcConfig.class);
        if (bean != null) {
            bean.getRpcAdapter().rpcMode(bean.getRpcServers(), new ArrayList<String>(ServerNames));
        } else {
            log.error("RPC\u63d2\u4ef6\u53c2\u6570\u672a\u914d\u7f6e");
        }
    }

    private void rpc() {
        Map all = IocUtil.getAll();
        all.forEach((k, v) -> {
            if (v instanceof List) {
                List v1 = (List)v;
                for (Object o : v1) {
                    this.autoZr(o);
                }
            } else {
                this.autoZr(v);
                this.changeRpcService(v);
            }
        });
    }

    public void changeRpcService(Object o) {
        RpcService rpcService = o.getClass().getAnnotation(RpcService.class);
        if (rpcService != null) {
            if (rpcService.value().trim().length() > 0) {
                IocUtil.addBean((String)rpcService.value(), (Object)o);
            } else {
                Class<?>[] interfaces = o.getClass().getInterfaces();
                if (interfaces != null && interfaces.length > 0) {
                    IocUtil.addBean((String)interfaces[0].getName(), (Object)o);
                } else {
                    log.error("RPC\u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u63a5\u53e3\uff0c\u9884\u8ba1\u8c03\u7528\u8fc7\u7a0b\u4f1a\u51fa\u73b0\u95ee\u9898:{}", (Object)o.getClass().getSimpleName());
                }
            }
        }
    }

    private void autoZr(Object v) {
        Class<?> par = v.getClass();
        while (!par.equals(Object.class)) {
            Field[] declaredFields;
            for (Field field : declaredFields = par.getDeclaredFields()) {
                this.rpczr(field, v);
            }
            par = par.getSuperclass();
        }
    }

    private void rpczr(Field declaredField, Object v) {
        Resource annotation = declaredField.getAnnotation(Resource.class);
        if (annotation != null) {
            try {
                this.check(declaredField.getType());
                String s = annotation.serverName();
                ServerNames.add(s);
                declaredField.setAccessible(true);
                Object proxy = ClientProxy.getProxy(declaredField.getType(), annotation);
                declaredField.set(v, proxy);
                log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0cRpc\u88c5\u914d", (Object)proxy.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
            }
            catch (Exception e) {
                log.error("{}----->{}\uff1a\u88c5\u914d\u9519\u8bef:RPC\u4ee3\u7406\u751f\u6210\u5931\u8d25", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
            }
        }
    }

    private void check(Class aClass) {
        Method[] declaredMethods;
        for (Method declaredMethod : declaredMethods = aClass.getDeclaredMethods()) {
            if (declaredMethod.getReturnType().isAssignableFrom(CompletableFuture.class)) continue;
            log.warn("\u7c7b\uff1a{}\uff0c\u65b9\u6cd5\uff1a{},\u8fd4\u56de\u503c\u4e0d\u662fCompletableFuture\uff0cRPC\u5f02\u6b65\u8c03\u7528\u8fc7\u7a0b\u4e2d\u4f1a\u51fa\u73b0\u95ee\u9898", (Object)aClass.getName(), (Object)declaredMethod.getName());
        }
    }
}

