/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.node.core;

import cn.hserver.plugin.node.core.Node;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.NodeRuntime;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.interop.converters.JavetProxyConverter;
import com.caoccao.javet.interop.executors.IV8Executor;
import com.caoccao.javet.node.modules.NodeModuleModule;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Js {
    private static final Logger log = LoggerFactory.getLogger(Js.class);
    private NodeRuntime nodeRuntime = null;
    private String nodePath;

    public Js(String nodeModulesPath) {
        try {
            this.nodePath = nodeModulesPath;
            NodeRuntime nodeRuntime = (NodeRuntime)V8Host.getNodeInstance().createV8Runtime();
            ((NodeModuleModule)nodeRuntime.getNodeModule(NodeModuleModule.class)).setRequireRootDirectory(nodeModulesPath);
            JavetProxyConverter javetProxyConverter = new JavetProxyConverter();
            nodeRuntime.setConverter((IJavetConverter)javetProxyConverter);
            this.nodeRuntime = nodeRuntime;
        }
        catch (JavetException e) {
            e.printStackTrace();
        }
        this.init();
    }

    public NodeRuntime getNodeRuntime() {
        return this.nodeRuntime;
    }

    public IV8Executor run(String script) {
        return this.nodeRuntime.getExecutor(script);
    }

    public IV8Executor run(File script) {
        try {
            IV8Executor executor = this.nodeRuntime.getExecutor(script);
            executor.setResourceName(this.nodePath + File.separator + script.getName());
            return executor;
        }
        catch (JavetException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void bind(String key, Object data) {
        try {
            this.nodeRuntime.getGlobalObject().set((Object)key, data);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void init() {
        this.bind("$node", Node.class);
    }
}

