/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mybatis.hook;

import cn.hserver.core.interfaces.HookAdapter;
import cn.hserver.core.ioc.annotation.Hook;
import cn.hserver.plugin.mybatis.annotation.Tx;
import cn.hserver.plugin.mybatis.proxy.MybatisProxy;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.Method;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Hook(value={Tx.class})
public class TxHook
implements HookAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TxHook.class);
    private static final FastThreadLocal<Long> TIMEOUT_MILLISECOND = new FastThreadLocal();
    public static final FastThreadLocal<Boolean> ISTX = new FastThreadLocal();

    public void before(Class aClass, Method method, Object[] objects) {
        Tx annotation = method.getAnnotation(Tx.class);
        if (annotation != null) {
            ISTX.set((Object)true);
            if (annotation.timeoutMillisecond() != -1) {
                TIMEOUT_MILLISECOND.set((Object)System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object after(Class aClass, Method method, Object o) {
        try {
            Tx annotation = method.getAnnotation(Tx.class);
            if (annotation != null) {
                try {
                    if (annotation.timeoutMillisecond() != -1) {
                        Long startTime = (Long)TIMEOUT_MILLISECOND.get();
                        if (System.currentTimeMillis() - startTime > (long)annotation.timeoutMillisecond()) {
                            try {
                                this.rollback();
                                logger.debug("rollback: \u8d85\u65f6 {}", (Object)(System.currentTimeMillis() - startTime > (long)annotation.timeoutMillisecond() ? 1 : 0));
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }
                    this.commit();
                }
                catch (Exception e) {
                    try {
                        this.rollback();
                        logger.debug("rollback:{}", (Object)e.getMessage());
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            Object object = o;
            return object;
        }
        finally {
            this.close();
            TIMEOUT_MILLISECOND.remove();
            ISTX.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void throwable(Class aClass, Method method, Throwable throwable) {
        block11: {
            Tx annotation = method.getAnnotation(Tx.class);
            if (annotation == null) return;
            try {
                int n;
                Class<? extends Throwable>[] classArray;
                Class<? extends Throwable>[] classes = annotation.rollbackFor();
                if (classes.length != 0) {
                    classArray = classes;
                    n = classArray.length;
                } else {
                    this.rollback();
                    logger.debug("rollback:{}", (Object)throwable.getMessage());
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    Class<? extends Throwable> aClass1 = classArray[i];
                    if (throwable.getClass() != aClass1) continue;
                    this.rollback();
                    this.close();
                    break block11;
                }
                this.commit();
                this.close();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return;
            }
            TIMEOUT_MILLISECOND.remove();
            ISTX.remove();
            return;
        }
        TIMEOUT_MILLISECOND.remove();
        ISTX.remove();
    }

    public void rollback() {
        SqlSession sqlSession = MybatisProxy.get();
        if (sqlSession != null) {
            sqlSession.rollback();
        }
    }

    public void commit() {
        SqlSession sqlSession = MybatisProxy.get();
        if (sqlSession != null) {
            sqlSession.commit();
        }
    }

    public void close() {
        SqlSession sqlSession = MybatisProxy.get();
        if (sqlSession != null) {
            sqlSession.close();
            MybatisProxy.removeSession();
        }
    }
}

