/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mybatis;

import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.server.context.ConstConfig;
import cn.hserver.core.server.util.JarInputStreamUtil;
import cn.hserver.plugin.mybatis.bean.MybatisConfig;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisSqlSessionFactoryBuilder;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisInit {
    private static final Logger log = LoggerFactory.getLogger(MybatisInit.class);

    public static Map<String, SqlSessionFactory> initMybatis(Set<Class<?>> classes) throws IllegalAccessException, InstantiationException {
        MybatisConfig mybatisConfig = (MybatisConfig)IocUtil.getBean(MybatisConfig.class);
        if (mybatisConfig == null) {
            log.error("MybatisConfig \u672a\u914d\u7f6e");
            return null;
        }
        if (mybatisConfig.getDataSources() == null) {
            log.error("\u6570\u636e\u6e90\u4e3anull");
            return null;
        }
        HashMap<String, SqlSessionFactory> stringSqlSessionFactoryHashMap = new HashMap<String, SqlSessionFactory>();
        Set<String> dataSourceNames = mybatisConfig.getDataSources().keySet();
        for (String dataSourceName : dataSourceNames) {
            MybatisConfiguration configuration = new MybatisConfiguration();
            if (mybatisConfig.getMapUnderscoreToCamelCase().booleanValue()) {
                configuration.setMapUnderscoreToCamelCase(true);
            }
            configuration.setUseGeneratedKeys(true);
            MybatisInit.loadMapper((Configuration)configuration, classes, dataSourceName);
            MybatisInit.loadInterceptor((Configuration)configuration, mybatisConfig.getPlugins());
            GlobalConfig globalConfig = GlobalConfigUtils.getGlobalConfig((Configuration)configuration);
            globalConfig.setSqlInjector((ISqlInjector)new DefaultSqlInjector());
            if (mybatisConfig.getIdentifierGenerator() != null) {
                globalConfig.setIdentifierGenerator(mybatisConfig.getIdentifierGenerator());
            }
            globalConfig.setSuperMapperClass(BaseMapper.class);
            if (mybatisConfig.getMetaObjectHandler() != null) {
                globalConfig.setMetaObjectHandler(mybatisConfig.getMetaObjectHandler());
            }
            Environment environment = new Environment(dataSourceName, (TransactionFactory)new JdbcTransactionFactory(), mybatisConfig.getDataSources().get(dataSourceName));
            configuration.setEnvironment(environment);
            MybatisInit.loadMapperXml((Configuration)configuration, mybatisConfig.getMapperLocations());
            SqlSessionFactory build = new MybatisSqlSessionFactoryBuilder().build((Configuration)configuration);
            stringSqlSessionFactoryHashMap.put(dataSourceName, build);
        }
        return stringSqlSessionFactoryHashMap;
    }

    private static void loadInterceptor(Configuration configuration, Interceptor[] plugins) {
        if (plugins != null) {
            for (Interceptor plugin : plugins) {
                configuration.addInterceptor(plugin);
            }
        }
    }

    private static void loadMapper(Configuration configuration, Set<Class<?>> classes, String dataSourceName) {
        for (Class<?> aClass : classes) {
            try {
                configuration.addMapper(aClass);
                log.debug("dataSourceName {}  addMapper:{}", (Object)dataSourceName, (Object)aClass.getName());
            }
            catch (Throwable e) {
                System.out.println(aClass);
                e.printStackTrace();
            }
        }
    }

    private static void loadMapperXml(Configuration configuration, String path) {
        HashMap<String, InputStream> xmlInput = new HashMap<String, InputStream>();
        if (ConstConfig.RUNJAR.booleanValue()) {
            MybatisInit.onlineFile(ConstConfig.CLASSPATH, path, xmlInput);
        } else {
            MybatisInit.developFile(ConstConfig.CLASSPATH + "/" + path, xmlInput);
        }
        xmlInput.forEach((k, v) -> {
            try {
                XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(v, configuration, k, configuration.getSqlFragments());
                xmlMapperBuilder.parse();
            }
            finally {
                try {
                    v.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void developFile(String path, Map<String, InputStream> xmlInput) {
        File[] files;
        File file = new File(path);
        if (file.exists() && null != (files = file.listFiles())) {
            File[] var4 = files;
            int var5 = files.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                File file2 = var4[var6];
                if (file2.isDirectory()) {
                    MybatisInit.developFile(file2.getAbsolutePath(), xmlInput);
                    continue;
                }
                try {
                    if (!file2.getAbsolutePath().endsWith(".xml")) continue;
                    xmlInput.put(file2.getAbsolutePath(), new FileInputStream(file2.getAbsolutePath()));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void onlineFile(String path, String mapperPath, Map<String, InputStream> xmlInput) {
        block17: {
            try {
                InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                if (resourceAsStream == null) break block17;
                try (JarInputStream jarInputStream = new JarInputStream(JarInputStreamUtil.decrypt((InputStream)resourceAsStream));){
                    JarEntry jarEntry;
                    while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                        String name = jarEntry.getName();
                        if (!name.startsWith(mapperPath) || !name.endsWith(".xml")) continue;
                        xmlInput.put(name, MybatisInit.class.getResourceAsStream("/" + name));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception var6) {
                var6.printStackTrace();
            }
        }
    }
}

