/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mybatis;

import cn.hserver.core.interfaces.PluginAdapter;
import cn.hserver.core.ioc.IocUtil;
import cn.hserver.core.ioc.ref.PackageScanner;
import cn.hserver.plugin.mybatis.MybatisInit;
import cn.hserver.plugin.mybatis.annotation.Mybatis;
import cn.hserver.plugin.mybatis.proxy.MybatisProxy;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisPlugin
implements PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlugin.class);

    public void startApp() {
    }

    public void startIocInit() {
    }

    public Set<Class<?>> iocInitBeanList() {
        return null;
    }

    public void iocInit(PackageScanner packageScanner) {
        try {
            Set annotationList = packageScanner.getAnnotationList(Mybatis.class);
            Map<String, SqlSessionFactory> stringSqlSessionFactoryMap = MybatisInit.initMybatis(annotationList);
            if (stringSqlSessionFactoryMap == null) {
                return;
            }
            stringSqlSessionFactoryMap.forEach(IocUtil::addBean);
            for (Class aClass : annotationList) {
                Mybatis mybatis = aClass.getAnnotation(Mybatis.class);
                String value = mybatis.value();
                if (value.trim().length() == 0) {
                    value = SqlSessionFactory.class.getName();
                }
                SqlSessionFactory sqlSessionFactory = stringSqlSessionFactoryMap.get(value);
                Object mapper = MybatisProxy.getInstance().getProxy(aClass, sqlSessionFactory);
                IocUtil.addBean((Object)mapper);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void iocInitEnd() {
    }

    public void startInjection() {
    }

    public void injectionEnd() {
        log.info("MybatisPlus\u63d2\u4ef6\u6267\u884c\u5b8c\u6210");
    }
}

