/*
 * Decompiled with CFR 0.152.
 */
package cn.hserver.plugin.mybatis.hook;

import cn.hserver.core.interfaces.HookAdapter;
import cn.hserver.core.ioc.annotation.Hook;
import cn.hserver.plugin.mybatis.annotation.Tx;
import cn.hserver.plugin.mybatis.proxy.MybatisProxy;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Hook(value={Tx.class})
public class TxHook
implements HookAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TxHook.class);
    private static final FastThreadLocal<Long> TIMEOUT_MILLISECOND = new FastThreadLocal();
    public static final FastThreadLocal<Boolean> ISTX = new FastThreadLocal();

    public void before(Class aClass, Method method, Object[] objects) {
        Tx annotation = method.getAnnotation(Tx.class);
        if (annotation != null) {
            ISTX.set((Object)true);
            if (annotation.timeoutMillisecond() != -1) {
                TIMEOUT_MILLISECOND.set((Object)System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object after(Class aClass, Method method, Object o) {
        try {
            Tx annotation = method.getAnnotation(Tx.class);
            if (annotation != null) {
                try {
                    if (annotation.timeoutMillisecond() != -1) {
                        Long startTime = (Long)TIMEOUT_MILLISECOND.get();
                        if (System.currentTimeMillis() - startTime > (long)annotation.timeoutMillisecond()) {
                            try {
                                MybatisProxy.get().rollback();
                                logger.debug("rollback: \u8d85\u65f6 {}", (Object)(System.currentTimeMillis() - startTime > (long)annotation.timeoutMillisecond() ? 1 : 0));
                            }
                            catch (Exception ex) {
                                logger.error(ex.getMessage());
                            }
                        }
                    }
                    MybatisProxy.get().commit();
                }
                catch (Exception e) {
                    try {
                        MybatisProxy.get().rollback();
                        logger.debug("rollback:{}", (Object)e.getMessage());
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage());
                    }
                }
            }
            Object object = o;
            return object;
        }
        finally {
            MybatisProxy.get().close();
            TIMEOUT_MILLISECOND.remove();
            ISTX.remove();
            MybatisProxy.removeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void throwable(Class aClass, Method method, Throwable throwable) {
        block11: {
            Tx annotation = method.getAnnotation(Tx.class);
            if (annotation == null) return;
            try {
                int n;
                Class<? extends Throwable>[] classArray;
                Class<? extends Throwable>[] classes = annotation.rollbackFor();
                if (classes.length != 0) {
                    classArray = classes;
                    n = classArray.length;
                } else {
                    MybatisProxy.get().rollback();
                    logger.debug("rollback:{}", (Object)throwable.getMessage());
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    Class<? extends Throwable> aClass1 = classArray[i];
                    if (throwable.getClass() != aClass1) continue;
                    MybatisProxy.get().rollback();
                    break block11;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return;
            }
            MybatisProxy.get().commit();
            MybatisProxy.get().close();
            TIMEOUT_MILLISECOND.remove();
            ISTX.remove();
            MybatisProxy.removeSession();
            return;
        }
        MybatisProxy.get().close();
        TIMEOUT_MILLISECOND.remove();
        ISTX.remove();
        MybatisProxy.removeSession();
    }
}

